/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.base.equinox;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.service.datalocation.Location;

public class ExtensionPriorityManager {
    private Properties priorityMap;
    private static final ExtensionPriorityManager instance = new ExtensionPriorityManager();

    private ExtensionPriorityManager() {
        block17: {
            this.priorityMap = new Properties();
            Location location = Platform.getInstanceLocation();
            URL url = location.getURL();
            File file = new File(url.getPath(), "extensions-priorty.properties");
            if (file.exists() && file.canRead()) {
                FileInputStream fileInput = null;
                try {
                    try {
                        fileInput = new FileInputStream(file);
                        this.priorityMap.load(fileInput);
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                        if (fileInput == null) break block17;
                        try {
                            fileInput.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        fileInput = null;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        if (fileInput == null) break block17;
                        try {
                            fileInput.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        fileInput = null;
                    }
                }
                finally {
                    if (fileInput != null) {
                        try {
                            fileInput.close();
                        }
                        catch (Exception exception) {}
                        fileInput = null;
                    }
                }
            }
        }
    }

    public int getPriority(IConfigurationElement element) {
        String p;
        int priority = 0;
        String id = element.getDeclaringExtension().getUniqueIdentifier();
        if (id != null && (p = this.priorityMap.getProperty(id)) != null) {
            try {
                priority = Integer.parseInt(p);
                return priority;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((p = element.getAttribute("priority")) != null) {
            try {
                priority = Integer.parseInt(p);
                return priority;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return priority;
    }

    public static ExtensionPriorityManager getInstance() {
        return instance;
    }
}

