/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.base;

import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.base.Core;
import org.compiere.Adempiere;
import org.compiere.model.MPInstance;
import org.compiere.process.ProcessCall;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoUtil;
import org.compiere.util.CLogMgt;
import org.compiere.util.Env;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;

public class PackInFolderApplication
implements IApplication {
    public Object start(IApplicationContext context) throws Exception {
        Adempiere.startup(false);
        String logLevel = System.getProperty("LogLevel");
        if (logLevel == null) {
            logLevel = "INFO";
        }
        switch (logLevel) {
            case "SEVERE": {
                CLogMgt.setLevel(Level.SEVERE);
                break;
            }
            case "WARNING": {
                CLogMgt.setLevel(Level.WARNING);
                break;
            }
            case "INFO": {
                CLogMgt.setLevel(Level.INFO);
                break;
            }
            case "CONFIG": {
                CLogMgt.setLevel(Level.CONFIG);
                break;
            }
            case "FINE": {
                CLogMgt.setLevel(Level.FINE);
                break;
            }
            case "FINER": {
                CLogMgt.setLevel(Level.FINER);
                break;
            }
            case "FINEST": {
                CLogMgt.setLevel(Level.FINEST);
                break;
            }
            default: {
                CLogMgt.setLevel(Level.INFO);
            }
        }
        Map args = context.getArguments();
        String[] commandlineArgs = (String[])args.get("application.args");
        if (commandlineArgs.length == 1) {
            Properties ctx = Env.getCtx();
            Env.setContext(ctx, "org.adempiere.base.PackInFolderApplication", "Y");
            String directory = commandlineArgs[0];
            ProcessInfo pi = new ProcessInfo("PackInFolder", 200099);
            pi.setAD_Client_ID(0);
            pi.setAD_User_ID(100);
            MPInstance instance = new MPInstance(ctx, 200099, 0);
            instance.saveEx();
            instance.createParameter(10, "Folder", directory);
            pi.setAD_PInstance_ID(instance.getAD_PInstance_ID());
            ProcessCall process = Core.getProcess("org.adempiere.pipo2.PackInFolder");
            boolean success = process.startProcess(ctx, pi, null);
            ProcessInfoUtil.setLogFromDB(pi);
            StringBuilder msgout = new StringBuilder("Process=").append(pi.getTitle()).append("\n Error=").append(pi.isError()).append("\n Summary=").append(pi.getSummary()).append("\n Logs=\n").append(pi.getLogInfo(false).replaceAll("<br>", "\n"));
            System.out.println(msgout.toString());
            if (!success) {
                return 1;
            }
        } else {
            System.out.println("Apply PackIn from Folder usage:");
            System.out.println("RUN_ApplyPackInFromFolder.sh folder");
            return 1;
        }
        return IApplication.EXIT_OK;
    }

    public void stop() {
    }
}

