/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.base;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Map;
import org.adempiere.util.ModelClassGenerator;
import org.adempiere.util.ModelGeneratorDialog;
import org.adempiere.util.ModelInterfaceGenerator;
import org.compiere.Adempiere;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkUtil;

public class ModelGeneratorApplication
implements IApplication {
    public Object start(final IApplicationContext context) throws Exception {
        Adempiere.startup(false);
        Map args = context.getArguments();
        String[] commandlineArgs = (String[])args.get("application.args");
        if (commandlineArgs.length >= 4) {
            String folder = commandlineArgs[0];
            String packageName = commandlineArgs[1];
            String entityType = commandlineArgs[2];
            String tableName = commandlineArgs[3];
            String columnEntityType = null;
            if (commandlineArgs.length >= 5) {
                columnEntityType = commandlineArgs[4];
            }
            ModelInterfaceGenerator.generateSource(folder, packageName, entityType, tableName, columnEntityType);
            ModelClassGenerator.generateSource(folder, packageName, entityType, tableName, columnEntityType);
        } else if (commandlineArgs.length != 0) {
            System.out.println("usage: ModelGenerator folder packageName tableEntityType tableName columnEntityType");
        } else {
            ModelGeneratorDialog dialog = new ModelGeneratorDialog();
            dialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    context.setResult((Object)IApplication.EXIT_OK, (IApplication)ModelGeneratorApplication.this);
                    try {
                        FrameworkUtil.getBundle(ModelGeneratorApplication.class).getBundleContext().getBundle(0L).stop();
                    }
                    catch (BundleException be) {
                        System.exit(0);
                    }
                }
            });
            dialog.setDefaultCloseOperation(2);
            dialog.pack();
            dialog.setLocationRelativeTo(null);
            dialog.setVisible(true);
        }
        return IApplicationContext.EXIT_ASYNC_RESULT;
    }

    public void stop() {
    }
}

