/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.base;

import io.github.classgraph.AnnotationInfo;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import org.adempiere.base.AnnotationBasedFactory;
import org.adempiere.base.IProcessFactory;
import org.adempiere.base.annotation.Process;
import org.compiere.process.ProcessCall;
import org.compiere.util.CLogger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;

public abstract class AnnotationBasedProcessFactory
extends AnnotationBasedFactory
implements IProcessFactory {
    private final Map<String, String> classCache = new HashMap<String, String>();
    private final Map<String, Constructor<?>[]> constructorCache = new ConcurrentHashMap<String, Constructor<?>[]>();
    private BundleContext bundleContext = null;
    private static final CLogger s_log = CLogger.getCLogger(AnnotationBasedProcessFactory.class);

    protected abstract String[] getPackages();

    @Activate
    public void activate(ComponentContext context) throws ClassNotFoundException {
        long start = System.currentTimeMillis();
        this.bundleContext = context.getBundleContext();
        ClassLoader classLoader = ((BundleWiring)this.bundleContext.getBundle().adapt(BundleWiring.class)).getClassLoader();
        ClassGraph graph = new ClassGraph().enableAnnotationInfo().overrideClassLoaders(new ClassLoader[]{classLoader}).disableNestedJarScanning().disableModuleScanning();
        String[] packages = this.getPackages();
        graph.acceptPackagesNonRecursive(packages);
        ClassGraph.ScanResultProcessor scanResultProcessor = scanResult -> {
            for (ClassInfo classInfo : scanResult.getClassesWithAnnotation(Process.class)) {
                if (classInfo.isAbstract()) continue;
                String className = classInfo.getName();
                AnnotationInfo annotationInfo = classInfo.getAnnotationInfo(Process.class);
                String alternateName = null;
                if (annotationInfo != null) {
                    alternateName = (String)annotationInfo.getParameterValues().getValue("name");
                }
                this.classCache.put(className, className);
                if (alternateName == null) continue;
                this.classCache.put(alternateName, className);
            }
            long end = System.currentTimeMillis();
            s_log.info(() -> String.valueOf(this.getClass().getSimpleName()) + " loaded " + this.classCache.size() + " classes in " + (float)(end - start) / 1000.0f + "s");
            this.signalScanCompletion(true);
        };
        graph.scanAsync(this.getExecutorService(), this.getMaxThreads(), scanResultProcessor, this.getScanFailureHandler());
    }

    @Override
    public ProcessCall newProcessInstance(String className) {
        this.blockWhileScanning();
        ProcessCall pc = null;
        String realClassName = this.classCache.get(className);
        if (realClassName != null) {
            Constructor<?>[] constructors = this.constructorCache.get(realClassName);
            if (constructors == null) {
                Class<?> clazz = null;
                try {
                    ClassLoader classLoader = ((BundleWiring)this.bundleContext.getBundle().adapt(BundleWiring.class)).getClassLoader();
                    clazz = classLoader.loadClass(realClassName);
                    Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
                    if (constructor != null) {
                        constructors = new Constructor[]{constructor};
                        this.constructorCache.put(realClassName, constructors);
                    }
                }
                catch (Exception e) {
                    s_log.log(Level.WARNING, e.getMessage(), e);
                }
                if (constructors == null) {
                    this.constructorCache.put(realClassName, new Constructor[0]);
                }
            }
            if (constructors != null && constructors.length == 1) {
                try {
                    pc = (ProcessCall)constructors[0].newInstance(new Object[0]);
                }
                catch (Exception e) {
                    s_log.log(Level.WARNING, e.getMessage(), e);
                    this.constructorCache.put(realClassName, new Constructor[0]);
                }
            }
        }
        return pc;
    }
}

