/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.base;

import io.github.classgraph.AnnotationClassRef;
import io.github.classgraph.AnnotationInfo;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.logging.Level;
import org.adempiere.base.AnnotationBasedFactory;
import org.adempiere.base.annotation.EventTopicDelegate;
import org.adempiere.base.annotation.ImportEventTopic;
import org.adempiere.base.annotation.ModelEventTopic;
import org.adempiere.base.annotation.ProcessEventTopic;
import org.adempiere.base.event.IEventManager;
import org.adempiere.base.event.annotations.EventDelegate;
import org.adempiere.base.event.annotations.ModelEventDelegate;
import org.adempiere.base.event.annotations.ModelEventHandler;
import org.adempiere.base.event.annotations.SimpleEventHandler;
import org.adempiere.base.event.annotations.imp.ImportEventDelegate;
import org.adempiere.base.event.annotations.imp.ImportEventHandler;
import org.adempiere.base.event.annotations.process.ProcessEventDelegate;
import org.adempiere.base.event.annotations.process.ProcessEventHandler;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.Util;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public abstract class AnnotationBasedEventManager
extends AnnotationBasedFactory {
    private static final CLogger s_log = CLogger.getCLogger(AnnotationBasedEventManager.class);
    private IEventManager eventManager;
    private BundleContext bundleContext;
    private List<EventHandler> handlers = new ArrayList<EventHandler>();
    private ServiceTracker<IEventManager, IEventManager> serviceTracker;

    public abstract String[] getPackages();

    @Activate
    public void activate(ComponentContext context) {
        this.bundleContext = context.getBundleContext();
        this.serviceTracker = new ServiceTracker(this.bundleContext, IEventManager.class, (ServiceTrackerCustomizer)new Customizer());
        this.serviceTracker.open();
    }

    @Deactivate
    public void deactivate(ComponentContext context) {
        if (this.serviceTracker != null) {
            this.serviceTracker.close();
            this.serviceTracker = null;
        }
        if (this.eventManager != null) {
            if (this.handlers.size() > 0) {
                this.unbindService(this.eventManager);
            }
            this.eventManager = null;
        }
    }

    protected void bindService(IEventManager eventManager) {
        this.eventManager = eventManager;
        if (eventManager != null) {
            this.scan();
        }
    }

    protected void unbindService(IEventManager eventManager) {
        if (eventManager != null && eventManager == this.eventManager) {
            if (this.handlers.size() > 0) {
                for (EventHandler handler : this.handlers) {
                    eventManager.unregister(handler);
                }
            }
            this.eventManager = null;
        }
    }

    protected void scan() {
        long start = System.currentTimeMillis();
        ClassLoader classLoader = ((BundleWiring)this.bundleContext.getBundle().adapt(BundleWiring.class)).getClassLoader();
        ClassGraph graph = new ClassGraph().enableAnnotationInfo().overrideClassLoaders(new ClassLoader[]{classLoader}).disableNestedJarScanning().disableModuleScanning().acceptPackagesNonRecursive(this.getPackages());
        ClassGraph.ScanResultProcessor scanResultProcessor = scanResult -> {
            for (ClassInfo classInfo : scanResult.getClassesWithAnnotation(EventTopicDelegate.class)) {
                AnnotationInfo annotationInfo;
                if (classInfo.isAbstract()) continue;
                String className = classInfo.getName();
                AnnotationInfo baseInfo = classInfo.getAnnotationInfo(EventTopicDelegate.class);
                String filter = (String)baseInfo.getParameterValues().getValue("filter");
                if (classInfo.hasAnnotation(ModelEventTopic.class)) {
                    annotationInfo = classInfo.getAnnotationInfo(ModelEventTopic.class);
                    this.modelEventDelegate(classLoader, className, annotationInfo, filter);
                    continue;
                }
                if (classInfo.hasAnnotation(ImportEventTopic.class)) {
                    annotationInfo = classInfo.getAnnotationInfo(ImportEventTopic.class);
                    this.importEventDelegate(classLoader, className, annotationInfo, filter);
                    continue;
                }
                if (classInfo.hasAnnotation(ProcessEventTopic.class)) {
                    annotationInfo = classInfo.getAnnotationInfo(ProcessEventTopic.class);
                    this.processEventDelegate(classLoader, className, annotationInfo, filter);
                    continue;
                }
                this.simpleEventDelegate(classLoader, className, filter);
            }
            long end = System.currentTimeMillis();
            s_log.info(() -> String.valueOf(this.getClass().getSimpleName()) + " loaded " + this.handlers.size() + " classes in " + (float)(end - start) / 1000.0f + "s");
            this.signalScanCompletion(true);
        };
        graph.scanAsync(this.getExecutorService(), this.getMaxThreads(), scanResultProcessor, this.getScanFailureHandler());
    }

    private void simpleEventDelegate(ClassLoader classLoader, String className, String filter) {
        block3: {
            try {
                Class<?> delegateClass = classLoader.loadClass(className);
                Constructor<?> constructor = delegateClass.getConstructor(Event.class);
                EventDelegateSupplier supplier = new EventDelegateSupplier(constructor);
                SimpleEventHandler handler = new SimpleEventHandler(delegateClass, supplier);
                if (!Util.isEmpty(filter, true)) {
                    handler.setFilter(filter);
                }
                this.handlers.add(handler);
                this.eventManager.register(handler.getTopics(), handler.getFilter(), (EventHandler)handler);
            }
            catch (Exception e) {
                if (!s_log.isLoggable(Level.INFO)) break block3;
                s_log.log(Level.INFO, e.getMessage(), e);
            }
        }
    }

    private void processEventDelegate(ClassLoader classLoader, String className, AnnotationInfo annotationInfo, String filter) {
        block3: {
            try {
                String processUUID = (String)annotationInfo.getParameterValues().getValue("processUUID");
                Class<?> delegateClass = classLoader.loadClass(className);
                Constructor<?> constructor = delegateClass.getConstructor(Event.class);
                ProcessDelegateSupplier supplier = new ProcessDelegateSupplier(constructor);
                ProcessEventHandler handler = new ProcessEventHandler(delegateClass, processUUID, supplier);
                if (!Util.isEmpty(filter, true)) {
                    handler.setFilter(filter);
                }
                this.handlers.add(handler);
                this.eventManager.register(handler.getTopics(), handler.getFilter(), (EventHandler)handler);
            }
            catch (Exception e) {
                if (!s_log.isLoggable(Level.INFO)) break block3;
                s_log.log(Level.INFO, e.getMessage(), e);
            }
        }
    }

    private void importEventDelegate(ClassLoader classLoader, String className, AnnotationInfo annotationInfo, String filter) {
        block3: {
            try {
                String importTableName = (String)annotationInfo.getParameterValues().getValue("importTableName");
                Class<?> delegateClass = classLoader.loadClass(className);
                Constructor<?> constructor = delegateClass.getConstructor(Event.class);
                ImportDelegateSupplier supplier = new ImportDelegateSupplier(constructor);
                ImportEventHandler handler = new ImportEventHandler(delegateClass, importTableName, supplier);
                if (!Util.isEmpty(filter, true)) {
                    handler.setFilter(filter);
                }
                this.handlers.add(handler);
                this.eventManager.register(handler.getTopics(), handler.getFilter(), (EventHandler)handler);
            }
            catch (Exception e) {
                if (!s_log.isLoggable(Level.INFO)) break block3;
                s_log.log(Level.INFO, e.getMessage(), e);
            }
        }
    }

    private void modelEventDelegate(ClassLoader classLoader, String className, AnnotationInfo annotationInfo, String filter) {
        block3: {
            try {
                AnnotationClassRef classRef = (AnnotationClassRef)annotationInfo.getParameterValues().getValue("modelClass");
                Class modelClass = classRef.loadClass();
                Class<?> delegateClass = classLoader.loadClass(className);
                Constructor<?> constructor = delegateClass.getDeclaredConstructor(modelClass, Event.class);
                ModelDelegateSupplier supplier = new ModelDelegateSupplier(constructor);
                ModelEventHandler handler = new ModelEventHandler(modelClass, delegateClass, supplier);
                if (!Util.isEmpty(filter, true)) {
                    handler.setFilter(filter);
                }
                this.handlers.add(handler);
                this.eventManager.register(handler.getTopics(), handler.getFilter(), handler);
            }
            catch (Exception e) {
                if (!s_log.isLoggable(Level.INFO)) break block3;
                s_log.log(Level.INFO, e.getMessage(), e);
            }
        }
    }

    private class Customizer
    implements ServiceTrackerCustomizer<IEventManager, IEventManager> {
        private Customizer() {
        }

        public IEventManager addingService(ServiceReference<IEventManager> reference) {
            IEventManager eventManager = (IEventManager)AnnotationBasedEventManager.this.bundleContext.getService(reference);
            AnnotationBasedEventManager.this.bindService(eventManager);
            return eventManager;
        }

        public void modifiedService(ServiceReference<IEventManager> reference, IEventManager service) {
            if (AnnotationBasedEventManager.this.eventManager != null && AnnotationBasedEventManager.this.eventManager != service) {
                AnnotationBasedEventManager.this.unbindService(AnnotationBasedEventManager.this.eventManager);
                AnnotationBasedEventManager.this.bindService(service);
            }
        }

        public void removedService(ServiceReference<IEventManager> reference, IEventManager service) {
            AnnotationBasedEventManager.this.unbindService(service);
        }
    }

    private static class EventDelegateSupplier
    implements Function<Event, EventDelegate> {
        private Constructor<?> constructor;

        private EventDelegateSupplier(Constructor<?> constructor) {
            this.constructor = constructor;
        }

        @Override
        public EventDelegate apply(Event t) {
            EventDelegate delegate = null;
            if (this.constructor != null) {
                try {
                    delegate = (EventDelegate)this.constructor.newInstance(t);
                }
                catch (Exception e) {
                    this.constructor = null;
                    s_log.log(Level.WARNING, e.getMessage(), e);
                }
            }
            return delegate;
        }
    }

    private static class ImportDelegateSupplier
    implements Function<Event, ImportEventDelegate> {
        private Constructor<?> constructor;

        private ImportDelegateSupplier(Constructor<?> constructor) {
            this.constructor = constructor;
        }

        @Override
        public ImportEventDelegate apply(Event t) {
            ImportEventDelegate delegate = null;
            if (this.constructor != null) {
                try {
                    delegate = (ImportEventDelegate)this.constructor.newInstance(t);
                }
                catch (Exception e) {
                    this.constructor = null;
                    s_log.log(Level.WARNING, e.getMessage(), e);
                }
            }
            return delegate;
        }
    }

    private static class ModelDelegateSupplier
    implements BiFunction<PO, Event, ModelEventDelegate<?>> {
        private Constructor<?> constructor;

        private ModelDelegateSupplier(Constructor<?> constructor) {
            this.constructor = constructor;
        }

        @Override
        public ModelEventDelegate<?> apply(PO t, Event u) {
            ModelEventDelegate delegate = null;
            if (this.constructor != null) {
                try {
                    delegate = (ModelEventDelegate)this.constructor.newInstance(t, u);
                }
                catch (Exception e) {
                    this.constructor = null;
                    s_log.log(Level.WARNING, e.getMessage(), e);
                }
            }
            return delegate;
        }
    }

    private static class ProcessDelegateSupplier
    implements Function<Event, ProcessEventDelegate> {
        private Constructor<?> constructor;

        private ProcessDelegateSupplier(Constructor<?> constructor) {
            this.constructor = constructor;
        }

        @Override
        public ProcessEventDelegate apply(Event t) {
            ProcessEventDelegate delegate = null;
            if (this.constructor != null) {
                try {
                    delegate = (ProcessEventDelegate)this.constructor.newInstance(t);
                }
                catch (Exception e) {
                    this.constructor = null;
                    s_log.log(Level.WARNING, e.getMessage(), e);
                }
            }
            return delegate;
        }
    }
}

