/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.server.rpl.imp;

import java.util.Properties;
import java.util.logging.Level;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import org.adempiere.process.rpl.XMLHelper;
import org.adempiere.process.rpl.imp.ImportHelper;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.compiere.model.MIMPProcessorLog;
import org.compiere.server.ReplicationProcessor;
import org.compiere.util.CLogger;
import org.w3c.dom.Document;

public class TopicListener
implements MessageListener {
    private Connection conn;
    private Session session;
    private Topic topic;
    private String url = "tcp://localhost:61616";
    private String host = "localhost";
    private int port = 61616;
    private String protocol = "tcp";
    private Properties ctx = null;
    private String trxName = null;
    private String topicName = null;
    private ReplicationProcessor replicationProcessor = null;
    protected static final CLogger log = CLogger.getCLogger(TopicListener.class);
    private boolean isDurableSubscription = false;
    private String subscriptionName = null;
    private String clientID = null;
    private String userName = null;
    private String password = null;

    public TopicListener(Properties ctx, ReplicationProcessor replicationProcessor, String protocol, String host, int port, boolean isDurableSubscription, String subscriptionName, String topicName, String clientID, String userName, String password, String options, String trxName) {
        if (host != null && !host.equals("")) {
            this.host = host;
        }
        if (port > 0) {
            this.port = port;
        }
        if (protocol != null && !protocol.equals("")) {
            this.protocol = protocol;
        }
        this.topicName = topicName;
        String uri = String.valueOf(this.protocol) + "://" + this.host + ":" + this.port;
        if (options != null && options.length() > 0 && !options.contains("?")) {
            uri = String.valueOf(uri) + "?" + options;
        }
        this.setUrl(uri);
        this.ctx = ctx;
        this.trxName = trxName;
        this.replicationProcessor = replicationProcessor;
        this.isDurableSubscription = isDurableSubscription;
        this.subscriptionName = subscriptionName;
        this.clientID = clientID;
        this.userName = userName;
        this.password = password;
    }

    public void run() throws JMSException {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(this.url);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("ActiveMQConnectionFactory = " + factory);
        }
        this.conn = this.userName != null && this.password != null ? factory.createConnection(this.userName, this.password) : factory.createConnection();
        if (log.isLoggable(Level.FINEST)) {
            log.finest("conn = " + this.conn);
        }
        if (this.conn.getClientID() == null) {
            try {
                this.conn.setClientID(this.clientID);
            }
            catch (Exception e) {
                this.conn.close();
                return;
            }
        }
        if (this.conn.getClientID().equals(this.clientID)) {
            log.warning("Connection with clientID '" + this.clientID + "' already exists");
            this.conn.close();
            return;
        }
        try {
            this.conn.setClientID(this.clientID);
        }
        catch (Exception e) {
            if (log.isLoggable(Level.INFO)) {
                log.info("Error while invoking setClientID(" + this.clientID + ")! " + e.getMessage());
            }
            this.conn.close();
            return;
        }
        this.session = this.conn.createSession(true, 1);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("session = " + this.session);
            log.finest("topicName = " + this.topicName);
            log.finest("subscriptionName = " + this.subscriptionName);
        }
        this.topic = this.session.createTopic(this.topicName);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("topic = " + this.topic);
        }
        Object consumer = null;
        consumer = this.isDurableSubscription ? this.session.createDurableSubscriber(this.topic, this.subscriptionName) : this.session.createConsumer((Destination)this.topic);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("consumer = " + consumer);
        }
        consumer.setMessageListener((MessageListener)this);
        this.conn.start();
        log.finest("Waiting for JMS messages...");
        if (this.replicationProcessor != null) {
            MIMPProcessorLog pLog = new MIMPProcessorLog(this.replicationProcessor.getMImportProcessor(), "Connected to JMS Server. Waiting for messages!");
            StringBuilder logReference = new StringBuilder("topicName = ").append(this.topicName).append(", subscriptionName = ").append(this.subscriptionName);
            pLog.setReference(logReference.toString());
            boolean resultSave = pLog.save();
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Result Save = " + resultSave);
            }
        }
    }

    public void onMessage(Message message) {
        if (message instanceof TextMessage) {
            try {
                TextMessage txtMessage = (TextMessage)message;
                String text = txtMessage.getText();
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Received message: \n" + text);
                }
                Document documentToBeImported = XMLHelper.createDocumentFromString((String)text);
                StringBuffer result = new StringBuffer();
                ImportHelper impHelper = new ImportHelper(this.ctx);
                impHelper.importXMLDocument(result, documentToBeImported, this.trxName);
                log.finest("Message processed ...");
                if (this.replicationProcessor != null) {
                    MIMPProcessorLog pLog = new MIMPProcessorLog(this.replicationProcessor.getMImportProcessor(), "Imported Document!");
                    if (text.length() > 2000) {
                        pLog.setTextMsg(text.substring(0, 1999));
                    } else {
                        pLog.setTextMsg(text);
                    }
                    pLog.saveEx();
                }
                this.session.commit();
            }
            catch (Exception e) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Rollback = " + e.toString());
                }
                try {
                    this.session.rollback();
                    this.stop();
                    this.replicationProcessor.setProcessRunning(false);
                }
                catch (JMSException e2) {
                    e2.printStackTrace();
                }
                e.printStackTrace();
            }
        } else {
            log.finest("Received NO TEXT Message: ");
        }
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void stop() throws JMSException {
        log.finest("Closing JMS Connection!");
        this.conn.close();
    }
}

