/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MBPartner;
import org.compiere.model.MBankAccount;
import org.compiere.model.MPaySelection;
import org.compiere.model.MPaySelectionCheck;
import org.compiere.model.MSysConfig;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.PaymentExport;
import org.compiere.util.Util;

public class JapanPaymentExport
implements PaymentExport {
    private static CLogger s_log = CLogger.getCLogger(JapanPaymentExport.class);
    private static final int BA_RequesterCode = 0;
    private static final int BA_RequesterName = 1;
    private static final int BA_DATE = 2;
    private static final int BA_RoutingNo = 3;
    private static final int BA_BankName_Kana = 4;
    private static final int BA_BranchCode = 5;
    private static final int BA_BranchName_Kana = 6;
    private static final int BA_BankAccountType = 7;
    private static final int BA_AccountNo = 8;
    private static final int BP_RoutingNo = 0;
    private static final int BP_BankName_Kana = 1;
    private static final int BP_BranchCode = 2;
    private static final int BP_BranchName_Kana = 3;
    private static final int BP_BankAccountType = 4;
    private static final int BP_AccountNo = 5;
    private static final int BP_A_Name_Kana = 6;
    private static final boolean LEFT = true;
    private static final boolean RIGHT = false;
    private static final String STR1 = " ";
    private static final String STR2 = "0";

    public int exportToFile(MPaySelectionCheck[] checks, File file, StringBuffer err) {
        String line_end = MSysConfig.getValue((String)"JP_JAPAN_PAYMENT_EXPORT_LINE_END", (String)Env.NL, (int)Env.getAD_Client_ID((Properties)Env.getCtx()), (int)0);
        if (Util.isEmpty((String)line_end)) {
            line_end = Env.NL;
        }
        if (line_end.equalsIgnoreCase("CRLF") || line_end.equalsIgnoreCase("\\r\\n")) {
            line_end = "\r\n";
        } else if (line_end.equalsIgnoreCase("CR") || line_end.equalsIgnoreCase("\\r")) {
            line_end = "\r";
        } else if (line_end.equalsIgnoreCase("LF") || line_end.equalsIgnoreCase("\\n")) {
            line_end = "\n";
        }
        if (checks == null || checks.length == 0) {
            return 0;
        }
        if (file.isDirectory()) {
            err.append("No se puede escribir, el archivo seleccionado es un directorio - " + file.getAbsolutePath());
            s_log.log(Level.SEVERE, err.toString());
            return -1;
        }
        try {
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception e) {
            s_log.log(Level.WARNING, "Could not delete - " + file.getAbsolutePath(), (Throwable)e);
        }
        int noLines = 0;
        StringBuffer line = null;
        try (PrintWriter p_writer = null;){
            try {
                String encoding = MSysConfig.getValue((String)"JP_JAPAN_PAYMENT_EXPORT_ENCODING", (String)"Shift_JIS", (int)Env.getAD_Client_ID((Properties)Env.getCtx()), (int)0);
                if (Util.isEmpty((String)encoding)) {
                    encoding = "Shift_JIS";
                }
                int C_PaySelection_ID = checks[0].getParent().get_ID();
                MPaySelection ps = new MPaySelection(Env.getCtx(), C_PaySelection_ID, null);
                MBankAccount m_BA = new MBankAccount(Env.getCtx(), ps.getC_BankAccount_ID(), null);
                String jp_RequesterName = (String)m_BA.get_Value("JP_RequesterName");
                if (Util.isEmpty((String)jp_RequesterName)) {
                    throw new Exception(String.valueOf(m_BA.getName()) + " - " + Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Null") + " [ " + Msg.getElement((Properties)Env.getCtx(), (String)"JP_RequesterName") + " ] ");
                }
                p_writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding)));
                line = new StringBuffer();
                String[] ba = JapanPaymentExport.getBankInfo(checks);
                line.append("1210").append(ba[0]).append(ba[1]).append(ba[2]).append(ba[3]).append(ba[4]).append(ba[5]).append(ba[6]).append(ba[7]).append(ba[8]).append(JapanPaymentExport.strAdd(null, true, STR1, 17)).append(line_end);
                p_writer.write(line.toString());
                BigDecimal allPayAmt = new BigDecimal(0);
                int i = 0;
                while (i < checks.length) {
                    MPaySelectionCheck mpp = checks[i];
                    if (mpp != null) {
                        String[] bp = JapanPaymentExport.getBPartnerInfo(mpp);
                        line = new StringBuffer();
                        line.append("2").append(bp[0]).append(bp[1]).append(bp[2]).append(bp[3]).append("    ").append(bp[4]).append(bp[5]).append(bp[6]).append(JapanPaymentExport.strAdd(mpp.getPayAmt().setScale(0, RoundingMode.HALF_UP).toString(), false, STR2, 10)).append(STR1).append(JapanPaymentExport.strAdd(null, false, STR1, 10)).append(JapanPaymentExport.strAdd(null, false, STR1, 10)).append(JapanPaymentExport.strAdd(null, true, STR1, 9)).append(line_end);
                        p_writer.write(line.toString());
                        ++noLines;
                        allPayAmt = allPayAmt.add(mpp.getPayAmt());
                    }
                    ++i;
                }
                line = new StringBuffer();
                line.append("8").append(JapanPaymentExport.strAdd(String.valueOf(noLines), false, STR2, 6)).append(JapanPaymentExport.strAdd(allPayAmt.toString(), false, STR2, 12)).append(JapanPaymentExport.strAdd(null, true, STR1, 101)).append(line_end);
                p_writer.write(line.toString());
                line = new StringBuffer();
                line.append("9").append(JapanPaymentExport.strAdd(null, true, STR1, 119)).append(line_end);
                p_writer.write(line.toString());
                p_writer.flush();
            }
            catch (Exception e) {
                s_log.log(Level.SEVERE, "", (Throwable)e);
                err = err.append(e.getLocalizedMessage());
                p_writer.close();
                return -1;
            }
        }
        return noLines;
    }

    private static String[] getBPartnerInfo(MPaySelectionCheck m_PaySelectionCheck) throws Exception {
        String[] bp;
        block16: {
            ResultSet rs;
            CPreparedStatement pstmt;
            block15: {
                MPaySelection m_PaySelection;
                boolean IsReceiptJP;
                bp = new String[10];
                String sql = "SELECT ba.RoutingNo,ba.JP_BankName_Kana,bpbc.JP_BranchCode,bpbc.JP_BranchName_Kana,case when bpbc.BankAccountType='S' then 1 else 2 end,bpbc.AccountNo,bpbc.JP_A_Name_Kana,bpbc.IsDefault as IsDefault FROM C_BP_BANKACCOUNT bpbc INNER JOIN C_Bank ba ON bpbc.C_Bank_ID=ba.C_Bank_ID ";
                int C_BP_BankAccount_ID = m_PaySelectionCheck.getC_BP_BankAccount_ID();
                sql = C_BP_BankAccount_ID == 0 ? ((IsReceiptJP = (m_PaySelection = new MPaySelection(Env.getCtx(), m_PaySelectionCheck.getC_PaySelection_ID(), null)).get_ValueAsBoolean("IsReceiptJP")) ? String.valueOf(sql) + "WHERE bpbc.C_BPartner_ID= ? " + " and bpbc.IsActive='Y' " + " and bpbc.IsACH='Y' " + " and bpbc.BPBankAcctUse IN ('B','D') " + " order by bpbc.IsDefault DESC, bpbc.Created ASC " : String.valueOf(sql) + "WHERE bpbc.C_BPartner_ID= ? " + " and bpbc.IsActive='Y' " + " and bpbc.IsACH='Y' " + " and bpbc.BPBankAcctUse IN ('B','T') " + " order by bpbc.IsDefault DESC, bpbc.Created ASC ") : String.valueOf(sql) + "WHERE bpbc.C_BP_BankAccount_ID= ? ";
                pstmt = null;
                rs = null;
                try {
                    try {
                        pstmt = DB.prepareStatement((String)sql, null);
                        if (C_BP_BankAccount_ID == 0) {
                            pstmt.setInt(1, m_PaySelectionCheck.getC_BPartner_ID());
                        } else {
                            pstmt.setInt(1, C_BP_BankAccount_ID);
                        }
                        rs = pstmt.executeQuery();
                        if (rs.next()) {
                            bp[0] = rs.getString(1);
                            if (bp[0] == null || bp[0].length() != 4) {
                                bp[0] = JapanPaymentExport.strAdd(bp[0], true, STR1, 4);
                            }
                            bp[1] = rs.getString(2);
                            if (bp[1] == null || bp[1].length() != 15) {
                                bp[1] = JapanPaymentExport.strAdd(bp[1], true, STR1, 15);
                            }
                            bp[2] = rs.getString(3);
                            if (bp[2] == null || bp[2].length() != 3) {
                                bp[2] = JapanPaymentExport.strAdd(bp[2], true, STR1, 3);
                            }
                            bp[3] = rs.getString(4);
                            if (bp[3] == null || bp[3].length() != 15) {
                                bp[3] = JapanPaymentExport.strAdd(bp[3], true, STR1, 15);
                            }
                            bp[4] = rs.getString(5);
                            if (bp[4] == null || bp[4].length() != 1) {
                                bp[4] = JapanPaymentExport.strAdd(bp[4], true, STR1, 1);
                            }
                            bp[5] = rs.getString(6);
                            if (bp[5] == null || bp[5].length() != 7) {
                                bp[5] = JapanPaymentExport.strAdd(bp[5], true, STR1, 7);
                            }
                            bp[6] = rs.getString(7);
                            if (Util.isEmpty((String)bp[6])) {
                                int C_BPartner_ID = m_PaySelectionCheck.getC_BPartner_ID();
                                MBPartner m_BP = MBPartner.get((Properties)Env.getCtx(), (int)C_BPartner_ID);
                                throw new Exception(String.valueOf(m_BP.getName()) + " - " + Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Null") + " [ " + Msg.getElement((Properties)Env.getCtx(), (String)"JP_A_Name_Kana") + " ] ");
                            }
                            if (bp[6].length() != 30) {
                                bp[6] = JapanPaymentExport.strAdd(bp[6], true, STR1, 30);
                            }
                            break block15;
                        }
                        int C_BPartner_ID = m_PaySelectionCheck.getC_BPartner_ID();
                        MBPartner m_BP = MBPartner.get((Properties)Env.getCtx(), (int)C_BPartner_ID);
                        throw new Exception(String.valueOf(m_BP.getName()) + " - " + Msg.getElement((Properties)Env.getCtx(), (String)"C_BP_BankAccount_ID") + STR1 + Msg.getMsg((Properties)Env.getCtx(), (String)"NotFound"));
                    }
                    catch (SQLException e) {
                        s_log.log(Level.SEVERE, sql, (Throwable)e);
                        DB.close(rs, (Statement)pstmt);
                        rs = null;
                        pstmt = null;
                        break block16;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        return bp;
    }

    private static String[] getBankInfo(MPaySelectionCheck[] checks) {
        String[] ba;
        block15: {
            ba = new String[10];
            int C_PaymentSelection_ID = checks[0].getParent().get_ID();
            String sql = "SELECT bc.JP_RequesterCode, bc.JP_RequesterName,to_char(ps.PayDate,'MMDD'),ba.RoutingNo,ba.JP_BankName_Kana,bc.JP_BranchCode,bc.JP_BranchName_Kana,case when bc.BankAccountType='S' then 1 else 2 end,bc.AccountNo FROM C_PaySelection ps  INNER JOIN C_BankAccount bc ON (ps.C_BankAccount_ID=bc.C_BankAccount_ID)  INNER JOIN C_Bank ba ON (bc.C_Bank_ID=ba.C_Bank_ID) WHERE ps.C_PaySelection_ID=? ";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    pstmt.setInt(1, C_PaymentSelection_ID);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        ba[0] = rs.getString(1);
                        if (ba[0] == null || ba[0].length() != 10) {
                            ba[0] = JapanPaymentExport.strAdd(ba[0], true, STR1, 10);
                        }
                        ba[1] = rs.getString(2);
                        if (ba[1] == null || ba[1].length() != 40) {
                            ba[1] = JapanPaymentExport.strAdd(ba[1], true, STR1, 40);
                        }
                        ba[2] = rs.getString(3);
                        if (ba[2] == null) {
                            ba[2] = JapanPaymentExport.strAdd(ba[2], true, STR1, 4);
                        }
                        ba[3] = rs.getString(4);
                        if (ba[3] == null || ba[3].length() != 4) {
                            ba[3] = JapanPaymentExport.strAdd(ba[3], true, STR1, 4);
                        }
                        ba[4] = rs.getString(5);
                        if (ba[4] == null || ba[4].length() != 15) {
                            ba[4] = JapanPaymentExport.strAdd(ba[4], true, STR1, 15);
                        }
                        ba[5] = rs.getString(6);
                        if (ba[5] == null || ba[5].length() != 3) {
                            ba[5] = JapanPaymentExport.strAdd(ba[5], true, STR1, 3);
                        }
                        ba[6] = rs.getString(7);
                        if (ba[6] == null || ba[6].length() != 15) {
                            ba[6] = JapanPaymentExport.strAdd(ba[6], true, STR1, 15);
                        }
                        ba[7] = rs.getString(8);
                        if (ba[7] == null || ba[7].length() != 1) {
                            ba[7] = JapanPaymentExport.strAdd(ba[7], true, STR1, 1);
                        }
                        ba[8] = rs.getString(9);
                        if (ba[8] == null || ba[8].length() != 7) {
                            ba[8] = JapanPaymentExport.strAdd(ba[8], true, STR1, 7);
                        }
                    }
                }
                catch (SQLException e) {
                    s_log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block15;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        return ba;
    }

    public static String strAdd(String strIn, boolean left, String addStr, int strLength) {
        StringBuffer returnStr = new StringBuffer("");
        int length1 = 0;
        if (strIn != null) {
            returnStr.append(strIn);
            length1 = strIn.length();
        }
        if (left) {
            if (length1 < strLength) {
                int i = length1;
                while (i < strLength) {
                    returnStr.append(addStr);
                    ++i;
                }
            } else {
                returnStr.delete(strLength, length1);
            }
        } else {
            int i = length1;
            while (i < strLength) {
                returnStr.insert(0, addStr);
                ++i;
            }
        }
        return returnStr.toString();
    }
}

