/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.keikai.view;

import io.keikai.api.Exporter;
import io.keikai.api.Exporters;
import io.keikai.api.Ranges;
import io.keikai.api.model.Book;
import io.keikai.api.model.Sheet;
import io.keikai.ui.UserActionContext;
import io.keikai.ui.UserActionHandler;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.idempiere.keikai.view.Helper;
import org.idempiere.ui.zk.media.Medias;
import org.zkoss.util.media.AMedia;
import org.zkoss.util.media.Media;
import org.zkoss.zul.Filedownload;

public class SaveBookHandler
implements UserActionHandler {
    public boolean isEnabled(Book book, Sheet sheet) {
        return book != null && sheet != null;
    }

    public boolean process(UserActionContext context) {
        boolean isProtected;
        Book book = context.getBook();
        String bookName = book.getBookName();
        if (bookName.endsWith(".csv")) {
            bookName = String.valueOf(bookName.substring(0, bookName.length() - 4)) + ".xlsx";
        }
        if (isProtected = book.getSheetAt(0).isProtected()) {
            Ranges.range((Sheet)book.getSheetAt(0)).unprotectSheet(null);
        }
        Exporter exporter = bookName.endsWith(".xls") ? Exporters.getExporter((String)"xls") : Exporters.getExporter((String)"xlsx");
        File file = null;
        try {
            file = File.createTempFile(Long.toString(System.currentTimeMillis()), "temp");
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        FileOutputStream fos = null;
        try {
            try {
                fos = new FileOutputStream(file);
                exporter.export(book, (OutputStream)fos);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
        String contentType = bookName.endsWith(".xls") ? Medias.EXCEL_MIME_TYPE : Medias.EXCEL_XML_MIME_TYPE;
        String extension = bookName.endsWith(".xls") ? "xls" : "xlsx";
        try {
            Filedownload.save((Media)new AMedia(bookName, contentType, extension, file, true));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (isProtected) {
            Helper.protectSheet(book.getSheetAt(0));
        }
        return true;
    }
}

