/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.db;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import com.zaxxer.hikari.HikariPoolMXBean;
import java.io.File;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.RowSet;
import org.adempiere.db.postgresql.PostgreSQLBundleActivator;
import org.adempiere.exceptions.DBException;
import org.compiere.db.AdempiereDatabase;
import org.compiere.db.CConnection;
import org.compiere.db.Database;
import org.compiere.dbPort.Convert;
import org.compiere.dbPort.Convert_PostgreSQL;
import org.compiere.model.MColumn;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Ini;
import org.compiere.util.Language;
import org.compiere.util.Trx;
import org.compiere.util.Util;

public class DB_PostgreSQL
implements AdempiereDatabase {
    private static final String P_POSTGRE_SQL_NATIVE = "PostgreSQLNative";
    private static final String POOL_PROPERTIES = "hikaricp.properties";
    private static Boolean sysNative = null;
    private org.postgresql.Driver s_driver = null;
    public static final String DRIVER = "org.postgresql.Driver";
    public static final int DEFAULT_PORT = 5432;
    private volatile HikariDataSource m_ds;
    private Convert_PostgreSQL m_convert = new Convert_PostgreSQL();
    private String m_dbName = null;
    private String m_userName = null;
    private String m_connectionURL;
    private static final CLogger log;
    private static final String NATIVE_MARKER;
    private CCache<String, String> convertCache = new CCache(null, "DB_PostgreSQL_Convert_Cache", 1000, CCache.DEFAULT_EXPIRE_MINUTE, false);
    private static final List<String> reservedKeywords;
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private final CountDownLatch initializedLatch = new CountDownLatch(1);

    static {
        String property = System.getProperty(P_POSTGRE_SQL_NATIVE);
        if (!Util.isEmpty((String)property, (boolean)true)) {
            sysNative = "Y".equalsIgnoreCase(property);
        }
        log = CLogger.getCLogger(DB_PostgreSQL.class);
        NATIVE_MARKER = "NATIVE_" + Database.DB_POSTGRESQL + "_KEYWORK";
        reservedKeywords = Arrays.asList("limit", "action", "old", "new");
    }

    public Convert getConvert() {
        return this.m_convert;
    }

    public String getName() {
        return Database.DB_POSTGRESQL;
    }

    public String getDescription() {
        try {
            if (this.s_driver == null) {
                this.getDriver();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.s_driver != null) {
            return this.s_driver.toString();
        }
        return "No Driver";
    }

    public int getStandardPort() {
        return 5432;
    }

    public Driver getDriver() throws SQLException {
        if (this.s_driver == null) {
            this.s_driver = new org.postgresql.Driver();
            DriverManager.registerDriver((Driver)this.s_driver);
            DriverManager.setLoginTimeout(Database.CONNECTION_TIMEOUT);
        }
        return this.s_driver;
    }

    public String getConnectionURL(CConnection connection) {
        StringBuilder sb = new StringBuilder("jdbc:postgresql://").append(connection.getDbHost()).append(":").append(connection.getDbPort()).append("/").append(connection.getDbName()).append("?encoding=UNICODE&ApplicationName=iDempiere");
        String urlParameters = System.getProperty("org.idempiere.postgresql.URLParameters");
        if (!Util.isEmpty((String)urlParameters)) {
            sb.append("&").append(urlParameters);
        }
        return sb.toString();
    }

    public String getConnectionURL(String dbHost, int dbPort, String dbName, String userName) {
        StringBuilder sb = new StringBuilder("jdbc:postgresql://").append(dbHost).append(":").append(dbPort).append("/").append(dbName);
        String urlParameters = System.getProperty("org.idempiere.postgresql.URLParameters");
        if (!Util.isEmpty((String)urlParameters)) {
            sb.append("?").append(urlParameters);
        }
        return sb.toString();
    }

    public String getConnectionURL(String connectionURL, String userName) {
        this.m_userName = userName;
        this.m_connectionURL = connectionURL;
        return this.m_connectionURL;
    }

    public String getCatalog() {
        if (this.m_dbName != null) {
            return this.m_dbName;
        }
        return null;
    }

    public String getSchema() {
        return "adempiere";
    }

    public boolean supportsBLOB() {
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DB_PostgreSQL[");
        sb.append(this.m_connectionURL);
        try {
            StringBuilder logBuffer = new StringBuilder();
            HikariPoolMXBean mxBean = this.m_ds.getHikariPoolMXBean();
            logBuffer.append("# Connections: ").append(mxBean.getTotalConnections());
            logBuffer.append(" , # Busy Connections: ").append(mxBean.getActiveConnections());
            logBuffer.append(" , # Idle Connections: ").append(mxBean.getIdleConnections());
            logBuffer.append(" , # Threads waiting on connection: ").append(mxBean.getThreadsAwaitingConnection());
        }
        catch (Exception e) {
            sb.append("=").append(e.getLocalizedMessage());
        }
        sb.append("]");
        return sb.toString();
    }

    public String getStatus() {
        if (this.m_ds == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        try {
            HikariPoolMXBean mxBean = this.m_ds.getHikariPoolMXBean();
            sb.append("# Connections: ").append(mxBean.getTotalConnections());
            sb.append(" , # Busy Connections: ").append(mxBean.getActiveConnections());
            sb.append(" , # Idle Connections: ").append(mxBean.getIdleConnections());
            sb.append(" , # Threads waiting on connection: ").append(mxBean.getThreadsAwaitingConnection());
            sb.append(" , # Min Pool Size: ").append(this.m_ds.getMinimumIdle());
            sb.append(" , # Max Pool Size: ").append(this.m_ds.getMaximumPoolSize());
            sb.append(" , # Open Transactions: ").append(Trx.getOpenTransactions().length);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sb.toString();
    }

    public String convertStatement(String oraStatement) {
        String cache;
        if (!this.isNativeMode() && (cache = (String)this.convertCache.get((Object)oraStatement)) != null) {
            Convert.logMigrationScript((String)oraStatement, (String)cache);
            if ("true".equals(System.getProperty("org.idempiere.db.debug"))) {
                String filterPgDebug = System.getProperty("org.idempiere.db.debug.filter");
                boolean print = true;
                if (filterPgDebug != null) {
                    print = cache.matches(filterPgDebug);
                }
                if (print) {
                    log.warning("Pgsql  -> " + cache);
                }
            }
            return cache;
        }
        String[] retValue = this.m_convert.convert(oraStatement);
        if (retValue == null || retValue.length == 0) {
            return oraStatement;
        }
        if (retValue.length != 1) {
            log.log(Level.SEVERE, "DB_PostgreSQL.convertStatement - Convert Command Number=" + retValue.length + " (" + oraStatement + ") - " + this.m_convert.getConversionError());
            throw new IllegalArgumentException("DB_PostgreSQL.convertStatement - Convert Command Number=" + retValue.length + " (" + oraStatement + ") - " + this.m_convert.getConversionError());
        }
        if (!this.isNativeMode()) {
            this.convertCache.put((Object)oraStatement, (Object)retValue[0]);
        }
        if (log.isLoggable(Level.FINE) && !oraStatement.equals(retValue[0]) && retValue[0].indexOf("AD_Error") == -1 && log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "PostgreSQL =>" + retValue[0] + "<= <" + oraStatement + ">");
        }
        Convert.logMigrationScript((String)oraStatement, (String)retValue[0]);
        return retValue[0];
    }

    public String getSystemUser() {
        String systemUser = System.getProperty("ADEMPIERE_DB_SYSTEM_USER");
        if (systemUser == null) {
            systemUser = "postgres";
        }
        return systemUser;
    }

    public String getSystemDatabase(String databaseName) {
        return "template1";
    }

    public String TO_DATE(Timestamp time, boolean dayOnly) {
        if (time == null) {
            if (dayOnly) {
                return "current_date";
            }
            return "current_timestamp";
        }
        StringBuilder dateString = new StringBuilder("TO_TIMESTAMP('");
        String myDate = time.toString();
        if (dayOnly) {
            dateString.append(myDate.substring(0, 10));
            dateString.append("','YYYY-MM-DD')");
        } else {
            dateString.append(myDate.substring(0, myDate.indexOf(46)));
            dateString.append("','YYYY-MM-DD HH24:MI:SS')");
        }
        return dateString.toString();
    }

    public String TO_CHAR(String columnName, int displayType, String AD_Language) {
        StringBuilder retValue = null;
        if (DisplayType.isDate((int)displayType)) {
            retValue = new StringBuilder("TO_CHAR(");
            retValue.append(columnName).append(",'").append(Language.getLanguage((String)AD_Language).getDBdatePattern()).append("')");
        } else {
            retValue = new StringBuilder("CAST (");
            retValue.append(columnName);
            retValue.append(" AS Text)");
        }
        return retValue.toString();
    }

    public String TO_NUMBER(BigDecimal number, int displayType) {
        if (number == null) {
            return "NULL";
        }
        BigDecimal result = number;
        int scale = DisplayType.getDefaultPrecision((int)displayType);
        if (scale > number.scale()) {
            try {
                result = number.setScale(scale, RoundingMode.HALF_UP);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result.toString();
    }

    public String[] getCommands(int cmdType) {
        if (cmdType == 0) {
            return new String[]{"CREATE USER adempiere;"};
        }
        if (1 == cmdType) {
            return new String[]{"CREATE DATABASE adempiere OWNER adempiere;", "GRANT ALL PRIVILEGES ON adempiere TO adempiere;", "CREATE SCHEMA adempiere;", "SET search_path TO adempiere;"};
        }
        if (2 == cmdType) {
            return new String[]{"DROP DATABASE adempiere;"};
        }
        return null;
    }

    public RowSet getRowSet(ResultSet rs) throws SQLException {
        throw new UnsupportedOperationException("PostgreSQL does not support RowSets");
    }

    public Connection getCachedConnection(CConnection connection, boolean autoCommit, int transactionIsolation) throws Exception {
        Connection conn = null;
        if (this.m_ds == null) {
            this.getDataSource(connection);
        }
        if ((conn = this.m_ds.getConnection()).getTransactionIsolation() != transactionIsolation) {
            conn.setTransactionIsolation(transactionIsolation);
        }
        if (conn.getAutoCommit() != autoCommit) {
            conn.setAutoCommit(autoCommit);
        }
        return conn;
    }

    private String getPoolPropertiesFile() {
        String base = Ini.getAdempiereHome();
        if (base != null && !base.endsWith(File.separator)) {
            base = String.valueOf(base) + File.separator;
        }
        return String.valueOf(base) + this.getName() + File.separator + POOL_PROPERTIES;
    }

    public DataSource getDataSource(CConnection connection) {
        this.ensureInitialized(connection);
        return this.m_ds;
    }

    public ConnectionPoolDataSource createPoolDataSource(CConnection connection) {
        throw new UnsupportedOperationException("Not supported/implemented");
    }

    public Connection getDriverConnection(CConnection connection) throws SQLException {
        this.getDriver();
        return DriverManager.getConnection(this.getConnectionURL(connection), connection.getDbUid(), connection.getDbPwd());
    }

    public Connection getDriverConnection(String dbUrl, String dbUid, String dbPwd) throws SQLException {
        this.getDriver();
        return DriverManager.getConnection(dbUrl, dbUid, dbPwd);
    }

    private Properties getPoolProperties() {
        Throwable throwable;
        File userPropertyFile = new File(this.getPoolPropertiesFile());
        URL propertyFileURL = null;
        if (userPropertyFile.exists() && userPropertyFile.canRead()) {
            try {
                propertyFileURL = userPropertyFile.toURI().toURL();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (propertyFileURL == null) {
            propertyFileURL = PostgreSQLBundleActivator.bundleContext.getBundle().getEntry("META-INF/pool/server.default.properties");
        }
        Properties poolProperties = new Properties();
        try {
            Throwable throwable2 = null;
            throwable = null;
            try (InputStream propertyFileInputStream = propertyFileURL.openStream();){
                poolProperties.load(propertyFileInputStream);
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Exception e) {
            throw new DBException(e);
        }
        if (!userPropertyFile.exists()) {
            try {
                Path directory = userPropertyFile.toPath().getParent();
                Files.createDirectories(directory, new FileAttribute[0]);
                throwable = null;
                Object var6_12 = null;
                try (InputStream propertyFileInputStream = propertyFileURL.openStream();){
                    Files.copy(propertyFileInputStream, userPropertyFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return poolProperties;
    }

    private void ensureInitialized(CConnection connection) {
        if (!this.initialized.compareAndSet(false, true)) {
            try {
                this.initializedLatch.await();
            }
            catch (InterruptedException e) {
                return;
            }
        }
        try {
            Properties poolProperties = this.getPoolProperties();
            if (!poolProperties.containsKey("jdbcUrl")) {
                poolProperties.put("jdbcUrl", this.getConnectionURL(connection));
            }
            if (!poolProperties.containsKey("username")) {
                poolProperties.put("username", connection.getDbUid());
            }
            if (!poolProperties.containsKey("password")) {
                poolProperties.put("password", connection.getDbPwd());
            }
            HikariConfig hikariConfig = new HikariConfig(poolProperties);
            hikariConfig.setDriverClassName(DRIVER);
            this.m_ds = new HikariDataSource(hikariConfig);
            this.m_connectionURL = this.m_ds.getJdbcUrl();
            this.initializedLatch.countDown();
        }
        catch (Exception ex) {
            throw new IllegalStateException("Could not initialise Hikari Datasource", ex);
        }
    }

    public void close() {
        if (log.isLoggable(Level.CONFIG)) {
            log.config(this.toString());
        }
        try {
            this.m_ds.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getAlternativeSQL(int reExNo, String msg, String sql) {
        return null;
    }

    public String getConstraintType(Connection conn, String tableName, String IXName) {
        if (IXName == null || IXName.length() == 0) {
            return "0";
        }
        if (IXName.toUpperCase().endsWith("_KEY")) {
            return "1" + IXName;
        }
        return "0";
    }

    public boolean isSupported(String sql) {
        return true;
    }

    public static void dumpLocks(Connection conn) {
        block8: {
            Statement stmt = null;
            ResultSet rs = null;
            try {
                try {
                    String sql = "select pg_class.relname,pg_locks.* from pg_class,pg_locks where pg_class.relfilenode=pg_locks.relation order by 1";
                    stmt = conn.createStatement();
                    rs = stmt.executeQuery(sql);
                    int cnt = rs.getMetaData().getColumnCount();
                    System.out.println();
                    while (rs.next()) {
                        int i = 0;
                        while (i < cnt) {
                            Object value = rs.getObject(i + 1);
                            if (i > 0) {
                                System.out.print(", ");
                            }
                            System.out.print(value != null ? value.toString() : "");
                            ++i;
                        }
                        System.out.println();
                    }
                    System.out.println();
                }
                catch (Exception exception) {
                    DB.close(rs, (Statement)stmt);
                    rs = null;
                    stmt = null;
                    break block8;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, stmt);
                rs = null;
                stmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)stmt);
            rs = null;
            stmt = null;
        }
    }

    public int getNextID(String name) {
        return this.getNextID(name, null);
    }

    public int getNextID(String name, String trxName) {
        int m_sequence_id = -1;
        try (Trx trx = null;){
            try {
                if (trxName == null) {
                    trxName = Trx.createTrxName((String)"getNextval");
                    trx = Trx.get((String)trxName, (boolean)true);
                }
                m_sequence_id = DB.getSQLValueEx((String)trxName, (String)("SELECT nextval('" + name.toLowerCase() + "')"), (Object[])new Object[0]);
            }
            catch (Exception e) {
                if (trx != null) {
                    trx.rollback();
                }
                if (trx != null) {
                    trx.close();
                }
            }
        }
        return m_sequence_id;
    }

    public boolean createSequence(String name, int increment, int minvalue, int maxvalue, int start, String trxName) {
        int no;
        int cnt = DB.getSQLValueEx((String)trxName, (String)"SELECT COUNT(*) FROM pg_class WHERE UPPER(relname)=? AND relkind='S'", (Object[])new Object[]{name.toUpperCase()});
        if (start < minvalue) {
            start = minvalue;
        }
        return (no = cnt == 0 ? DB.executeUpdate((String)("CREATE SEQUENCE " + name.toUpperCase() + " INCREMENT BY " + increment + " MINVALUE " + minvalue + " MAXVALUE " + maxvalue + " START WITH " + start), (String)trxName) : DB.executeUpdate((String)("ALTER SEQUENCE " + name.toUpperCase() + " INCREMENT BY " + increment + " MINVALUE " + minvalue + " MAXVALUE " + maxvalue + " RESTART WITH " + start), (String)trxName)) != -1;
    }

    public boolean isQueryTimeoutSupported() {
        return true;
    }

    public String addPagingSQL(String sql, int start, int end) {
        StringBuilder newSql = new StringBuilder(sql);
        if (start > 1) {
            newSql.append(" OFFSET ").append(start - 1).append(" ROWS");
        }
        if (end > 0) {
            newSql.append(" FETCH FIRST ").append(end - start + 1).append(" ROWS ONLY");
        }
        return newSql.toString();
    }

    public boolean isPagingSupported() {
        return true;
    }

    public boolean forUpdate(PO po, int timeout) {
        if (po.get_TrxName() == null) {
            return false;
        }
        String[] keyColumns = po.get_KeyColumns();
        if (keyColumns != null && keyColumns.length > 0 && !po.is_new()) {
            ResultSet rs;
            CPreparedStatement stmt;
            block12: {
                StringBuilder sqlBuffer = new StringBuilder(" SELECT ");
                sqlBuffer.append(keyColumns[0]).append(" FROM ").append(po.get_TableName()).append(" WHERE ");
                int i = 0;
                while (i < keyColumns.length) {
                    if (i > 0) {
                        sqlBuffer.append(" AND ");
                    }
                    sqlBuffer.append(keyColumns[i]).append("=?");
                    ++i;
                }
                sqlBuffer.append(" FOR UPDATE ");
                Object[] parameters = new Object[keyColumns.length];
                int i2 = 0;
                while (i2 < keyColumns.length) {
                    Object parameter = po.get_Value(keyColumns[i2]);
                    if (parameter != null && parameter instanceof Boolean) {
                        parameter = (Boolean)parameter != false ? "Y" : "N";
                    }
                    parameters[i2] = parameter;
                    ++i2;
                }
                stmt = null;
                rs = null;
                try {
                    stmt = DB.prepareStatement((String)sqlBuffer.toString(), (int)1003, (int)1008, (String)po.get_TrxName());
                    int i3 = 0;
                    while (i3 < keyColumns.length) {
                        stmt.setObject(i3 + 1, parameters[i3]);
                        ++i3;
                    }
                    stmt.setQueryTimeout(timeout > 0 ? timeout : 60);
                    rs = stmt.executeQuery();
                    if (!rs.next()) break block12;
                }
                catch (Exception e) {
                    try {
                        if (log.isLoggable(Level.INFO)) {
                            log.log(Level.INFO, e.getLocalizedMessage(), (Throwable)e);
                        }
                        throw new DBException("Could not lock record for " + po.toString() + " caused by " + e.getLocalizedMessage());
                    }
                    catch (Throwable throwable) {
                        DB.close(rs, stmt);
                        rs = null;
                        stmt = null;
                        throw throwable;
                    }
                }
                DB.close((ResultSet)rs, (Statement)stmt);
                rs = null;
                stmt = null;
                return true;
            }
            DB.close((ResultSet)rs, (Statement)stmt);
            rs = null;
            stmt = null;
            return false;
        }
        return false;
    }

    public String getNameOfUniqueConstraintError(Exception e) {
        String info = e.getMessage();
        int fromIndex = info.indexOf("\"");
        if (fromIndex == -1) {
            fromIndex = info.indexOf("\u00ab");
        }
        if (fromIndex == -1) {
            return info;
        }
        int toIndex = info.indexOf("\"", fromIndex + 1);
        if (toIndex == -1) {
            toIndex = info.indexOf("\u00bb", fromIndex + 1);
        }
        if (toIndex == -1) {
            return info;
        }
        return info.substring(fromIndex + 1, toIndex);
    }

    public String subsetClauseForCSV(String columnName, String csv) {
        StringBuilder builder = new StringBuilder();
        builder.append("string_to_array(").append(columnName).append(",',')");
        builder.append(" <@ ");
        builder.append("string_to_array(").append(DB.TO_STRING((String)csv)).append(",',')");
        return builder.toString();
    }

    public String quoteColumnName(String columnName) {
        if (!this.isNativeMode()) {
            return columnName;
        }
        String lowerCase = columnName.toLowerCase();
        if (reservedKeywords.contains(lowerCase)) {
            StringBuilder sql = new StringBuilder("\"");
            sql.append(lowerCase).append("\"");
            return sql.toString();
        }
        return columnName;
    }

    public String intersectClauseForCSV(String columnName, String csv) {
        return this.intersectClauseForCSV(columnName, csv, false);
    }

    public String intersectClauseForCSV(String columnName, String csv, boolean isNotClause) {
        StringBuilder builder = new StringBuilder();
        if (isNotClause) {
            builder.append("NOT");
        }
        builder.append("(string_to_array(").append(columnName).append(",',')");
        builder.append(" && ");
        builder.append("string_to_array(").append(DB.TO_STRING((String)csv)).append(",','))");
        return builder.toString();
    }

    public boolean isNativeMode() {
        return DB_PostgreSQL.isUseNativeDialect();
    }

    public static final boolean isUseNativeDialect() {
        if (Convert.isLogMigrationScript()) {
            return false;
        }
        if (sysNative != null) {
            return sysNative;
        }
        if (!Util.isEmpty((String)Ini.getProperty((String)P_POSTGRE_SQL_NATIVE), (boolean)true)) {
            return Ini.isPropertyBool((String)P_POSTGRE_SQL_NATIVE);
        }
        return true;
    }

    public static final String markNativeKeyword(String keyword) {
        if (DB_PostgreSQL.isUseNativeDialect()) {
            return keyword;
        }
        return String.valueOf(NATIVE_MARKER) + keyword;
    }

    public static final String removeNativeKeyworkMarker(String statement) {
        return statement.replace(NATIVE_MARKER, "");
    }

    public String getNumericDataType() {
        return "NUMERIC";
    }

    public String getCharacterDataType() {
        return "CHAR";
    }

    public String getVarcharDataType() {
        return "VARCHAR";
    }

    public String getBlobDataType() {
        return "BYTEA";
    }

    public String getClobDataType() {
        return "TEXT";
    }

    public String getTimestampDataType() {
        return "TIMESTAMP";
    }

    public String getTimestampWithTimezoneDataType() {
        return "TIMESTAMP WITH TIME ZONE";
    }

    public String getSQLDDL(MColumn column) {
        String defaultValue;
        StringBuilder sql = new StringBuilder().append(column.getColumnName()).append(" ").append(column.getSQLDataType());
        if (column.isMandatory()) {
            sql.append(" NOT NULL");
        }
        if (column.getAD_Reference_ID() == 20) {
            sql.append(" CHECK (").append(column.getColumnName()).append(" IN ('Y','N'))");
        }
        if (!((defaultValue = column.getDefaultValue()) == null || defaultValue.length() <= 0 || defaultValue.indexOf(64) != -1 || DisplayType.isID((int)column.getAD_Reference_ID()) && defaultValue.equals("-1"))) {
            if ((DisplayType.isText((int)column.getAD_Reference_ID()) || DisplayType.isList((int)column.getAD_Reference_ID()) || column.getAD_Reference_ID() == 20 || column.getColumnName().equals("EntityType") || column.getColumnName().equals("AD_Language") || column.getAD_Reference_ID() == 28 && !column.getColumnName().endsWith("_ID")) && !defaultValue.startsWith("'") && !defaultValue.endsWith("'")) {
                defaultValue = DB.TO_STRING((String)defaultValue);
            }
            if (defaultValue.equalsIgnoreCase("sysdate")) {
                defaultValue = "getDate()";
            }
            sql.append(" DEFAULT ").append(defaultValue);
        } else {
            if (!column.isMandatory()) {
                sql.append(" DEFAULT NULL ");
            }
            defaultValue = null;
        }
        return sql.toString();
    }

    public String getSQLAdd(MTable table, MColumn column) {
        StringBuilder sql = new StringBuilder("ALTER TABLE ").append(table.getTableName()).append(" ADD COLUMN ").append(column.getSQLDDL());
        String constraint = column.getConstraint(table.getTableName());
        if (constraint != null && constraint.length() > 0) {
            sql.append("; ").append("ALTER TABLE ").append(table.getTableName()).append(" ADD ").append(constraint);
        }
        return sql.toString();
    }

    public String getSQLModify(MTable table, MColumn column, boolean setNullOption) {
        String defaultValue;
        StringBuilder sql = new StringBuilder("INSERT INTO t_alter_column values('").append(table.getTableName()).append("','").append(this.quoteColumnName(column.getColumnName())).append("','").append(column.getSQLDataType()).append("',");
        if (setNullOption) {
            if (column.isMandatory()) {
                sql.append("'NOT NULL',");
            } else {
                sql.append("'NULL',");
            }
        } else {
            sql.append("null,");
        }
        String originalDefaultValue = defaultValue = column.getDefaultValue();
        if (!(defaultValue == null || defaultValue.length() <= 0 || defaultValue.indexOf(64) != -1 || DisplayType.isID((int)column.getAD_Reference_ID()) && defaultValue.equals("-1"))) {
            if (defaultValue.equalsIgnoreCase("sysdate")) {
                defaultValue = "getDate()";
            }
            if (!defaultValue.startsWith("'") && !defaultValue.endsWith("'")) {
                defaultValue = DB.TO_STRING((String)defaultValue);
            }
            sql.append(defaultValue);
        } else {
            sql.append("null");
            defaultValue = null;
        }
        sql.append(")");
        if (column.isMandatory() && defaultValue != null && defaultValue.length() > 0) {
            if (!(DisplayType.isText((int)column.getAD_Reference_ID()) || DisplayType.isList((int)column.getAD_Reference_ID()) || column.getAD_Reference_ID() == 20 || column.getAD_Reference_ID() == 200012 || column.getColumnName().equals("EntityType") || column.getColumnName().equals("AD_Language") || column.getAD_Reference_ID() == 28 && !column.getColumnName().endsWith("_ID") || !(defaultValue = originalDefaultValue).equalsIgnoreCase("sysdate"))) {
                defaultValue = "getDate()";
            }
            StringBuilder sqlSet = new StringBuilder("UPDATE ").append(table.getTableName()).append(" SET ").append(this.quoteColumnName(column.getColumnName())).append("=").append(defaultValue).append(" WHERE ").append(this.quoteColumnName(column.getColumnName())).append(" IS NULL");
            sql.append("; ").append((CharSequence)sqlSet);
        }
        return sql.toString();
    }

    public boolean isQueryTimeout(SQLException ex) {
        return "57014".equals(ex.getSQLState());
    }
}

