/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkplus.jpa;

import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.util.Configuration;

public class JpaUtil {
    private static final Logger log = LoggerFactory.getLogger(JpaUtil.class);
    public static final String CONFIG = "JpaUtil.PersistenceUnitName";
    public static final String JPA_EMF_MAP = "org.zkoss.zkplus.jpa.EmfMap";
    public static final String JPA_EM_MAP = "org.zkoss.zkplus.jpa.EmMap";

    private static Map<String, EntityManagerFactory> getEmfMap() {
        HashMap map = (HashMap)JpaUtil.getWebApp().getAttribute(JPA_EMF_MAP);
        if (map == null) {
            map = new HashMap();
            JpaUtil.getWebApp().setAttribute(JPA_EMF_MAP, map);
        }
        return map;
    }

    private static Map<String, EntityManager> getEmMap() {
        Execution current = Executions.getCurrent();
        HashMap map = (HashMap)current.getAttribute(JPA_EM_MAP);
        if (map == null) {
            map = new HashMap();
            Executions.getCurrent().setAttribute(JPA_EM_MAP, map);
        }
        return map;
    }

    public static EntityManagerFactory getEntityManagerFactory() {
        return JpaUtil.initEntityManagerFactory(null, null);
    }

    public static EntityManagerFactory getEntityManagerFactory(String puName) {
        return JpaUtil.initEntityManagerFactory(puName, null);
    }

    public static EntityManagerFactory getEntityManagerFactory(String puName, Map properties) {
        return JpaUtil.initEntityManagerFactory(puName, properties);
    }

    public static EntityManager getEntityManager() {
        return JpaUtil.initEntityManger(null, null);
    }

    public static EntityManager getEntityManager(String puName) {
        return JpaUtil.initEntityManger(puName, null);
    }

    public static void closeEntityManager() {
        JpaUtil.closeEntityManager(null);
    }

    public static void closeEntityManager(String puName) {
        EntityManager em = JpaUtil.getEmMap().remove(JpaUtil.getPersistenceUnitName(puName));
        if (em != null && em.isOpen()) {
            em.close();
        }
    }

    public static EntityManager getEntiyManager(String puName, Map properties) {
        return JpaUtil.initEntityManger(puName, properties);
    }

    private static EntityManagerFactory initEntityManagerFactory(String puName, Map properties) {
        EntityManagerFactory emf;
        if (properties == null) {
            emf = JpaUtil.getEmfMap().get(puName);
            if (emf == null) {
                emf = JpaUtil.createEntityManagerFactory(puName, null);
                JpaUtil.getEmfMap().put(puName, emf);
            }
        } else {
            emf = JpaUtil.createEntityManagerFactory(puName, properties);
            JpaUtil.getEmfMap().put(puName, emf);
        }
        return emf;
    }

    private static EntityManager initEntityManger(String puName, Map properties) {
        EntityManager em;
        if (properties == null) {
            String puName2 = JpaUtil.getPersistenceUnitName(puName);
            em = JpaUtil.getEmMap().get(puName2);
            if (em == null) {
                em = JpaUtil.createEntityManager(puName, null);
                JpaUtil.getEmMap().put(puName2, em);
            }
        } else {
            em = JpaUtil.createEntityManager(puName, properties);
            JpaUtil.getEmMap().put(JpaUtil.getPersistenceUnitName(puName), em);
        }
        return em;
    }

    private static EntityManagerFactory createEntityManagerFactory(String puName, Map properties) {
        EntityManagerFactory emf;
        puName = JpaUtil.getPersistenceUnitName(puName);
        try {
            if (properties == null) {
                emf = Persistence.createEntityManagerFactory((String)puName);
                log.info("EntityManagerFactory for: " + puName + " is created ");
            } else {
                emf = Persistence.createEntityManagerFactory((String)puName, (Map)properties);
                log.info("EntityManagerFactory for: " + puName + " with properties " + properties + " is created ");
            }
        }
        catch (Exception ex) {
            log.error("Initial EntityManagerFactory creation failed." + ex);
            throw new ExceptionInInitializerError(ex);
        }
        JpaUtil.getEmfMap().put(puName, emf);
        return emf;
    }

    private static EntityManager createEntityManager(String puName, Map properties) {
        puName = JpaUtil.getPersistenceUnitName(puName);
        EntityManager em = JpaUtil.initEntityManagerFactory(puName, properties).createEntityManager();
        return em;
    }

    private static WebApp getWebApp() {
        Desktop desktop;
        WebApp app = null;
        Execution exec = Executions.getCurrent();
        if (exec != null && (desktop = exec.getDesktop()) != null) {
            app = desktop.getWebApp();
        }
        return app;
    }

    private static String getPersistenceUnitName(String pu) {
        if (pu == null || pu.equals("")) {
            Configuration config = JpaUtil.getWebApp().getConfiguration();
            pu = config.getPreference(CONFIG, null);
        }
        if (pu == null) {
            throw new UiException("Forget to specify the preference of JpaUtil.PersistenceUnitName in WEB-INF/zk.xml?");
        }
        return pu;
    }
}

