/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.printformat.editor.ui;

import org.compiere.print.MPrintFormatItem;
import org.compiere.util.DisplayType;
import org.compiere.util.Util;
import org.zkoss.zk.ui.HtmlBasedComponent;

public class PrintFormatEditorUtil {
    public static void addCSSStyle(HtmlBasedComponent comp, String style, boolean isAppend) {
        if (!Util.isEmpty((String)comp.getStyle(), (boolean)true) && isAppend) {
            comp.setStyle(String.valueOf(comp.getStyle()) + style);
        } else {
            comp.setStyle(style);
        }
    }

    public static int pointToPixel(float point) {
        return Float.valueOf(point * 4.0f / 3.0f).intValue();
    }

    public static float pixelToPointValue(int pixel) {
        return (float)pixel * 3.0f / 4.0f;
    }

    public static float inchToPointValue(float inch) {
        return inch * 72.0f;
    }

    public static float mmToPointValue(float mm) {
        return PrintFormatEditorUtil.inchToPointValue(mm / 25.4f);
    }

    public static String getCSSFontFamily(String fontFamily) {
        if ("Dialog".equals(fontFamily) || "DialogInput".equals(fontFamily) || "SansSerif".equals(fontFamily)) {
            return "sans-serif";
        }
        if ("SansSerif".equals(fontFamily)) {
            return "sans-serif";
        }
        if ("Serif".equals(fontFamily)) {
            return "serif";
        }
        if ("Monospaced".equals(fontFamily)) {
            return "monospace";
        }
        return null;
    }

    public static String getAlignmentStyleCSS(MPrintFormatItem pfItem) {
        String retValue = "left";
        String align = pfItem.getFieldAlignmentType();
        if (align != null) {
            if (align.equalsIgnoreCase("L")) {
                retValue = "left";
            } else if (align.equalsIgnoreCase("T")) {
                retValue = "right";
            } else if (align.equals("C")) {
                retValue = "center";
            }
        }
        if (align == null || align.equalsIgnoreCase("D")) {
            retValue = DisplayType.isNumeric((int)pfItem.getAD_Column().getAD_Reference_ID()) ? "right" : "left";
        }
        return retValue;
    }

    public static void setX(MPrintFormatItem pfItem, float xVal) {
        if (!pfItem.isRelativePosition()) {
            pfItem.setXPosition(Float.valueOf(xVal).intValue());
        } else {
            pfItem.setXSpace(Float.valueOf(xVal).intValue());
        }
    }

    public static void setY(MPrintFormatItem pfItem, float yVal) {
        if (!pfItem.isRelativePosition()) {
            pfItem.setYPosition(Float.valueOf(yVal).intValue());
        } else {
            pfItem.setYSpace(Float.valueOf(yVal).intValue());
        }
    }

    public static int getX(MPrintFormatItem pfItem) {
        int retVal = 0;
        retVal = !pfItem.isRelativePosition() ? pfItem.getXPosition() : pfItem.getXSpace();
        return retVal;
    }

    public static int getY(MPrintFormatItem pfItem) {
        int retVal = 0;
        retVal = !pfItem.isRelativePosition() ? pfItem.getYPosition() : pfItem.getYSpace();
        return retVal;
    }
}

