/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.db.oracle.config;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.adempiere.install.DBConfigStatus;
import org.adempiere.install.IDBConfigMonitor;
import org.adempiere.install.IDatabaseConfig;
import org.compiere.db.AdempiereDatabase;
import org.compiere.db.Database;
import org.compiere.install.ConfigurationData;
import org.compiere.util.CLogger;

public class ConfigOracle
implements IDatabaseConfig {
    private static final CLogger log = CLogger.getCLogger(ConfigOracle.class);
    private String[] p_discovered = null;
    private String[] p_dbname = null;
    private Connection m_con = null;
    private boolean m_XE = false;
    private AdempiereDatabase p_db = Database.getDatabase((String)Database.DB_ORACLE);

    public void init(ConfigurationData configurationData) {
        configurationData.setDatabasePort(String.valueOf(1521));
        configurationData.setDatabaseSystemPassword(true);
    }

    public String[] discoverDatabases(String selected) {
        String path;
        String serviceName;
        if (this.p_discovered != null) {
            return this.p_discovered;
        }
        ArrayList<String> list = new ArrayList<String>();
        ArrayList<String> dblist = new ArrayList<String>();
        String def = selected;
        if (def != null && def.trim().length() == 0) {
            def = null;
        }
        if (def != null) {
            list.add(def.toLowerCase());
            dblist.add(def.toLowerCase());
        }
        if (this.m_XE && !list.contains(serviceName = "xe")) {
            list.add(serviceName);
            dblist.add(serviceName);
        }
        if ((path = System.getenv("ORACLE_HOME")) == null) {
            path = System.getProperty("java.library.path");
            String[] entries = path.split(File.pathSeparator);
            int e = 0;
            while (e < entries.length) {
                String entry = entries[e].toLowerCase();
                if (entry.indexOf("ora") != -1 && entry.endsWith("bin")) {
                    StringBuffer sb = this.getTNS_File(entries[e].substring(0, entries[e].length() - 4));
                    String[] tnsnames = this.getTNS_Names(sb, true);
                    String[] dbNames = this.getTNS_Names(sb, false);
                    if (dbNames == null) {
                        dbNames = tnsnames;
                    }
                    if (tnsnames != null) {
                        int i = 0;
                        while (i < tnsnames.length) {
                            String db;
                            String tns = tnsnames[i];
                            String string = db = i < dbNames.length ? dbNames[i] : tns;
                            if (!tns.equals(def)) {
                                list.add(tns);
                                dblist.add(db);
                            } else {
                                dblist.remove(0);
                                dblist.add(0, db);
                            }
                            ++i;
                        }
                        break;
                    }
                }
                ++e;
            }
        } else {
            StringBuffer sb = this.getTNS_File(path);
            String[] tnsnames = this.getTNS_Names(sb, true);
            String[] dbNames = this.getTNS_Names(sb, false);
            if (dbNames == null) {
                dbNames = tnsnames;
            }
            if (tnsnames != null) {
                int i = 0;
                while (i < tnsnames.length) {
                    String db;
                    String tns = tnsnames[i];
                    String string = db = i < dbNames.length ? dbNames[i] : tns;
                    if (!tns.equals(def)) {
                        list.add(tns);
                        dblist.add(db);
                    } else {
                        dblist.remove(0);
                        dblist.add(0, db);
                    }
                    ++i;
                }
            }
        }
        this.p_discovered = new String[list.size()];
        list.toArray(this.p_discovered);
        this.p_dbname = new String[dblist.size()];
        dblist.toArray(this.p_dbname);
        return this.p_discovered;
    }

    public String getDatabaseName(String nativeConnectioName) {
        int idx = -1;
        if (this.p_discovered == null) {
            return nativeConnectioName;
        }
        int i = 0;
        while (i < this.p_discovered.length) {
            if (this.p_discovered[i].equals(nativeConnectioName)) {
                idx = i;
                break;
            }
            ++i;
        }
        if (idx >= 0 && this.p_dbname != null && idx < this.p_dbname.length) {
            return this.p_dbname[idx];
        }
        return nativeConnectioName;
    }

    private StringBuffer getTNS_File(String oraHome) {
        String tnsnames = String.valueOf(oraHome) + File.separator + "network" + File.separator + "admin" + File.separator + "tnsnames.ora";
        File tnsfile = new File(tnsnames);
        if (!tnsfile.exists()) {
            return null;
        }
        log.fine(tnsnames);
        StringBuffer sb = new StringBuffer();
        FileReader fr = null;
        try {
            try {
                int c;
                fr = new FileReader(tnsfile);
                while ((c = fr.read()) != -1) {
                    sb.append((char)c);
                }
            }
            catch (IOException ex) {
                log.warning("Error Reading " + tnsnames);
                ex.printStackTrace();
                if (fr != null) {
                    try {
                        fr.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    fr = null;
                }
                return null;
            }
        }
        finally {
            if (fr != null) {
                try {
                    fr.close();
                }
                catch (Exception exception) {}
                fr = null;
            }
        }
        if (sb.length() == 0) {
            return null;
        }
        return sb;
    }

    private String[] getTNS_Names(StringBuffer tnsnames, boolean tns) {
        if (tnsnames == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        Pattern pattern = Pattern.compile("\n", 8);
        System.out.println(tnsnames);
        String[] lines = pattern.split(tnsnames);
        int i = 0;
        while (i < lines.length) {
            String entry;
            String line = lines[i].trim();
            if (log.isLoggable(Level.FINEST)) {
                log.finest(String.valueOf(i) + ": " + line);
            }
            if (tns) {
                if (line.length() > 0 && Character.isLetter(line.charAt(0)) && line.indexOf(61) != -1 && line.indexOf("EXTPROC_") == -1 && line.indexOf("_HTTP") == -1) {
                    entry = line.substring(0, line.indexOf(61)).trim().toLowerCase();
                    log.fine(entry);
                    list.add(entry);
                }
            } else if (line.length() > 0 && line.toUpperCase().indexOf("SERVICE_NAME") != -1) {
                entry = line.substring(line.indexOf(61) + 1).trim().toLowerCase();
                int index = entry.indexOf(41);
                if (index != 0) {
                    entry = entry.substring(0, index).trim();
                }
                log.fine(entry);
                list.add(entry);
            }
            ++i;
        }
        if (list.size() == 0) {
            return null;
        }
        String[] retValue = new String[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public String test(IDBConfigMonitor monitor, ConfigurationData data) {
        String server = data.getDatabaseServer();
        boolean pass = server != null && server.length() > 0;
        String error = "Not correct: DB Server = " + server;
        InetAddress databaseServer = null;
        try {
            if (pass) {
                databaseServer = InetAddress.getByName(server);
            }
        }
        catch (Exception e) {
            error = String.valueOf(error) + " - " + e.getMessage();
            pass = false;
        }
        if (monitor != null) {
            monitor.update(new DBConfigStatus("DATABASE_SERVER", "ErrorDatabaseServer", pass, true, error));
        }
        if (log.isLoggable(Level.INFO)) {
            log.info("OK: Database Server = " + databaseServer);
        }
        data.setProperty("ADEMPIERE_DB_SERVER", databaseServer != null ? databaseServer.getHostName() : null);
        data.setProperty("ADEMPIERE_DB_TYPE", data.getDatabaseType());
        data.setProperty("ADEMPIERE_DB_PATH", data.getDatabaseType().toLowerCase());
        int databasePort = data.getDatabasePort();
        pass = data.testPort(databaseServer, databasePort, true);
        error = "DB Server Port = " + databasePort;
        if (monitor != null) {
            monitor.update(new DBConfigStatus("DATABASE_SERVER", "ErrorDatabasePort", pass, true, error));
        }
        if (!pass) {
            return error;
        }
        if (log.isLoggable(Level.INFO)) {
            log.info("OK: Database Port = " + databasePort);
        }
        data.setProperty("ADEMPIERE_DB_PORT", String.valueOf(databasePort));
        boolean isDBExists = data.getDatabaseExists();
        String databaseName = data.getDatabaseName();
        String systemPassword = data.getDatabaseSystemPassword();
        pass = systemPassword != null && systemPassword.length() > 0;
        error = "No Database System Password entered";
        if (monitor != null) {
            monitor.update(new DBConfigStatus("DATABASE_SYSTEM_PASSWORD", "ErrorJDBC", pass, true, error));
        }
        if (!pass) {
            if (isDBExists) {
                log.warning(error);
            } else {
                return error;
            }
        }
        String url = "jdbc:oracle:thin:@//" + databaseServer.getHostName() + ":" + databasePort + "/" + databaseName;
        pass = this.testJDBC(url, this.p_db.getSystemUser(), systemPassword);
        error = "Error connecting: " + url + " - as " + this.p_db.getSystemUser() + "/" + systemPassword;
        if (monitor != null) {
            monitor.update(new DBConfigStatus("DATABASE_SYSTEM_PASSWORD", "ErrorJDBC", pass, true, error));
        }
        if (!pass) {
            if (isDBExists) {
                log.warning(error);
            } else {
                return error;
            }
        }
        if (log.isLoggable(Level.INFO)) {
            log.info("OK: Connection = " + url);
        }
        data.setProperty("ADEMPIERE_DB_URL", url);
        if (log.isLoggable(Level.INFO)) {
            log.info("OK: Database System User " + databaseName);
        }
        data.setProperty("ADEMPIERE_DB_NAME", databaseName);
        data.setProperty("ADEMPIERE_DB_SYSTEM", systemPassword);
        String databaseUser = data.getDatabaseUser();
        String databasePassword = data.getDatabasePassword();
        pass = databasePassword != null && databasePassword.length() > 0;
        error = "Invalid Database User Password";
        if (monitor != null) {
            monitor.update(new DBConfigStatus("DATABASE_USER", "ErrorJDBC", pass, true, error));
        }
        if (!pass) {
            return error;
        }
        pass = this.testJDBC(url, databaseUser, databasePassword);
        error = "Cannot connect to User: " + databaseUser + "/" + databasePassword + " - Database may not be imported yet (OK on initial run).";
        if (monitor != null) {
            boolean critical = true;
            if (!isDBExists) {
                critical = false;
            }
            monitor.update(new DBConfigStatus("DATABASE_USER", "ErrorJDBC", pass, critical, error));
        }
        if (pass) {
            if (log.isLoggable(Level.INFO)) {
                log.info("OK: Database User = " + databaseUser);
            }
            if (this.m_con != null) {
                data.setProperty("ADEMPIERE_WEBSTORES", data.getWebStores(this.m_con));
            }
        } else {
            if (isDBExists) {
                return error;
            }
            log.warning(error);
        }
        data.setProperty("ADEMPIERE_DB_USER", databaseUser);
        data.setProperty("ADEMPIERE_DB_PASSWORD", databasePassword);
        data.setProperty("ADEMPIERE_DB_EXISTS", isDBExists ? "Y" : "N");
        String testFile = "utils/oracle/Test.sql";
        if (!new File(testFile).isFile()) {
            String ospath = System.getProperty("os.name").startsWith("Windows") ? "windows" : "unix";
            testFile = "utils." + ospath + "/oracle/Test.sql";
            if (!new File(testFile).isFile() && !new File(testFile = "org.adempiere.server-feature/" + testFile).isFile()) {
                testFile = null;
            }
        }
        if (testFile != null) {
            String sqlplus = "sqlplus " + this.p_db.getSystemUser() + "/" + systemPassword + "@" + "//" + databaseServer.getHostName() + ":" + databasePort + "/" + databaseName + " @" + testFile;
            log.config(sqlplus);
            pass = this.testSQL(sqlplus);
            error = "Error connecting via: " + sqlplus;
        } else {
            pass = false;
            error = "Test file does not exist";
            log.warning(error);
        }
        if (monitor != null) {
            monitor.update(new DBConfigStatus("DATABASE_SQL_TEST", "ErrorTNS", pass, true, error));
        }
        if (pass) {
            log.info("OK: Database SQL Connection");
        }
        if (System.getProperty("TestOCI", "N").equals("Y")) {
            url = "jdbc:oracle:oci8:@" + databaseName;
            pass = this.testJDBC(url, this.p_db.getSystemUser(), systemPassword);
            if (pass) {
                if (log.isLoggable(Level.INFO)) {
                    log.info("OK: Connection = " + url);
                }
            } else {
                log.warning("Cannot connect via Net8: " + url);
            }
        } else {
            log.info("OCI Test Skipped");
        }
        this.m_con = null;
        return null;
    }

    private boolean testJDBC(String url, String uid, String pwd) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Url=" + url + ", UID=" + uid);
        }
        try {
            DriverManager.registerDriver(Database.getDatabase((String)Database.DB_ORACLE).getDriver());
            this.m_con = DriverManager.getConnection(url, uid, pwd);
        }
        catch (UnsatisfiedLinkError ule) {
            log.warning("Check [ORACLE_HOME]/jdbc/Readme.txt for (OCI) driver setup");
            log.warning(ule.toString());
        }
        catch (Exception e) {
            log.warning(e.toString());
            return false;
        }
        return true;
    }

    private boolean testSQL(String sqlplus) {
        StringBuilder sbOut = new StringBuilder();
        StringBuilder sbErr = new StringBuilder();
        int result = -1;
        try {
            int c;
            Process p = Runtime.getRuntime().exec(sqlplus);
            InputStream in = p.getInputStream();
            while ((c = in.read()) != -1) {
                sbOut.append((char)c);
                System.out.print((char)c);
            }
            in.close();
            in = p.getErrorStream();
            while ((c = in.read()) != -1) {
                sbErr.append((char)c);
            }
            in.close();
            try {
                Thread.yield();
                result = p.exitValue();
            }
            catch (Exception e) {
                Thread.sleep(200L);
                result = p.exitValue();
            }
        }
        catch (Exception ex) {
            log.warning(ex.toString());
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer(sbOut.toString());
        }
        if (sbErr.length() > 0) {
            log.warning(sbErr.toString());
        }
        return result == 0;
    }

    public String getName() {
        return Database.DB_ORACLE;
    }
}

