/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.CalloutEngine;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.MConversionRate;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class CalloutTimeExpense
extends CalloutEngine {
    public String product(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer M_Product_ID = (Integer)value;
        if (M_Product_ID == null || M_Product_ID == 0) {
            return "";
        }
        BigDecimal priceActual = null;
        Timestamp DateExpense = Env.getContextAsDate((Properties)ctx, (int)WindowNo, (String)"DateExpense");
        if (DateExpense == null) {
            DateExpense = new Timestamp(System.currentTimeMillis());
        }
        String sql = null;
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                Integer ii;
                Date plDate;
                boolean noPrice = true;
                sql = "SELECT bomPriceStd(p.M_Product_ID,pv.M_PriceList_Version_ID) AS PriceStd,bomPriceList(p.M_Product_ID,pv.M_PriceList_Version_ID) AS PriceList,bomPriceLimit(p.M_Product_ID,pv.M_PriceList_Version_ID) AS PriceLimit,p.C_UOM_ID,pv.ValidFrom,pl.C_Currency_ID FROM M_Product p, M_ProductPrice pp, M_Pricelist pl, M_PriceList_Version pv WHERE p.M_Product_ID=pp.M_Product_ID AND pp.M_PriceList_Version_ID=pv.M_PriceList_Version_ID AND pv.M_PriceList_ID=pl.M_PriceList_ID AND pv.IsActive='Y' AND p.M_Product_ID=? AND pl.M_PriceList_ID=? ORDER BY pv.ValidFrom DESC";
                pstmt = DB.prepareStatement((String)sql, null);
                pstmt.setInt(1, M_Product_ID);
                pstmt.setInt(2, Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"M_PriceList_ID"));
                rs = pstmt.executeQuery();
                while (rs.next() && noPrice) {
                    plDate = rs.getDate("ValidFrom");
                    if (plDate != null && DateExpense.before(plDate)) continue;
                    noPrice = false;
                    priceActual = rs.getBigDecimal("PriceStd");
                    if (priceActual == null) {
                        priceActual = rs.getBigDecimal("PriceList");
                    }
                    if (priceActual == null) {
                        priceActual = rs.getBigDecimal("PriceLimit");
                    }
                    ii = rs.getInt("C_Currency_ID");
                    if (rs.wasNull()) continue;
                    mTab.setValue("C_Currency_ID", (Object)ii);
                }
                if (noPrice) {
                    sql = "SELECT bomPriceStd(p.M_Product_ID,pv.M_PriceList_Version_ID) AS PriceStd,bomPriceList(p.M_Product_ID,pv.M_PriceList_Version_ID) AS PriceList,bomPriceLimit(p.M_Product_ID,pv.M_PriceList_Version_ID) AS PriceLimit,p.C_UOM_ID,pv.ValidFrom,pl.C_Currency_ID FROM M_Product p, M_ProductPrice pp, M_Pricelist pl, M_Pricelist bpl, M_PriceList_Version pv WHERE p.M_Product_ID=pp.M_Product_ID AND pp.M_PriceList_Version_ID=pv.M_PriceList_Version_ID AND pv.M_PriceList_ID=bpl.M_PriceList_ID AND pv.IsActive='Y' AND bpl.M_PriceList_ID=pl.BasePriceList_ID AND p.M_Product_ID=? AND pl.M_PriceList_ID=? ORDER BY pv.ValidFrom DESC";
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    pstmt = DB.prepareStatement((String)sql, null);
                    pstmt.setInt(1, M_Product_ID);
                    pstmt.setInt(2, Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"M_PriceList_ID"));
                    rs = pstmt.executeQuery();
                    while (rs.next() && noPrice) {
                        plDate = rs.getDate("ValidFrom");
                        if (plDate != null && DateExpense.before(plDate)) continue;
                        noPrice = false;
                        priceActual = rs.getBigDecimal("PriceStd");
                        if (priceActual == null) {
                            priceActual = rs.getBigDecimal("PriceList");
                        }
                        if (priceActual == null) {
                            priceActual = rs.getBigDecimal("PriceLimit");
                        }
                        ii = rs.getInt("C_Currency_ID");
                        if (rs.wasNull()) continue;
                        mTab.setValue("C_Currency_ID", (Object)ii);
                    }
                }
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, sql, (Throwable)e);
                String string = e.getLocalizedMessage();
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                return string;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        if (priceActual == null) {
            priceActual = Env.ZERO;
        }
        mTab.setValue("PriceEntered", (Object)priceActual);
        return "";
    }

    public String amount(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        BigDecimal ConvertedAmt;
        if (this.isCalloutActive()) {
            return "";
        }
        BigDecimal ExpenseAmt = (BigDecimal)mTab.getValue("ExpenseAmt");
        Integer C_Currency_From_ID = (Integer)mTab.getValue("C_Currency_ID");
        int C_Currency_To_ID = Env.getContextAsInt((Properties)ctx, (String)"$C_Currency_ID");
        Timestamp DateExpense = Env.getContextAsDate((Properties)ctx, (int)WindowNo, (String)"DateExpense");
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Amt=" + ExpenseAmt + ", C_Currency_ID=" + C_Currency_From_ID);
        }
        if ((ConvertedAmt = ExpenseAmt).compareTo(Env.ZERO) != 0 && C_Currency_To_ID != C_Currency_From_ID) {
            int AD_Client_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"AD_Client_ID");
            int AD_Org_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"AD_Org_ID");
            ConvertedAmt = MConversionRate.convert((Properties)ctx, (BigDecimal)ConvertedAmt, (int)C_Currency_From_ID, (int)C_Currency_To_ID, (Timestamp)DateExpense, (int)0, (int)AD_Client_ID, (int)AD_Org_ID);
        }
        mTab.setValue("ConvertedAmt", (Object)ConvertedAmt);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("= ConvertedAmt=" + ConvertedAmt);
        }
        return "";
    }

    public String priceOrQty(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        BigDecimal qty = Env.ZERO;
        BigDecimal price = Env.ZERO;
        String columnName = mField.getColumnName();
        if ("Qty".equals(columnName)) {
            qty = (BigDecimal)value;
            price = (BigDecimal)mTab.getValue("PriceEntered");
        } else {
            price = (BigDecimal)value;
            qty = (BigDecimal)mTab.getValue("Qty");
        }
        if (qty == null) {
            qty = Env.ZERO;
        }
        if (price == null) {
            price = Env.ZERO;
        }
        BigDecimal expenseAmt = price.multiply(qty);
        mTab.setValue("ExpenseAmt", (Object)expenseAmt);
        return "";
    }
}

