/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.CalloutEngine;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.MConversionRate;
import org.compiere.model.MCurrency;
import org.compiere.model.MDocType;
import org.compiere.model.MInvoice;
import org.compiere.model.MOrder;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class CalloutPayment
extends CalloutEngine {
    public String invoice(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Timestamp ts;
        Integer C_Invoice_ID = (Integer)value;
        if (this.isCalloutActive() || C_Invoice_ID == null || C_Invoice_ID == 0) {
            return "";
        }
        mTab.setValue("C_Order_ID", null);
        mTab.setValue("C_Charge_ID", null);
        mTab.setValue("IsPrepayment", (Object)Boolean.FALSE);
        mTab.setValue("DiscountAmt", (Object)Env.ZERO);
        mTab.setValue("WriteOffAmt", (Object)Env.ZERO);
        mTab.setValue("OverUnderAmt", (Object)Env.ZERO);
        int C_InvoicePaySchedule_ID = 0;
        if (Env.getContextAsInt((Properties)ctx, (int)WindowNo, (int)1113, (String)"C_Invoice_ID") == C_Invoice_ID && Env.getContextAsInt((Properties)ctx, (int)WindowNo, (int)1113, (String)"C_InvoicePaySchedule_ID") != 0) {
            C_InvoicePaySchedule_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (int)1113, (String)"C_InvoicePaySchedule_ID");
        }
        if ((ts = (Timestamp)mTab.getValue("DateTrx")) == null) {
            ts = new Timestamp(System.currentTimeMillis());
        }
        String sql = "SELECT C_BPartner_ID,C_Currency_ID, invoiceOpen(C_Invoice_ID, ?), invoiceDiscount(C_Invoice_ID,?,?), IsSOTrx FROM C_Invoice WHERE C_Invoice_ID=?";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)sql, null);
                pstmt.setInt(1, C_InvoicePaySchedule_ID);
                pstmt.setTimestamp(2, ts);
                pstmt.setInt(3, C_InvoicePaySchedule_ID);
                pstmt.setInt(4, C_Invoice_ID);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    BigDecimal DiscountAmt;
                    mTab.setValue("C_BPartner_ID", (Object)rs.getInt(1));
                    int C_Currency_ID = rs.getInt(2);
                    mTab.setValue("C_Currency_ID", (Object)C_Currency_ID);
                    BigDecimal InvoiceOpen = rs.getBigDecimal(3);
                    if (InvoiceOpen == null) {
                        InvoiceOpen = Env.ZERO;
                    }
                    if ((DiscountAmt = rs.getBigDecimal(4)) == null) {
                        DiscountAmt = Env.ZERO;
                    }
                    mTab.setValue("PayAmt", (Object)InvoiceOpen.subtract(DiscountAmt));
                    mTab.setValue("DiscountAmt", (Object)DiscountAmt);
                    Env.setContext((Properties)ctx, (int)WindowNo, (String)"C_Invoice_ID", (String)C_Invoice_ID.toString());
                    mTab.setValue("C_Invoice_ID", (Object)C_Invoice_ID);
                }
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, sql, (Throwable)e);
                String string = e.getLocalizedMessage();
                DB.close(rs, (Statement)pstmt);
                return string;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, (Statement)pstmt);
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        return this.docType(ctx, WindowNo, mTab, mField, value);
    }

    public String order(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer C_Order_ID = (Integer)value;
        if (this.isCalloutActive() || C_Order_ID == null || C_Order_ID == 0) {
            return "";
        }
        mTab.setValue("C_Invoice_ID", null);
        mTab.setValue("C_Charge_ID", null);
        mTab.setValue("IsPrepayment", (Object)Boolean.TRUE);
        mTab.setValue("DiscountAmt", (Object)Env.ZERO);
        mTab.setValue("WriteOffAmt", (Object)Env.ZERO);
        mTab.setValue("IsOverUnderPayment", (Object)Boolean.FALSE);
        mTab.setValue("OverUnderAmt", (Object)Env.ZERO);
        Timestamp ts = (Timestamp)mTab.getValue("DateTrx");
        if (ts == null) {
            ts = new Timestamp(System.currentTimeMillis());
        }
        String sql = "SELECT COALESCE(Bill_BPartner_ID, C_BPartner_ID) as C_BPartner_ID , C_Currency_ID , GrandTotal FROM C_Order WHERE C_Order_ID=?";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)sql, null);
                pstmt.setInt(1, C_Order_ID);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    mTab.setValue("C_BPartner_ID", (Object)rs.getInt(1));
                    int C_Currency_ID = rs.getInt(2);
                    mTab.setValue("C_Currency_ID", (Object)C_Currency_ID);
                    BigDecimal GrandTotal = rs.getBigDecimal(3);
                    if (GrandTotal == null) {
                        GrandTotal = Env.ZERO;
                    }
                    mTab.setValue("PayAmt", (Object)GrandTotal);
                }
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, sql, (Throwable)e);
                String string = e.getLocalizedMessage();
                DB.close((ResultSet)rs, (Statement)pstmt);
                return string;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, (Statement)pstmt);
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        return this.docType(ctx, WindowNo, mTab, mField, value);
    }

    public String charge(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer C_Charge_ID = (Integer)value;
        if (this.isCalloutActive() || C_Charge_ID == null || C_Charge_ID == 0) {
            return "";
        }
        mTab.setValue("C_Invoice_ID", null);
        mTab.setValue("C_Order_ID", null);
        mTab.setValue("IsPrepayment", (Object)Boolean.FALSE);
        mTab.setValue("DiscountAmt", (Object)Env.ZERO);
        mTab.setValue("WriteOffAmt", (Object)Env.ZERO);
        mTab.setValue("IsOverUnderPayment", (Object)Boolean.FALSE);
        mTab.setValue("OverUnderAmt", (Object)Env.ZERO);
        return "";
    }

    public String docType(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        int C_Invoice_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"C_Invoice_ID");
        int C_Order_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"C_Order_ID");
        int C_DocType_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"C_DocType_ID");
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Payment_DocType - C_Invoice_ID=" + C_Invoice_ID + ", C_DocType_ID=" + C_DocType_ID);
        }
        MDocType dt = null;
        if (C_DocType_ID != 0) {
            dt = MDocType.get((Properties)ctx, (int)C_DocType_ID);
            Env.setContext((Properties)ctx, (int)WindowNo, (String)"IsSOTrx", (String)(dt.isSOTrx() ? "Y" : "N"));
        }
        if (C_Invoice_ID != 0) {
            MInvoice inv = new MInvoice(ctx, C_Invoice_ID, null);
            if (dt != null && inv.isSOTrx() != dt.isSOTrx()) {
                return "PaymentDocTypeInvoiceInconsistent";
            }
        }
        if (C_Order_ID != 0) {
            MOrder ord = new MOrder(ctx, C_Order_ID, null);
            if (dt != null && ord.isSOTrx() != dt.isSOTrx()) {
                return "PaymentDocTypeInvoiceInconsistent";
            }
        }
        return "";
    }

    public String amounts(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value, Object oldValue) {
        BigDecimal OverUnderAmt;
        BigDecimal WriteOffAmt;
        BigDecimal DiscountAmt;
        BigDecimal PayAmt;
        Integer curr_int;
        if (this.isCalloutActive()) {
            return "";
        }
        int C_Invoice_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"C_Invoice_ID");
        if (Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"C_Payment_ID") == 0 && Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"C_BPartner_ID") == 0 && C_Invoice_ID == 0) {
            return "";
        }
        String colName = mField.getColumnName();
        if (colName.equals("IsOverUnderPayment") || !"Y".equals(Env.getContext((Properties)ctx, (int)WindowNo, (String)"IsOverUnderPayment"))) {
            mTab.setValue("OverUnderAmt", (Object)Env.ZERO);
        }
        int C_InvoicePaySchedule_ID = 0;
        if (Env.getContextAsInt((Properties)ctx, (int)WindowNo, (int)1113, (String)"C_Invoice_ID") == C_Invoice_ID && Env.getContextAsInt((Properties)ctx, (int)WindowNo, (int)1113, (String)"C_InvoicePaySchedule_ID") != 0) {
            C_InvoicePaySchedule_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (int)1113, (String)"C_InvoicePaySchedule_ID");
        }
        if ((curr_int = (Integer)mTab.getValue("C_Currency_ID")) == null) {
            curr_int = 0;
        }
        int C_Currency_ID = curr_int;
        MCurrency currency = MCurrency.get((Properties)ctx, (int)C_Currency_ID);
        int C_ConversionType_ID = 0;
        Integer ii = (Integer)mTab.getValue("C_ConversionType_ID");
        if (ii != null) {
            C_ConversionType_ID = ii;
        }
        int AD_Client_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"AD_Client_ID");
        int AD_Org_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"AD_Org_ID");
        Boolean overrideCR = (Boolean)(colName.equals("IsOverrideCurrencyRate") ? value : mTab.getValue("IsOverrideCurrencyRate"));
        if (overrideCR == null) {
            overrideCR = Boolean.FALSE;
        }
        if (colName.equals("CurrencyRate")) {
            if (value != null) {
                BigDecimal payAmt;
                BigDecimal baseCurrencyRate = (BigDecimal)value;
                if (baseCurrencyRate.signum() < 0) {
                    mTab.setValue(colName, oldValue);
                    mTab.fireDataStatusEEvent("Invalid", Msg.getElement((Properties)ctx, (String)colName), true);
                    return "";
                }
                if (baseCurrencyRate.signum() == 0) {
                    Timestamp dateAcct;
                    int baseCurrencyId = Env.getContextAsInt((Properties)ctx, (String)"$C_Currency_ID");
                    baseCurrencyRate = MConversionRate.getRate((int)C_Currency_ID, (int)baseCurrencyId, (Timestamp)(dateAcct = (Timestamp)mTab.getValue("DateAcct")), (int)C_ConversionType_ID, (int)AD_Client_ID, (int)AD_Org_ID);
                    if (baseCurrencyRate == null) {
                        return "";
                    }
                    mTab.setValue("CurrencyRate", (Object)baseCurrencyRate);
                }
                if ((payAmt = (BigDecimal)mTab.getValue("PayAmt")) != null) {
                    BigDecimal convertedAmt = payAmt.multiply(baseCurrencyRate);
                    mTab.setValue("ConvertedAmt", (Object)convertedAmt);
                }
                return "";
            }
            mTab.setValue(colName, oldValue);
            if (overrideCR.booleanValue()) {
                mTab.fireDataStatusEEvent("Invalid", Msg.getElement((Properties)ctx, (String)colName), true);
            }
            return "";
        }
        if (colName.equals("ConvertedAmt")) {
            if (value != null) {
                BigDecimal convertedAmt = (BigDecimal)value;
                if (convertedAmt.signum() == 0) {
                    mTab.setValue(colName, oldValue);
                    mTab.fireDataStatusEEvent("Invalid", Msg.getElement((Properties)ctx, (String)colName), true);
                    return "";
                }
                BigDecimal payAmt = (BigDecimal)mTab.getValue("PayAmt");
                if (payAmt != null) {
                    BigDecimal baseCurrencyRate = convertedAmt.divide(payAmt, 6, RoundingMode.HALF_UP);
                    mTab.setValue("CurrencyRate", (Object)baseCurrencyRate);
                }
                return "";
            }
            mTab.setValue(colName, oldValue);
            if (overrideCR.booleanValue()) {
                mTab.fireDataStatusEEvent("Invalid", Msg.getElement((Properties)ctx, (String)colName), true);
            }
            return "";
        }
        BigDecimal InvoiceOpenAmt = Env.ZERO;
        int C_Currency_Invoice_ID = 0;
        if (C_Invoice_ID != 0) {
            Timestamp ts = (Timestamp)mTab.getValue("DateTrx");
            if (ts == null) {
                ts = new Timestamp(System.currentTimeMillis());
            }
            String sql = "SELECT C_BPartner_ID,C_Currency_ID, invoiceOpen(C_Invoice_ID,?), invoiceDiscount(C_Invoice_ID,?,?), IsSOTrx FROM C_Invoice WHERE C_Invoice_ID=?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    pstmt.setInt(1, C_InvoicePaySchedule_ID);
                    pstmt.setTimestamp(2, ts);
                    pstmt.setInt(3, C_InvoicePaySchedule_ID);
                    pstmt.setInt(4, C_Invoice_ID);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        C_Currency_Invoice_ID = rs.getInt(2);
                        InvoiceOpenAmt = rs.getBigDecimal(3);
                        if (InvoiceOpenAmt == null) {
                            InvoiceOpenAmt = Env.ZERO;
                        }
                    }
                }
                catch (SQLException e) {
                    this.log.log(Level.SEVERE, sql, (Throwable)e);
                    String string = e.getLocalizedMessage();
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    return string;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Open=" + InvoiceOpenAmt + ", C_Invoice_ID=" + C_Invoice_ID + ", C_Currency_ID=" + C_Currency_Invoice_ID);
        }
        if ((PayAmt = (BigDecimal)mTab.getValue("PayAmt")) == null) {
            PayAmt = Env.ZERO;
        }
        if ((DiscountAmt = (BigDecimal)mTab.getValue("DiscountAmt")) == null) {
            DiscountAmt = Env.ZERO;
        }
        if ((WriteOffAmt = (BigDecimal)mTab.getValue("WriteOffAmt")) == null) {
            WriteOffAmt = Env.ZERO;
        }
        if ((OverUnderAmt = (BigDecimal)mTab.getValue("OverUnderAmt")) == null) {
            OverUnderAmt = Env.ZERO;
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Pay=" + PayAmt + ", Discount=" + DiscountAmt + ", WriteOff=" + WriteOffAmt + ", OverUnderAmt=" + OverUnderAmt);
        }
        Timestamp ConvDate = (Timestamp)mTab.getValue("DateTrx");
        BigDecimal CurrencyRate = Env.ONE;
        if (C_Currency_ID > 0 && C_Currency_Invoice_ID > 0 && C_Currency_ID != C_Currency_Invoice_ID || colName.equals("C_Currency_ID") || colName.equals("C_ConversionType_ID")) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("InvCurrency=" + C_Currency_Invoice_ID + ", PayCurrency=" + C_Currency_ID + ", Date=" + ConvDate + ", Type=" + C_ConversionType_ID);
            }
            if ((CurrencyRate = MConversionRate.getRate((int)C_Currency_Invoice_ID, (int)C_Currency_ID, (Timestamp)ConvDate, (int)C_ConversionType_ID, (int)AD_Client_ID, (int)AD_Org_ID)) == null || CurrencyRate.compareTo(Env.ZERO) == 0) {
                if (C_Currency_Invoice_ID == 0) {
                    return "";
                }
                return "NoCurrencyConversion";
            }
            InvoiceOpenAmt = InvoiceOpenAmt.multiply(CurrencyRate).setScale(currency.getStdPrecision(), RoundingMode.HALF_UP);
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Rate=" + CurrencyRate + ", InvoiceOpenAmt=" + InvoiceOpenAmt);
            }
        }
        if (colName.equals("C_Currency_ID")) {
            if (oldValue != null && oldValue instanceof Integer) {
                BigDecimal conversionRate = null;
                int oldId = (Integer)oldValue;
                if (oldId > 0 && oldId == C_Currency_Invoice_ID) {
                    conversionRate = CurrencyRate;
                } else if (oldId > 0 && (conversionRate = MConversionRate.getRate((int)oldId, (int)C_Currency_ID, (Timestamp)ConvDate, (int)C_ConversionType_ID, (int)AD_Client_ID, (int)AD_Org_ID)) == null && (conversionRate = MConversionRate.getRate((int)C_Currency_ID, (int)oldId, (Timestamp)ConvDate, (int)C_ConversionType_ID, (int)AD_Client_ID, (int)AD_Org_ID)) != null) {
                    conversionRate = new BigDecimal("1").divide(conversionRate, 12, RoundingMode.HALF_UP);
                }
                if (conversionRate != null) {
                    PayAmt = PayAmt.multiply(conversionRate).setScale(currency.getStdPrecision(), RoundingMode.HALF_UP);
                    mTab.setValue("PayAmt", (Object)PayAmt);
                    DiscountAmt = DiscountAmt.multiply(conversionRate).setScale(currency.getStdPrecision(), RoundingMode.HALF_UP);
                    mTab.setValue("DiscountAmt", (Object)DiscountAmt);
                    WriteOffAmt = WriteOffAmt.multiply(conversionRate).setScale(currency.getStdPrecision(), RoundingMode.HALF_UP);
                    mTab.setValue("WriteOffAmt", (Object)WriteOffAmt);
                    OverUnderAmt = OverUnderAmt.multiply(conversionRate).setScale(currency.getStdPrecision(), RoundingMode.HALF_UP);
                    mTab.setValue("OverUnderAmt", (Object)OverUnderAmt);
                }
            }
        } else if (C_Invoice_ID == 0) {
            if (Env.ZERO.compareTo(DiscountAmt) != 0) {
                mTab.setValue("DiscountAmt", (Object)Env.ZERO);
            }
            if (Env.ZERO.compareTo(WriteOffAmt) != 0) {
                mTab.setValue("WriteOffAmt", (Object)Env.ZERO);
            }
            if (Env.ZERO.compareTo(OverUnderAmt) != 0) {
                mTab.setValue("OverUnderAmt", (Object)Env.ZERO);
            }
        } else {
            boolean processed = mTab.getValueAsBoolean("Processed");
            if (colName.equals("PayAmt") && !processed && "Y".equals(Env.getContext((Properties)ctx, (int)WindowNo, (String)"IsOverUnderPayment"))) {
                OverUnderAmt = InvoiceOpenAmt.subtract(PayAmt).subtract(DiscountAmt).subtract(WriteOffAmt);
                if (OverUnderAmt.signum() > 0) {
                    DiscountAmt = Env.ZERO;
                    mTab.setValue("DiscountAmt", (Object)DiscountAmt);
                    OverUnderAmt = InvoiceOpenAmt.subtract(PayAmt).subtract(DiscountAmt).subtract(WriteOffAmt);
                }
                mTab.setValue("OverUnderAmt", (Object)OverUnderAmt);
            } else if (colName.equals("PayAmt") && !processed) {
                WriteOffAmt = InvoiceOpenAmt.subtract(PayAmt).subtract(DiscountAmt).subtract(OverUnderAmt);
                mTab.setValue("WriteOffAmt", (Object)WriteOffAmt);
            } else if (colName.equals("IsOverUnderPayment") && !processed) {
                boolean overUnderPaymentActive = "Y".equals(Env.getContext((Properties)ctx, (int)WindowNo, (String)"IsOverUnderPayment"));
                if (overUnderPaymentActive) {
                    OverUnderAmt = InvoiceOpenAmt.subtract(PayAmt).subtract(DiscountAmt);
                    mTab.setValue("WriteOffAmt", (Object)Env.ZERO);
                    mTab.setValue("OverUnderAmt", (Object)OverUnderAmt);
                } else {
                    WriteOffAmt = InvoiceOpenAmt.subtract(PayAmt).subtract(DiscountAmt);
                    mTab.setValue("WriteOffAmt", (Object)WriteOffAmt);
                    mTab.setValue("OverUnderAmt", (Object)Env.ZERO);
                }
            } else if (!processed) {
                PayAmt = InvoiceOpenAmt.subtract(DiscountAmt).subtract(WriteOffAmt).subtract(OverUnderAmt);
                mTab.setValue("PayAmt", (Object)PayAmt);
            }
        }
        if (colName.equals("C_Currency_ID") || colName.equals("PayAmt") || colName.equals("IsOverrideCurrencyRate")) {
            int baseCurrencyId = Env.getContextAsInt((Properties)ctx, (String)"$C_Currency_ID");
            if (baseCurrencyId == C_Currency_ID) {
                mTab.setValue("IsOverrideCurrencyRate", (Object)false);
                mTab.setValue("CurrencyRate", null);
                mTab.setValue("ConvertedAmt", null);
            } else if (!overrideCR.booleanValue()) {
                mTab.setValue("CurrencyRate", null);
                mTab.setValue("ConvertedAmt", null);
            } else {
                BigDecimal payAmt;
                BigDecimal bigDecimal = payAmt = colName.equals("PayAmt") ? (BigDecimal)value : (BigDecimal)mTab.getValue("PayAmt");
                if (payAmt == null) {
                    return "";
                }
                if (colName.equals("PayAmt") && oldValue != null) {
                    BigDecimal oldPayAmt = (BigDecimal)oldValue;
                    BigDecimal baseConversionRate = (BigDecimal)mTab.getValue("CurrencyRate");
                    BigDecimal converted = (BigDecimal)mTab.getValue("ConvertedAmt");
                    if (baseConversionRate != null && converted != null && oldPayAmt.multiply(baseConversionRate).compareTo(converted) == 0) {
                        converted = payAmt.multiply(baseConversionRate);
                        int stdPrecision = MCurrency.getStdPrecision((Properties)ctx, (int)baseCurrencyId);
                        if (converted.scale() > stdPrecision) {
                            converted = converted.setScale(stdPrecision, RoundingMode.HALF_UP);
                        }
                        mTab.setValue("ConvertedAmt", (Object)converted);
                        return "";
                    }
                }
            }
        }
        return "";
    }
}

