/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.CalloutEngine;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class CalloutPaySelection
extends CalloutEngine {
    public String payAmt(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (this.isCalloutActive() || value == null) {
            return "";
        }
        Integer ii = (Integer)mTab.getValue("C_Invoice_ID");
        if (ii == null) {
            return "";
        }
        int C_Invoice_ID = ii;
        if (C_Invoice_ID == 0) {
            return "";
        }
        BigDecimal OpenAmt = (BigDecimal)mTab.getValue("OpenAmt");
        BigDecimal PayAmt = (BigDecimal)mTab.getValue("PayAmt");
        BigDecimal DiscountAmt = (BigDecimal)mTab.getValue("DiscountAmt");
        BigDecimal WriteOffAmt = (BigDecimal)mTab.getValue("WriteOffAmt");
        BigDecimal DifferenceAmt = OpenAmt.subtract(PayAmt).subtract(DiscountAmt).subtract(WriteOffAmt);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(" - OpenAmt=" + OpenAmt + " - PayAmt=" + PayAmt + ", Discount=" + DiscountAmt + ", WriteOff=" + WriteOffAmt + ", Difference=" + DifferenceAmt);
        }
        mTab.setValue("DifferenceAmt", (Object)DifferenceAmt);
        return "";
    }

    public String invoice(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Boolean IsSOTrx;
        BigDecimal DiscountAmt;
        BigDecimal OpenAmt;
        int C_BankAccount_ID;
        int C_Invoice_ID;
        block10: {
            if (this.isCalloutActive() || value == null) {
                return "";
            }
            C_Invoice_ID = (Integer)value;
            if (C_Invoice_ID == 0) {
                return "";
            }
            C_BankAccount_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"C_BankAccount_ID");
            Timestamp PayDate = Env.getContextAsDate((Properties)ctx, (int)WindowNo, (String)"PayDate");
            if (PayDate == null) {
                PayDate = new Timestamp(System.currentTimeMillis());
            }
            OpenAmt = Env.ZERO;
            DiscountAmt = Env.ZERO;
            IsSOTrx = Boolean.FALSE;
            String sql = "SELECT currencyConvertInvoice(i.C_Invoice_ID, ba.C_Currency_ID, invoiceOpen(i.C_Invoice_ID, 0), i.DateInvoiced), currencyConvert(paymentTermDiscount(i.GrandTotal,i.C_Currency_ID,i.C_PaymentTerm_ID,i.DateInvoiced, ?), i.C_Currency_ID, ba.C_Currency_ID, i.DateInvoiced, i.C_ConversionType_ID, i.AD_Client_ID, i.AD_Org_ID), i.IsSOTrx FROM C_Invoice_v i, C_BankAccount ba WHERE i.C_Invoice_ID=? AND ba.C_BankAccount_ID=?";
            ResultSet rs = null;
            CPreparedStatement pstmt = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    pstmt.setInt(2, C_Invoice_ID);
                    pstmt.setInt(3, C_BankAccount_ID);
                    pstmt.setTimestamp(1, PayDate);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        OpenAmt = rs.getBigDecimal(1);
                        DiscountAmt = rs.getBigDecimal(2);
                        IsSOTrx = "Y".equals(rs.getString(3));
                    }
                }
                catch (SQLException e) {
                    this.log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block10;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(" - OpenAmt=" + OpenAmt + " (Invoice=" + C_Invoice_ID + ",BankAcct=" + C_BankAccount_ID + ")");
        }
        mTab.setValue("OpenAmt", (Object)OpenAmt);
        mTab.setValue("PayAmt", (Object)OpenAmt.subtract(DiscountAmt));
        mTab.setValue("DiscountAmt", (Object)DiscountAmt);
        mTab.setValue("DifferenceAmt", (Object)Env.ZERO);
        mTab.setValue("IsSOTrx", (Object)IsSOTrx);
        return "";
    }
}

