/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.base.Core;
import org.adempiere.base.IProductPricing;
import org.adempiere.model.GridTabWrapper;
import org.compiere.model.CalloutEngine;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.I_C_InvoiceLine;
import org.compiere.model.MInOutLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MPaymentTerm;
import org.compiere.model.MPriceList;
import org.compiere.model.MProduct;
import org.compiere.model.MRole;
import org.compiere.model.MSequence;
import org.compiere.model.MTax;
import org.compiere.model.MUOM;
import org.compiere.model.MUOMConversion;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;

public class CalloutInvoice
extends CalloutEngine {
    public String docType(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer C_DocType_ID = (Integer)value;
        if (C_DocType_ID == null || C_DocType_ID == 0) {
            return "";
        }
        String sql = "SELECT d.HasCharges,d.IsDocNoControlled,d.DocBaseType, s.AD_Sequence_ID FROM C_DocType d LEFT OUTER JOIN AD_Sequence s ON (d.DocNoSequence_ID=s.AD_Sequence_ID) WHERE C_DocType_ID=?";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)sql, null);
                pstmt.setInt(1, C_DocType_ID);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    Env.setContext((Properties)ctx, (int)WindowNo, (String)"HasCharges", (String)rs.getString("HasCharges"));
                    if (rs.getString("IsDocNoControlled").equals("Y")) {
                        int AD_Sequence_ID = rs.getInt("AD_Sequence_ID");
                        mTab.setValue("DocumentNo", (Object)MSequence.getPreliminaryNo((GridTab)mTab, (int)AD_Sequence_ID));
                    }
                    String s = rs.getString("DocBaseType");
                    Env.setContext((Properties)ctx, (int)WindowNo, (String)"DocBaseType", (String)s);
                    if (s.startsWith("AP")) {
                        mTab.setValue("PaymentRule", (Object)"S");
                    } else if (s.endsWith("C")) {
                        mTab.setValue("PaymentRule", (Object)"P");
                    }
                }
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, sql, (Throwable)e);
                String string = e.getLocalizedMessage();
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                return string;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        return "";
    }

    public String bPartner(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer C_BPartner_ID = (Integer)value;
        if (C_BPartner_ID == null || C_BPartner_ID == 0) {
            return "";
        }
        String sql = "SELECT p.AD_Language,p.C_PaymentTerm_ID, COALESCE(p.M_PriceList_ID,g.M_PriceList_ID) AS M_PriceList_ID, p.PaymentRule,p.POReference, p.SO_Description,p.IsDiscountPrinted, p.SO_CreditLimit, p.SO_CreditLimit-p.SO_CreditUsed AS CreditAvailable, (select max(lbill.C_BPartner_Location_ID) from C_BPartner_Location lbill where p.C_BPartner_ID=lbill.C_BPartner_ID AND lbill.IsBillTo='Y' AND lbill.IsActive='Y') AS C_BPartner_Location_ID, (select max(c.AD_User_ID) from AD_User c where p.C_BPartner_ID=c.C_BPartner_ID AND c.IsActive='Y') as AD_User_ID, (select max(c.AD_User_ID) from AD_User c where p.C_BPartner_ID=c.C_BPartner_ID AND c.IsActive='Y' AND IsBillTo='Y') as BillTo_User_ID, COALESCE(p.PO_PriceList_ID,g.PO_PriceList_ID) AS PO_PriceList_ID, p.PaymentRulePO,p.PO_PaymentTerm_ID, p.SalesRep_ID FROM C_BPartner p INNER JOIN C_BP_Group g ON (p.C_BP_Group_ID=g.C_BP_Group_ID)WHERE p.C_BPartner_ID=? AND p.IsActive='Y'";
        boolean IsSOTrx = Env.getContext((Properties)ctx, (int)WindowNo, (String)"IsSOTrx").equals("Y");
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)sql, null);
                pstmt.setInt(1, C_BPartner_ID);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    double CreditLimit;
                    String cont;
                    String loc;
                    Integer salesRep = rs.getInt("SalesRep_ID");
                    if (IsSOTrx && salesRep != 0) {
                        mTab.setValue("SalesRep_ID", (Object)salesRep);
                    }
                    Integer ii = rs.getInt(IsSOTrx ? "M_PriceList_ID" : "PO_PriceList_ID");
                    if (!rs.wasNull()) {
                        mTab.setValue("M_PriceList_ID", (Object)ii);
                    } else {
                        int i = Env.getContextAsInt((Properties)ctx, (String)"#M_PriceList_ID");
                        if (i != 0) {
                            MPriceList pl = new MPriceList(ctx, i, null);
                            if (IsSOTrx == pl.isSOPriceList()) {
                                mTab.setValue("M_PriceList_ID", (Object)i);
                            } else {
                                String sql2 = "SELECT M_PriceList_ID FROM M_PriceList WHERE AD_Client_ID=? AND IsSOPriceList=? AND IsActive='Y' ORDER BY IsDefault DESC";
                                ii = DB.getSQLValue(null, (String)sql2, (Object[])new Object[]{Env.getAD_Client_ID((Properties)ctx), IsSOTrx});
                                if (ii != 0) {
                                    mTab.setValue("M_PriceList_ID", (Object)ii);
                                }
                            }
                        }
                    }
                    String s = rs.getString(IsSOTrx ? "PaymentRule" : "PaymentRulePO");
                    if (s != null && s.length() != 0) {
                        mTab.setValue("PaymentRule", (Object)s);
                    }
                    if (Env.getContext((Properties)ctx, (int)WindowNo, (String)"DocBaseType").endsWith("C")) {
                        s = "P";
                    }
                    ii = rs.getInt(IsSOTrx ? "C_PaymentTerm_ID" : "PO_PaymentTerm_ID");
                    if (!rs.wasNull()) {
                        mTab.setValue("C_PaymentTerm_ID", (Object)ii);
                    }
                    int locID = rs.getInt("C_BPartner_Location_ID");
                    if (C_BPartner_ID.toString().equals(Env.getContext((Properties)ctx, (int)WindowNo, (int)1113, (String)"C_BPartner_ID")) && (loc = Env.getContext((Properties)ctx, (int)WindowNo, (int)1113, (String)"C_BPartner_Location_ID")).length() > 0) {
                        locID = Integer.parseInt(loc);
                    }
                    if (locID == 0) {
                        mTab.setValue("C_BPartner_Location_ID", null);
                    } else {
                        mTab.setValue("C_BPartner_Location_ID", (Object)locID);
                    }
                    int contID = rs.getInt("AD_User_ID");
                    if (C_BPartner_ID.toString().equals(Env.getContext((Properties)ctx, (int)WindowNo, (int)1113, (String)"C_BPartner_ID")) && (cont = Env.getContext((Properties)ctx, (int)WindowNo, (int)1113, (String)"AD_User_ID")).length() > 0) {
                        contID = Integer.parseInt(cont);
                    }
                    int BillTo_User_ID = rs.getInt("BillTo_User_ID");
                    if (contID == 0) {
                        mTab.setValue("AD_User_ID", null);
                    } else {
                        Integer userID = BillTo_User_ID > 0 ? Integer.valueOf(BillTo_User_ID) : Integer.valueOf(contID);
                        mTab.setValue("AD_User_ID", (Object)userID);
                    }
                    if (IsSOTrx && (CreditLimit = rs.getDouble("SO_CreditLimit")) != 0.0) {
                        double CreditAvailable = rs.getDouble("CreditAvailable");
                        if (!rs.wasNull() && CreditAvailable < 0.0) {
                            mTab.fireDataStatusEEvent("CreditLimitOver", DisplayType.getNumberFormat((int)12).format(CreditAvailable), false);
                        }
                    }
                    if ((s = rs.getString("POReference")) != null && s.length() != 0) {
                        mTab.setValue("POReference", (Object)s);
                    }
                    if ((s = rs.getString("SO_Description")) != null && s.trim().length() != 0) {
                        mTab.setValue("Description", (Object)s);
                    }
                    if ((s = rs.getString("IsDiscountPrinted")) != null && s.length() != 0) {
                        mTab.setValue("IsDiscountPrinted", (Object)s);
                    } else {
                        mTab.setValue("IsDiscountPrinted", (Object)"N");
                    }
                }
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, "bPartner", (Throwable)e);
                String string = e.getLocalizedMessage();
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                return string;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        return "";
    }

    @Deprecated
    public String paymentTerm(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer C_PaymentTerm_ID = (Integer)value;
        int C_Invoice_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"C_Invoice_ID");
        if (C_PaymentTerm_ID == null || C_PaymentTerm_ID == 0 || C_Invoice_ID == 0) {
            return "";
        }
        MPaymentTerm pt = new MPaymentTerm(ctx, C_PaymentTerm_ID.intValue(), null);
        if (pt.get_ID() == 0) {
            return "PaymentTerm not found";
        }
        boolean valid = pt.apply(C_Invoice_ID);
        mTab.setValue("IsPayScheduleValid", (Object)(valid ? "Y" : "N"));
        return "";
    }

    public String product(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        String sql;
        Integer M_Product_ID = (Integer)value;
        if (M_Product_ID == null || M_Product_ID == 0) {
            return "";
        }
        mTab.setValue("C_Charge_ID", null);
        if (Env.getContextAsInt((Properties)ctx, (int)WindowNo, (int)1113, (String)"M_Product_ID") == M_Product_ID && Env.getContextAsInt((Properties)ctx, (int)WindowNo, (int)1113, (String)"M_AttributeSetInstance_ID") != 0) {
            mTab.setValue("M_AttributeSetInstance_ID", (Object)Env.getContextAsInt((Properties)ctx, (int)WindowNo, (int)1113, (String)"M_AttributeSetInstance_ID"));
        } else {
            mTab.setValue("M_AttributeSetInstance_ID", null);
        }
        boolean IsSOTrx = Env.getContext((Properties)ctx, (int)WindowNo, (String)"IsSOTrx").equals("Y");
        int C_BPartner_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"C_BPartner_ID");
        BigDecimal Qty = (BigDecimal)mTab.getValue("QtyInvoiced");
        IProductPricing pp = Core.getProductPricing();
        pp.setInitialValues(M_Product_ID.intValue(), C_BPartner_ID, Qty, IsSOTrx, null);
        Timestamp invoiceDate = Env.getContextAsDate((Properties)ctx, (int)WindowNo, (String)"DateInvoiced");
        pp.setPriceDate(invoiceDate);
        I_C_InvoiceLine invoiceLine = (I_C_InvoiceLine)GridTabWrapper.create((GridTab)mTab, I_C_InvoiceLine.class);
        pp.setInvoiceLine(invoiceLine, null);
        int M_PriceList_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"M_PriceList_ID");
        pp.setM_PriceList_ID(M_PriceList_ID);
        int M_PriceList_Version_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"M_PriceList_Version_ID");
        if (M_PriceList_Version_ID == 0 && M_PriceList_ID > 0 && (M_PriceList_Version_ID = DB.getSQLValueEx(null, (String)(sql = "SELECT plv.M_PriceList_Version_ID FROM M_PriceList_Version plv WHERE plv.M_PriceList_ID=?  AND plv.ValidFrom <= ? ORDER BY plv.ValidFrom DESC"), (Object[])new Object[]{M_PriceList_ID, invoiceDate})) > 0) {
            Env.setContext((Properties)ctx, (int)WindowNo, (String)"M_PriceList_Version_ID", (int)M_PriceList_Version_ID);
        }
        pp.setM_PriceList_Version_ID(M_PriceList_Version_ID);
        mTab.setValue("PriceList", (Object)pp.getPriceList());
        mTab.setValue("PriceLimit", (Object)pp.getPriceLimit());
        mTab.setValue("PriceActual", (Object)pp.getPriceStd());
        mTab.setValue("PriceEntered", (Object)pp.getPriceStd());
        mTab.setValue("C_Currency_ID", (Object)pp.getC_Currency_ID());
        mTab.setValue("C_UOM_ID", (Object)pp.getC_UOM_ID());
        Env.setContext((Properties)ctx, (int)WindowNo, (String)"EnforcePriceLimit", (String)(pp.isEnforcePriceLimit() ? "Y" : "N"));
        Env.setContext((Properties)ctx, (int)WindowNo, (String)"DiscountSchema", (String)(pp.isDiscountSchema() ? "Y" : "N"));
        return this.tax(ctx, WindowNo, mTab, mField, value);
    }

    public String charge(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer C_Charge_ID = (Integer)value;
        if (C_Charge_ID == null || C_Charge_ID == 0) {
            return "";
        }
        if (mTab.getValue("M_Product_ID") != null) {
            mTab.setValue("C_Charge_ID", null);
            return "ChargeExclusively";
        }
        mTab.setValue("M_AttributeSetInstance_ID", null);
        mTab.setValue("S_ResourceAssignment_ID", null);
        mTab.setValue("C_UOM_ID", (Object)100);
        Env.setContext((Properties)ctx, (int)WindowNo, (String)"DiscountSchema", (String)"N");
        String sql = "SELECT ChargeAmt FROM C_Charge WHERE C_Charge_ID=?";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)sql, null);
                pstmt.setInt(1, C_Charge_ID);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    mTab.setValue("PriceEntered", (Object)rs.getBigDecimal(1));
                    mTab.setValue("PriceActual", (Object)rs.getBigDecimal(1));
                    mTab.setValue("PriceLimit", (Object)Env.ZERO);
                    mTab.setValue("PriceList", (Object)Env.ZERO);
                    mTab.setValue("Discount", (Object)Env.ZERO);
                }
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, String.valueOf(sql) + e);
                String string = e.getLocalizedMessage();
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                return string;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        return this.tax(ctx, WindowNo, mTab, mField, value);
    }

    public String tax(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        String column = mField.getColumnName();
        if (value == null) {
            return "";
        }
        int M_Product_ID = 0;
        M_Product_ID = column.equals("M_Product_ID") ? (Integer)value : Env.getContextAsInt((Properties)ctx, (int)WindowNo, (int)mTab.getTabNo(), (String)"M_Product_ID");
        int C_Charge_ID = 0;
        C_Charge_ID = column.equals("C_Charge_ID") ? (Integer)value : Env.getContextAsInt((Properties)ctx, (int)WindowNo, (int)mTab.getTabNo(), (String)"C_Charge_ID");
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Product=" + M_Product_ID + ", C_Charge_ID=" + C_Charge_ID);
        }
        if (M_Product_ID == 0 && C_Charge_ID == 0) {
            return this.amt(ctx, WindowNo, mTab, mField, value);
        }
        int shipC_BPartner_Location_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"C_BPartner_Location_ID");
        if (shipC_BPartner_Location_ID == 0) {
            return this.amt(ctx, WindowNo, mTab, mField, value);
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Ship BP_Location=" + shipC_BPartner_Location_ID);
        }
        int billC_BPartner_Location_ID = shipC_BPartner_Location_ID;
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Bill BP_Location=" + billC_BPartner_Location_ID);
        }
        Timestamp billDate = Env.getContextAsDate((Properties)ctx, (int)WindowNo, (String)"DateInvoiced");
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Bill Date=" + billDate);
        }
        Timestamp shipDate = billDate;
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Ship Date=" + shipDate);
        }
        int AD_Org_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"AD_Org_ID");
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Org=" + AD_Org_ID);
        }
        int M_Warehouse_ID = Env.getContextAsInt((Properties)ctx, (String)"#M_Warehouse_ID");
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Warehouse=" + M_Warehouse_ID);
        }
        String deliveryViaRule = this.getLineDeliveryViaRule(ctx, WindowNo, mTab);
        int C_Tax_ID = Core.getTaxLookup().get(ctx, M_Product_ID, C_Charge_ID, billDate, shipDate, AD_Org_ID, M_Warehouse_ID, billC_BPartner_Location_ID, shipC_BPartner_Location_ID, Env.getContext((Properties)ctx, (int)WindowNo, (String)"IsSOTrx").equals("Y"), deliveryViaRule, null);
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Tax ID=" + C_Tax_ID);
        }
        if (C_Tax_ID == 0) {
            mTab.fireDataStatusEEvent(CLogger.retrieveError());
        } else {
            mTab.setValue("C_Tax_ID", (Object)C_Tax_ID);
        }
        return this.amt(ctx, WindowNo, mTab, mField, value);
    }

    private String getLineDeliveryViaRule(Properties ctx, int windowNo, GridTab mTab) {
        int M_InOutLine_ID;
        int C_OrderLine_ID;
        if (mTab.getValue("C_OrderLine_ID") != null && (C_OrderLine_ID = ((Integer)mTab.getValue("C_OrderLine_ID")).intValue()) > 0) {
            MOrderLine orderLine = new MOrderLine(ctx, C_OrderLine_ID, null);
            return orderLine.getParent().getDeliveryViaRule();
        }
        if (mTab.getValue("M_InOutLine_ID") != null && (M_InOutLine_ID = ((Integer)mTab.getValue("M_InOutLine_ID")).intValue()) > 0) {
            MInOutLine ioLine = new MInOutLine(ctx, M_InOutLine_ID, null);
            return ioLine.getParent().getDeliveryViaRule();
        }
        int C_Order_ID = Env.getContextAsInt((Properties)ctx, (int)windowNo, (String)"C_Order_ID", (boolean)true);
        if (C_Order_ID > 0) {
            MOrder order = new MOrder(ctx, C_Order_ID, null);
            return order.getDeliveryViaRule();
        }
        return null;
    }

    public String amt(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        BigDecimal LineNetAmt;
        boolean enforce;
        if (this.isCalloutActive() || value == null) {
            return "";
        }
        int C_UOM_To_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (int)mTab.getTabNo(), (String)"C_UOM_ID");
        int M_Product_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (int)mTab.getTabNo(), (String)"M_Product_ID");
        int M_PriceList_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"M_PriceList_ID");
        int StdPrecision = MPriceList.getStandardPrecision((Properties)ctx, (int)M_PriceList_ID);
        MPriceList pl = new MPriceList(ctx, M_PriceList_ID, null);
        boolean isEnforcePriceLimit = pl.isEnforcePriceLimit();
        BigDecimal QtyEntered = (BigDecimal)mTab.getValue("QtyEntered");
        BigDecimal QtyInvoiced = (BigDecimal)mTab.getValue("QtyInvoiced");
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("QtyEntered=" + QtyEntered + ", Invoiced=" + QtyInvoiced + ", UOM=" + C_UOM_To_ID);
        }
        BigDecimal PriceEntered = (BigDecimal)mTab.getValue("PriceEntered");
        BigDecimal PriceActual = (BigDecimal)mTab.getValue("PriceActual");
        BigDecimal PriceLimit = (BigDecimal)mTab.getValue("PriceLimit");
        BigDecimal PriceList = (BigDecimal)mTab.getValue("PriceList");
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("PriceList=" + PriceList + ", Limit=" + PriceLimit + ", Precision=" + StdPrecision);
            this.log.fine("PriceEntered=" + PriceEntered + ", Actual=" + PriceActual);
        }
        if (M_Product_ID == 0) {
            if (mField.getColumnName().equals("PriceActual")) {
                PriceEntered = (BigDecimal)value;
                mTab.setValue("PriceEntered", value);
            } else if (mField.getColumnName().equals("PriceEntered")) {
                PriceActual = (BigDecimal)value;
                mTab.setValue("PriceActual", value);
            }
        } else if ((mField.getColumnName().equals("QtyInvoiced") || mField.getColumnName().equals("QtyEntered") || mField.getColumnName().equals("C_UOM_ID") || mField.getColumnName().equals("M_Product_ID")) && !"N".equals(Env.getContext((Properties)ctx, (int)WindowNo, (String)"DiscountSchema"))) {
            int C_BPartner_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"C_BPartner_ID");
            if (mField.getColumnName().equals("QtyEntered")) {
                QtyInvoiced = MUOMConversion.convertProductFrom((Properties)ctx, (int)M_Product_ID, (int)C_UOM_To_ID, (BigDecimal)QtyEntered);
            }
            if (QtyInvoiced == null) {
                QtyInvoiced = QtyEntered;
            }
            boolean IsSOTrx = Env.getContext((Properties)ctx, (int)WindowNo, (String)"IsSOTrx").equals("Y");
            IProductPricing pp = Core.getProductPricing();
            pp.setInitialValues(M_Product_ID, C_BPartner_ID, QtyInvoiced, IsSOTrx, null);
            Timestamp date = (Timestamp)mTab.getValue("DateInvoiced");
            pp.setPriceDate(date);
            I_C_InvoiceLine invoiceLine = (I_C_InvoiceLine)GridTabWrapper.create((GridTab)mTab, I_C_InvoiceLine.class);
            pp.setInvoiceLine(invoiceLine, null);
            pp.setM_PriceList_ID(M_PriceList_ID);
            int M_PriceList_Version_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"M_PriceList_Version_ID");
            pp.setM_PriceList_Version_ID(M_PriceList_Version_ID);
            PriceEntered = MUOMConversion.convertProductFrom((Properties)ctx, (int)M_Product_ID, (int)C_UOM_To_ID, (BigDecimal)pp.getPriceStd(), (int)12);
            if (PriceEntered == null) {
                PriceEntered = pp.getPriceStd();
            }
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("amt - QtyChanged -> PriceActual=" + pp.getPriceStd() + ", PriceEntered=" + PriceEntered + ", Discount=" + pp.getDiscount());
            }
            PriceActual = pp.getPriceStd();
            mTab.setValue("PriceActual", (Object)pp.getPriceStd());
            mTab.setValue("PriceEntered", (Object)PriceEntered);
            Env.setContext((Properties)ctx, (int)WindowNo, (String)"DiscountSchema", (String)(pp.isDiscountSchema() ? "Y" : "N"));
        } else if (mField.getColumnName().equals("PriceActual")) {
            PriceActual = (BigDecimal)value;
            PriceEntered = MUOMConversion.convertProductFrom((Properties)ctx, (int)M_Product_ID, (int)C_UOM_To_ID, (BigDecimal)PriceActual, (int)12);
            if (PriceEntered == null) {
                PriceEntered = PriceActual;
            }
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("amt - PriceActual=" + PriceActual + " -> PriceEntered=" + PriceEntered);
            }
            mTab.setValue("PriceEntered", (Object)PriceEntered);
        } else if (mField.getColumnName().equals("PriceEntered")) {
            PriceEntered = (BigDecimal)value;
            PriceActual = MUOMConversion.convertProductTo((Properties)ctx, (int)M_Product_ID, (int)C_UOM_To_ID, (BigDecimal)PriceEntered, (int)12);
            if (PriceActual == null) {
                PriceActual = PriceEntered;
            }
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("amt - PriceEntered=" + PriceEntered + " -> PriceActual=" + PriceActual);
            }
            mTab.setValue("PriceActual", (Object)PriceActual);
        }
        String epl = Env.getContext((Properties)ctx, (int)WindowNo, (String)"EnforcePriceLimit");
        boolean bl = enforce = Env.isSOTrx((Properties)ctx, (int)WindowNo) && epl != null && !epl.equals("") ? epl.equals("Y") : isEnforcePriceLimit;
        if (enforce && MRole.getDefault().isOverwritePriceLimit()) {
            enforce = false;
        }
        if (enforce && PriceLimit.doubleValue() != 0.0 && PriceActual.compareTo(PriceLimit) < 0) {
            BigDecimal Discount;
            PriceActual = PriceLimit;
            PriceEntered = MUOMConversion.convertProductFrom((Properties)ctx, (int)M_Product_ID, (int)C_UOM_To_ID, (BigDecimal)PriceLimit, (int)12);
            if (PriceEntered == null) {
                PriceEntered = PriceLimit;
            }
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("amt =(under) PriceEntered=" + PriceEntered + ", Actual" + PriceLimit);
            }
            mTab.setValue("PriceActual", (Object)PriceLimit);
            mTab.setValue("PriceEntered", (Object)PriceEntered);
            mTab.fireDataStatusEEvent("UnderLimitPrice", "", false);
            if (PriceList.compareTo(Env.ZERO) != 0 && (Discount = BigDecimal.valueOf((PriceList.doubleValue() - PriceActual.doubleValue()) / PriceList.doubleValue() * 100.0)).scale() > 2) {
                Discount = Discount.setScale(2, RoundingMode.HALF_UP);
            }
        }
        if ((LineNetAmt = QtyEntered.multiply(PriceEntered)).scale() > StdPrecision) {
            LineNetAmt = LineNetAmt.setScale(StdPrecision, RoundingMode.HALF_UP);
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("amt = LineNetAmt=" + LineNetAmt);
        }
        mTab.setValue("LineNetAmt", (Object)LineNetAmt);
        boolean IsSOTrx = "Y".equals(Env.getContext((Properties)Env.getCtx(), (int)WindowNo, (String)"IsSOTrx"));
        if (!IsSOTrx) {
            BigDecimal TaxAmt = Env.ZERO;
            if (mField.getColumnName().equals("TaxAmt")) {
                TaxAmt = (BigDecimal)mTab.getValue("TaxAmt");
            } else {
                Integer taxID = (Integer)mTab.getValue("C_Tax_ID");
                if (taxID != null) {
                    int C_Tax_ID = taxID;
                    MTax tax = new MTax(ctx, C_Tax_ID, null);
                    TaxAmt = tax.calculateTax(LineNetAmt, this.isTaxIncluded(WindowNo), StdPrecision);
                    mTab.setValue("TaxAmt", (Object)TaxAmt);
                }
            }
            mTab.setValue("LineTotalAmt", (Object)LineNetAmt.add(TaxAmt));
        }
        return "";
    }

    private boolean isTaxIncluded(int WindowNo) {
        String ss = Env.getContext((Properties)Env.getCtx(), (int)WindowNo, (String)"IsTaxIncluded");
        if (ss.length() == 0) {
            int M_PriceList_ID = Env.getContextAsInt((Properties)Env.getCtx(), (int)WindowNo, (String)"M_PriceList_ID");
            if (M_PriceList_ID == 0) {
                return false;
            }
            ss = DB.getSQLValueString(null, (String)"SELECT IsTaxIncluded FROM M_PriceList WHERE M_PriceList_ID=?", (int)M_PriceList_ID);
            if (ss == null) {
                ss = "N";
            }
            Env.setContext((Properties)Env.getCtx(), (int)WindowNo, (String)"IsTaxIncluded", (String)ss);
        }
        return "Y".equals(ss);
    }

    public String qty(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (this.isCalloutActive() || value == null) {
            return "";
        }
        int M_Product_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (int)mTab.getTabNo(), (String)"M_Product_ID");
        if (M_Product_ID == 0) {
            BigDecimal QtyEntered = (BigDecimal)mTab.getValue("QtyEntered");
            mTab.setValue("QtyInvoiced", (Object)QtyEntered);
        } else if (mField.getColumnName().equals("C_UOM_ID")) {
            BigDecimal QtyInvoiced;
            BigDecimal QtyEntered1;
            int C_UOM_To_ID = (Integer)value;
            BigDecimal QtyEntered = (BigDecimal)mTab.getValue("QtyEntered");
            if (QtyEntered.compareTo(QtyEntered1 = QtyEntered.setScale(MUOM.getPrecision((Properties)ctx, (int)C_UOM_To_ID), RoundingMode.HALF_UP)) != 0) {
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Corrected QtyEntered Scale UOM=" + C_UOM_To_ID + "; QtyEntered=" + QtyEntered + "->" + QtyEntered1);
                }
                QtyEntered = QtyEntered1;
                mTab.setValue("QtyEntered", (Object)QtyEntered);
            }
            if ((QtyInvoiced = MUOMConversion.convertProductFrom((Properties)ctx, (int)M_Product_ID, (int)C_UOM_To_ID, (BigDecimal)QtyEntered)) == null) {
                QtyInvoiced = QtyEntered;
            }
            boolean conversion = QtyEntered.compareTo(QtyInvoiced) != 0;
            BigDecimal PriceActual = (BigDecimal)mTab.getValue("PriceActual");
            BigDecimal PriceEntered = MUOMConversion.convertProductFrom((Properties)ctx, (int)M_Product_ID, (int)C_UOM_To_ID, (BigDecimal)PriceActual, (int)12);
            if (PriceEntered == null) {
                PriceEntered = PriceActual;
            }
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("qty - UOM=" + C_UOM_To_ID + ", QtyEntered/PriceActual=" + QtyEntered + "/" + PriceActual + " -> " + conversion + " QtyInvoiced/PriceEntered=" + QtyInvoiced + "/" + PriceEntered);
            }
            Env.setContext((Properties)ctx, (int)WindowNo, (String)"UOMConversion", (String)(conversion ? "Y" : "N"));
            mTab.setValue("QtyInvoiced", (Object)QtyInvoiced);
            mTab.setValue("PriceEntered", (Object)PriceEntered);
        } else if (mField.getColumnName().equals("QtyEntered")) {
            boolean conversion;
            BigDecimal QtyInvoiced;
            BigDecimal QtyEntered = (BigDecimal)value;
            int C_UOM_To_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (int)mTab.getTabNo(), (String)"C_UOM_ID");
            BigDecimal QtyEntered1 = QtyEntered.setScale(MUOM.getPrecision((Properties)ctx, (int)C_UOM_To_ID), RoundingMode.HALF_UP);
            if (QtyEntered.compareTo(QtyEntered1) != 0) {
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Corrected QtyEntered Scale UOM=" + C_UOM_To_ID + "; QtyEntered=" + QtyEntered + "->" + QtyEntered1);
                }
                QtyEntered = QtyEntered1;
                mTab.setValue("QtyEntered", (Object)QtyEntered);
            }
            if ((QtyInvoiced = MUOMConversion.convertProductFrom((Properties)ctx, (int)M_Product_ID, (int)C_UOM_To_ID, (BigDecimal)QtyEntered)) == null) {
                QtyInvoiced = QtyEntered;
            }
            boolean bl = conversion = QtyEntered.compareTo(QtyInvoiced) != 0;
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("qty - UOM=" + C_UOM_To_ID + ", QtyEntered=" + QtyEntered + " -> " + conversion + " QtyInvoiced=" + QtyInvoiced);
            }
            Env.setContext((Properties)ctx, (int)WindowNo, (String)"UOMConversion", (String)(conversion ? "Y" : "N"));
            mTab.setValue("QtyInvoiced", (Object)QtyInvoiced);
        } else if (mField.getColumnName().equals("QtyInvoiced")) {
            boolean conversion;
            BigDecimal QtyEntered;
            int C_UOM_To_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (int)mTab.getTabNo(), (String)"C_UOM_ID");
            BigDecimal QtyInvoiced = (BigDecimal)value;
            int precision = MProduct.get((Properties)ctx, (int)M_Product_ID).getUOMPrecision();
            BigDecimal QtyInvoiced1 = QtyInvoiced.setScale(precision, RoundingMode.HALF_UP);
            if (QtyInvoiced.compareTo(QtyInvoiced1) != 0) {
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Corrected QtyInvoiced Scale " + QtyInvoiced + "->" + QtyInvoiced1);
                }
                QtyInvoiced = QtyInvoiced1;
                mTab.setValue("QtyInvoiced", (Object)QtyInvoiced);
            }
            if ((QtyEntered = MUOMConversion.convertProductTo((Properties)ctx, (int)M_Product_ID, (int)C_UOM_To_ID, (BigDecimal)QtyInvoiced)) == null) {
                QtyEntered = QtyInvoiced;
            }
            boolean bl = conversion = QtyInvoiced.compareTo(QtyEntered) != 0;
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("qty - UOM=" + C_UOM_To_ID + ", QtyInvoiced=" + QtyInvoiced + " -> " + conversion + " QtyEntered=" + QtyEntered);
            }
            Env.setContext((Properties)ctx, (int)WindowNo, (String)"UOMConversion", (String)(conversion ? "Y" : "N"));
            mTab.setValue("QtyEntered", (Object)QtyEntered);
        }
        return "";
    }

    public String navigateInvoiceLine(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        String sql;
        Integer M_Product_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (int)mTab.getTabNo(), (String)"M_Product_ID");
        if (M_Product_ID == null || M_Product_ID == 0) {
            Env.setContext((Properties)ctx, (int)WindowNo, (String)"DiscountSchema", (String)"N");
            return "";
        }
        int C_BPartner_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"C_BPartner_ID");
        BigDecimal Qty = (BigDecimal)mTab.getValue("QtyOrdered");
        boolean IsSOTrx = Env.getContext((Properties)ctx, (int)WindowNo, (String)"IsSOTrx").equals("Y");
        IProductPricing pp = Core.getProductPricing();
        pp.setInitialValues(M_Product_ID.intValue(), C_BPartner_ID, Qty, IsSOTrx, null);
        Timestamp orderDate = (Timestamp)mTab.getValue("DateOrdered");
        pp.setPriceDate(orderDate);
        I_C_InvoiceLine invoiceLine = (I_C_InvoiceLine)GridTabWrapper.create((GridTab)mTab, I_C_InvoiceLine.class);
        pp.setInvoiceLine(invoiceLine, null);
        int M_PriceList_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"M_PriceList_ID");
        pp.setM_PriceList_ID(M_PriceList_ID);
        int M_PriceList_Version_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"M_PriceList_Version_ID");
        if (M_PriceList_Version_ID == 0 && M_PriceList_ID > 0 && (M_PriceList_Version_ID = DB.getSQLValueEx(null, (String)(sql = "SELECT plv.M_PriceList_Version_ID FROM M_PriceList_Version plv WHERE plv.M_PriceList_ID=?  AND plv.ValidFrom <= ? ORDER BY plv.ValidFrom DESC"), (Object[])new Object[]{M_PriceList_ID, orderDate})) > 0) {
            Env.setContext((Properties)ctx, (int)WindowNo, (String)"M_PriceList_Version_ID", (int)M_PriceList_Version_ID);
        }
        pp.setM_PriceList_Version_ID(M_PriceList_Version_ID);
        Env.setContext((Properties)ctx, (int)WindowNo, (String)"EnforcePriceLimit", (String)(pp.isEnforcePriceLimit() ? "Y" : "N"));
        Env.setContext((Properties)ctx, (int)WindowNo, (String)"DiscountSchema", (String)(pp.isDiscountSchema() ? "Y" : "N"));
        return "";
    }
}

