/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.CalloutEngine;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.MAttributeSetInstance;
import org.compiere.model.MDocType;
import org.compiere.model.MInOut;
import org.compiere.model.MLocator;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MRMA;
import org.compiere.model.MRMALine;
import org.compiere.model.MSequence;
import org.compiere.model.MUOM;
import org.compiere.model.MUOMConversion;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;

public class CalloutInOut
extends CalloutEngine {
    public String order(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer C_Order_ID = (Integer)value;
        if (C_Order_ID == null || C_Order_ID == 0) {
            return "";
        }
        if (this.isCalloutActive()) {
            return "";
        }
        MOrder order = new MOrder(ctx, C_Order_ID.intValue(), null);
        if (order.get_ID() != 0) {
            mTab.setValue("DateOrdered", (Object)order.getDateOrdered());
            mTab.setValue("POReference", (Object)order.getPOReference());
            mTab.setValue("AD_Org_ID", (Object)order.getAD_Org_ID());
            mTab.setValue("AD_OrgTrx_ID", (Object)order.getAD_OrgTrx_ID());
            mTab.setValue("C_Activity_ID", (Object)order.getC_Activity_ID());
            mTab.setValue("C_Campaign_ID", (Object)order.getC_Campaign_ID());
            mTab.setValue("C_Project_ID", (Object)order.getC_Project_ID());
            mTab.setValue("User1_ID", (Object)order.getUser1_ID());
            mTab.setValue("User2_ID", (Object)order.getUser2_ID());
            mTab.setValue("M_Warehouse_ID", (Object)order.getM_Warehouse_ID());
            mTab.setValue("DeliveryRule", (Object)order.getDeliveryRule());
            mTab.setValue("DeliveryViaRule", (Object)order.getDeliveryViaRule());
            mTab.setValue("M_Shipper_ID", (Object)order.getM_Shipper_ID());
            mTab.setValue("FreightCostRule", (Object)order.getFreightCostRule());
            mTab.setValue("FreightAmt", (Object)order.getFreightAmt());
            mTab.setValue("C_BPartner_ID", (Object)order.getC_BPartner_ID());
            mTab.setValue("C_BPartner_Location_ID", (Object)order.getC_BPartner_Location_ID());
            if (order.getAD_User_ID() > 0) {
                mTab.setValue("AD_User_ID", (Object)order.getAD_User_ID());
            } else {
                mTab.setValue("AD_User_ID", null);
            }
            if (order.isDropShip()) {
                mTab.setValue("IsDropShip", (Object)order.isDropShip());
                mTab.setValue("DropShip_BPartner_ID", (Object)order.getDropShip_BPartner_ID());
                mTab.setValue("DropShip_Location_ID", (Object)order.getDropShip_Location_ID());
                mTab.setValue("DropShip_User_ID", (Object)order.getDropShip_User_ID());
            }
        }
        int docTypeId = order.getC_DocType_ID();
        int relatedDocTypeId = 0;
        if (docTypeId == 0) {
            docTypeId = order.getC_DocTypeTarget_ID();
        }
        relatedDocTypeId = MDocType.getShipmentReceiptDocType((int)docTypeId);
        mTab.setValue("C_DocType_ID", (Object)relatedDocTypeId);
        return "";
    }

    public String rma(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer M_RMA_ID = (Integer)value;
        if (M_RMA_ID == null || M_RMA_ID == 0) {
            return "";
        }
        if (this.isCalloutActive()) {
            return "";
        }
        MRMA rma = new MRMA(ctx, M_RMA_ID.intValue(), null);
        MInOut originalReceipt = rma.getShipment();
        if (rma.get_ID() != 0) {
            mTab.setValue("DateOrdered", (Object)originalReceipt.getDateOrdered());
            mTab.setValue("POReference", (Object)originalReceipt.getPOReference());
            mTab.setValue("AD_Org_ID", (Object)originalReceipt.getAD_Org_ID());
            mTab.setValue("AD_OrgTrx_ID", (Object)originalReceipt.getAD_OrgTrx_ID());
            mTab.setValue("C_Activity_ID", (Object)originalReceipt.getC_Activity_ID());
            mTab.setValue("C_Campaign_ID", (Object)originalReceipt.getC_Campaign_ID());
            mTab.setValue("C_Project_ID", (Object)originalReceipt.getC_Project_ID());
            mTab.setValue("User1_ID", (Object)originalReceipt.getUser1_ID());
            mTab.setValue("User2_ID", (Object)originalReceipt.getUser2_ID());
            mTab.setValue("M_Warehouse_ID", (Object)originalReceipt.getM_Warehouse_ID());
            mTab.setValue("DeliveryRule", (Object)originalReceipt.getDeliveryRule());
            mTab.setValue("DeliveryViaRule", (Object)originalReceipt.getDeliveryViaRule());
            mTab.setValue("M_Shipper_ID", (Object)originalReceipt.getM_Shipper_ID());
            mTab.setValue("FreightCostRule", (Object)originalReceipt.getFreightCostRule());
            mTab.setValue("FreightAmt", (Object)originalReceipt.getFreightAmt());
            mTab.setValue("C_BPartner_ID", (Object)originalReceipt.getC_BPartner_ID());
            mTab.setValue("C_BPartner_Location_ID", (Object)originalReceipt.getC_BPartner_Location_ID());
            if (originalReceipt.getAD_User_ID() > 0) {
                mTab.setValue("AD_User_ID", (Object)originalReceipt.getAD_User_ID());
            } else {
                mTab.setValue("AD_User_ID", null);
            }
        }
        return "";
    }

    public String docType(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer C_DocType_ID = (Integer)value;
        if (C_DocType_ID == null || C_DocType_ID == 0) {
            return "";
        }
        String sql = "SELECT d.DocBaseType, d.IsDocNoControlled, s.AD_Sequence_ID, d.IsSOTrx FROM C_DocType d LEFT OUTER JOIN AD_Sequence s ON (d.DocNoSequence_ID=s.AD_Sequence_ID) WHERE C_DocType_ID=?";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                Env.setContext((Properties)ctx, (int)WindowNo, (String)"C_DocTypeTarget_ID", (int)C_DocType_ID);
                pstmt = DB.prepareStatement((String)sql, null);
                pstmt.setInt(1, C_DocType_ID);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    String trxFlag = rs.getString("IsSOTrx");
                    Object isSOTrxValue = mTab.getValue("IsSOTrx");
                    String isSOTrxValueStr = null;
                    boolean IsSOTrx = "Y".equals(trxFlag);
                    if (isSOTrxValue != null) {
                        isSOTrxValueStr = isSOTrxValue instanceof Boolean ? ((Boolean)isSOTrxValue != false ? "Y" : "N") : (String)isSOTrxValue;
                    }
                    if (!trxFlag.equals(isSOTrxValueStr)) {
                        mTab.setValue("IsSOTrx", (Object)trxFlag);
                    }
                    mTab.setValue("MovementType", (Object)MInOut.getMovementType((Properties)ctx, (int)C_DocType_ID, (boolean)IsSOTrx, null));
                    if (rs.getString("IsDocNoControlled").equals("Y")) {
                        int AD_Sequence_ID = rs.getInt("AD_Sequence_ID");
                        mTab.setValue("DocumentNo", (Object)MSequence.getPreliminaryNo((GridTab)mTab, (int)AD_Sequence_ID));
                    }
                }
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, sql, (Throwable)e);
                String string = e.getLocalizedMessage();
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                return string;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        return "";
    }

    public String bpartner(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer C_BPartner_ID = (Integer)value;
        if (C_BPartner_ID == null || C_BPartner_ID == 0) {
            return "";
        }
        String sql = "SELECT p.AD_Language,p.C_PaymentTerm_ID,p.M_PriceList_ID,p.PaymentRule,p.POReference,p.SO_Description,p.IsDiscountPrinted,p.SO_CreditLimit-p.SO_CreditUsed AS CreditAvailable,(select max(l.C_BPartner_Location_ID) from C_BPartner_Location l where p.C_BPartner_ID=l.C_BPartner_ID AND l.IsActive='Y') as C_BPartner_Location_ID,(select max(c.AD_User_ID) from AD_User c where p.C_BPartner_ID=c.C_BPartner_ID AND c.IsActive='Y' AND IsShipTo='Y') as ShipTo_User_ID,(select max(c.AD_User_ID) from AD_User c where p.C_BPartner_ID=c.C_BPartner_ID AND c.IsActive='Y') as AD_User_ID FROM C_BPartner p WHERE p.C_BPartner_ID=?";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)sql, null);
                pstmt.setInt(1, C_BPartner_ID);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    boolean IsSOTrx = "Y".equals(Env.getContext((Properties)ctx, (int)WindowNo, (String)"IsSOTrx"));
                    if (!IsSOTrx) {
                        Integer ii = rs.getInt("C_BPartner_Location_ID");
                        if (rs.wasNull()) {
                            mTab.setValue("C_BPartner_Location_ID", null);
                        } else {
                            mTab.setValue("C_BPartner_Location_ID", (Object)ii);
                        }
                        ii = rs.getInt("AD_User_ID");
                        if (rs.wasNull()) {
                            mTab.setValue("AD_User_ID", null);
                        } else {
                            int ShipTo_User_ID = rs.getInt("ShipTo_User_ID");
                            Integer userID = ShipTo_User_ID > 0 ? Integer.valueOf(ShipTo_User_ID) : ii;
                            mTab.setValue("AD_User_ID", (Object)userID);
                        }
                    }
                    if (IsSOTrx) {
                        double CreditAvailable = rs.getDouble("CreditAvailable");
                        if (!rs.wasNull() && CreditAvailable < 0.0) {
                            mTab.fireDataStatusEEvent("CreditLimitOver", DisplayType.getNumberFormat((int)12).format(CreditAvailable), false);
                        }
                    }
                }
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, sql, (Throwable)e);
                String string = e.getLocalizedMessage();
                DB.close((ResultSet)rs, (Statement)pstmt);
                return string;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, (Statement)pstmt);
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        return "";
    }

    public String warehouse(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (this.isCalloutActive()) {
            return "";
        }
        Integer M_Warehouse_ID = (Integer)value;
        if (M_Warehouse_ID == null || M_Warehouse_ID == 0) {
            return "";
        }
        String sql = "SELECT w.AD_Org_ID, l.M_Locator_ID, w.IsDisallowNegativeInv  FROM M_Warehouse w LEFT OUTER JOIN M_Locator l ON (l.M_Warehouse_ID=w.M_Warehouse_ID AND l.IsDefault='Y') WHERE w.M_Warehouse_ID=?";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)sql, null);
                pstmt.setInt(1, M_Warehouse_ID);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    Integer ii = rs.getInt(1);
                    int AD_Org_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"AD_Org_ID");
                    if (AD_Org_ID != ii) {
                        mTab.setValue("AD_Org_ID", (Object)ii);
                    }
                    ii = rs.getInt(2);
                    if (rs.wasNull()) {
                        Env.setContext((Properties)ctx, (int)WindowNo, (int)0, (String)"M_Locator_ID", null);
                    } else {
                        if (this.log.isLoggable(Level.CONFIG)) {
                            this.log.config("M_Locator_ID=" + ii);
                        }
                        Env.setContext((Properties)ctx, (int)WindowNo, (String)"M_Locator_ID", (int)ii);
                    }
                }
                Boolean disallowNegInv = rs.getString(3).equals("Y");
                String DeliveryRule = mTab.get_ValueAsString("DeliveryRule");
                if (disallowNegInv.booleanValue() && DeliveryRule.equals("F") || DeliveryRule == null || DeliveryRule.length() == 0) {
                    mTab.setValue("DeliveryRule", (Object)"A");
                }
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, sql, (Throwable)e);
                String string = e.getLocalizedMessage();
                DB.close((ResultSet)rs, (Statement)pstmt);
                return string;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, (Statement)pstmt);
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        return "";
    }

    public String orderLine(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer C_OrderLine_ID = (Integer)value;
        if (C_OrderLine_ID == null || C_OrderLine_ID == 0) {
            return "";
        }
        MOrderLine ol = new MOrderLine(ctx, C_OrderLine_ID.intValue(), null);
        if (ol.get_ID() != 0) {
            if (ol.getC_Charge_ID() > 0 && ol.getM_Product_ID() <= 0) {
                mTab.setValue("C_Charge_ID", (Object)ol.getC_Charge_ID());
                mTab.setValue("M_Product_ID", null);
                mTab.setValue("M_AttributeSetInstance_ID", null);
            } else {
                mTab.setValue("M_Product_ID", (Object)ol.getM_Product_ID());
                mTab.setValue("M_AttributeSetInstance_ID", (Object)ol.getM_AttributeSetInstance_ID());
                mTab.setValue("C_Charge_ID", null);
            }
            mTab.setValue("C_UOM_ID", (Object)ol.getC_UOM_ID());
            BigDecimal MovementQty = ol.getQtyOrdered().subtract(ol.getQtyDelivered());
            BigDecimal runningqty = DB.getSQLValueBDEx(null, (String)"SELECT SUM(MovementQty) FROM M_InOutLine WHERE M_InOut_ID=? AND M_InOutLine_ID!=? AND C_OrderLine_ID=?", (Object[])new Object[]{Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"M_InOut_ID"), Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"M_InOutLine_ID"), ol.get_ID()});
            if (runningqty != null) {
                MovementQty = MovementQty.subtract(runningqty);
            }
            mTab.setValue("MovementQty", (Object)MovementQty);
            BigDecimal QtyEntered = MovementQty;
            if (ol.getQtyEntered().compareTo(ol.getQtyOrdered()) != 0) {
                QtyEntered = QtyEntered.multiply(ol.getQtyEntered()).divide(ol.getQtyOrdered(), 12, RoundingMode.HALF_UP);
            }
            mTab.setValue("QtyEntered", (Object)QtyEntered);
            mTab.setValue("C_Activity_ID", (Object)ol.getC_Activity_ID());
            mTab.setValue("C_Campaign_ID", (Object)ol.getC_Campaign_ID());
            mTab.setValue("C_Project_ID", (Object)ol.getC_Project_ID());
            mTab.setValue("C_ProjectPhase_ID", (Object)ol.getC_ProjectPhase_ID());
            mTab.setValue("C_ProjectTask_ID", (Object)ol.getC_ProjectTask_ID());
            mTab.setValue("AD_OrgTrx_ID", (Object)ol.getAD_OrgTrx_ID());
            mTab.setValue("User1_ID", (Object)ol.getUser1_ID());
            mTab.setValue("User2_ID", (Object)ol.getUser2_ID());
        }
        return "";
    }

    public String rmaLine(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer M_RMALine_id = (Integer)value;
        if (M_RMALine_id == null || M_RMALine_id == 0) {
            return "";
        }
        MRMALine rl = new MRMALine(ctx, M_RMALine_id.intValue(), null);
        if (rl.get_ID() != 0) {
            if (rl.getC_Charge_ID() > 0 && rl.getM_Product_ID() <= 0) {
                mTab.setValue("C_Charge_ID", (Object)rl.getC_Charge_ID());
                mTab.setValue("M_Product_ID", null);
                mTab.setValue("M_AttributeSetInstance_ID", null);
            } else {
                mTab.setValue("M_Product_ID", (Object)rl.getM_Product_ID());
                mTab.setValue("M_AttributeSetInstance_ID", (Object)rl.getM_AttributeSetInstance_ID());
                mTab.setValue("C_Charge_ID", null);
            }
            mTab.setValue("C_UOM_ID", (Object)rl.getC_UOM_ID());
            BigDecimal MovementQty = rl.getQty().subtract(rl.getQtyDelivered());
            mTab.setValue("MovementQty", (Object)MovementQty);
            BigDecimal QtyEntered = MovementQty;
            mTab.setValue("QtyEntered", (Object)QtyEntered);
            mTab.setValue("C_Activity_ID", (Object)rl.getC_Activity_ID());
            mTab.setValue("C_Campaign_ID", (Object)rl.getC_Campaign_ID());
            mTab.setValue("C_Project_ID", (Object)rl.getC_Project_ID());
            mTab.setValue("C_ProjectPhase_ID", (Object)rl.getC_ProjectPhase_ID());
            mTab.setValue("C_ProjectTask_ID", (Object)rl.getC_ProjectTask_ID());
            mTab.setValue("AD_OrgTrx_ID", (Object)rl.getAD_OrgTrx_ID());
            mTab.setValue("User1_ID", (Object)rl.getUser1_ID());
            mTab.setValue("User2_ID", (Object)rl.getUser2_ID());
        }
        return "";
    }

    public String product(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (this.isCalloutActive()) {
            return "";
        }
        Integer M_Product_ID = (Integer)value;
        if (M_Product_ID == null || M_Product_ID == 0) {
            return "";
        }
        int M_Locator_ID = 0;
        if (Env.getContextAsInt((Properties)ctx, (int)WindowNo, (int)1113, (String)"M_Product_ID") == M_Product_ID && Env.getContextAsInt((Properties)ctx, (int)WindowNo, (int)1113, (String)"M_AttributeSetInstance_ID") != 0) {
            mTab.setValue("M_AttributeSetInstance_ID", (Object)Env.getContextAsInt((Properties)ctx, (int)WindowNo, (int)1113, (String)"M_AttributeSetInstance_ID"));
            M_Locator_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (int)1113, (String)"M_Locator_ID");
            if (M_Locator_ID != 0) {
                mTab.setValue("M_Locator_ID", (Object)M_Locator_ID);
            }
        } else {
            mTab.setValue("M_AttributeSetInstance_ID", null);
        }
        int M_Warehouse_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"M_Warehouse_ID");
        boolean IsSOTrx = "Y".equals(Env.getContext((Properties)ctx, (int)WindowNo, (String)"IsSOTrx"));
        if (IsSOTrx) {
            return "";
        }
        MProduct product = MProduct.get((Properties)ctx, (int)M_Product_ID);
        mTab.setValue("C_UOM_ID", (Object)product.getC_UOM_ID());
        BigDecimal QtyEntered = (BigDecimal)mTab.getValue("QtyEntered");
        mTab.setValue("MovementQty", (Object)QtyEntered);
        if (M_Locator_ID == 0) {
            if (product.getM_Locator_ID() != 0) {
                MLocator loc = MLocator.get((Properties)ctx, (int)product.getM_Locator_ID());
                if (M_Warehouse_ID == loc.getM_Warehouse_ID()) {
                    mTab.setValue("M_Locator_ID", (Object)product.getM_Locator_ID());
                } else if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("No Locator for M_Product_ID=" + M_Product_ID + " and M_Warehouse_ID=" + M_Warehouse_ID);
                }
            } else if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("No Locator for M_Product_ID=" + M_Product_ID);
            }
        }
        return "";
    }

    public String qty(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (this.isCalloutActive() || value == null) {
            return "";
        }
        int M_Product_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (int)mTab.getTabNo(), (String)"M_Product_ID");
        if (M_Product_ID == 0) {
            BigDecimal QtyEntered = (BigDecimal)mTab.getValue("QtyEntered");
            mTab.setValue("MovementQty", (Object)QtyEntered);
        } else if (mField.getColumnName().equals("C_UOM_ID")) {
            boolean conversion;
            BigDecimal MovementQty;
            BigDecimal QtyEntered1;
            int C_UOM_To_ID = (Integer)value;
            BigDecimal QtyEntered = (BigDecimal)mTab.getValue("QtyEntered");
            if (QtyEntered.compareTo(QtyEntered1 = QtyEntered.setScale(MUOM.getPrecision((Properties)ctx, (int)C_UOM_To_ID), RoundingMode.HALF_UP)) != 0) {
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Corrected QtyEntered Scale UOM=" + C_UOM_To_ID + "; QtyEntered=" + QtyEntered + "->" + QtyEntered1);
                }
                QtyEntered = QtyEntered1;
                mTab.setValue("QtyEntered", (Object)QtyEntered);
            }
            if ((MovementQty = MUOMConversion.convertProductFrom((Properties)ctx, (int)M_Product_ID, (int)C_UOM_To_ID, (BigDecimal)QtyEntered)) == null) {
                MovementQty = QtyEntered;
            }
            boolean bl = conversion = QtyEntered.compareTo(MovementQty) != 0;
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("UOM=" + C_UOM_To_ID + ", QtyEntered=" + QtyEntered + " -> " + conversion + " MovementQty=" + MovementQty);
            }
            Env.setContext((Properties)ctx, (int)WindowNo, (String)"UOMConversion", (String)(conversion ? "Y" : "N"));
            mTab.setValue("MovementQty", (Object)MovementQty);
        } else if (Env.getContextAsInt((Properties)ctx, (int)WindowNo, (int)mTab.getTabNo(), (String)"C_UOM_ID") == 0) {
            BigDecimal QtyEntered = (BigDecimal)mTab.getValue("QtyEntered");
            mTab.setValue("MovementQty", (Object)QtyEntered);
        } else if (mField.getColumnName().equals("QtyEntered")) {
            boolean conversion;
            BigDecimal MovementQty;
            BigDecimal QtyEntered = (BigDecimal)value;
            int C_UOM_To_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (int)mTab.getTabNo(), (String)"C_UOM_ID");
            BigDecimal QtyEntered1 = QtyEntered.setScale(MUOM.getPrecision((Properties)ctx, (int)C_UOM_To_ID), RoundingMode.HALF_UP);
            if (QtyEntered.compareTo(QtyEntered1) != 0) {
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Corrected QtyEntered Scale UOM=" + C_UOM_To_ID + "; QtyEntered=" + QtyEntered + "->" + QtyEntered1);
                }
                QtyEntered = QtyEntered1;
                mTab.setValue("QtyEntered", (Object)QtyEntered);
            }
            if ((MovementQty = MUOMConversion.convertProductFrom((Properties)ctx, (int)M_Product_ID, (int)C_UOM_To_ID, (BigDecimal)QtyEntered)) == null) {
                MovementQty = QtyEntered;
            }
            boolean bl = conversion = QtyEntered.compareTo(MovementQty) != 0;
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("UOM=" + C_UOM_To_ID + ", QtyEntered=" + QtyEntered + " -> " + conversion + " MovementQty=" + MovementQty);
            }
            Env.setContext((Properties)ctx, (int)WindowNo, (String)"UOMConversion", (String)(conversion ? "Y" : "N"));
            mTab.setValue("MovementQty", (Object)MovementQty);
        } else if (mField.getColumnName().equals("MovementQty")) {
            boolean conversion;
            BigDecimal QtyEntered;
            int C_UOM_To_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (int)mTab.getTabNo(), (String)"C_UOM_ID");
            BigDecimal MovementQty = (BigDecimal)value;
            int precision = MProduct.get((Properties)ctx, (int)M_Product_ID).getUOMPrecision();
            BigDecimal MovementQty1 = MovementQty.setScale(precision, RoundingMode.HALF_UP);
            if (MovementQty.compareTo(MovementQty1) != 0) {
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Corrected MovementQty " + MovementQty + "->" + MovementQty1);
                }
                MovementQty = MovementQty1;
                mTab.setValue("MovementQty", (Object)MovementQty);
            }
            if ((QtyEntered = MUOMConversion.convertProductTo((Properties)ctx, (int)M_Product_ID, (int)C_UOM_To_ID, (BigDecimal)MovementQty)) == null) {
                QtyEntered = MovementQty;
            }
            boolean bl = conversion = MovementQty.compareTo(QtyEntered) != 0;
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("UOM=" + C_UOM_To_ID + ", MovementQty=" + MovementQty + " -> " + conversion + " QtyEntered=" + QtyEntered);
            }
            Env.setContext((Properties)ctx, (int)WindowNo, (String)"UOMConversion", (String)(conversion ? "Y" : "N"));
            mTab.setValue("QtyEntered", (Object)QtyEntered);
        }
        return "";
    }

    public String asi(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        MAttributeSetInstance asi;
        int selectedM_Locator_ID;
        if (this.isCalloutActive()) {
            return "";
        }
        Integer M_ASI_ID = (Integer)value;
        if (M_ASI_ID == null || M_ASI_ID == 0) {
            return "";
        }
        int M_Product_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (int)mTab.getTabNo(), (String)"M_Product_ID");
        int M_Warehouse_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"M_Warehouse_ID");
        int M_Locator_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (int)mTab.getTabNo(), (String)"M_Locator_ID");
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("M_Product_ID=" + M_Product_ID + ", M_ASI_ID=" + M_ASI_ID + " - M_Warehouse_ID=" + M_Warehouse_ID + ", M_Locator_ID=" + M_Locator_ID);
        }
        int M_AttributeSetInstance_ID = Env.getContextAsInt((Properties)Env.getCtx(), (int)WindowNo, (int)1113, (String)"M_AttributeSetInstance_ID");
        if (M_ASI_ID == M_AttributeSetInstance_ID && (selectedM_Locator_ID = Env.getContextAsInt((Properties)Env.getCtx(), (int)WindowNo, (int)1113, (String)"M_Locator_ID")) != 0) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Selected M_Locator_ID=" + selectedM_Locator_ID);
            }
            mTab.setValue("M_Locator_ID", (Object)selectedM_Locator_ID);
        }
        if ((asi = MAttributeSetInstance.get((Properties)ctx, (int)M_ASI_ID, (int)0)).getSerNo() != null) {
            mTab.setValue("MovementQty", (Object)Env.ONE);
            mTab.setValue("QtyEntered", (Object)Env.ONE);
            MProduct product = MProduct.get((Properties)ctx, (int)M_Product_ID);
            if (product != null) {
                mTab.setValue("C_UOM_ID", (Object)product.getC_UOM_ID());
            }
        }
        return "";
    }

    public String navigateInOutLine(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (this.isCalloutActive() || value == null) {
            return "";
        }
        int M_Product_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (int)mTab.getTabNo(), (String)"M_Product_ID");
        if (M_Product_ID != 0) {
            MProduct product = MProduct.get((Properties)ctx, (int)M_Product_ID);
            int C_UOM_To_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (int)mTab.getTabNo(), (String)"C_UOM_ID");
            boolean conversion = C_UOM_To_ID != product.getC_UOM_ID();
            Env.setContext((Properties)ctx, (int)WindowNo, (String)"UOMConversion", (String)(conversion ? "Y" : "N"));
        }
        return "";
    }
}

