/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tsp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.NoSuchProviderException;
import java.security.cert.X509Extension;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.tsp.TimeStampReq;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.tsp.TSPException;
import org.bouncycastle.tsp.TSPUtil;
import org.bouncycastle.tsp.TSPValidationException;

public class TimeStampRequest
implements X509Extension {
    private TimeStampReq req;
    private X509Extensions extensions;

    public TimeStampRequest(TimeStampReq timeStampReq) {
        this.req = timeStampReq;
        this.extensions = timeStampReq.getExtensions();
    }

    public TimeStampRequest(byte[] byArray) throws IOException {
        this(new ByteArrayInputStream(byArray));
    }

    public TimeStampRequest(InputStream inputStream) throws IOException {
        try {
            this.req = TimeStampReq.getInstance((Object)new ASN1InputStream(inputStream).readObject());
        }
        catch (ClassCastException classCastException) {
            throw new IOException("malformed request: " + classCastException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IOException("malformed request: " + illegalArgumentException);
        }
    }

    public int getVersion() {
        return this.req.getVersion().getValue().intValue();
    }

    public String getMessageImprintAlgOID() {
        return this.req.getMessageImprint().getHashAlgorithm().getObjectId().getId();
    }

    public byte[] getMessageImprintDigest() {
        return this.req.getMessageImprint().getHashedMessage();
    }

    public String getReqPolicy() {
        if (this.req.getReqPolicy() != null) {
            return this.req.getReqPolicy().getId();
        }
        return null;
    }

    public BigInteger getNonce() {
        if (this.req.getNonce() != null) {
            return this.req.getNonce().getValue();
        }
        return null;
    }

    public boolean getCertReq() {
        if (this.req.getCertReq() != null) {
            return this.req.getCertReq().isTrue();
        }
        return false;
    }

    public void validate(Set set, Set set2, Set set3, String string) throws TSPException, NoSuchProviderException {
        int n;
        if (!set.contains(this.getMessageImprintAlgOID())) {
            throw new TSPValidationException("request contains unknown algorithm.", 128);
        }
        if (set2 != null && this.getReqPolicy() != null && !set2.contains(this.getReqPolicy())) {
            throw new TSPValidationException("request contains unknown policy.", 256);
        }
        if (this.getExtensions() != null && set3 != null) {
            Enumeration enumeration = this.getExtensions().oids();
            while (enumeration.hasMoreElements()) {
                String string2 = ((DERObjectIdentifier)enumeration.nextElement()).getId();
                if (set3.contains(string2)) continue;
                throw new TSPValidationException("request contains unknown extension.", 0x800000);
            }
        }
        if ((n = TSPUtil.getDigestLength(this.getMessageImprintAlgOID())) != this.getMessageImprintDigest().length) {
            throw new TSPValidationException("imprint digest the wrong length.", 4);
        }
    }

    public void validate(Set set, Set set2, Set set3) throws TSPException {
        int n;
        if (!set.contains(this.getMessageImprintAlgOID())) {
            throw new TSPValidationException("request contains unknown algorithm.", 128);
        }
        if (set2 != null && this.getReqPolicy() != null && !set2.contains(this.getReqPolicy())) {
            throw new TSPValidationException("request contains unknown policy.", 256);
        }
        if (this.getExtensions() != null && set3 != null) {
            Enumeration enumeration = this.getExtensions().oids();
            while (enumeration.hasMoreElements()) {
                String string = ((DERObjectIdentifier)enumeration.nextElement()).getId();
                if (set3.contains(string)) continue;
                throw new TSPValidationException("request contains unknown extension.", 0x800000);
            }
        }
        if ((n = TSPUtil.getDigestLength(this.getMessageImprintAlgOID())) != this.getMessageImprintDigest().length) {
            throw new TSPValidationException("imprint digest the wrong length.", 4);
        }
    }

    public byte[] getEncoded() throws IOException {
        return this.req.getEncoded();
    }

    X509Extensions getExtensions() {
        return this.extensions;
    }

    public boolean hasExtensions() {
        return this.extensions != null;
    }

    public org.bouncycastle.asn1.x509.X509Extension getExtension(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        if (this.extensions != null) {
            return this.extensions.getExtension(aSN1ObjectIdentifier);
        }
        return null;
    }

    public List getExtensionOIDs() {
        return TSPUtil.getExtensionOIDs(this.extensions);
    }

    public byte[] getExtensionValue(String string) {
        org.bouncycastle.asn1.x509.X509Extension x509Extension;
        X509Extensions x509Extensions = this.req.getExtensions();
        if (x509Extensions != null && (x509Extension = x509Extensions.getExtension(new DERObjectIdentifier(string))) != null) {
            try {
                return x509Extension.getValue().getEncoded();
            }
            catch (Exception exception) {
                throw new RuntimeException("error encoding " + exception.toString());
            }
        }
        return null;
    }

    private Set getExtensionOIDS(boolean bl) {
        HashSet<String> hashSet = new HashSet<String>();
        X509Extensions x509Extensions = this.req.getExtensions();
        if (x509Extensions != null) {
            Enumeration enumeration = x509Extensions.oids();
            while (enumeration.hasMoreElements()) {
                DERObjectIdentifier dERObjectIdentifier = (DERObjectIdentifier)enumeration.nextElement();
                org.bouncycastle.asn1.x509.X509Extension x509Extension = x509Extensions.getExtension(dERObjectIdentifier);
                if (x509Extension.isCritical() != bl) continue;
                hashSet.add(dERObjectIdentifier.getId());
            }
            return hashSet;
        }
        return null;
    }

    public Set getNonCriticalExtensionOIDs() {
        return this.getExtensionOIDS(false);
    }

    public Set getCriticalExtensionOIDs() {
        return this.getExtensionOIDS(true);
    }

    public boolean hasUnsupportedCriticalExtension() {
        return false;
    }
}

