/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.addon.chosenbox;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.text.StringEscapeUtils;
import org.zkoss.lang.Objects;
import org.zkoss.xel.VariableResolver;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuScript;
import org.zkoss.zk.au.out.AuSetAttribute;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.InputEvent;
import org.zkoss.zk.ui.event.OpenEvent;
import org.zkoss.zk.ui.event.SelectEvent;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zk.ui.util.ForEachStatus;
import org.zkoss.zk.ui.util.Template;
import org.zkoss.zul.ItemRenderer;
import org.zkoss.zul.Label;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.ListModelList;
import org.zkoss.zul.ListSubModel;
import org.zkoss.zul.event.ListDataEvent;
import org.zkoss.zul.event.ListDataListener;

public class Chosenbox<T>
extends HtmlBasedComponent {
    private static final String CHOSENBOX_PREPARE_DATA = "chosenbox.prepareData";
    private static final long serialVersionUID = 4501010016457525407L;
    private List<Integer> _selIdxs = new ArrayList<Integer>();
    private String _name;
    private String _value = "";
    private boolean _disabled;
    private int _jsel = -1;
    private int _tabindex;
    private boolean _open;
    private boolean _creatable;
    private String _emptyMessage;
    private String _noResultsText;
    private String _createMessage;
    private String _separator;
    private transient ListModelList<T> _model;
    private transient ListModel<T> _subListModel;
    private transient ListDataListener _dataListener;
    private transient EventListener<InputEvent> _eventListener;
    private transient ItemRenderer<T> _renderer;
    private transient boolean _childable;
    private transient String[] _options;
    private transient String[] _chgSel;
    private long _onSelectTimestamp;
    private long _onOkTimestamp;
    private final ItemRenderer<T> _defRend = new ItemRenderer<T>(){

        public String render(final Component owner, final T data, final int index) {
            Chosenbox self = (Chosenbox)owner;
            Template tm = self.getTemplate("model");
            if (tm == null) {
                return Objects.toString(data);
            }
            Component[] items = tm.create(owner, null, new VariableResolver(){

                public Object resolveVariable(String name) {
                    if ("each".equals(name)) {
                        return data;
                    }
                    if ("forEachStatus".equals(name)) {
                        return new ForEachStatus(){

                            public ForEachStatus getPrevious() {
                                return null;
                            }

                            public Object getEach() {
                                return data;
                            }

                            public int getIndex() {
                                return index;
                            }

                            public Integer getBegin() {
                                return 0;
                            }

                            public Integer getEnd() {
                                return ((Chosenbox)owner).getModel().getSize();
                            }

                            public boolean isFirst() {
                                return index == 0;
                            }

                            public boolean isLast() {
                                return index + 1 == ((Chosenbox)owner).getModel().getSize();
                            }

                            public int getCount() {
                                return index + 1;
                            }

                            public Object getCurrent() {
                                return data;
                            }

                            public Integer getStep() {
                                return 1;
                            }
                        };
                    }
                    return null;
                }
            }, null);
            if (items.length != 1) {
                throw new UiException("The model template must have exactly one item, not " + items.length);
            }
            if (!(items[0] instanceof Label)) {
                throw new UiException("The model template can only support Label component, not " + items[0]);
            }
            items[0].detach();
            return ((Label)items[0]).getValue();
        }
    };

    static {
        Chosenbox.addClientEvent(Chosenbox.class, (String)"onSelect", (int)8193);
        Chosenbox.addClientEvent(Chosenbox.class, (String)"onFocus", (int)8192);
        Chosenbox.addClientEvent(Chosenbox.class, (String)"onBlur", (int)8192);
        Chosenbox.addClientEvent(Chosenbox.class, (String)"onOpen", (int)1);
        Chosenbox.addClientEvent(Chosenbox.class, (String)"onSearching", (int)8193);
        Chosenbox.addClientEvent(Chosenbox.class, (String)"onSearch", (int)8193);
        Chosenbox.addClientEvent(Chosenbox.class, (String)"onOK", (int)8193);
    }

    public Chosenbox() {
        this.addEventListener("onOkTimer", e -> this.onOkTimer());
    }

    private void onOkTimer() {
        if (this._onSelectTimestamp == 0L || this._onOkTimestamp == 0L) {
            this.postOnOk();
        } else {
            long diff = this._onSelectTimestamp - this._onOkTimestamp;
            this._onOkTimestamp = 0L;
            this._onSelectTimestamp = 0L;
            if (diff < 0L) {
                diff *= -1L;
            }
            if (diff > 500L) {
                this.postOnOk();
            }
        }
    }

    private void postOnOk() {
        Component p2 = this.getParent();
        while (p2 != null) {
            Iterable iterable = p2.getEventListeners("onOK");
            if (iterable.iterator().hasNext()) {
                Events.postEvent((String)"onOK", (Component)p2, null);
                break;
            }
            p2 = p2.getParent();
        }
    }

    public String getZclass() {
        return this._zclass == null ? "z-chosenbox" : this._zclass;
    }

    public void setOpen(boolean open) {
        if (this._open != open) {
            this._open = open;
            this.smartUpdate("open", this._open);
        }
    }

    public boolean isOpen() {
        return this._open;
    }

    public int getTabindex() {
        return this._tabindex;
    }

    public void setTabindex(int tabindex) throws WrongValueException {
        if (this._tabindex != tabindex) {
            this._tabindex = tabindex;
            this.smartUpdate("tabindex", tabindex);
        }
    }

    public boolean isDisabled() {
        return this._disabled;
    }

    public void setDisabled(boolean disabled) {
        if (this._disabled != disabled) {
            this._disabled = disabled;
            this.smartUpdate("disabled", this._disabled);
        }
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        if (name != null && name.length() == 0) {
            name = null;
        }
        if (!Objects.equals((Object)this._name, (Object)name)) {
            this._name = name;
            this.smartUpdate("name", name);
        }
    }

    public String getEmptyMessage() {
        return this._emptyMessage;
    }

    public void setEmptyMessage(String emptyMessage) {
        if (emptyMessage != null && emptyMessage.length() == 0) {
            emptyMessage = null;
        }
        if (!Objects.equals((Object)this._emptyMessage, (Object)emptyMessage)) {
            this._emptyMessage = emptyMessage;
            this.smartUpdate("emptyMessage", this.getEmptyMessage());
        }
    }

    public String getNoResultsText() {
        return this._noResultsText;
    }

    public void setNoResultsText(String noResultsText) {
        if (noResultsText != null && noResultsText.length() == 0) {
            noResultsText = null;
        }
        if (!Objects.equals((Object)this._noResultsText, (Object)noResultsText)) {
            this._noResultsText = noResultsText;
            this.smartUpdate("noResultsText", this.getNoResultsText());
        }
    }

    public String getCreateMessage() {
        return this._createMessage;
    }

    public void setCreateMessage(String createMessage) {
        if (createMessage != null && createMessage.length() == 0) {
            createMessage = null;
        }
        if (!Objects.equals((Object)this._createMessage, (Object)createMessage)) {
            this._createMessage = createMessage;
            this.smartUpdate("createMessage", this.getCreateMessage());
        }
    }

    public String getSeparator() {
        return this._separator;
    }

    public void setSeparator(String separator) {
        if (separator != null && separator.length() == 0) {
            separator = null;
        }
        if (!Objects.equals((Object)this._separator, (Object)separator)) {
            this._separator = separator;
            this.smartUpdate("separator", this.getSeparator());
        }
    }

    public LinkedHashSet<T> getSelectedObjects() {
        LinkedHashSet<Object> objects = new LinkedHashSet<Object>();
        ListModel<T> model = this.getModel();
        if (model != null) {
            int i = 0;
            while (i < this._selIdxs.size()) {
                objects.add(model.getElementAt(this._selIdxs.get(i).intValue()));
                ++i;
            }
        }
        return objects;
    }

    public void setSelectedObjects(Set<T> objects) {
        if (this.getModel() != null) {
            this._selIdxs.clear();
            ListModel<T> lm = this.getModel();
            boolean found = false;
            for (T object : objects) {
                int i = 0;
                while (i < lm.getSize()) {
                    if (lm.getElementAt(i).equals(object)) {
                        if (this._jsel == -1 || this._jsel > i) {
                            this._jsel = i;
                        }
                        found = true;
                        this._selIdxs.add(i);
                        break;
                    }
                    ++i;
                }
                if (!found && Logger.getLogger(((Object)((Object)this)).getClass().getName()).isLoggable(Level.INFO)) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).info("No such item: " + object);
                }
                found = false;
            }
            this.smartUpdate("chgSel", this.getChgSel());
        }
    }

    public int getSelectedIndex() {
        return this._jsel;
    }

    public void setSelectedIndex(int jsel) {
        if (jsel <= -1) {
            jsel = -1;
        }
        if (jsel < 0) {
            this.clearSelection();
        } else if (jsel != this._jsel || this._selIdxs.size() > 1) {
            if (this._selIdxs.size() > 1 && jsel == this._jsel) {
                this.smartUpdate("selectedIndex", -1);
            }
            if (this.getModel() != null && jsel >= this.getModel().getSize()) {
                throw new UiException("Out of bound: " + jsel + " while size=" + this.getModel().getSize());
            }
            this._selIdxs.clear();
            this._jsel = jsel;
            this._selIdxs.add(jsel);
            this.smartUpdate("chgSel", this.getChgSel());
        }
    }

    public boolean isCreatable() {
        return this._creatable;
    }

    public void setCreatable(boolean creatable) {
        if (this._creatable != creatable) {
            this._creatable = creatable;
            this.smartUpdate("creatable", this._creatable);
        }
    }

    public ItemRenderer<T> getRealRenderer() {
        ItemRenderer<T> renderer = this.getItemRenderer();
        return renderer != null ? renderer : this._defRend;
    }

    public ItemRenderer<T> getItemRenderer() {
        return this._renderer;
    }

    public ListModel<T> getModel() {
        return this._model;
    }

    public void setModel(ListModelList<T> model) {
        if (model != null) {
            if (this._model != model) {
                if (this.getSelectedIndex() >= model.getSize()) {
                    this.setSelectedIndex(model.getSize() - 1);
                }
                if (this._model != null) {
                    this._model.removeListDataListener(this._dataListener);
                }
                this._model = model;
                this.initDataListener();
            }
        } else if (this._model != null) {
            this._model.removeListDataListener(this._dataListener);
            if (this._model instanceof ListSubModel) {
                this.removeEventListener("onSearching", this._eventListener);
            }
            this._model = null;
        }
        this.fixIndexs(true, null);
        this.smartUpdate("renderByServer", this._model instanceof ListSubModel);
        this.updateItems();
    }

    public void clearSelection() {
        this._selIdxs.clear();
        this._jsel = -1;
        this.smartUpdate("chgSel", this.getChgSel());
    }

    public void addItemToSelection(Object o) {
        if (this.getModel() != null) {
            ListModel<T> lm = this.getModel();
            int i = 0;
            while (i < lm.getSize()) {
                if (lm.getElementAt(i).equals(o)) {
                    this._selIdxs.add(i);
                    if (i < this._jsel) {
                        this._jsel = i;
                    }
                    this.smartUpdate("chgSel", this.getChgSel());
                }
                ++i;
            }
        }
    }

    public void removeItemFromSelection(Object o) {
        if (this.getModel() != null) {
            ListModel<T> lm = this.getModel();
            int i = 0;
            while (i < lm.getSize()) {
                if (lm.getElementAt(i).equals(o)) {
                    int cur = -1;
                    int min = -1;
                    int j = 0;
                    while (j < this._selIdxs.size()) {
                        if (i == this._selIdxs.get(j)) {
                            cur = j;
                        } else if (min == -1 || this._selIdxs.get(j) < min) {
                            min = this._selIdxs.get(j);
                        }
                        ++j;
                    }
                    if (cur == -1) break;
                    this._jsel = min;
                    this._selIdxs.remove(cur);
                    this.smartUpdate("chgSel", this.getChgSel());
                    break;
                }
                ++i;
            }
        }
    }

    private String[] getChgSel() {
        this.prepareItems(null, true, (ListModel<T>)this._model);
        if (this._options != null) {
            String[] chgSel = this._options;
            this._options = null;
            return chgSel;
        }
        return new String[0];
    }

    protected boolean isChildable() {
        return this._childable;
    }

    private void prepareData() {
        if (this.getAttribute(CHOSENBOX_PREPARE_DATA) != null) {
            return;
        }
        if (this._selIdxs.size() > 0) {
            this._chgSel = this.getChgSel();
        }
        if (!(this._model instanceof ListSubModel)) {
            this.prepareItems(null, false, (ListModel<T>)this._model);
        }
        this.setAttribute(CHOSENBOX_PREPARE_DATA, Boolean.TRUE);
    }

    private void fixIndexs(boolean modelReplaced, ListDataEvent event) {
        if (modelReplaced) {
            if (this._model == null) {
                this.clearSelection();
            } else {
                Iterator<Integer> it = this._selIdxs.iterator();
                while (it.hasNext()) {
                    if (it.next() < this._model.getSize()) continue;
                    it.remove();
                }
            }
        } else {
            int pos0 = event.getIndex0();
            int pos1 = event.getIndex1();
            int amount = pos1 - pos0 + 1;
            switch (event.getType()) {
                case 1: {
                    int i = 0;
                    while (i < this._selIdxs.size()) {
                        if (this._selIdxs.get(i) >= pos0) {
                            this._selIdxs.set(i, this._selIdxs.get(i) + amount);
                        }
                        ++i;
                    }
                    break;
                }
                case 2: {
                    ListIterator<Integer> lit = this._selIdxs.listIterator();
                    while (lit.hasNext()) {
                        Integer i = lit.next();
                        if (i > pos1) {
                            lit.set(i - amount);
                            continue;
                        }
                        if (i < pos0) continue;
                        lit.remove();
                    }
                    break;
                }
            }
        }
    }

    private void prepareItems(String prefix, boolean excludeUnselected, ListModel<T> model) {
        if (model != null) {
            ArrayList<String> optList = new ArrayList<String>();
            boolean old = this._childable;
            try {
                try {
                    this._childable = true;
                    ItemRenderer<T> renderer = this.getRealRenderer();
                    if (excludeUnselected) {
                        int i = 0;
                        while (i < this._selIdxs.size()) {
                            String s = renderer.render((Component)this, model.getElementAt(this._selIdxs.get(i).intValue()), this._selIdxs.get(i).intValue());
                            if (prefix == null || s.toLowerCase().startsWith(prefix.toLowerCase())) {
                                optList.add(s);
                            }
                            ++i;
                        }
                    } else {
                        int i = 0;
                        while (i < model.getSize()) {
                            String s = renderer.render((Component)this, model.getElementAt(i), i);
                            if (prefix == null || s.toLowerCase().startsWith(prefix.toLowerCase())) {
                                optList.add(s);
                            }
                            ++i;
                        }
                    }
                    if (optList.size() > 0) {
                        this._options = optList.toArray(new String[0]);
                    }
                }
                catch (Exception e) {
                    throw UiException.Aide.wrap((Throwable)e);
                }
            }
            finally {
                this._childable = old;
                this.getChildren().clear();
            }
        }
    }

    private void updateItems() {
        this.prepareItems(null, false, (ListModel<T>)this._model);
        if (this._options != null) {
            this.smartUpdate("items", this._options);
            this._options = null;
        }
        this.smartUpdate("chgSel", this.getChgSel());
    }

    private void updateListContent(String prefix, ListModel<T> subModel) {
        if (!(this._model instanceof ListSubModel)) {
            this.prepareItems(null, false, subModel);
        } else {
            this.prepareItems(prefix, false, subModel);
        }
        if (this._options != null) {
            this.smartUpdate("listContent", this._options);
            this._options = null;
        } else {
            this.smartUpdate("listContent", new String[0]);
        }
    }

    private void initDataListener() {
        if (this._dataListener == null) {
            this._dataListener = new ListDataListener(){

                public void onChange(ListDataEvent event) {
                    Chosenbox.this.fixIndexs(false, event);
                    Chosenbox.this.updateItems();
                }
            };
        }
        if (this._eventListener == null) {
            this._eventListener = new EventListener<InputEvent>(){

                public void onEvent(InputEvent event) throws Exception {
                    if (Chosenbox.this.getModel() instanceof ListSubModel) {
                        Chosenbox.this.updateListContent(null, ((ListSubModel)Chosenbox.this._model).getSubModel((Object)event.getValue(), Chosenbox.this._model.getSize()));
                    }
                }
            };
        }
        this._model.addListDataListener(this._dataListener);
        if (this._model instanceof ListSubModel) {
            this.addEventListener("onSearching", this._eventListener);
        }
    }

    private Integer getIndexFromValue(String valueHTML, boolean checkSubList) {
        String value = StringEscapeUtils.unescapeHtml4((String)valueHTML);
        int i = 0;
        while (i < this._model.getSize()) {
            if (value.equals(this._model.getElementAt(i).toString())) {
                return i;
            }
            ++i;
        }
        if (checkSubList && this._subListModel != null) {
            i = 0;
            while (i < this._subListModel.getSize()) {
                if (value.equals(this._subListModel.getElementAt(i).toString())) {
                    this._model.add(this._subListModel.getElementAt(i));
                    return this._model.getSize() - 1;
                }
                ++i;
            }
        }
        throw new UiException("No such item: " + value);
    }

    public void invalidate() {
        this.prepareData();
        super.invalidate();
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        this.prepareData();
        this.removeAttribute(CHOSENBOX_PREPARE_DATA);
        if (this._options != null) {
            this.render(renderer, "items", this._options);
            this._options = null;
        } else {
            this.render(renderer, "items", new String[0]);
        }
        if (this._chgSel != null) {
            this.render(renderer, "chgSel", this._chgSel);
            this._chgSel = null;
        } else {
            this.render(renderer, "chgSel", new String[0]);
        }
        this.render(renderer, "name", this._name);
        this.render(renderer, "disabled", this.isDisabled());
        if (this._tabindex != 0) {
            renderer.render("tabindex", this._tabindex);
        }
        this.render(renderer, "emptyMessage", this.getEmptyMessage());
        this.render(renderer, "noResultsText", this.getNoResultsText());
        this.render(renderer, "separator", this.getSeparator());
        this.render(renderer, "createMessage", this.getCreateMessage());
        renderer.render("selectedIndex", this._jsel);
        renderer.render("creatable", this._creatable);
        renderer.render("renderByServer", this._model instanceof ListSubModel);
        this.render(renderer, "open", this._open);
        if (this._model instanceof ListSubModel && this._selIdxs.size() > 0) {
            this.prepareItems(null, true, (ListModel<T>)this._model);
            if (this._options != null && this._options.length > 0) {
                this.response("listContent", (AuResponse)new AuSetAttribute((Component)this, "listContent", (Object)this._options));
                this.response("chgSel", (AuResponse)new AuSetAttribute((Component)this, "chgSel", (Object)this._options));
                this._options = null;
            }
        }
    }

    public void service(AuRequest request, boolean everError) {
        String cmd = request.getCommand();
        if (cmd.equals("onSelect")) {
            List selItems = (List)request.getData().get("");
            this._selIdxs.clear();
            this._jsel = -1;
            int i = 0;
            while (i < selItems.size()) {
                int idx = this.getIndexFromValue(selItems.get(i).toString(), true);
                this._selIdxs.add(idx);
                if (idx < this._jsel || this._jsel == -1) {
                    this._jsel = idx;
                }
                ++i;
            }
            Integer index = this.getSelectedIndex();
            LinkedHashSet<T> objects = this.getSelectedObjects();
            Events.postEvent((Event)new SelectEvent("onSelect", (Component)this, null, null, null, objects, null, null, null, (Object)index, 0));
            if (selItems.size() < (this.getSubListModel() != null ? this.getSubListModel().getSize() : this.getModel().getSize())) {
                StringBuilder script = new StringBuilder();
                script.append("(function(){let w=zk.Widget.$('#").append(this.getUuid()).append("');");
                script.append("w.$n('inp').focus();})()");
                Executions.schedule((Desktop)this.getDesktop(), e -> {
                    this.setOpen(true);
                    Clients.evalJavaScript((String)script.toString());
                }, (Event)new Event("onPostSelect"));
            }
            this._onSelectTimestamp = System.currentTimeMillis();
        } else if (cmd.equals("onOpen")) {
            this._open = (Boolean)request.getData().get("open");
            Events.postEvent((Event)OpenEvent.getOpenEvent((AuRequest)request));
        } else if (cmd.equals("onSearch")) {
            Events.postEvent((Event)new Event("onSearch", (Component)this, (Object)((List)request.getData().get("")).get(0).toString()));
        } else if (cmd.equals("onSearching")) {
            Object data = ((List)request.getData().get("")).get(0);
            Events.postEvent((Event)new InputEvent(cmd, (Component)this, (String)data, (Object)this._value));
            this._value = (String)data;
        } else if (cmd.equals("onOK")) {
            this._onOkTimestamp = System.currentTimeMillis();
            Clients.evalJavaScript((String)("setTimeout(function(){zAu.send(new zk.Event(zk.Widget.$('#" + this.getUuid() + "'), 'onOkTimer', null));}, 100);"));
        } else if (cmd.equals("onOkTimer")) {
            Events.postEvent((String)"onOkTimer", (Component)this, null);
        }
    }

    public ListModel<T> getSubListModel() {
        return this._subListModel;
    }

    public void setSubListModel(ListModel<T> _subListModel) {
        this._subListModel = _subListModel;
    }

    public void focus() {
        this.response((AuResponse)new AuScript("$('#" + this.getUuid() + "-inp').focus();"));
    }
}

