/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.window;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.logging.Level;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.SimpleJasperReportsContext;
import net.sf.jasperreports.engine.export.HtmlExporter;
import net.sf.jasperreports.engine.export.JRCsvExporter;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.export.JRXlsExporter;
import net.sf.jasperreports.engine.export.ooxml.JRXlsxExporter;
import net.sf.jasperreports.export.ExporterConfiguration;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.ExporterOutput;
import net.sf.jasperreports.export.ReportExportConfiguration;
import net.sf.jasperreports.export.SimpleCsvExporterConfiguration;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleHtmlExporterOutput;
import net.sf.jasperreports.export.SimpleHtmlReportConfiguration;
import net.sf.jasperreports.export.SimpleOutputStreamExporterOutput;
import net.sf.jasperreports.export.SimpleWriterExporterOutput;
import net.sf.jasperreports.export.SimpleXlsReportConfiguration;
import net.sf.jasperreports.export.SimpleXlsxReportConfiguration;
import org.adempiere.base.upload.IUploadService;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.Extensions;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.component.ListItem;
import org.adempiere.webui.component.Listbox;
import org.adempiere.webui.component.Tabpanel;
import org.adempiere.webui.component.ToolBarButton;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.panel.ITabOnCloseHandler;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.Dialog;
import org.adempiere.webui.window.IReportViewerExportSource;
import org.adempiere.webui.window.WEMailDialog;
import org.adempiere.webui.window.WReportExportDialog;
import org.adempiere.webui.window.WReportUploadDialog;
import org.compiere.model.MArchive;
import org.compiere.model.MAttachment;
import org.compiere.model.MAuthorizationAccount;
import org.compiere.model.MRole;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTable;
import org.compiere.model.MToolBarButtonRestrict;
import org.compiere.model.MUser;
import org.compiere.model.PO;
import org.compiere.model.PrintInfo;
import org.compiere.model.X_AD_ToolBarButton;
import org.compiere.tools.FileUtil;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.idempiere.ui.zk.media.IMediaView;
import org.idempiere.ui.zk.media.WMediaOptions;
import org.zkoss.util.media.AMedia;
import org.zkoss.util.media.Media;
import org.zkoss.zk.ui.AbstractComponent;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.KeyEvent;
import org.zkoss.zk.ui.ext.render.DynamicMedia;
import org.zkoss.zul.Borderlayout;
import org.zkoss.zul.Center;
import org.zkoss.zul.Iframe;
import org.zkoss.zul.North;
import org.zkoss.zul.Separator;
import org.zkoss.zul.Tab;
import org.zkoss.zul.Toolbar;
import org.zkoss.zul.Toolbarbutton;
import org.zkoss.zul.impl.Utils;

public class ZkJRViewer
extends Window
implements EventListener<Event>,
ITabOnCloseHandler,
IReportViewerExportSource {
    private static final long serialVersionUID = -7204858572267608018L;
    private JasperPrint jasperPrint;
    private List<JasperPrint> jasperPrintList;
    private boolean isList;
    private Listbox previewType = new Listbox();
    private Iframe iframe;
    private AMedia media;
    private String defaultType;
    private ToolBarButton bSendMail = new ToolBarButton();
    private File attachment = null;
    private static final CLogger log = CLogger.getCLogger(ZkJRViewer.class);
    private int m_WindowNo = -1;
    private long prevKeyEventTime = 0L;
    private KeyEvent prevKeyEvent;
    private String m_title;
    Toolbar toolbar = new Toolbar();
    protected ToolBarButton bArchive = new ToolBarButton();
    protected ToolBarButton bAttachment = new ToolBarButton();
    protected ToolBarButton bExport = new ToolBarButton();
    protected ToolBarButton bCloudUpload = new ToolBarButton();
    private PrintInfo m_printInfo;
    private int mediaVersion = 0;
    protected static final String CSV_OUTPUT_TYPE = "CSV";
    protected static final String HTML_OUTPUT_TYPE = "HTML";
    protected static final String PDF_OUTPUT_TYPE = "PDF";
    protected static final String XLS_OUTPUT_TYPE = "XLS";
    protected static final String XLSX_OUTPUT_TYPE = "XLSX";
    protected final Map<String, Supplier<AMedia>> mediaSuppliers = new HashMap<String, Supplier<AMedia>>();
    protected Map<MAuthorizationAccount, IUploadService> uploadServicesMap = new HashMap<MAuthorizationAccount, IUploadService>();
    private final IReportViewerExportSource.ExportFormat[] exportFormats = new IReportViewerExportSource.ExportFormat[]{new IReportViewerExportSource.ExportFormat("pdf - " + Msg.getMsg((Properties)Env.getCtx(), (String)"FilePDF"), "pdf", PDF_MIME_TYPE), new IReportViewerExportSource.ExportFormat("html - " + Msg.getMsg((Properties)Env.getCtx(), (String)"FileHTML"), "html", HTML_MIME_TYPE), new IReportViewerExportSource.ExportFormat("csv - " + Msg.getMsg((Properties)Env.getCtx(), (String)"FileCSV"), "csv", CSV_MIME_TYPE), new IReportViewerExportSource.ExportFormat("xls - " + Msg.getMsg((Properties)Env.getCtx(), (String)"FileXLS"), "xls", EXCEL_MIME_TYPE), new IReportViewerExportSource.ExportFormat("xlsx - " + Msg.getMsg((Properties)Env.getCtx(), (String)"FileXLSX"), "xlsx", EXCEL_XML_MIME_TYPE), new IReportViewerExportSource.ExportFormat("ssv - " + Msg.getMsg((Properties)Env.getCtx(), (String)"FileSSV"), "ssv", CSV_MIME_TYPE)};
    private Center center;
    private boolean ToolBarMenuRestictionLoaded = false;

    public ZkJRViewer(JasperPrint jasperPrint, String title, PrintInfo printInfo) {
        this.setTitle(title);
        this.m_title = title;
        this.jasperPrint = jasperPrint;
        this.isList = false;
        this.m_WindowNo = SessionManager.getAppDesktop().registerWindow(this);
        this.setAttribute("desktop.windowno", this.m_WindowNo);
        this.m_printInfo = printInfo;
        this.init();
    }

    public ZkJRViewer(List<JasperPrint> jasperPrintList, String title, PrintInfo printInfo) {
        this.setTitle(title);
        this.m_title = title;
        this.jasperPrintList = jasperPrintList;
        this.isList = true;
        this.m_WindowNo = SessionManager.getAppDesktop().registerWindow(this);
        this.setAttribute("desktop.windowno", this.m_WindowNo);
        this.m_printInfo = printInfo;
        this.init();
    }

    public void onPageAttached(Page newpage, Page oldpage) {
        super.onPageAttached(newpage, oldpage);
        try {
            SessionManager.getSessionApplication().getKeylistener().addEventListener("onCtrlKey", this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void onPageDetached(Page page) {
        super.onPageDetached(page);
        try {
            SessionManager.getSessionApplication().getKeylistener().removeEventListener("onCtrlKey", this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void init() {
        boolean isCanExport = MRole.getDefault().isCanExport();
        String string = this.defaultType = this.jasperPrint == null ? null : this.jasperPrint.getProperty("IDEMPIERE_REPORT_TYPE");
        if (Util.isEmpty((String)this.defaultType)) {
            this.defaultType = MSysConfig.getValue((String)"ZK_REPORT_JASPER_OUTPUT_TYPE", (String)PDF_OUTPUT_TYPE, (int)Env.getAD_Client_ID((Properties)Env.getCtx()), (int)Env.getAD_Org_ID((Properties)Env.getCtx()));
        }
        if (Util.isEmpty((String)this.defaultType)) {
            this.defaultType = PDF_OUTPUT_TYPE;
        }
        this.initMediaSuppliers();
        Borderlayout layout = new Borderlayout();
        layout.setStyle("position: absolute; height: 99%; width: 99%");
        this.appendChild((Component)layout);
        this.setStyle("width: 100%; height: 100%; position: absolute");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this.toolbar, "32px");
        this.previewType.setMold("select");
        this.attachment = null;
        if (isCanExport) {
            this.previewType.appendItem(PDF_OUTPUT_TYPE, PDF_OUTPUT_TYPE);
            this.previewType.appendItem(HTML_OUTPUT_TYPE, HTML_OUTPUT_TYPE);
            this.previewType.appendItem(XLS_OUTPUT_TYPE, XLS_OUTPUT_TYPE);
            this.previewType.appendItem(CSV_OUTPUT_TYPE, CSV_OUTPUT_TYPE);
            this.previewType.appendItem(XLSX_OUTPUT_TYPE, XLSX_OUTPUT_TYPE);
            if (PDF_OUTPUT_TYPE.equals(this.defaultType)) {
                this.previewType.setSelectedIndex(0);
            } else if (HTML_OUTPUT_TYPE.equals(this.defaultType)) {
                this.previewType.setSelectedIndex(1);
            } else if (XLS_OUTPUT_TYPE.equals(this.defaultType)) {
                this.previewType.setSelectedIndex(2);
            } else if (CSV_OUTPUT_TYPE.equals(this.defaultType)) {
                this.previewType.setSelectedIndex(3);
            } else if (XLSX_OUTPUT_TYPE.equals(this.defaultType)) {
                this.previewType.setSelectedIndex(4);
            } else {
                this.previewType.setSelectedIndex(0);
                log.info("Format not Valid: " + this.defaultType);
            }
        } else {
            this.previewType.appendItem(PDF_OUTPUT_TYPE, PDF_OUTPUT_TYPE);
            this.previewType.appendItem(HTML_OUTPUT_TYPE, HTML_OUTPUT_TYPE);
            if (PDF_OUTPUT_TYPE.equals(this.defaultType)) {
                this.previewType.setSelectedIndex(0);
            } else if (HTML_OUTPUT_TYPE.equals(this.defaultType)) {
                this.previewType.setSelectedIndex(1);
            } else if (XLS_OUTPUT_TYPE.equals(this.defaultType)) {
                this.previewType.setSelectedIndex(0);
            } else if (CSV_OUTPUT_TYPE.equals(this.defaultType)) {
                this.previewType.setSelectedIndex(0);
            } else if (XLSX_OUTPUT_TYPE.equals(this.defaultType)) {
                this.previewType.setSelectedIndex(0);
            } else {
                this.previewType.setSelectedIndex(0);
                log.info("Format not Valid: " + this.defaultType);
            }
        }
        this.toolbar.appendChild((Component)this.previewType);
        this.previewType.addEventListener("onSelect", this);
        this.toolbar.appendChild((Component)new Separator("vertical"));
        this.bSendMail.setName("SendMail");
        if (ThemeManager.isUseFontIconForImage()) {
            this.bSendMail.setIconSclass("z-icon-SendMail");
        } else {
            this.bSendMail.setImage(ThemeManager.getThemeResource("images/SendMail24.png"));
        }
        this.bSendMail.setTooltiptext(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"SendMail")));
        this.toolbar.appendChild((Component)this.bSendMail);
        this.bSendMail.addEventListener("onClick", this);
        this.toolbar.appendChild((Component)new Separator("vertical"));
        this.bArchive.setName("Archive");
        if (ThemeManager.isUseFontIconForImage()) {
            this.bArchive.setIconSclass("z-icon-Archive");
        } else {
            this.bArchive.setImage(ThemeManager.getThemeResource("images/Archive24.png"));
        }
        this.bArchive.setTooltiptext(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"Archive")));
        this.toolbar.appendChild((Component)this.bArchive);
        this.bArchive.addEventListener("onClick", this);
        int tableId = this.m_printInfo.getAD_Table_ID();
        int recordId = this.m_printInfo.getRecord_ID();
        if (tableId > 0 && recordId > 0) {
            this.toolbar.appendChild((Component)new Separator("vertical"));
            this.bAttachment.setName("Attachment");
            if (ThemeManager.isUseFontIconForImage()) {
                this.bAttachment.setIconSclass("z-icon-Attachment");
            } else {
                this.bAttachment.setImage(ThemeManager.getThemeResource("images/Attachment24.png"));
            }
            this.bAttachment.setTooltiptext(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"Attachment")));
            this.toolbar.appendChild((Component)this.bAttachment);
            this.bAttachment.addEventListener("onClick", this);
        }
        if (isCanExport) {
            this.bExport.setName("Export");
            if (ThemeManager.isUseFontIconForImage()) {
                this.bExport.setIconSclass("z-icon-Export");
            } else {
                this.bExport.setImage(ThemeManager.getThemeResource("images/Export24.png"));
            }
            this.bExport.setTooltiptext(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"Export")));
            this.toolbar.appendChild((Component)this.bExport);
            this.bExport.addEventListener("onClick", this);
            if (ThemeManager.isUseFontIconForImage()) {
                LayoutUtils.addSclass("medium-toolbarbutton", (HtmlBasedComponent)this.bExport);
            }
            this.uploadServicesMap = MAuthorizationAccount.getUserUploadServices();
            if (this.uploadServicesMap.size() > 0) {
                this.bCloudUpload.setName("CloudUpload");
                if (ThemeManager.isUseFontIconForImage()) {
                    this.bCloudUpload.setIconSclass("z-icon-FileImport");
                } else {
                    this.bCloudUpload.setImage(ThemeManager.getThemeResource("images/FileImport24.png"));
                }
                this.bCloudUpload.setTooltiptext(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"CloudUpload")));
                this.toolbar.appendChild((Component)this.bCloudUpload);
                this.bCloudUpload.addEventListener("onClick", this);
            }
        }
        North north = new North();
        layout.appendChild((Component)north);
        north.appendChild((Component)this.toolbar);
        ZKUpdateUtil.setVflex((HtmlBasedComponent)north, "min");
        this.center = new Center();
        layout.appendChild((Component)this.center);
        this.iframe = new Iframe();
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.iframe, "true");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.iframe, "true");
        this.iframe.setId("reportFrame");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this.iframe, "100%");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.iframe, "100%");
        int AD_Window_ID = Env.getContextAsInt((Properties)Env.getCtx(), (int)this.m_WindowNo, (String)"_WinInfo_AD_Window_ID", (boolean)true);
        int AD_Process_ID = this.m_printInfo.getAD_Process_ID();
        this.updateToolbarAccess(AD_Window_ID, AD_Process_ID);
        try {
            this.renderReport();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getLocalizedMessage(), (Throwable)e);
            throw new AdempiereException("Failed to render report.", (Throwable)e);
        }
        this.center.appendChild((Component)this.iframe);
        this.setBorder("normal");
    }

    public void updateToolbarAccess(int AD_Window_ID, int AD_Process_ID) {
        int[] restrictionList;
        if (this.ToolBarMenuRestictionLoaded) {
            return;
        }
        Properties m_ctx = Env.getCtx();
        int ToolBarButton_ID = 0;
        int[] nArray = restrictionList = AD_Window_ID > 0 ? MToolBarButtonRestrict.getOfWindow((Properties)m_ctx, (int)MRole.getDefault().getAD_Role_ID(), (int)AD_Window_ID, (boolean)true, null) : MToolBarButtonRestrict.getOfReport((Properties)m_ctx, (int)MRole.getDefault().getAD_Role_ID(), (int)AD_Process_ID, null);
        if (log.isLoggable(Level.INFO)) {
            log.info("restrictionList=" + restrictionList.toString());
        }
        int i = 0;
        while (i < restrictionList.length) {
            ToolBarButton_ID = restrictionList[i];
            X_AD_ToolBarButton tbt = new X_AD_ToolBarButton(m_ctx, ToolBarButton_ID, null);
            if ("R".equals(tbt.getAction())) {
                String restrictName = tbt.getComponentName();
                if (log.isLoggable(Level.CONFIG)) {
                    log.config("tbt=" + tbt.getAD_ToolBarButton_ID() + " / " + restrictName);
                }
                Component p2 = this.toolbar.getFirstChild();
                while (p2 != null) {
                    if (p2 instanceof Toolbarbutton && restrictName.equals(((ToolBarButton)p2).getName())) {
                        this.toolbar.removeChild(p2);
                        break;
                    }
                    p2 = p2.getNextSibling();
                }
            }
            ++i;
        }
        this.ToolBarMenuRestictionLoaded = true;
    }

    private void initMediaSuppliers() {
        this.mediaSuppliers.put(this.toMediaType(PDF_MIME_TYPE, "pdf"), () -> {
            try {
                this.attachment = this.getPDF();
                return new AMedia(String.valueOf(this.m_title) + "." + "pdf", "pdf", PDF_MIME_TYPE, this.attachment, true);
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
        });
        this.mediaSuppliers.put(this.toMediaType(HTML_MIME_TYPE, "html"), () -> {
            try {
                String path = System.getProperty("java.io.tmpdir");
                String prefix = null;
                prefix = this.isList ? String.valueOf(this.makePrefix(this.jasperPrintList.get(0).getName())) + "_List" : this.makePrefix(this.jasperPrint.getName());
                if (prefix.length() < 3) {
                    prefix = String.valueOf(prefix) + "_".repeat(3 - prefix.length());
                }
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Path=" + path + " Prefix=" + prefix);
                }
                File file = File.createTempFile(prefix, ".html", new File(path));
                HtmlExporter exporter = new HtmlExporter();
                SimpleHtmlReportConfiguration htmlConfig = new SimpleHtmlReportConfiguration();
                htmlConfig.setEmbedImage(Boolean.valueOf(true));
                htmlConfig.setAccessibleHtml(Boolean.valueOf(true));
                if (!this.isList) {
                    this.jasperPrintList = new ArrayList<JasperPrint>();
                    this.jasperPrintList.add(this.jasperPrint);
                }
                exporter.setExporterInput((ExporterInput)SimpleExporterInput.getInstance(this.jasperPrintList));
                exporter.setExporterOutput((ExporterOutput)new SimpleHtmlExporterOutput(file));
                exporter.setConfiguration((ReportExportConfiguration)htmlConfig);
                exporter.exportReport();
                return new AMedia(String.valueOf(this.m_title) + "." + "html", "html", HTML_MIME_TYPE, file, false);
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
        });
        this.mediaSuppliers.put(this.toMediaType(EXCEL_MIME_TYPE, "xls"), () -> {
            try {
                String path = System.getProperty("java.io.tmpdir");
                String prefix = null;
                prefix = this.isList ? String.valueOf(this.makePrefix(this.jasperPrintList.get(0).getName())) + "_List" : this.makePrefix(this.jasperPrint.getName());
                if (prefix.length() < 3) {
                    prefix = String.valueOf(prefix) + "_".repeat(3 - prefix.length());
                }
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Path=" + path + " Prefix=" + prefix);
                }
                File file = File.createTempFile(prefix, ".xls", new File(path));
                try (FileOutputStream fos = null;){
                    fos = new FileOutputStream(file);
                    JRXlsExporter exporterXLS = new JRXlsExporter();
                    SimpleXlsReportConfiguration xlsConfig = new SimpleXlsReportConfiguration();
                    xlsConfig.setOnePagePerSheet(Boolean.valueOf(false));
                    if (!this.isList) {
                        this.jasperPrintList = new ArrayList<JasperPrint>();
                        this.jasperPrintList.add(this.jasperPrint);
                    }
                    exporterXLS.setExporterInput((ExporterInput)SimpleExporterInput.getInstance(this.jasperPrintList));
                    exporterXLS.setExporterOutput((ExporterOutput)new SimpleOutputStreamExporterOutput((OutputStream)fos));
                    exporterXLS.setConfiguration((ReportExportConfiguration)xlsConfig);
                    exporterXLS.exportReport();
                }
                return new AMedia(String.valueOf(this.m_title) + "." + "xls", "xls", EXCEL_MIME_TYPE, file, true);
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
        });
        this.mediaSuppliers.put(this.toMediaType(EXCEL_XML_MIME_TYPE, "xlsx"), () -> {
            try {
                String path = System.getProperty("java.io.tmpdir");
                String prefix = null;
                prefix = this.isList ? String.valueOf(this.makePrefix(this.jasperPrintList.get(0).getName())) + "_List" : this.makePrefix(this.jasperPrint.getName());
                if (prefix.length() < 3) {
                    prefix = String.valueOf(prefix) + "_".repeat(3 - prefix.length());
                }
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Path=" + path + " Prefix=" + prefix);
                }
                File file = File.createTempFile(prefix, ".xlsx", new File(path));
                try (FileOutputStream fos = null;){
                    fos = new FileOutputStream(file);
                    JRXlsxExporter exporterXLSX = new JRXlsxExporter();
                    SimpleXlsxReportConfiguration xlsxConfig = new SimpleXlsxReportConfiguration();
                    xlsxConfig.setOnePagePerSheet(Boolean.valueOf(false));
                    if (!this.isList) {
                        this.jasperPrintList = new ArrayList<JasperPrint>();
                        this.jasperPrintList.add(this.jasperPrint);
                    }
                    exporterXLSX.setExporterInput((ExporterInput)SimpleExporterInput.getInstance(this.jasperPrintList));
                    exporterXLSX.setExporterOutput((ExporterOutput)new SimpleOutputStreamExporterOutput((OutputStream)fos));
                    exporterXLSX.setConfiguration((ReportExportConfiguration)xlsxConfig);
                    exporterXLSX.exportReport();
                }
                return new AMedia(String.valueOf(this.m_title) + "." + "xlsx", "xlsx", EXCEL_XML_MIME_TYPE, file, true);
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
        });
        this.mediaSuppliers.put(this.toMediaType(CSV_MIME_TYPE, "csv"), () -> {
            try {
                String path = System.getProperty("java.io.tmpdir");
                String prefix = null;
                prefix = this.isList ? String.valueOf(this.makePrefix(this.jasperPrintList.get(0).getName())) + "_List" : this.makePrefix(this.jasperPrint.getName());
                if (prefix.length() < 3) {
                    prefix = String.valueOf(prefix) + "_".repeat(3 - prefix.length());
                }
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Path=" + path + " Prefix=" + prefix);
                }
                File file = File.createTempFile(prefix, ".csv", new File(path));
                try (FileOutputStream fos = null;){
                    fos = new FileOutputStream(file);
                    JRCsvExporter exporter = new JRCsvExporter();
                    if (!this.isList) {
                        this.jasperPrintList = new ArrayList<JasperPrint>();
                        this.jasperPrintList.add(this.jasperPrint);
                    }
                    exporter.setExporterInput((ExporterInput)SimpleExporterInput.getInstance(this.jasperPrintList));
                    exporter.setExporterOutput((ExporterOutput)new SimpleWriterExporterOutput((OutputStream)fos));
                    exporter.exportReport();
                }
                return new AMedia(String.valueOf(this.m_title) + "." + "csv", "csv", CSV_MIME_TYPE, file, false);
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
        });
        this.mediaSuppliers.put(this.toMediaType(CSV_MIME_TYPE, "ssv"), () -> {
            try {
                String path = System.getProperty("java.io.tmpdir");
                String prefix = null;
                prefix = this.isList ? String.valueOf(this.makePrefix(this.jasperPrintList.get(0).getName())) + "_List" : this.makePrefix(this.jasperPrint.getName());
                if (prefix.length() < 3) {
                    prefix = String.valueOf(prefix) + "_".repeat(3 - prefix.length());
                }
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Path=" + path + " Prefix=" + prefix);
                }
                File file = File.createTempFile(prefix, ".ssv", new File(path));
                try (FileOutputStream fos = null;){
                    fos = new FileOutputStream(file);
                    JRCsvExporter exporter = new JRCsvExporter();
                    SimpleCsvExporterConfiguration csvConfig = new SimpleCsvExporterConfiguration();
                    csvConfig.setFieldDelimiter(";");
                    if (!this.isList) {
                        this.jasperPrintList = new ArrayList<JasperPrint>();
                        this.jasperPrintList.add(this.jasperPrint);
                    }
                    exporter.setExporterInput((ExporterInput)SimpleExporterInput.getInstance(this.jasperPrintList));
                    exporter.setExporterOutput((ExporterOutput)new SimpleWriterExporterOutput((OutputStream)fos));
                    exporter.setConfiguration((ExporterConfiguration)csvConfig);
                    exporter.exportReport();
                }
                return new AMedia(String.valueOf(this.m_title) + "." + "ssv", "ssv", CSV_MIME_TYPE, file, false);
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
        });
    }

    private String toMediaType(String contentType, String fileExtension) {
        return String.valueOf(contentType) + ";" + fileExtension;
    }

    private String makePrefix(String name) {
        char[] nameArray;
        StringBuilder prefix = new StringBuilder();
        char[] cArray = nameArray = name.toCharArray();
        int n = nameArray.length;
        int n2 = 0;
        while (n2 < n) {
            char ch = cArray[n2];
            if (Character.isLetterOrDigit(ch)) {
                prefix.append(ch);
            } else {
                prefix.append("_");
            }
            ++n2;
        }
        return prefix.toString();
    }

    public void actionPerformed(Event e) {
        if (e.getTarget() == this.previewType) {
            this.cmd_render();
        } else if (e.getTarget() == this.bSendMail) {
            this.cmd_sendMail();
        } else if (e.getTarget() == this.bArchive) {
            this.cmd_archive();
        } else if (e.getTarget() == this.bAttachment) {
            this.cmd_attachment();
        } else if (e.getTarget() == this.bExport) {
            this.cmd_export();
        } else if (e.getTarget() == this.bCloudUpload) {
            this.cmd_upload();
        }
    }

    private void cmd_render() {
        try {
            this.renderReport();
        }
        catch (Exception e) {
            throw new AdempiereException("Failed to render report", (Throwable)e);
        }
    }

    private void cmd_sendMail() {
        if (this.attachment == null) {
            try {
                this.attachment = this.getPDF();
            }
            catch (Exception e) {
                Dialog.error(this.m_WindowNo, e.getLocalizedMessage(), this.m_title);
                return;
            }
        }
        String to = "";
        MUser from = MUser.get((Properties)Env.getCtx(), (int)Env.getAD_User_ID((Properties)Env.getCtx()));
        String subject = this.m_title;
        WEMailDialog dialog = new WEMailDialog(Msg.getMsg((Properties)Env.getCtx(), (String)"SendMail"), from, to, subject, "", (DataSource)new FileDataSource(this.attachment), this.m_WindowNo, this.m_printInfo.getAD_Table_ID(), this.m_printInfo.getRecord_ID(), this.m_printInfo);
        AEnv.showWindow(dialog);
    }

    public void onEvent(Event event) throws Exception {
        if (event.getName().equals("onClick") || event.getName().equals("onSelect")) {
            this.actionPerformed(event);
        } else if (event.getName().equals("onCtrlKey")) {
            KeyEvent keyEvent = (KeyEvent)event;
            if (LayoutUtils.isReallyVisible((Component)this)) {
                long time = System.currentTimeMillis();
                if (this.prevKeyEvent != null && this.prevKeyEventTime > 0L && this.prevKeyEvent.getKeyCode() == keyEvent.getKeyCode() && this.prevKeyEvent.getTarget() == keyEvent.getTarget() && this.prevKeyEvent.isAltKey() == keyEvent.isAltKey() && this.prevKeyEvent.isCtrlKey() == keyEvent.isCtrlKey() && this.prevKeyEvent.isShiftKey() == keyEvent.isShiftKey() && time - this.prevKeyEventTime <= 300L) {
                    return;
                }
                this.onCtrlKeyEvent(keyEvent);
            }
        }
    }

    private void onCtrlKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.isAltKey() && keyEvent.getKeyCode() == 88 && this.m_WindowNo > 0) {
            this.prevKeyEventTime = System.currentTimeMillis();
            this.prevKeyEvent = keyEvent;
            keyEvent.stopPropagation();
            SessionManager.getAppDesktop().closeWindow(this.m_WindowNo);
        }
    }

    private void renderReport() throws Exception {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(JasperReport.class.getClassLoader());
            ListItem selected = this.previewType.getSelectedItem();
            String reportType = (String)selected.getValue();
            if (PDF_OUTPUT_TYPE.equals(reportType)) {
                this.createNewMedia(PDF_MIME_TYPE, "pdf");
            } else if (HTML_OUTPUT_TYPE.equals(reportType)) {
                this.createNewMedia(HTML_MIME_TYPE, "html");
            } else if (XLS_OUTPUT_TYPE.equals(reportType)) {
                this.createNewMedia(EXCEL_MIME_TYPE, "xls");
            } else if (XLSX_OUTPUT_TYPE.equals(reportType)) {
                this.createNewMedia(EXCEL_XML_MIME_TYPE, "xlsx");
            } else if (CSV_OUTPUT_TYPE.equals(reportType)) {
                this.createNewMedia(CSV_MIME_TYPE, "csv");
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
        this.iframe.setSrc(null);
        Events.echoEvent((String)"onRenderReport", (Component)this, null);
    }

    private File getPDF() throws IOException, JRException {
        String path = System.getProperty("java.io.tmpdir");
        String prefix = null;
        prefix = this.isList ? String.valueOf(this.makePrefix(this.jasperPrintList.get(0).getName())) + "_List" : this.makePrefix(this.jasperPrint.getName());
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Path=" + path + " Prefix=" + prefix);
        }
        File file = new File(FileUtil.getTempMailName((String)prefix, (String)".pdf"));
        SimpleJasperReportsContext context = new SimpleJasperReportsContext((JasperReportsContext)DefaultJasperReportsContext.getInstance());
        JRPdfExporter exporter = new JRPdfExporter((JasperReportsContext)context);
        if (!this.isList) {
            this.jasperPrintList = new ArrayList<JasperPrint>();
            this.jasperPrintList.add(this.jasperPrint);
        }
        exporter.setExporterInput((ExporterInput)SimpleExporterInput.getInstance(this.jasperPrintList));
        exporter.setExporterOutput((ExporterOutput)new SimpleOutputStreamExporterOutput(file));
        exporter.exportReport();
        return file;
    }

    public void onRenderReport() {
        ListItem selected = this.previewType.getSelectedItem();
        String reportType = (String)selected.getValue();
        if (ClientInfo.isMobile()) {
            if (PDF_OUTPUT_TYPE.equals(reportType)) {
                this.openWithPdfJsViewer();
            } else if (HTML_OUTPUT_TYPE.equals(reportType)) {
                this.attachIFrame();
                this.iframe.setSrc(null);
                this.iframe.setContent((Media)this.media);
            } else {
                IMediaView view = null;
                boolean showOptions = false;
                if (XLS_OUTPUT_TYPE.equals(reportType) || XLSX_OUTPUT_TYPE.equals(reportType)) {
                    view = XLS_OUTPUT_TYPE.equals(reportType) ? Extensions.getMediaView(EXCEL_MIME_TYPE, "xls", true) : Extensions.getMediaView(EXCEL_XML_MIME_TYPE, "xlsx", true);
                    showOptions = true;
                } else if (CSV_OUTPUT_TYPE.equals(reportType)) {
                    view = Extensions.getMediaView(CSV_MIME_TYPE, "csv", true);
                    showOptions = true;
                }
                if (showOptions && (view != null || this.uploadServicesMap.size() > 0)) {
                    this.clearPreviewContainer();
                    IMediaView fview = view;
                    WMediaOptions options = new WMediaOptions(this.media, fview != null ? () -> {
                        Component component = fview.renderMediaView((Component)this.center, this.media, true);
                    } : null, this.uploadServicesMap);
                    options.setPage(this.getPage());
                    options.doHighlighted();
                } else {
                    this.attachIFrame();
                    this.iframe.setSrc(null);
                    this.iframe.setContent((Media)this.media);
                }
            }
        } else if (MSysConfig.getBooleanValue((String)"ZK_USE_PDF_JS_VIEWER", (boolean)false, (int)Env.getAD_Client_ID((Properties)Env.getCtx())) && PDF_OUTPUT_TYPE.equals(reportType)) {
            this.openWithPdfJsViewer();
        } else {
            IMediaView view = null;
            boolean showOptions = false;
            if (XLS_OUTPUT_TYPE.equals(reportType) || XLSX_OUTPUT_TYPE.equals(reportType)) {
                view = XLS_OUTPUT_TYPE.equals(reportType) ? Extensions.getMediaView(EXCEL_MIME_TYPE, "xls", false) : Extensions.getMediaView(EXCEL_XML_MIME_TYPE, "xlsx", false);
                showOptions = true;
            } else if (CSV_OUTPUT_TYPE.equals(reportType)) {
                view = Extensions.getMediaView(CSV_MIME_TYPE, "csv", false);
                showOptions = true;
            }
            if (showOptions && (view != null || this.uploadServicesMap.size() > 0)) {
                this.clearPreviewContainer();
                IMediaView fview = view;
                WMediaOptions options = new WMediaOptions(this.media, fview != null ? () -> {
                    Component component = fview.renderMediaView((Component)this.center, this.media, true);
                } : null, this.uploadServicesMap);
                options.setPage(this.getPage());
                options.doHighlighted();
            } else {
                this.attachIFrame();
                this.iframe.setSrc(null);
                this.iframe.setContent((Media)this.media);
            }
        }
    }

    protected void openWithPdfJsViewer() {
        this.attachIFrame();
        ++this.mediaVersion;
        String url = Utils.getDynamicMediaURI((AbstractComponent)this, (int)this.mediaVersion, (String)this.media.getName(), (String)this.media.getFormat());
        String pdfJsUrl = "pdf.js/web/viewer.html?file=" + url;
        this.iframe.setContent(null);
        this.iframe.setSrc(pdfJsUrl);
    }

    private void clearPreviewContainer() {
        this.center.getChildren().clear();
    }

    private void attachIFrame() {
        if (this.iframe != null && this.iframe.getPage() == null) {
            this.center.getChildren().clear();
            this.center.appendChild((Component)this.iframe);
        }
    }

    @Override
    public void onClose(Tabpanel tabPanel) {
        Tab tab = tabPanel.getLinkedTab();
        tab.close();
        this.cleanUp();
    }

    public void setParent(Component parent) {
        super.setParent(parent);
        if (parent != null && parent instanceof Tabpanel) {
            Tabpanel tabPanel = (Tabpanel)parent;
            tabPanel.setOnCloseHandler(this);
        }
    }

    private void cleanUp() {
        if (this.jasperPrint != null || this.m_WindowNo >= 0) {
            SessionManager.getAppDesktop().unregisterWindow(this.m_WindowNo);
            this.jasperPrint = null;
            this.m_WindowNo = -1;
        }
    }

    public Object getExtraCtrl() {
        return new ExtraCtrl();
    }

    protected void cmd_archive() {
        boolean success = false;
        try {
            byte[] data = this.getFileByteData(this.getPDF());
            if (data != null && this.m_printInfo != null) {
                MArchive archive = new MArchive(Env.getCtx(), this.m_printInfo, null);
                archive.setBinaryData(data);
                success = archive.save();
            }
            if (success) {
                Dialog.info(this.m_WindowNo, "Archived");
            } else {
                Dialog.error(this.m_WindowNo, "ArchiveError");
            }
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "Exception while reading file " + e);
        }
        catch (JRException e) {
            log.log(Level.SEVERE, "Error loading object from InputStream" + (Object)((Object)e));
        }
    }

    protected void cmd_attachment() {
        int tableId = this.m_printInfo.getAD_Table_ID();
        int recordId = this.m_printInfo.getRecord_ID();
        if (tableId == 0 || recordId == 0) {
            return;
        }
        boolean success = false;
        MTable table2 = MTable.get((int)tableId);
        PO po = table2.getPO(recordId, null);
        MAttachment attachment = po.createAttachment();
        String fileName = String.valueOf(this.m_title.replace(" ", "_")) + "." + this.media.getFormat();
        byte[] data = this.media.isBinary() ? this.media.getByteData() : this.media.getStringData().getBytes();
        attachment.addEntry(fileName, data);
        success = attachment.save();
        if (success) {
            Dialog.info(this.m_WindowNo, "Attached", fileName);
        } else {
            Dialog.error(this.m_WindowNo, "AttachError");
        }
    }

    private byte[] getFileByteData(File tempFile) {
        byte[] fileContent = new byte[(int)tempFile.length()];
        try {
            FileInputStream fis = new FileInputStream(tempFile);
            fis.read(fileContent);
            fis.close();
        }
        catch (FileNotFoundException e) {
            log.log(Level.SEVERE, "File not found  " + e);
        }
        catch (IOException ioe) {
            log.log(Level.SEVERE, "Exception while reading file " + ioe);
        }
        return fileContent;
    }

    private void cmd_export() {
        WReportExportDialog winExportFile = new WReportExportDialog(this);
        winExportFile.setTitle(String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"Export")) + ": " + this.getTitle());
        winExportFile.setAttribute("mode", "highlighted");
        AEnv.showWindow(winExportFile);
    }

    private void cmd_upload() {
        if (this.media == null) {
            return;
        }
        WReportUploadDialog winUploadFile = new WReportUploadDialog(this);
        winUploadFile.setTitle(String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"CloudUpload")) + ": " + this.getTitle());
        winUploadFile.setAttribute("mode", "highlighted");
        AEnv.showWindow(winUploadFile);
    }

    private void createNewMedia(String contentType, String fileExtension) {
        this.media = null;
        this.media = this.getMedia(contentType, fileExtension);
    }

    @Override
    public AMedia getMedia(String contentType, String fileExtension) {
        if (this.media != null && this.media.getContentType().equals(contentType) && this.media.getFormat().equals(fileExtension)) {
            return this.media;
        }
        Supplier<AMedia> supplier = this.mediaSuppliers.get(this.toMediaType(contentType, fileExtension));
        return supplier != null ? supplier.get() : null;
    }

    @Override
    public IReportViewerExportSource.ExportFormat[] getExportFormats() {
        return this.exportFormats;
    }

    @Override
    public String getContentType() {
        return this.media.getContentType();
    }

    @Override
    public String getFileExtension() {
        return this.media.getFormat();
    }

    @Override
    public Map<MAuthorizationAccount, IUploadService> getUploadServiceMap() {
        return this.uploadServicesMap;
    }

    @Override
    public String getReportName() {
        return this.m_title;
    }

    protected class ExtraCtrl
    extends HtmlBasedComponent.ExtraCtrl
    implements DynamicMedia {
        protected ExtraCtrl() {
            super((HtmlBasedComponent)ZkJRViewer.this);
        }

        public Media getMedia(String pathInfo) {
            return ZkJRViewer.this.media;
        }
    }
}

