/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.window;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.base.upload.IUploadHandler;
import org.adempiere.base.upload.IUploadService;
import org.adempiere.base.upload.UploadMedia;
import org.adempiere.base.upload.UploadResponse;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.component.ConfirmPanel;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.ListItem;
import org.adempiere.webui.component.Listbox;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.report.LinkWindow;
import org.adempiere.webui.util.ReaderInputStream;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.Dialog;
import org.adempiere.webui.window.IReportViewerExportSource;
import org.compiere.model.MAuthorizationAccount;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.zkoss.util.media.AMedia;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Div;
import org.zkoss.zul.Vlayout;

public class WReportUploadDialog
extends Window
implements EventListener<Event> {
    private static final long serialVersionUID = 8580712975224551032L;
    private Listbox cboType = new Listbox();
    private Listbox cboActions = new Listbox();
    private ConfirmPanel confirmPanel = new ConfirmPanel(true);
    private IReportViewerExportSource viewer;
    private static final CLogger log = CLogger.getCLogger(WReportUploadDialog.class);

    public WReportUploadDialog(IReportViewerExportSource viewer) {
        this.viewer = viewer;
        ZKUpdateUtil.setWindowWidthX((HtmlBasedComponent)this, 500);
        this.setClosable(true);
        this.setBorder("normal");
        this.setSclass("popup-dialog");
        this.cboType.setMold("select");
        this.cboType.getItems().clear();
        this.cboType.appendItem("ps - " + Msg.getMsg((Properties)Env.getCtx(), (String)"FilePS"), "ps");
        this.cboType.appendItem("xml - " + Msg.getMsg((Properties)Env.getCtx(), (String)"FileXML"), "xml");
        this.cboType.appendItem("pdf - " + Msg.getMsg((Properties)Env.getCtx(), (String)"FilePDF"), "pdf");
        this.cboType.appendItem("html - " + Msg.getMsg((Properties)Env.getCtx(), (String)"FileHTML"), "html");
        this.cboType.appendItem("txt - " + Msg.getMsg((Properties)Env.getCtx(), (String)"FileTXT"), "txt");
        this.cboType.appendItem("csv - " + Msg.getMsg((Properties)Env.getCtx(), (String)"FileCSV"), "csv");
        this.cboType.appendItem("ssv - " + Msg.getMsg((Properties)Env.getCtx(), (String)"FileSSV"), "ssv");
        this.cboType.appendItem("xls - " + Msg.getMsg((Properties)Env.getCtx(), (String)"FileXLS"), "xls");
        this.cboType.appendItem("xlsx - " + Msg.getMsg((Properties)Env.getCtx(), (String)"FileXLSX"), "xlsx");
        String contentType = viewer.getContentType();
        if (IReportViewerExportSource.PDF_MIME_TYPE.equals(contentType)) {
            this.cboType.setSelectedIndex(2);
        } else if (IReportViewerExportSource.HTML_MIME_TYPE.equals(contentType)) {
            this.cboType.setSelectedIndex(3);
        } else if (IReportViewerExportSource.CSV_MIME_TYPE.equals(contentType)) {
            if ("csv".equals(viewer.getFileExtension())) {
                this.cboType.setSelectedIndex(5);
            } else {
                this.cboType.setSelectedIndex(6);
            }
        } else if (IReportViewerExportSource.EXCEL_MIME_TYPE.equals(contentType)) {
            this.cboType.setSelectedIndex(7);
        } else if (IReportViewerExportSource.EXCEL_XML_MIME_TYPE.equals(contentType)) {
            this.cboType.setSelectedIndex(8);
        }
        this.cboType.addActionListener(this);
        Div hb = new Div();
        hb.setSclass("dialog-content");
        hb.setWidth("100%");
        Div div = new Div();
        div.setStyle("text-align: right;display:inline-block;padding-right:5px;");
        div.setWidth("30%");
        div.appendChild((Component)new Label(Msg.getMsg((Properties)Env.getCtx(), (String)"FilesOfType")));
        hb.appendChild((Component)div);
        hb.appendChild((Component)this.cboType);
        this.cboType.setWidth("70%");
        this.cboType.setStyle("border-width:1px !important;");
        Vlayout vb = new Vlayout();
        ZKUpdateUtil.setWidth((HtmlBasedComponent)vb, "100%");
        vb.setVflex("1");
        this.appendChild((Component)vb);
        vb.appendChild((Component)hb);
        this.cboActions.setMold("select");
        hb = new Div();
        hb.setSclass("dialog-content");
        hb.setWidth("100%");
        div = new Div();
        div.setStyle("text-align: right;display:inline-block;padding-right:5px;");
        div.setWidth("30%");
        div.appendChild((Component)new Label(Msg.getMsg((Properties)Env.getCtx(), (String)"UploadAction")));
        hb.appendChild((Component)div);
        hb.appendChild((Component)this.cboActions);
        this.cboActions.setWidth("70%");
        this.cboActions.setStyle("border-width:1px !important;");
        vb.appendChild((Component)hb);
        this.onOutputTypeSelectionChanged();
        vb.appendChild((Component)this.confirmPanel);
        LayoutUtils.addSclass("dialog-footer", (HtmlBasedComponent)this.confirmPanel);
        this.confirmPanel.addActionListener(this);
        this.addEventListener("onCancel", e -> this.onCancel());
        this.setVflex("min");
    }

    public void onEvent(Event event) throws Exception {
        if (event.getTarget().getId().equals("Cancel")) {
            this.onCancel();
        } else if (event.getTarget().getId().equals("Ok")) {
            this.uploadFile();
        } else if (event.getTarget() == this.cboType) {
            this.onOutputTypeSelectionChanged();
        }
    }

    private void onCancel() {
        this.onClose();
    }

    private void onOutputTypeSelectionChanged() {
        ListItem li = this.cboType.getSelectedItem();
        String ext = li.getValue().toString();
        String mime = this.toContentType(ext);
        this.cboActions.getItems().clear();
        Map<MAuthorizationAccount, IUploadService> map = this.viewer.getUploadServiceMap();
        for (MAuthorizationAccount account : map.keySet()) {
            IUploadHandler[] handlers;
            IUploadService service = map.get(account);
            IUploadHandler[] iUploadHandlerArray = handlers = service.getUploadHandlers(mime);
            int n = handlers.length;
            int n2 = 0;
            while (n2 < n) {
                IUploadHandler handler = iUploadHandlerArray[n2];
                this.cboActions.appendItem(handler.getLabel(), new UploadHandler(account, handler));
                ++n2;
            }
        }
    }

    private String toContentType(String ext) {
        if (ext.equals("pdf")) {
            return IReportViewerExportSource.PDF_MIME_TYPE;
        }
        if (ext.equals("ps")) {
            return IReportViewerExportSource.POSTSCRIPT_MIME_TYPE;
        }
        if (ext.equals("xml")) {
            return IReportViewerExportSource.XML_MIME_TYPE;
        }
        if (ext.equals("csv")) {
            return IReportViewerExportSource.CSV_MIME_TYPE;
        }
        if (ext.equals("ssv")) {
            return IReportViewerExportSource.CSV_MIME_TYPE;
        }
        if (ext.equals("txt")) {
            return IReportViewerExportSource.TEXT_MIME_TYPE;
        }
        if (ext.equals("html") || ext.equals("htm")) {
            return IReportViewerExportSource.HTML_MIME_TYPE;
        }
        if (ext.equals("xlsx")) {
            return IReportViewerExportSource.EXCEL_XML_MIME_TYPE;
        }
        if (ext.equals("xls")) {
            return IReportViewerExportSource.EXCEL_MIME_TYPE;
        }
        return null;
    }

    private void uploadFile() {
        try {
            AMedia media = null;
            ListItem li = this.cboType.getSelectedItem();
            String ext = li.getValue().toString();
            if (ext.equals("pdf")) {
                media = this.viewer.getMedia(IReportViewerExportSource.PDF_MIME_TYPE, "pdf");
            } else if (ext.equals("ps")) {
                media = this.viewer.getMedia(IReportViewerExportSource.POSTSCRIPT_MIME_TYPE, "ps");
            } else if (ext.equals("xml")) {
                media = this.viewer.getMedia(IReportViewerExportSource.XML_MIME_TYPE, "xml");
            } else if (ext.equals("csv")) {
                media = this.viewer.getMedia(IReportViewerExportSource.CSV_MIME_TYPE, "csv");
            } else if (ext.equals("ssv")) {
                media = this.viewer.getMedia(IReportViewerExportSource.CSV_MIME_TYPE, "ssv");
            } else if (ext.equals("txt")) {
                media = this.viewer.getMedia(IReportViewerExportSource.TEXT_MIME_TYPE, "txt");
            } else if (ext.equals("html") || ext.equals("htm")) {
                media = this.viewer.getMedia(IReportViewerExportSource.HTML_MIME_TYPE, "html");
            } else if (ext.equals("xlsx")) {
                media = this.viewer.getMedia(IReportViewerExportSource.EXCEL_XML_MIME_TYPE, "xlsx");
            } else if (ext.equals("xls")) {
                media = this.viewer.getMedia(IReportViewerExportSource.EXCEL_MIME_TYPE, "xls");
            } else {
                Dialog.error(-1, "FileInvalidExtension", ext, this.getTitle());
                return;
            }
            Page page = this.getPage();
            this.onClose();
            UploadHandler uh = (UploadHandler)this.cboActions.getSelectedItem().getValue();
            UploadResponse response = uh.handler.uploadMedia(new UploadMedia(media.getName(), media.getContentType(), media.isBinary() ? media.getStreamData() : new ReaderInputStream(media.getReaderData(), StandardCharsets.UTF_8.name()), (long)(media.isBinary() ? media.getByteData().length : 0)), uh.account);
            if (response != null && response.getLink() != null) {
                LinkWindow linkWindow = new LinkWindow(response.getLink(), response.getLinkLabel());
                linkWindow.setPage(page);
                linkWindow.doHighlighted();
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Failed to upload content.", (Throwable)e);
            Dialog.error(-1, "Error", e.getMessage(), this.getTitle());
        }
    }

    public void focus() {
        super.focus();
        if (this.cboType != null) {
            this.cboType.focus();
        }
    }

    private class UploadHandler {
        private MAuthorizationAccount account;
        private IUploadHandler handler;

        private UploadHandler(MAuthorizationAccount account, IUploadHandler handler) {
            this.account = account;
            this.handler = handler;
        }
    }
}

