/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.window;

import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.component.ConfirmPanel;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.ListItem;
import org.adempiere.webui.component.Listbox;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.Dialog;
import org.adempiere.webui.window.IReportViewerExportSource;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.zkoss.util.media.AMedia;
import org.zkoss.util.media.Media;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Div;
import org.zkoss.zul.Filedownload;
import org.zkoss.zul.Hbox;
import org.zkoss.zul.Vbox;

public class WReportExportDialog
extends Window
implements EventListener<Event> {
    private static final long serialVersionUID = 8580712975224551032L;
    private Listbox cboType = new Listbox();
    private ConfirmPanel confirmPanel = new ConfirmPanel(true);
    private IReportViewerExportSource viewer;
    private static final CLogger log = CLogger.getCLogger(WReportExportDialog.class);

    public WReportExportDialog(IReportViewerExportSource viewer) {
        this.viewer = viewer;
        ZKUpdateUtil.setWindowWidthX((HtmlBasedComponent)this, 450);
        ZKUpdateUtil.setWindowHeightX((HtmlBasedComponent)this, 150);
        this.setClosable(true);
        this.setBorder("normal");
        this.setSclass("popup-dialog");
        this.setStyle("position:absolute");
        this.cboType.setMold("select");
        this.cboType.getItems().clear();
        this.cboType.appendItem("ps - " + Msg.getMsg((Properties)Env.getCtx(), (String)"FilePS"), "ps");
        this.cboType.appendItem("xml - " + Msg.getMsg((Properties)Env.getCtx(), (String)"FileXML"), "xml");
        this.cboType.appendItem("pdf - " + Msg.getMsg((Properties)Env.getCtx(), (String)"FilePDF"), "pdf");
        this.cboType.appendItem("html - " + Msg.getMsg((Properties)Env.getCtx(), (String)"FileHTML"), "html");
        this.cboType.appendItem("txt - " + Msg.getMsg((Properties)Env.getCtx(), (String)"FileTXT"), "txt");
        this.cboType.appendItem("ssv - " + Msg.getMsg((Properties)Env.getCtx(), (String)"FileSSV"), "ssv");
        this.cboType.appendItem("csv - " + Msg.getMsg((Properties)Env.getCtx(), (String)"FileCSV"), "csv");
        this.cboType.appendItem("xls - " + Msg.getMsg((Properties)Env.getCtx(), (String)"FileXLS"), "xls");
        this.cboType.appendItem("xlsx - " + Msg.getMsg((Properties)Env.getCtx(), (String)"FileXLSX"), "xlsx");
        String contentType = viewer.getContentType();
        if (IReportViewerExportSource.PDF_MIME_TYPE.equals(contentType)) {
            this.cboType.setSelectedIndex(2);
        } else if (IReportViewerExportSource.HTML_MIME_TYPE.equals(contentType)) {
            this.cboType.setSelectedIndex(3);
        } else if (IReportViewerExportSource.EXCEL_MIME_TYPE.equals(contentType)) {
            this.cboType.setSelectedIndex(7);
        } else if (IReportViewerExportSource.CSV_MIME_TYPE.equals(contentType)) {
            this.cboType.setSelectedIndex(6);
        } else if (IReportViewerExportSource.EXCEL_XML_MIME_TYPE.equals(contentType)) {
            this.cboType.setSelectedIndex(8);
        }
        Hbox hb = new Hbox();
        hb.setSclass("dialog-content");
        hb.setAlign("center");
        hb.setPack("start");
        Div div = new Div();
        div.setStyle("text-align: right;");
        div.appendChild((Component)new Label(Msg.getMsg((Properties)Env.getCtx(), (String)"FilesOfType")));
        hb.appendChild((Component)div);
        hb.appendChild((Component)this.cboType);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.cboType, "100%");
        Vbox vb = new Vbox();
        ZKUpdateUtil.setWidth((HtmlBasedComponent)vb, "100%");
        this.appendChild((Component)vb);
        vb.appendChild((Component)hb);
        vb.appendChild((Component)this.confirmPanel);
        LayoutUtils.addSclass("dialog-footer", (HtmlBasedComponent)this.confirmPanel);
        this.confirmPanel.addActionListener(this);
        this.addEventListener("onCancel", e -> this.onCancel());
    }

    public void onEvent(Event event) throws Exception {
        if (event.getTarget().getId().equals("Cancel")) {
            this.onCancel();
        } else if (event.getTarget().getId().equals("Ok")) {
            this.exportFile();
        }
    }

    private void onCancel() {
        this.onClose();
    }

    private void exportFile() {
        try {
            AMedia media = null;
            ListItem li = this.cboType.getSelectedItem();
            if (li == null || li.getValue() == null) {
                Dialog.error(-1, "FileInvalidExtension");
                return;
            }
            String ext = li.getValue().toString();
            if (ext.equals("pdf")) {
                media = this.viewer.getMedia(IReportViewerExportSource.PDF_MIME_TYPE, "pdf");
            } else if (ext.equals("ps")) {
                media = this.viewer.getMedia(IReportViewerExportSource.POSTSCRIPT_MIME_TYPE, "ps");
            } else if (ext.equals("xml")) {
                media = this.viewer.getMedia(IReportViewerExportSource.XML_MIME_TYPE, "xml");
            } else if (ext.equals("csv")) {
                media = this.viewer.getMedia(IReportViewerExportSource.CSV_MIME_TYPE, "csv");
            } else if (ext.equals("ssv")) {
                media = this.viewer.getMedia(IReportViewerExportSource.CSV_MIME_TYPE, "ssv");
            } else if (ext.equals("txt")) {
                media = this.viewer.getMedia(IReportViewerExportSource.TEXT_MIME_TYPE, "txt");
            } else if (ext.equals("html") || ext.equals("htm")) {
                media = this.viewer.getMedia(IReportViewerExportSource.HTML_MIME_TYPE, "html");
            } else if (ext.equals("xlsx")) {
                media = this.viewer.getMedia(IReportViewerExportSource.EXCEL_XML_MIME_TYPE, "xlsx");
            } else if (ext.equals("xls")) {
                media = this.viewer.getMedia(IReportViewerExportSource.EXCEL_MIME_TYPE, "xls");
            } else {
                Dialog.error(-1, "FileInvalidExtension");
                return;
            }
            this.onClose();
            Filedownload.save((Media)media, (String)(String.valueOf(this.viewer.getReportName()) + "." + ext));
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Failed to export content.", (Throwable)e);
        }
    }
}

