/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.window;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.component.ConfirmPanel;
import org.adempiere.webui.component.Listbox;
import org.adempiere.webui.component.SimpleListModel;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.RecordTimeLinePanel;
import org.compiere.model.DataStatusEvent;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.GridTable;
import org.compiere.model.MChangeLog;
import org.compiere.model.MColumn;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MRole;
import org.compiere.model.MTable;
import org.compiere.model.MUser;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.compiere.util.NamePair;
import org.compiere.util.Util;
import org.zkoss.zhtml.Pre;
import org.zkoss.zhtml.Text;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.util.Callback;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zk.ui.util.Notification;
import org.zkoss.zul.Borderlayout;
import org.zkoss.zul.Center;
import org.zkoss.zul.Div;
import org.zkoss.zul.Hbox;
import org.zkoss.zul.Hlayout;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.Listhead;
import org.zkoss.zul.Listheader;
import org.zkoss.zul.North;
import org.zkoss.zul.Radio;
import org.zkoss.zul.Radiogroup;
import org.zkoss.zul.South;
import org.zkoss.zul.Toolbarbutton;

public class WRecordInfo
extends Window
implements EventListener<Event> {
    private static final long serialVersionUID = -7436682051825360216L;
    private Listbox table = new Listbox();
    private RecordTimeLinePanel timeLinePanel = new RecordTimeLinePanel();
    private ConfirmPanel confirmPanel = new ConfirmPanel(false);
    private static final CLogger log = CLogger.getCLogger(WRecordInfo.class);
    private Vector<Vector<String>> m_data = new Vector();
    private StringBuffer m_info = new StringBuffer();
    private Toolbarbutton m_permalink = new Toolbarbutton();
    private Toolbarbutton m_copySelect = new Toolbarbutton();
    private SimpleDateFormat m_dateTimeFormat = DisplayType.getDateFormat((int)16, (Language)Env.getLanguage((Properties)Env.getCtx()));
    private SimpleDateFormat m_dateFormat = DisplayType.getDateFormat((int)16, (Language)Env.getLanguage((Properties)Env.getCtx()));
    private DecimalFormat m_numberFormat = DisplayType.getNumberFormat((int)22, (Language)Env.getLanguage((Properties)Env.getCtx()));
    private DecimalFormat m_amtFormat = DisplayType.getNumberFormat((int)12, (Language)Env.getLanguage((Properties)Env.getCtx()));
    private DecimalFormat m_intFormat = DisplayType.getNumberFormat((int)11, (Language)Env.getLanguage((Properties)Env.getCtx()));

    public WRecordInfo(String title, DataStatusEvent dse, GridTab gridTab) {
        this.setTitle(title);
        if (!ThemeManager.isUseCSSForWindowSize()) {
            ZKUpdateUtil.setWindowWidthX((HtmlBasedComponent)this, 800);
            ZKUpdateUtil.setWindowHeightX((HtmlBasedComponent)this, 600);
        } else {
            this.addCallback("afterPageAttached", (Callback & Serializable)t -> {
                ZKUpdateUtil.setCSSHeight((HtmlBasedComponent)this);
                ZKUpdateUtil.setCSSWidth((HtmlBasedComponent)this);
            });
        }
        this.setBorder("normal");
        this.setSizable(true);
        this.setClosable(true);
        this.setMaximizable(true);
        this.setWidgetAttribute("instanceName", "recordInfo");
        this.setSclass("popup-dialog record-info-dialog");
        try {
            this.init(this.dynInit(gridTab, dse, title));
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", (Throwable)e);
        }
        this.setAttribute("mode", "highlighted");
        AEnv.showCenterScreen(this);
    }

    private void init(boolean showTable) throws Exception {
        Div div = new Div();
        div.setStyle("width: 100%; height: 100%");
        Pre pre = new Pre();
        Text text = new Text(this.m_info.toString());
        text.setParent((Component)pre);
        pre.setParent((Component)div);
        Borderlayout layout = new Borderlayout();
        layout.setParent((Component)this);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)layout, "100%");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)layout, "100%");
        Center center = new Center();
        center.setParent((Component)layout);
        if (showTable) {
            this.table.setSclass("record-info-changelog-table");
            ZKUpdateUtil.setHflex((HtmlBasedComponent)this.table, "true");
            ZKUpdateUtil.setVflex((HtmlBasedComponent)this.table, "true");
            North north = new North();
            north.setParent((Component)layout);
            north.appendChild((Component)div);
            center.appendChild((Component)this.table);
            Radiogroup group = new Radiogroup();
            div.appendChild((Component)group);
            Hlayout hlayout = new Hlayout();
            hlayout.setSclass("record-info-radiogroup");
            Radio radio = new Radio(Msg.getElement((Properties)Env.getCtx(), (String)"AD_ChangeLog_ID"));
            radio.setRadiogroup(group);
            hlayout.appendChild((Component)radio);
            radio = new Radio(Msg.getMsg((Properties)Env.getCtx(), (String)"TimeLine"));
            radio.setRadiogroup(group);
            hlayout.appendChild((Component)radio);
            div.appendChild((Component)hlayout);
            group.setSelectedIndex(0);
            group.addEventListener("onCheck", evt -> {
                int index = group.getSelectedIndex();
                if (index == 0) {
                    if (this.table.getParent() == null && this.timeLinePanel.getParent() != null) {
                        this.timeLinePanel.detach();
                        center.appendChild((Component)this.table);
                    }
                } else if (index == 1 && this.table.getParent() != null && this.timeLinePanel.getParent() == null) {
                    this.table.detach();
                    center.appendChild((Component)this.timeLinePanel);
                }
            });
            if (ClientInfo.isMobile()) {
                group.setSelectedIndex(1);
                Events.sendEvent((String)"onCheck", (Component)group, null);
            }
        } else {
            ZKUpdateUtil.setHflex((HtmlBasedComponent)div, "true");
            ZKUpdateUtil.setVflex((HtmlBasedComponent)div, "true");
            center.appendChild((Component)div);
        }
        South south = new South();
        south.setSclass("dialog-footer");
        south.setParent((Component)layout);
        this.m_permalink.setLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"Permalink"));
        this.m_permalink.setTooltiptext(Msg.getMsg((Properties)Env.getCtx(), (String)"Permalink_tooltip"));
        this.m_copySelect.setLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"CopySelect"));
        this.m_copySelect.setTooltiptext(Msg.getMsg((Properties)Env.getCtx(), (String)"CopySelect_tooltip"));
        Hbox hbox = new Hbox();
        hbox.setWidth("100%");
        south.appendChild((Component)hbox);
        hbox.appendChild((Component)this.m_permalink);
        hbox.appendChild((Component)this.m_copySelect);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.confirmPanel, "true");
        hbox.appendChild((Component)this.confirmPanel);
        this.confirmPanel.addActionListener("onClick", this);
        this.addEventListener("onCancel", e -> this.onCancel());
    }

    private boolean dynInit(GridTab gridTab, DataStatusEvent dse, String title) {
        block29: {
            PO po;
            GridField firstField;
            if (dse.CreatedBy == null) {
                return false;
            }
            MUser user = MUser.get((Properties)Env.getCtx(), (int)dse.CreatedBy);
            this.m_info.append(" ").append(Msg.translate((Properties)Env.getCtx(), (String)"CreatedBy")).append(": ").append(user.getName()).append(" - ").append(this.m_dateTimeFormat.format(dse.Created)).append("\n");
            if (!dse.Created.equals(dse.Updated) || !dse.CreatedBy.equals(dse.UpdatedBy)) {
                if (!dse.CreatedBy.equals(dse.UpdatedBy)) {
                    user = MUser.get((Properties)Env.getCtx(), (int)dse.UpdatedBy);
                }
                this.m_info.append(" ").append(Msg.translate((Properties)Env.getCtx(), (String)"UpdatedBy")).append(": ").append(user.getName()).append(" - ").append(this.m_dateTimeFormat.format(dse.Updated)).append("\n");
            }
            if (dse.Info != null && dse.Info.length() > 0) {
                this.m_info.append("\n ").append(dse.Info).append("");
            }
            GridTable gridTable = null;
            String tabName = null;
            if (gridTab != null) {
                gridTable = gridTab.getTableModel();
            } else if (dse.getSource() instanceof GridTab) {
                gridTab = (GridTab)dse.getSource();
                gridTable = gridTab.getTableModel();
                tabName = gridTab.getName();
            } else if (dse.getSource() instanceof GridTable && (firstField = (gridTable = (GridTable)dse.getSource()).getField(0)) != null && firstField.getGridTab() != null) {
                tabName = firstField.getGridTab().getName();
            }
            int Record_ID = -1;
            if (dse.Record_ID instanceof Integer) {
                Record_ID = (Integer)dse.Record_ID;
            } else {
                log.info("dynInit - Invalid Record_ID=" + dse.Record_ID);
            }
            MTable dbtable = null;
            if (dse.AD_Table_ID != 0) {
                dbtable = MTable.get((Properties)Env.getCtx(), (int)dse.AD_Table_ID);
            }
            if (gridTable != null && dse.getCurrentRow() >= 0 && dse.getCurrentRow() < gridTable.getRowCount() && (po = gridTable.getPO(dse.getCurrentRow())) != null) {
                String uuidcol = po.getUUIDColumnName();
                String uuid = null;
                if (po.is_new()) {
                    if (Record_ID == 0 && MTable.isZeroIDTable((String)dbtable.getTableName())) {
                        StringBuilder sql = new StringBuilder("SELECT ").append(uuidcol).append(" FROM ").append(dbtable.getTableName()).append(" WHERE ").append(dbtable.getTableName()).append("_ID=0");
                        uuid = DB.getSQLValueString(null, (String)sql.toString(), (Object[])new Object[0]);
                    }
                } else {
                    uuid = po.get_ValueAsString(uuidcol);
                }
                if (!Util.isEmpty(uuid)) {
                    this.m_info.append("\n ").append(uuidcol).append("=").append(uuid);
                }
                if (po.get_KeyColumns().length == 1) {
                    this.m_permalink.addEventListener("onClick", (EventListener)new EventListener<Event>(){

                        public void onEvent(Event event) throws Exception {
                            String ticketURL = AEnv.getZoomUrlTableID(po);
                            StringBuffer sb = new StringBuffer("navigator.clipboard.writeText(\"").append(ticketURL).append("\");");
                            Clients.evalJavaScript((String)sb.toString());
                            Notification.show((String)Msg.getMsg((Properties)Env.getCtx(), (String)"Copied"), (String)"info", (Component)WRecordInfo.this.m_permalink, (String)"end_before", (int)1000);
                        }
                    });
                }
                this.m_permalink.setVisible(po.get_KeyColumns().length == 1);
                this.m_copySelect.addEventListener("onClick", (EventListener)new EventListener<Event>(){

                    public void onEvent(Event event) throws Exception {
                        StringBuffer query = new StringBuffer("navigator.clipboard.writeText(\"SELECT * FROM ").append(po.get_TableName()).append(" WHERE ").append(po.get_WhereClause(true));
                        query.append("\");");
                        Clients.evalJavaScript((String)query.toString());
                        Notification.show((String)Msg.getMsg((Properties)Env.getCtx(), (String)"Copied"), (String)"info", (Component)WRecordInfo.this.m_copySelect, (String)"end_before", (int)1000);
                    }
                });
                this.m_copySelect.setVisible(true);
            }
            if (gridTab != null) {
                this.timeLinePanel.render(gridTab);
            }
            if (tabName == null && dse.AD_Table_ID != 0) {
                tabName = dbtable.getName();
            }
            this.setTitle(String.valueOf(title) + " - " + tabName);
            if (!"C".equals(MRole.getDefault().getPreferenceType())) {
                return false;
            }
            if (Record_ID <= 0) {
                return false;
            }
            String sql = "SELECT AD_Column_ID, Updated, UpdatedBy, OldValue, NewValue FROM AD_ChangeLog WHERE AD_Table_ID=? AND Record_ID=? ORDER BY Updated DESC";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    pstmt.setInt(1, dse.AD_Table_ID);
                    pstmt.setInt(2, Record_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        this.addLine(rs.getInt(1), rs.getTimestamp(2), rs.getInt(3), rs.getString(4), rs.getString(5));
                    }
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block29;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        ArrayList<String> columnNames = new ArrayList<String>();
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"Name"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"NewValue"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"OldValue"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"UpdatedBy"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"Updated"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"AD_Column_ID"));
        Listhead listhead = new Listhead();
        listhead.setSizable(true);
        int i = 0;
        while (i < columnNames.size()) {
            Listheader listheader = new Listheader(((String)columnNames.get(i)).replaceAll("[&]", ""));
            listhead.appendChild((Component)listheader);
            ++i;
        }
        this.table.appendChild((Component)listhead);
        SimpleListModel model = new SimpleListModel(this.m_data);
        this.table.setItemRenderer(model);
        this.table.setModel((ListModel)model);
        return true;
    }

    private void addLine(int AD_Column_ID, Timestamp Updated, int UpdatedBy, String OldValue, String NewValue) {
        Vector<String> line = new Vector<String>();
        MColumn column = MColumn.get((Properties)Env.getCtx(), (int)AD_Column_ID);
        line.add(Msg.translate((Properties)Env.getCtx(), (String)column.getColumnName()));
        if (OldValue != null && OldValue.equals(MChangeLog.NULL)) {
            OldValue = null;
        }
        String showOldValue = OldValue;
        if (NewValue != null && NewValue.equals(MChangeLog.NULL)) {
            NewValue = null;
        }
        String showNewValue = NewValue;
        try {
            if (!DisplayType.isText((int)column.getAD_Reference_ID())) {
                if (column.getAD_Reference_ID() == 20) {
                    boolean yes;
                    if (OldValue != null) {
                        yes = OldValue.equals("true") || OldValue.equals("Y");
                        showOldValue = Msg.getMsg((Properties)Env.getCtx(), (String)(yes ? "Y" : "N"));
                    }
                    if (NewValue != null) {
                        yes = NewValue.equals("true") || NewValue.equals("Y");
                        showNewValue = Msg.getMsg((Properties)Env.getCtx(), (String)(yes ? "Y" : "N"));
                    }
                } else if (column.getAD_Reference_ID() == 12) {
                    if (OldValue != null) {
                        showOldValue = this.m_amtFormat.format(new BigDecimal(OldValue));
                    }
                    if (NewValue != null) {
                        showNewValue = this.m_amtFormat.format(new BigDecimal(NewValue));
                    }
                } else if (column.getAD_Reference_ID() == 11) {
                    if (OldValue != null) {
                        showOldValue = this.m_intFormat.format(Integer.valueOf(OldValue));
                    }
                    if (NewValue != null) {
                        showNewValue = this.m_intFormat.format(Integer.valueOf(NewValue));
                    }
                } else if (DisplayType.isNumeric((int)column.getAD_Reference_ID())) {
                    if (OldValue != null) {
                        showOldValue = this.m_numberFormat.format(new BigDecimal(OldValue));
                    }
                    if (NewValue != null) {
                        showNewValue = this.m_numberFormat.format(new BigDecimal(NewValue));
                    }
                } else if (column.getAD_Reference_ID() == 15) {
                    if (OldValue != null) {
                        showOldValue = this.m_dateFormat.format(Timestamp.valueOf(OldValue));
                    }
                    if (NewValue != null) {
                        showNewValue = this.m_dateFormat.format(Timestamp.valueOf(NewValue));
                    }
                } else if (column.getAD_Reference_ID() == 16) {
                    if (OldValue != null) {
                        showOldValue = this.m_dateTimeFormat.format(Timestamp.valueOf(OldValue));
                    }
                    if (NewValue != null) {
                        showNewValue = this.m_dateTimeFormat.format(Timestamp.valueOf(NewValue));
                    }
                } else if (DisplayType.isLookup((int)column.getAD_Reference_ID())) {
                    String key;
                    NamePair pp;
                    MLookup lookup = MLookupFactory.get((Properties)Env.getCtx(), (int)0, (int)AD_Column_ID, (int)column.getAD_Reference_ID(), (Language)Env.getLanguage((Properties)Env.getCtx()), (String)column.getColumnName(), (int)column.getAD_Reference_Value_ID(), (boolean)column.isParent(), null);
                    if (OldValue != null && (pp = lookup.get((Object)(key = OldValue))) != null) {
                        showOldValue = pp.getName();
                    }
                    if (NewValue != null && (pp = lookup.get((Object)(key = NewValue))) != null) {
                        showNewValue = pp.getName();
                    }
                } else if (DisplayType.isLOB((int)column.getAD_Reference_ID())) {
                    // empty if block
                }
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, String.valueOf(OldValue) + "->" + NewValue, (Throwable)e);
        }
        line.add(showNewValue);
        line.add(showOldValue);
        MUser user = MUser.get((Properties)Env.getCtx(), (int)UpdatedBy);
        line.add(user.getName());
        line.add(this.m_dateFormat.format(Updated));
        line.add(column.getColumnName());
        this.m_data.add(line);
    }

    public void onEvent(Event event) throws Exception {
        this.onCancel();
    }

    private void onCancel() {
        this.detach();
    }
}

