/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.window;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.component.Checkbox;
import org.adempiere.webui.component.Column;
import org.adempiere.webui.component.Columns;
import org.adempiere.webui.component.ConfirmPanel;
import org.adempiere.webui.component.Grid;
import org.adempiere.webui.component.GridFactory;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.ListItem;
import org.adempiere.webui.component.Listbox;
import org.adempiere.webui.component.Row;
import org.adempiere.webui.component.Rows;
import org.adempiere.webui.component.Textbox;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.editor.WTableDirEditor;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.Dialog;
import org.compiere.model.Lookup;
import org.compiere.model.MLocator;
import org.compiere.model.MLocatorLookup;
import org.compiere.model.MLocatorType;
import org.compiere.model.MRole;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.util.Callback;
import org.zkoss.zul.Borderlayout;
import org.zkoss.zul.Center;
import org.zkoss.zul.South;
import org.zkoss.zul.Space;

public class WLocatorDialog
extends Window
implements EventListener<Event> {
    private static final long serialVersionUID = -2441739966645819543L;
    private Grid mainPanel = GridFactory.newGridLayout();
    private WTableDirEditor locatorField = null;
    private Listbox lstWarehouse = new Listbox();
    private Listbox lstLocatorType = new Listbox();
    private Checkbox chkCreateNew = new Checkbox();
    private Textbox txtWarehouse = new Textbox();
    private Textbox txtLocatorType = new Textbox();
    private Textbox txtAisleX = new Textbox();
    private Textbox txtBinY = new Textbox();
    private Textbox txtLevelZ = new Textbox();
    private Textbox txtKey = new Textbox();
    private Label lblLocator = new Label();
    private Label lblWarehouse = new Label();
    private Label lblWarehouse2 = new Label();
    private Label lblLocatorType = new Label();
    private Label lblLocatorType2 = new Label();
    private Label lblAisleX = new Label();
    private Label lblBinY = new Label();
    private Label lblLevelZ = new Label();
    private Label lblKey = new Label();
    private ConfirmPanel confirmPanel;
    private MLocatorLookup m_mLocator;
    private int m_WindowNo;
    private int m_M_Locator_ID;
    private int m_AD_Client_ID;
    private int m_AD_Org_ID;
    private int m_only_Warehouse_ID;
    private int m_M_Warehouse_ID;
    private boolean m_mandatory;
    private String m_M_WarehouseName;
    private String m_M_WarehouseValue;
    private String m_Separator;
    private boolean m_change;
    private String title;
    private static final CLogger log = CLogger.getCLogger(WLocatorDialog.class);

    public WLocatorDialog(String title, MLocatorLookup mLocator, int M_Locator_ID, boolean mandatory, int only_Warehouse_ID, int windowNo) {
        this.m_WindowNo = windowNo;
        this.title = title;
        this.m_mLocator = mLocator;
        this.initComponents();
        this.m_M_Locator_ID = M_Locator_ID;
        this.m_mandatory = mandatory;
        this.m_only_Warehouse_ID = only_Warehouse_ID;
        this.initLocator();
    }

    private void initComponents() {
        this.lblLocator.setValue(Msg.translate((Properties)Env.getCtx(), (String)"M_Locator_ID"));
        this.lblWarehouse.setValue(Msg.translate((Properties)Env.getCtx(), (String)"M_Warehouse_ID"));
        this.lblWarehouse2.setValue(Msg.translate((Properties)Env.getCtx(), (String)"M_Warehouse_ID"));
        this.lblLocatorType.setValue(Msg.getElement((Properties)Env.getCtx(), (String)"M_LocatorType_ID"));
        this.lblLocatorType2.setValue(Msg.getElement((Properties)Env.getCtx(), (String)"M_LocatorType_ID"));
        this.lblAisleX.setValue(Msg.getElement((Properties)Env.getCtx(), (String)"X"));
        this.lblBinY.setValue(Msg.getElement((Properties)Env.getCtx(), (String)"Y"));
        this.lblLevelZ.setValue(Msg.getElement((Properties)Env.getCtx(), (String)"Z"));
        this.lblKey.setValue(Msg.translate((Properties)Env.getCtx(), (String)"Value"));
        this.locatorField = new WTableDirEditor((Lookup)this.m_mLocator, Msg.translate((Properties)Env.getCtx(), (String)"M_Locator_ID"), "", true, false, true, true);
        LayoutUtils.addSclass("z-label", (HtmlBasedComponent)this.locatorField.getComponent());
        this.chkCreateNew.setLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"CreateNew"));
        this.lstWarehouse.setMold("select");
        this.lstWarehouse.setRows(0);
        LayoutUtils.addSclass("z-label", (HtmlBasedComponent)this.lstWarehouse);
        this.lstLocatorType.setMold("select");
        this.lstLocatorType.setRows(0);
        LayoutUtils.addSclass("z-label", (HtmlBasedComponent)this.lstLocatorType);
        this.confirmPanel = new ConfirmPanel(true);
        this.confirmPanel.addActionListener(this);
        Columns columns = new Columns();
        this.mainPanel.appendChild((Component)columns);
        Column column = new Column();
        columns.appendChild((Component)column);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)column, "30%");
        column = new Column();
        columns.appendChild((Component)column);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)column, "70%");
        Rows rows = this.mainPanel.newRows();
        Row row = new Row();
        rows.appendChild((Component)row);
        row.appendChild((Component)this.lblLocator);
        row.appendChild((Component)this.locatorField.getComponent());
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.locatorField.getComponent(), "1");
        row = new Row();
        rows.appendChild((Component)row);
        row.appendChild((Component)new Space());
        row.appendChild((Component)this.chkCreateNew);
        row = new Row();
        rows.appendChild((Component)row);
        row.appendChild((Component)this.lblWarehouse);
        row.appendChild((Component)this.lstWarehouse);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.lstWarehouse, "1");
        row = new Row();
        rows.appendChild((Component)row);
        row.appendChild((Component)this.lblWarehouse2);
        row.appendChild((Component)this.txtWarehouse);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.txtWarehouse, "1");
        row = new Row();
        rows.appendChild((Component)row);
        row.appendChild((Component)this.lblLocatorType);
        row.appendChild((Component)this.lstLocatorType);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.lstLocatorType, "1");
        row = new Row();
        rows.appendChild((Component)row);
        row.appendChild((Component)this.lblLocatorType2);
        row.appendChild((Component)this.txtLocatorType);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.txtLocatorType, "1");
        row = new Row();
        rows.appendChild((Component)row);
        row.appendChild((Component)this.lblAisleX);
        row.appendChild((Component)this.txtAisleX);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.txtAisleX, "1");
        row = new Row();
        rows.appendChild((Component)row);
        row.appendChild((Component)this.lblBinY);
        row.appendChild((Component)this.txtBinY);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.txtBinY, "1");
        row = new Row();
        rows.appendChild((Component)row);
        row.appendChild((Component)this.lblLevelZ);
        row.appendChild((Component)this.txtLevelZ);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.txtLevelZ, "1");
        row = new Row();
        rows.appendChild((Component)row);
        row.appendChild((Component)this.lblKey);
        row.appendChild((Component)this.txtKey);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.txtKey, "1");
        Borderlayout borderlayout = new Borderlayout();
        this.appendChild((Component)borderlayout);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)borderlayout, "1");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)borderlayout, "1");
        Center centerPane = new Center();
        centerPane.setSclass("dialog-content");
        centerPane.setAutoscroll(true);
        borderlayout.appendChild((Component)centerPane);
        centerPane.appendChild((Component)this.mainPanel);
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.mainPanel, "1");
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.mainPanel, "1");
        South southPane = new South();
        southPane.setSclass("dialog-footer");
        borderlayout.appendChild((Component)southPane);
        southPane.appendChild((Component)this.confirmPanel);
        this.setTitle(this.title);
        this.setSclass("popup-dialog locator-dialog");
        this.setClosable(true);
        this.setBorder("normal");
        if (!ThemeManager.isUseCSSForWindowSize()) {
            ZKUpdateUtil.setWindowWidthX((HtmlBasedComponent)this, 260);
            ZKUpdateUtil.setWindowHeightX((HtmlBasedComponent)this, 350);
        } else {
            this.addCallback("afterPageAttached", (Callback & Serializable)t -> {
                ZKUpdateUtil.setCSSHeight((HtmlBasedComponent)this);
                ZKUpdateUtil.setCSSWidth((HtmlBasedComponent)this);
            });
        }
        this.setShadow(true);
        this.setAttribute("mode", "highlighted");
        this.setSizable(true);
        if (ClientInfo.isMobile()) {
            ClientInfo.onClientInfo((Component)this, () -> {
                ZKUpdateUtil.setCSSHeight((HtmlBasedComponent)this);
                ZKUpdateUtil.setCSSWidth((HtmlBasedComponent)this);
            });
        }
        this.addEventListener("onCancel", e -> this.onCancel());
    }

    private void initLocator() {
        MLocator locator;
        block21: {
            ResultSet rs;
            CPreparedStatement pstmt;
            String SQL;
            String sql;
            block19: {
                log.fine("");
                sql = "SELECT M_Warehouse_ID, Name FROM M_Warehouse";
                if (this.m_only_Warehouse_ID != 0) {
                    sql = String.valueOf(sql) + " WHERE M_Warehouse_ID=" + this.m_only_Warehouse_ID;
                }
                SQL = String.valueOf(MRole.getDefault().addAccessSQL(sql, "M_Warehouse", false, false)) + " ORDER BY 2";
                pstmt = null;
                rs = null;
                try {
                    try {
                        pstmt = DB.prepareStatement((String)SQL, null);
                        rs = pstmt.executeQuery();
                        while (rs.next()) {
                            KeyNamePair key = new KeyNamePair(rs.getInt(1), rs.getString(2));
                            this.lstWarehouse.appendItem(key.getName(), key);
                        }
                    }
                    catch (SQLException e) {
                        log.log(Level.SEVERE, SQL, (Throwable)e);
                        DB.close((ResultSet)rs, (Statement)pstmt);
                        rs = null;
                        pstmt = null;
                        break block19;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("Warehouses=" + this.lstWarehouse.getItemCount());
            }
            sql = "SELECT M_LocatorType_ID, Name FROM M_LocatorType WHERE IsActive='Y'";
            SQL = String.valueOf(MRole.getDefault().addAccessSQL(sql, "M_LocatorType", false, false)) + " ORDER BY 2";
            pstmt = null;
            rs = null;
            KeyNamePair keyEmpty = new KeyNamePair(0, "");
            this.lstLocatorType.appendItem(keyEmpty.getName(), keyEmpty);
            try {
                try {
                    pstmt = DB.prepareStatement((String)SQL, null);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        KeyNamePair key = new KeyNamePair(rs.getInt(1), rs.getString(2));
                        this.lstLocatorType.appendItem(key.getName(), key);
                    }
                }
                catch (SQLException e) {
                    log.log(Level.SEVERE, SQL, (Throwable)e);
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block21;
                }
            }
            catch (Throwable throwable) {
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("LocatorTypes=" + this.lstLocatorType.getItemCount());
        }
        this.m_mLocator.refreshIfNeeded();
        this.m_mLocator.fillComboBox(this.m_mandatory, true, true, false, false);
        if (log.isLoggable(Level.FINE)) {
            log.fine(this.m_mLocator.toString());
        }
        if (this.m_mLocator.getSize() == 0) {
            throw new AdempiereUserError(Msg.getMsg((Properties)Env.getCtx(), (String)"DRP-001", (boolean)false));
        }
        if (this.m_mLocator.getSize() == 1 && ((locator = (MLocator)this.m_mLocator.getElementAt(0)) == null || locator.getM_Locator_ID() <= 0)) {
            throw new AdempiereUserError(Msg.getMsg((Properties)Env.getCtx(), (String)"DRP-001", (boolean)false));
        }
        if (this.m_M_Locator_ID > 0) {
            this.locatorField.setValue(this.m_M_Locator_ID);
        }
        this.locatorField.getComponent().addEventListener("onSelect", this);
        this.displayLocator();
        this.chkCreateNew.setChecked(false);
        this.chkCreateNew.addEventListener("onCheck", this);
        if (!MRole.getDefault().isTableAccess(207, false)) {
            this.chkCreateNew.setVisible(false);
        }
        this.enableNew();
        this.lstWarehouse.addEventListener("onSelect", this);
        this.txtAisleX.addEventListener("onChange", this);
        this.txtBinY.addEventListener("onChange", this);
        this.txtLevelZ.addEventListener("onChange", this);
    }

    private void displayLocator() {
        KeyNamePair pp;
        ListItem listItem;
        MLocator l = null;
        Integer M_Locator_ID = (Integer)this.locatorField.getValue();
        if (M_Locator_ID != null) {
            l = MLocator.get((Properties)Env.getCtx(), (int)M_Locator_ID);
        }
        if (l == null) {
            return;
        }
        this.m_M_Locator_ID = l.getM_Locator_ID();
        this.txtWarehouse.setText(l.getWarehouseName());
        if (l.getM_LocatorType_ID() > 0) {
            MLocatorType lt = MLocatorType.get((Properties)Env.getCtx(), (int)l.getM_LocatorType_ID());
            this.txtLocatorType.setText(lt.getName());
        } else {
            this.txtLocatorType.setText("");
        }
        this.txtAisleX.setText(l.getX());
        this.txtBinY.setText(l.getY());
        this.txtLevelZ.setText(l.getZ());
        this.txtKey.setText(l.getValue());
        this.getWarehouseInfo(l.getM_Warehouse_ID());
        int size = this.lstWarehouse.getItemCount();
        int i = 0;
        while (i < size) {
            listItem = this.lstWarehouse.getItemAtIndex(i);
            pp = (KeyNamePair)listItem.getValue();
            if (pp.getKey() == l.getM_Warehouse_ID()) {
                this.lstWarehouse.setSelectedIndex(i);
            }
            ++i;
        }
        size = this.lstLocatorType.getItemCount();
        i = 0;
        while (i < size) {
            listItem = this.lstLocatorType.getItemAtIndex(i);
            pp = (KeyNamePair)listItem.getValue();
            if (pp.getKey() == l.getM_LocatorType_ID()) {
                this.lstLocatorType.setSelectedIndex(i);
            }
            ++i;
        }
    }

    private void enableNew() {
        boolean sel = this.chkCreateNew.isChecked();
        this.lstWarehouse.setVisible(sel);
        this.lstWarehouse.getParent().setVisible(sel);
        this.txtWarehouse.setVisible(!sel);
        this.txtWarehouse.getParent().setVisible(!sel);
        this.txtWarehouse.setReadonly(true);
        this.lstLocatorType.setVisible(sel);
        this.lstLocatorType.getParent().setVisible(sel);
        this.txtLocatorType.setVisible(!sel);
        this.txtLocatorType.getParent().setVisible(!sel);
        this.txtLocatorType.setReadonly(true);
        this.txtAisleX.setReadonly(!sel);
        this.txtBinY.setReadonly(!sel);
        this.txtLevelZ.setReadonly(!sel);
        this.txtKey.setReadonly(!sel);
        this.mainPanel.invalidate();
    }

    private void getWarehouseInfo(int M_Warehouse_ID) {
        block7: {
            if (M_Warehouse_ID == this.m_M_Warehouse_ID) {
                return;
            }
            this.m_M_Warehouse_ID = 0;
            this.m_M_WarehouseName = "";
            this.m_M_WarehouseValue = "";
            this.m_Separator = ".";
            this.m_AD_Client_ID = 0;
            this.m_AD_Org_ID = 0;
            String SQL = "SELECT M_Warehouse_ID, Value, Name, Separator, AD_Client_ID, AD_Org_ID FROM M_Warehouse WHERE M_Warehouse_ID=?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)SQL, null);
                    pstmt.setInt(1, M_Warehouse_ID);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        this.m_M_Warehouse_ID = rs.getInt(1);
                        this.m_M_WarehouseValue = rs.getString(2);
                        this.m_M_WarehouseName = rs.getString(3);
                        this.m_Separator = rs.getString(4);
                        this.m_AD_Client_ID = rs.getInt(5);
                        this.m_AD_Org_ID = rs.getInt(6);
                    }
                }
                catch (SQLException e) {
                    log.log(Level.SEVERE, SQL, (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
    }

    private void createValue() {
        ListItem listitem = this.lstWarehouse.getSelectedItem();
        KeyNamePair pp = (KeyNamePair)listitem.getValue();
        if (pp == null) {
            return;
        }
        this.getWarehouseInfo(pp.getKey());
        StringBuilder buf = new StringBuilder(this.m_M_WarehouseValue);
        buf.append(this.m_Separator).append(this.txtAisleX.getText());
        buf.append(this.m_Separator).append(this.txtBinY.getText());
        buf.append(this.m_Separator).append(this.txtLevelZ.getText());
        this.txtKey.setText(buf.toString());
    }

    private void actionOK() {
        if (this.chkCreateNew.isChecked()) {
            MLocator loc;
            ListItem listitem = this.lstWarehouse.getSelectedItem();
            KeyNamePair pp = (KeyNamePair)listitem.getValue();
            if (pp != null) {
                this.getWarehouseInfo(pp.getKey());
            }
            String mandatoryFields = "";
            if (this.m_M_Warehouse_ID == 0) {
                mandatoryFields = String.valueOf(mandatoryFields) + this.lblWarehouse.getValue() + " - ";
            }
            if (this.txtKey.getText().length() == 0) {
                mandatoryFields = String.valueOf(mandatoryFields) + this.lblKey.getValue() + " - ";
            }
            if (this.txtAisleX.getText().length() == 0) {
                mandatoryFields = String.valueOf(mandatoryFields) + this.lblAisleX.getValue() + " - ";
            }
            if (this.txtBinY.getText().length() == 0) {
                mandatoryFields = String.valueOf(mandatoryFields) + this.lblBinY.getValue() + " - ";
            }
            if (this.txtLevelZ.getText().length() == 0) {
                mandatoryFields = String.valueOf(mandatoryFields) + this.lblLevelZ.getValue() + " - ";
            }
            if (mandatoryFields.length() != 0) {
                Dialog.error(this.m_WindowNo, "FillMandatory", mandatoryFields.substring(0, mandatoryFields.length() - 3));
                return;
            }
            listitem = this.lstLocatorType.getSelectedItem();
            pp = (KeyNamePair)listitem.getValue();
            int lt = 0;
            if (pp != null) {
                lt = pp.getKey();
            }
            if ((loc = MLocator.get((Properties)Env.getCtx(), (int)this.m_M_Warehouse_ID, (String)this.txtKey.getText(), (String)this.txtAisleX.getText(), (String)this.txtBinY.getText(), (String)this.txtLevelZ.getText(), (int)lt)) == null) {
                Dialog.error(this.m_WindowNo, "AccessCannotInsert", Msg.getElement((Properties)Env.getCtx(), (String)"M_Locator_ID"));
                return;
            }
            this.m_M_Locator_ID = loc.getM_Locator_ID();
            this.locatorField.actionRefresh();
            this.locatorField.getComponent().appendItem(loc.getValue(), this.m_M_Locator_ID);
            this.locatorField.setValue(this.m_M_Locator_ID);
        }
        if (log.isLoggable(Level.CONFIG)) {
            log.config("M_Locator_ID=" + this.m_M_Locator_ID);
        }
    }

    public Integer getValue() {
        return (Integer)this.locatorField.getValue();
    }

    public boolean isChanged() {
        Integer locator_id;
        if (this.m_change && (locator_id = (Integer)this.locatorField.getValue()) != null) {
            return locator_id == this.m_M_Locator_ID;
        }
        return this.m_change;
    }

    public void onEvent(Event event) throws Exception {
        if (event == null) {
            return;
        }
        if (event.getTarget() == this.confirmPanel.getButton("Cancel")) {
            this.onCancel();
        } else if (event.getTarget() == this.confirmPanel.getButton("Ok")) {
            this.actionOK();
            this.m_change = true;
            this.detach();
        } else if (event.getTarget() == this.locatorField.getComponent()) {
            this.displayLocator();
        } else if (event.getTarget() == this.chkCreateNew) {
            this.enableNew();
        } else if (this.chkCreateNew.isChecked() && (event.getTarget() == this.lstWarehouse || event.getTarget() == this.txtAisleX || event.getTarget() == this.txtBinY || event.getTarget() == this.txtLevelZ)) {
            this.createValue();
        }
    }

    private void onCancel() {
        this.m_change = false;
        this.detach();
    }
}

