/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.window;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import org.adempiere.util.Callback;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.component.Button;
import org.adempiere.webui.component.Checkbox;
import org.adempiere.webui.component.Column;
import org.adempiere.webui.component.Columns;
import org.adempiere.webui.component.ConfirmPanel;
import org.adempiere.webui.component.Grid;
import org.adempiere.webui.component.GridFactory;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.ListItem;
import org.adempiere.webui.component.Listbox;
import org.adempiere.webui.component.Panel;
import org.adempiere.webui.component.Row;
import org.adempiere.webui.component.Rows;
import org.adempiere.webui.component.Textbox;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.Dialog;
import org.adempiere.webui.window.WAutoCompleterCity;
import org.compiere.model.GridField;
import org.compiere.model.MAddressValidation;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MCountry;
import org.compiere.model.MLocation;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MRegion;
import org.compiere.model.MSysConfig;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zul.Borderlayout;
import org.zkoss.zul.Cell;
import org.zkoss.zul.Center;
import org.zkoss.zul.South;
import org.zkoss.zul.Vbox;

public class WLocationDialog
extends Window
implements EventListener<Event> {
    private static final long serialVersionUID = -9116270523919373406L;
    private static final CLogger log = CLogger.getCLogger(WLocationDialog.class);
    private Label lblAddress1;
    private Label lblAddress2;
    private Label lblAddress3;
    private Label lblAddress4;
    private Label lblAddress5;
    private Label lblComments;
    private Label lblCity;
    private Label lblZip;
    private Label lblRegion;
    private Label lblPostal;
    private Label lblPostalAdd;
    private Label lblCountry;
    private Textbox txtAddress1;
    private Textbox txtAddress2;
    private Textbox txtAddress3;
    private Textbox txtAddress4;
    private Textbox txtAddress5;
    private Textbox txtComments;
    private WAutoCompleterCity txtCity;
    private Textbox txtPostal;
    private Textbox txtPostalAdd;
    private Listbox lstRegion;
    private Listbox lstCountry;
    private ConfirmPanel confirmPanel;
    private Grid mainPanel;
    private boolean m_change = false;
    private MLocation m_location;
    private int m_origCountry_ID;
    private int s_oldCountry_ID = 0;
    private int m_WindowNo = 0;
    private boolean isCityMandatory = false;
    private boolean isRegionMandatory = false;
    private boolean isAddress1Mandatory = false;
    private boolean isAddress2Mandatory = false;
    private boolean isAddress3Mandatory = false;
    private boolean isAddress4Mandatory = false;
    private boolean isAddress5Mandatory = false;
    private boolean isCommentsMandatory = false;
    private boolean isPostalMandatory = false;
    private boolean isPostalAddMandatory = false;
    private boolean inCountryAction;
    private boolean inOKAction;
    private Button toLink;
    private Button toRoute;
    private Listbox lstAddressValidation;
    private Button btnOnline;
    private Textbox txtResult;
    private Checkbox cbxValid;
    private ArrayList<String> enabledCountryList = new ArrayList();
    private GridField m_GridField = null;
    private boolean onSaveError = false;

    public WLocationDialog(String title, MLocation location) {
        this(title, location, null);
    }

    public WLocationDialog(String title, MLocation location, GridField gridField) {
        this.m_GridField = gridField;
        this.m_location = location;
        if (this.m_location == null) {
            this.m_location = new MLocation(Env.getCtx(), 0, null);
        }
        if (this.m_location.getC_Location_ID() == 0) {
            this.setTitle(Msg.getMsg((Properties)Env.getCtx(), (String)"LocationNew"));
        } else {
            this.setTitle(Msg.getMsg((Properties)Env.getCtx(), (String)"LocationUpdate"));
        }
        Env.setContext((Properties)Env.getCtx(), (int)this.m_WindowNo, (int)1113, (String)"C_Region_ID", null);
        Env.setContext((Properties)Env.getCtx(), (int)this.m_WindowNo, (int)1113, (String)"C_Country_ID", null);
        this.initComponents();
        this.init();
        MCountry[] mCountryArray = MCountry.getCountries();
        int n = mCountryArray.length;
        int n2 = 0;
        while (n2 < n) {
            MCountry country = mCountryArray[n2];
            this.lstCountry.appendItem(country.toString(), country);
            ++n2;
        }
        this.setCountry();
        this.lstCountry.addEventListener("onSelect", this);
        this.lstRegion.addEventListener("onSelect", this);
        this.m_origCountry_ID = this.m_location.getC_Country_ID();
        this.lstRegion.appendItem("", null);
        mCountryArray = MRegion.getRegions((int)this.m_origCountry_ID);
        n = mCountryArray.length;
        n2 = 0;
        while (n2 < n) {
            MCountry region = mCountryArray[n2];
            this.lstRegion.appendItem(region.getTrlName(), region);
            ++n2;
        }
        if (this.m_location.getCountry().isHasRegion()) {
            if (this.m_location.getCountry().get_Translation("RegionName") != null && this.m_location.getCountry().get_Translation("RegionName").trim().length() > 0) {
                this.lblRegion.setValue(this.m_location.getCountry().get_Translation("RegionName"));
            } else {
                this.lblRegion.setValue(Msg.getMsg((Properties)Env.getCtx(), (String)"Region"));
            }
        }
        this.setRegion();
        this.initLocation();
        if (!ThemeManager.isUseCSSForWindowSize()) {
            ZKUpdateUtil.setWindowWidthX((HtmlBasedComponent)this, 380);
            ZKUpdateUtil.setWindowHeightX((HtmlBasedComponent)this, 420);
        } else {
            this.addCallback("afterPageAttached", (org.zkoss.zk.ui.util.Callback & Serializable)t -> {
                ZKUpdateUtil.setCSSHeight((HtmlBasedComponent)this);
                ZKUpdateUtil.setCSSWidth((HtmlBasedComponent)this);
            });
        }
        this.setSclass("popup-dialog location-dialog");
        this.setClosable(true);
        this.setBorder("normal");
        this.setShadow(true);
        this.setAttribute("mode", "highlighted");
    }

    private void initComponents() {
        this.lblAddress1 = new Label(Msg.getElement((Properties)Env.getCtx(), (String)"Address1"));
        this.lblAddress1.setSclass("field-label");
        this.lblAddress2 = new Label(Msg.getElement((Properties)Env.getCtx(), (String)"Address2"));
        this.lblAddress2.setSclass("field-label");
        this.lblAddress3 = new Label(Msg.getElement((Properties)Env.getCtx(), (String)"Address3"));
        this.lblAddress3.setSclass("field-label");
        this.lblAddress4 = new Label(Msg.getElement((Properties)Env.getCtx(), (String)"Address4"));
        this.lblAddress4.setSclass("field-label");
        this.lblAddress5 = new Label(Msg.getElement((Properties)Env.getCtx(), (String)"Address5"));
        this.lblAddress5.setSclass("field-label");
        this.lblComments = new Label(Msg.getElement((Properties)Env.getCtx(), (String)"Comments"));
        this.lblComments.setSclass("field-label");
        this.lblCity = new Label(Msg.getMsg((Properties)Env.getCtx(), (String)"City"));
        this.lblCity.setSclass("field-label");
        this.lblZip = new Label(Msg.getMsg((Properties)Env.getCtx(), (String)"Postal"));
        this.lblZip.setSclass("field-label");
        this.lblRegion = new Label(Msg.getMsg((Properties)Env.getCtx(), (String)"Region"));
        this.lblRegion.setSclass("field-label");
        this.lblPostal = new Label(Msg.getMsg((Properties)Env.getCtx(), (String)"Postal"));
        this.lblPostal.setSclass("field-label");
        this.lblPostalAdd = new Label(Msg.getMsg((Properties)Env.getCtx(), (String)"PostalAdd"));
        this.lblPostalAdd.setSclass("field-label");
        this.lblCountry = new Label(Msg.getMsg((Properties)Env.getCtx(), (String)"Country"));
        this.lblCountry.setSclass("field-label");
        this.txtAddress1 = new Textbox();
        this.txtAddress1.setCols(20);
        this.txtAddress1.setMaxlength(MLocation.getFieldLength((String)"Address1"));
        this.txtAddress2 = new Textbox();
        this.txtAddress2.setCols(20);
        this.txtAddress2.setMaxlength(MLocation.getFieldLength((String)"Address2"));
        this.txtAddress3 = new Textbox();
        this.txtAddress3.setCols(20);
        this.txtAddress3.setMaxlength(MLocation.getFieldLength((String)"Address3"));
        this.txtAddress4 = new Textbox();
        this.txtAddress4.setCols(20);
        this.txtAddress4.setMaxlength(MLocation.getFieldLength((String)"Address4"));
        this.txtAddress5 = new Textbox();
        this.txtAddress5.setCols(20);
        this.txtAddress5.setMaxlength(MLocation.getFieldLength((String)"Address5"));
        this.txtComments = new Textbox();
        this.txtComments.setCols(20);
        this.txtComments.setMaxlength(MLocation.getFieldLength((String)"Comments"));
        this.txtCity = new WAutoCompleterCity(this.m_WindowNo);
        this.txtCity.setCols(20);
        this.txtCity.setMaxlength(MLocation.getFieldLength((String)"City"));
        this.txtCity.setAutodrop(true);
        this.txtCity.setAutocomplete(true);
        this.txtCity.addEventListener("onChanging", this);
        this.txtPostal = new Textbox();
        this.txtPostal.setCols(20);
        this.txtPostal.setMaxlength(MLocation.getFieldLength((String)"Postal"));
        this.txtPostalAdd = new Textbox();
        this.txtPostalAdd.setCols(20);
        this.txtPostalAdd.setMaxlength(MLocation.getFieldLength((String)"Postal_Add"));
        this.lstRegion = new Listbox();
        this.lstRegion.setMold("select");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.lstRegion, "154px");
        this.lstRegion.setRows(0);
        this.lstCountry = new Listbox();
        this.lstCountry.setMold("select");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.lstCountry, "154px");
        this.lstCountry.setRows(0);
        this.confirmPanel = new ConfirmPanel(true);
        this.confirmPanel.addActionListener(this);
        this.toLink = new Button(Msg.getMsg((Properties)Env.getCtx(), (String)"Map"));
        LayoutUtils.addSclass("txt-btn", (HtmlBasedComponent)this.toLink);
        this.toLink.addEventListener("onClick", this);
        this.toRoute = new Button(Msg.getMsg((Properties)Env.getCtx(), (String)"Route"));
        LayoutUtils.addSclass("txt-btn", (HtmlBasedComponent)this.toRoute);
        this.toRoute.addEventListener("onClick", this);
        this.btnOnline = new Button(Msg.getElement((Properties)Env.getCtx(), (String)"ValidateAddress"));
        LayoutUtils.addSclass("txt-btn", (HtmlBasedComponent)this.btnOnline);
        this.btnOnline.addEventListener("onClick", this);
        this.txtResult = new Textbox();
        this.txtResult.setCols(2);
        this.txtResult.setRows(3);
        this.txtResult.setReadonly(true);
        this.cbxValid = new Checkbox();
        this.cbxValid.setText(Msg.getElement((Properties)Env.getCtx(), (String)"IsValid"));
        this.cbxValid.setDisabled(true);
        this.lstAddressValidation = new Listbox();
        this.lstAddressValidation.setMold("select");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.lstAddressValidation, "154px");
        this.lstAddressValidation.setRows(0);
        this.mainPanel = GridFactory.newGridLayout();
        if (ClientInfo.isMobile() && (ClientInfo.maxWidth(500) || ClientInfo.maxHeight(500))) {
            this.confirmPanel.addButtonSclass("btn-medium small-image-btn");
        }
    }

    private void init() {
        Columns columns = new Columns();
        this.mainPanel.appendChild((Component)columns);
        Column column = new Column();
        columns.appendChild((Component)column);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)column, "30%");
        column = new Column();
        columns.appendChild((Component)column);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)column, "70%");
        Row pnlAddress1 = new Row();
        pnlAddress1.appendChild((Component)this.lblAddress1);
        pnlAddress1.appendChild((Component)this.txtAddress1);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.txtAddress1, "1");
        Row pnlAddress2 = new Row();
        pnlAddress2.appendChild((Component)this.lblAddress2);
        pnlAddress2.appendChild((Component)this.txtAddress2);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.txtAddress2, "1");
        Row pnlAddress3 = new Row();
        pnlAddress3.appendChild((Component)this.lblAddress3);
        pnlAddress3.appendChild((Component)this.txtAddress3);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.txtAddress3, "1");
        Row pnlAddress4 = new Row();
        pnlAddress4.appendChild((Component)this.lblAddress4);
        pnlAddress4.appendChild((Component)this.txtAddress4);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.txtAddress4, "1");
        Row pnlAddress5 = new Row();
        pnlAddress5.appendChild((Component)this.lblAddress5);
        pnlAddress5.appendChild((Component)this.txtAddress5);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.txtAddress5, "1");
        Row pnlComments = new Row();
        pnlComments.appendChild((Component)this.lblComments);
        pnlComments.appendChild((Component)this.txtComments);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.txtComments, "1");
        Row pnlCity = new Row();
        pnlCity.appendChild((Component)this.lblCity);
        pnlCity.appendChild((Component)this.txtCity);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.txtCity, "1");
        Row pnlPostal = new Row();
        pnlPostal.appendChild((Component)this.lblPostal);
        pnlPostal.appendChild((Component)this.txtPostal);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)pnlPostal, "1");
        Row pnlPostalAdd = new Row();
        pnlPostalAdd.appendChild((Component)this.lblPostalAdd);
        pnlPostalAdd.appendChild((Component)this.txtPostalAdd);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.txtPostalAdd, "1");
        Row pnlRegion = new Row();
        pnlRegion.appendChild((Component)this.lblRegion);
        pnlRegion.appendChild((Component)this.lstRegion);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.lstRegion, "1");
        Row pnlCountry = new Row();
        pnlCountry.appendChild((Component)this.lblCountry);
        pnlCountry.appendChild((Component)this.lstCountry);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.lstCountry, "1");
        Panel pnlLinks = new Panel();
        pnlLinks.appendChild((Component)this.toLink);
        if (MLocation.LOCATION_MAPS_URL_PREFIX == null) {
            this.toLink.setVisible(false);
        }
        pnlLinks.appendChild((Component)this.toRoute);
        if (MLocation.LOCATION_MAPS_ROUTE_PREFIX == null || Env.getAD_Org_ID((Properties)Env.getCtx()) <= 0) {
            this.toRoute.setVisible(false);
        }
        ZKUpdateUtil.setWidth((HtmlBasedComponent)pnlLinks, "100%");
        pnlLinks.setStyle("text-align:right");
        Borderlayout borderlayout = new Borderlayout();
        this.appendChild((Component)borderlayout);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)borderlayout, "1");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)borderlayout, "1");
        Center centerPane = new Center();
        centerPane.setSclass("dialog-content");
        centerPane.setAutoscroll(true);
        borderlayout.appendChild((Component)centerPane);
        Vbox vbox = new Vbox();
        centerPane.appendChild((Component)vbox);
        vbox.appendChild((Component)this.mainPanel);
        if (MLocation.LOCATION_MAPS_URL_PREFIX != null || MLocation.LOCATION_MAPS_ROUTE_PREFIX != null) {
            vbox.appendChild((Component)pnlLinks);
        }
        String addressValidation = MSysConfig.getValue((String)"ADDRESS_VALIDATION", null, (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
        this.enabledCountryList.clear();
        if (addressValidation != null && addressValidation.trim().length() > 0) {
            StringTokenizer st = new StringTokenizer(addressValidation, ";");
            while (st.hasMoreTokens()) {
                String token = st.nextToken().trim();
                this.enabledCountryList.add(token);
            }
        }
        if (this.enabledCountryList.size() > 0) {
            Grid grid = GridFactory.newGridLayout();
            vbox.appendChild((Component)grid);
            columns = new Columns();
            grid.appendChild((Component)columns);
            Rows rows = new Rows();
            grid.appendChild((Component)rows);
            Row row = new Row();
            rows.appendChild((Component)row);
            row.appendCellChild((Component)this.lstAddressValidation, 2);
            ZKUpdateUtil.setHflex((HtmlBasedComponent)this.lstAddressValidation, "1");
            MAddressValidation[] validations = MAddressValidation.getAddressValidation((Properties)Env.getCtx(), (int)Env.getAD_Client_ID((Properties)Env.getCtx()), null);
            MAddressValidation[] mAddressValidationArray = validations;
            int n = validations.length;
            int n2 = 0;
            while (n2 < n) {
                MAddressValidation validation = mAddressValidationArray[n2];
                ListItem li = this.lstAddressValidation.appendItem(validation.getName(), validation);
                if (this.m_location.getC_AddressValidation_ID() == validation.getC_AddressValidation_ID()) {
                    this.lstAddressValidation.setSelectedItem(li);
                }
                ++n2;
            }
            if (this.lstAddressValidation.getSelectedIndex() == -1 && this.lstAddressValidation.getChildren().size() > 0) {
                this.lstAddressValidation.setSelectedIndex(0);
            }
            row = new Row();
            rows.appendChild((Component)row);
            row.appendCellChild((Component)this.txtResult, 2);
            ZKUpdateUtil.setHflex((HtmlBasedComponent)this.txtResult, "1");
            this.txtResult.setText(this.m_location.getResult());
            row = new Row();
            rows.appendChild((Component)row);
            row.appendChild((Component)this.cbxValid);
            this.cbxValid.setChecked(this.m_location.isValid());
            Cell cell = new Cell();
            cell.setColspan(1);
            cell.setRowspan(1);
            cell.appendChild((Component)this.btnOnline);
            cell.setAlign("right");
            row.appendChild((Component)cell);
            if (!this.enabledCountryList.isEmpty()) {
                boolean isEnabled = false;
                if (this.m_location.getCountry() != null) {
                    for (String enabledCountry : this.enabledCountryList) {
                        if (!enabledCountry.equals(this.m_location.getCountry().getCountryCode().trim())) continue;
                        isEnabled = true;
                        break;
                    }
                }
                this.btnOnline.setEnabled(isEnabled);
            }
        }
        ZKUpdateUtil.setVflex((HtmlBasedComponent)vbox, "1");
        ZKUpdateUtil.setHflex((HtmlBasedComponent)vbox, "1");
        South southPane = new South();
        southPane.setSclass("dialog-footer");
        borderlayout.appendChild((Component)southPane);
        southPane.appendChild((Component)this.confirmPanel);
        this.addEventListener("onSaveError", this);
        this.addEventListener("onCancel", e -> this.onCancel());
    }

    private void addComponents(Row row) {
        if (this.mainPanel.getRows() != null) {
            this.mainPanel.getRows().appendChild((Component)row);
        } else {
            this.mainPanel.newRows().appendChild((Component)row);
        }
    }

    private void initLocation() {
        if (this.mainPanel.getRows() != null) {
            this.mainPanel.getRows().getChildren().clear();
        }
        MCountry country = this.m_location.getCountry();
        if (log.isLoggable(Level.FINE)) {
            log.fine(String.valueOf(country.getName()) + ", Region=" + country.isHasRegion() + " " + country.getCaptureSequence() + ", C_Location_ID=" + this.m_location.getC_Location_ID());
        }
        if (this.m_location.getC_Country_ID() != this.s_oldCountry_ID) {
            this.lstRegion.getChildren().clear();
            if (country.isHasRegion()) {
                this.lstRegion.appendItem("", null);
                MRegion[] mRegionArray = MRegion.getRegions((int)country.getC_Country_ID());
                int n = mRegionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    MRegion region = mRegionArray[n2];
                    this.lstRegion.appendItem(region.getTrlName(), region);
                    ++n2;
                }
                if (this.m_location.getCountry().get_Translation("RegionName") != null && this.m_location.getCountry().get_Translation("RegionName").trim().length() > 0) {
                    this.lblRegion.setValue(this.m_location.getCountry().get_Translation("RegionName"));
                } else {
                    this.lblRegion.setValue(Msg.getMsg((Properties)Env.getCtx(), (String)"Region"));
                }
            }
            this.s_oldCountry_ID = this.m_location.getC_Country_ID();
        }
        if (this.m_location.getC_Region_ID() > 0 && this.m_location.getC_Region().getC_Country_ID() == country.getC_Country_ID()) {
            this.setRegion();
        } else {
            this.lstRegion.setSelectedItem(null);
            this.m_location.setC_Region_ID(0);
        }
        if (country.isHasRegion() && this.m_location.getC_Region_ID() > 0) {
            Env.setContext((Properties)Env.getCtx(), (int)this.m_WindowNo, (int)1113, (String)"C_Region_ID", (String)String.valueOf(this.m_location.getC_Region_ID()));
        } else {
            Env.setContext((Properties)Env.getCtx(), (int)this.m_WindowNo, (int)1113, (String)"C_Region_ID", (String)"0");
        }
        Env.setContext((Properties)Env.getCtx(), (int)this.m_WindowNo, (int)1113, (String)"C_Country_ID", (String)String.valueOf(country.get_ID()));
        this.txtCity.fillList();
        String ds = country.getCaptureSequence();
        if (ds == null || ds.length() == 0) {
            log.log(Level.SEVERE, "CaptureSequence empty - " + country);
            ds = "";
        }
        this.isCityMandatory = false;
        this.isRegionMandatory = false;
        this.isAddress1Mandatory = false;
        this.isAddress2Mandatory = false;
        this.isAddress3Mandatory = false;
        this.isAddress4Mandatory = false;
        this.isAddress5Mandatory = false;
        this.isCommentsMandatory = false;
        this.isPostalMandatory = false;
        this.isPostalAddMandatory = false;
        StringTokenizer st = new StringTokenizer(ds, "@", false);
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (s.startsWith("CO")) {
                this.addComponents((Row)this.lstCountry.getParent());
                continue;
            }
            if (s.startsWith("Com")) {
                this.addComponents((Row)this.txtComments.getParent());
                this.isCommentsMandatory = s.endsWith("!");
                continue;
            }
            if (s.startsWith("A1")) {
                this.addComponents((Row)this.txtAddress1.getParent());
                this.isAddress1Mandatory = s.endsWith("!");
                continue;
            }
            if (s.startsWith("A2")) {
                this.addComponents((Row)this.txtAddress2.getParent());
                this.isAddress2Mandatory = s.endsWith("!");
                continue;
            }
            if (s.startsWith("A3")) {
                this.addComponents((Row)this.txtAddress3.getParent());
                this.isAddress3Mandatory = s.endsWith("!");
                continue;
            }
            if (s.startsWith("A4")) {
                this.addComponents((Row)this.txtAddress4.getParent());
                this.isAddress4Mandatory = s.endsWith("!");
                continue;
            }
            if (s.startsWith("A5")) {
                this.addComponents((Row)this.txtAddress5.getParent());
                this.isAddress5Mandatory = s.endsWith("!");
                continue;
            }
            if (s.startsWith("C")) {
                this.addComponents((Row)this.txtCity.getParent());
                this.isCityMandatory = s.endsWith("!");
                continue;
            }
            if (s.startsWith("P")) {
                this.addComponents((Row)this.txtPostal.getParent());
                this.isPostalMandatory = s.endsWith("!");
                continue;
            }
            if (s.startsWith("A")) {
                this.addComponents((Row)this.txtPostalAdd.getParent());
                this.isPostalAddMandatory = s.endsWith("!");
                continue;
            }
            if (!s.startsWith("R") || !this.m_location.getCountry().isHasRegion()) continue;
            this.addComponents((Row)this.lstRegion.getParent());
            this.isRegionMandatory = s.endsWith("!");
        }
        this.setPlaceholders();
        if (this.m_location.getC_Location_ID() != 0) {
            this.txtAddress1.setText(this.m_location.getAddress1());
            this.txtAddress2.setText(this.m_location.getAddress2());
            this.txtAddress3.setText(this.m_location.getAddress3());
            this.txtAddress4.setText(this.m_location.getAddress4());
            this.txtAddress5.setText(this.m_location.getAddress5());
            this.txtComments.setText(this.m_location.getComments());
            this.txtCity.setText(this.m_location.getCity());
            this.txtPostal.setText(this.m_location.getPostal());
            this.txtPostalAdd.setText(this.m_location.getPostal_Add());
            if (this.m_location.getCountry().isHasRegion()) {
                if (this.m_location.getCountry().get_Translation("RegionName") != null && this.m_location.getCountry().get_Translation("RegionName").trim().length() > 0) {
                    this.lblRegion.setValue(this.m_location.getCountry().get_Translation("RegionName"));
                } else {
                    this.lblRegion.setValue(Msg.getMsg((Properties)Env.getCtx(), (String)"Region"));
                }
                this.setRegion();
            }
            this.setCountry();
        }
    }

    private void setCountry() {
        List listCountry = this.lstCountry.getChildren();
        for (ListItem listitem : listCountry) {
            if (!this.m_location.getCountry().equals(listitem.getValue())) continue;
            this.lstCountry.setSelectedItem(listitem);
        }
    }

    private void setRegion() {
        if (this.m_location.getRegion() != null) {
            List listState = this.lstRegion.getChildren();
            for (ListItem listitem : listState) {
                if (!this.m_location.getRegion().equals(listitem.getValue())) continue;
                this.lstRegion.setSelectedItem(listitem);
            }
        } else {
            this.lstRegion.setSelectedItem(null);
        }
    }

    public boolean isChanged() {
        return this.m_change;
    }

    public MLocation getValue() {
        return this.m_location;
    }

    public void onEvent(Event event) throws Exception {
        if (event.getTarget() == this.confirmPanel.getButton("Ok")) {
            String msg;
            this.onSaveError = false;
            this.inOKAction = true;
            if (this.m_location.getCountry().isHasRegion() && this.lstRegion.getSelectedItem() == null && this.txtCity.getC_Region_ID() > 0 && this.txtCity.getC_Region_ID() != this.m_location.getC_Region_ID()) {
                this.m_location.setRegion(MRegion.get((Properties)Env.getCtx(), (int)this.txtCity.getC_Region_ID()));
                this.setRegion();
            }
            if ((msg = this.validate_OK()) != null) {
                this.onSaveError = true;
                Dialog.error(0, "FillMandatory", Msg.parseTranslation((Properties)Env.getCtx(), (String)msg), new Callback<Integer>(){

                    public void onCallback(Integer result) {
                        Events.echoEvent((String)"onSaveError", (Component)WLocationDialog.this, null);
                    }
                });
                this.inOKAction = false;
                return;
            }
            if (this.action_OK()) {
                this.m_change = true;
                this.inOKAction = false;
                this.dispose();
            } else {
                this.onSaveError = true;
                Dialog.error(0, "CityNotFound", null, new Callback<Integer>(){

                    public void onCallback(Integer result) {
                        Events.echoEvent((String)"onSaveError", (Component)WLocationDialog.this, null);
                    }
                });
            }
            this.inOKAction = false;
        } else if (event.getTarget() == this.confirmPanel.getButton("Cancel")) {
            this.onCancel();
        } else if (((Object)((Object)this.toLink)).equals(event.getTarget())) {
            String urlString = String.valueOf(MLocation.LOCATION_MAPS_URL_PREFIX) + this.getFullAdress();
            String message = null;
            try {
                Executions.getCurrent().sendRedirect(urlString, "_blank");
            }
            catch (Exception e) {
                message = e.getMessage();
                Dialog.warn(0, "URLnotValid", message, null);
            }
        } else if (((Object)((Object)this.toRoute)).equals(event.getTarget())) {
            int AD_Org_ID = Env.getAD_Org_ID((Properties)Env.getCtx());
            if (AD_Org_ID != 0) {
                MOrgInfo orgInfo = MOrgInfo.get((Properties)Env.getCtx(), (int)AD_Org_ID, null);
                MLocation orgLocation = new MLocation(Env.getCtx(), orgInfo.getC_Location_ID(), null);
                String urlString = String.valueOf(MLocation.LOCATION_MAPS_ROUTE_PREFIX) + MLocation.LOCATION_MAPS_SOURCE_ADDRESS + orgLocation.getMapsLocation() + MLocation.LOCATION_MAPS_DESTINATION_ADDRESS + this.getFullAdress();
                String message = null;
                try {
                    Executions.getCurrent().sendRedirect(urlString, "_blank");
                }
                catch (Exception e) {
                    message = e.getMessage();
                    Dialog.warn(0, "URLnotValid", message, null);
                }
            }
        } else if (((Object)((Object)this.btnOnline)).equals(event.getTarget())) {
            String msg;
            this.btnOnline.setEnabled(false);
            this.onSaveError = false;
            this.inOKAction = true;
            if (this.m_location.getCountry().isHasRegion() && this.lstRegion.getSelectedItem() == null && this.txtCity.getC_Region_ID() > 0 && this.txtCity.getC_Region_ID() != this.m_location.getC_Region_ID()) {
                this.m_location.setRegion(MRegion.get((Properties)Env.getCtx(), (int)this.txtCity.getC_Region_ID()));
                this.setRegion();
            }
            if ((msg = this.validate_OK()) != null) {
                this.onSaveError = true;
                Dialog.error(0, "FillMandatory", Msg.parseTranslation((Properties)Env.getCtx(), (String)msg), new Callback<Integer>(){

                    public void onCallback(Integer result) {
                        Events.echoEvent((String)"onSaveError", (Component)WLocationDialog.this, null);
                    }
                });
                this.inOKAction = false;
                return;
            }
            MLocation m_location = new MLocation(Env.getCtx(), 0, null);
            m_location.setAddress1(this.txtAddress1.getValue());
            m_location.setAddress2(this.txtAddress2.getValue());
            m_location.setAddress3(this.txtAddress3.getValue());
            m_location.setAddress4(this.txtAddress4.getValue());
            m_location.setAddress5(this.txtAddress5.getValue());
            m_location.setComments(this.txtComments.getValue());
            m_location.setC_City_ID(this.txtCity.getC_City_ID());
            m_location.setCity(this.txtCity.getValue());
            m_location.setPostal(this.txtPostal.getValue());
            MCountry country = (MCountry)this.lstCountry.getSelectedItem().getValue();
            m_location.setCountry(country);
            if (country.isHasRegion() && this.lstRegion.getSelectedItem() != null) {
                MRegion r = (MRegion)this.lstRegion.getSelectedItem().getValue();
                m_location.setRegion(r);
            } else {
                m_location.setC_Region_ID(0);
            }
            MAddressValidation validation = (MAddressValidation)this.lstAddressValidation.getSelectedItem().getValue();
            if (validation == null && this.lstAddressValidation.getChildren().size() > 0) {
                validation = (MAddressValidation)this.lstAddressValidation.getItemAtIndex(0).getValue();
            }
            if (validation != null) {
                boolean ok = m_location.processOnline(validation.getC_AddressValidation_ID());
                this.txtResult.setText(m_location.getResult());
                this.cbxValid.setChecked(m_location.isValid());
                List list = this.lstAddressValidation.getChildren();
                for (ListItem listitem : list) {
                    if (!m_location.getC_AddressValidation().equals(listitem.getValue())) continue;
                    this.lstAddressValidation.setSelectedItem(listitem);
                    break;
                }
                if (!ok) {
                    this.onSaveError = true;
                    Dialog.error(0, "Error", m_location.getErrorMessage(), new Callback<Integer>(){

                        public void onCallback(Integer result) {
                            Events.echoEvent((String)"onSaveError", (Component)WLocationDialog.this, null);
                        }
                    });
                }
            }
            this.inOKAction = false;
            this.btnOnline.setEnabled(true);
        } else if (((Object)((Object)this.lstCountry)).equals(event.getTarget())) {
            this.inCountryAction = true;
            MCountry c = (MCountry)this.lstCountry.getSelectedItem().getValue();
            this.m_location.setCountry(c);
            this.m_location.setC_City_ID(0);
            this.m_location.setCity(null);
            this.initLocation();
            if (!this.enabledCountryList.isEmpty()) {
                boolean isEnabled = false;
                if (c != null) {
                    for (String enabledCountry : this.enabledCountryList) {
                        if (!enabledCountry.equals(c.getCountryCode().trim())) continue;
                        isEnabled = true;
                        break;
                    }
                }
                this.btnOnline.setEnabled(isEnabled);
            }
            this.inCountryAction = false;
            this.lstCountry.focus();
        } else if (((Object)((Object)this.lstRegion)).equals(event.getTarget())) {
            if (this.inCountryAction || this.inOKAction) {
                return;
            }
            MRegion r = (MRegion)this.lstRegion.getSelectedItem().getValue();
            this.m_location.setRegion(r);
            this.m_location.setC_City_ID(0);
            this.m_location.setCity(null);
            this.initLocation();
            this.lstRegion.focus();
        } else if ("onSaveError".equals(event.getName())) {
            this.onSaveError = false;
            this.doPopup();
            this.focus();
        }
    }

    private void onCancel() {
        this.m_change = false;
        this.dispose();
    }

    private String validate_OK() {
        String fields = "";
        if (this.isAddress1Mandatory && this.txtAddress1.getText().trim().length() == 0) {
            fields = String.valueOf(fields) + " " + "@Address1@, ";
        }
        if (this.isAddress2Mandatory && this.txtAddress2.getText().trim().length() == 0) {
            fields = String.valueOf(fields) + " " + "@Address2@, ";
        }
        if (this.isAddress3Mandatory && this.txtAddress3.getText().trim().length() == 0) {
            fields = String.valueOf(fields) + " " + "@Address3@, ";
        }
        if (this.isAddress4Mandatory && this.txtAddress4.getText().trim().length() == 0) {
            fields = String.valueOf(fields) + " " + "@Address4@, ";
        }
        if (this.isAddress5Mandatory && this.txtAddress5.getText().trim().length() == 0) {
            fields = String.valueOf(fields) + " " + "@Address5@, ";
        }
        if (this.isCommentsMandatory && this.txtComments.getText().trim().length() == 0) {
            fields = String.valueOf(fields) + " " + "@Comments@, ";
        }
        if (this.isCityMandatory && this.txtCity.getValue().trim().length() == 0) {
            fields = String.valueOf(fields) + " " + "@C_City_ID@, ";
        }
        if (this.isRegionMandatory && this.lstRegion.getSelectedItem() == null) {
            fields = String.valueOf(fields) + " " + "@C_Region_ID@, ";
        }
        if (this.isPostalMandatory && this.txtPostal.getText().trim().length() == 0) {
            fields = String.valueOf(fields) + " " + "@Postal@, ";
        }
        if (this.isPostalAddMandatory && this.txtPostalAdd.getText().trim().length() == 0) {
            fields = String.valueOf(fields) + " " + "@PostalAdd@, ";
        }
        if (fields.trim().length() > 0) {
            return fields.substring(0, fields.length() - 2);
        }
        return null;
    }

    private boolean action_OK() {
        Trx trx = Trx.get((String)Trx.createTrxName((String)"WLocationDialog"), (boolean)true);
        trx.setDisplayName(String.valueOf(this.getClass().getName()) + "_action_Ok");
        this.m_location.set_TrxName(trx.getTrxName());
        this.m_location.setAddress1(this.txtAddress1.getValue());
        this.m_location.setAddress2(this.txtAddress2.getValue());
        this.m_location.setAddress3(this.txtAddress3.getValue());
        this.m_location.setAddress4(this.txtAddress4.getValue());
        this.m_location.setAddress5(this.txtAddress5.getValue());
        this.m_location.setComments(this.txtComments.getValue());
        this.m_location.setC_City_ID(this.txtCity.getC_City_ID());
        this.m_location.setCity(this.txtCity.getValue());
        this.m_location.setPostal(this.txtPostal.getValue());
        this.m_location.setPostal_Add(this.txtPostalAdd.getValue());
        MCountry country = (MCountry)this.lstCountry.getSelectedItem().getValue();
        this.m_location.setCountry(country);
        if (country.isHasRegion() && this.lstRegion.getSelectedItem() != null) {
            MRegion r = (MRegion)this.lstRegion.getSelectedItem().getValue();
            this.m_location.setRegion(r);
        } else {
            this.m_location.setC_Region_ID(0);
        }
        if (this.lstAddressValidation.getSelectedIndex() != -1) {
            MAddressValidation validation = (MAddressValidation)this.lstAddressValidation.getSelectedItem().getValue();
            this.m_location.setC_AddressValidation_ID(validation.getC_AddressValidation_ID());
        }
        boolean changedCity = this.m_location.is_ValueChanged("City") || this.m_location.is_ValueChanged("C_City_ID");
        boolean changedAddress1 = this.m_location.is_ValueChanged("Address1");
        boolean changedAddress2 = this.m_location.is_ValueChanged("Address2");
        boolean changedRegion = this.m_location.is_ValueChanged("RegionName") || this.m_location.is_ValueChanged("C_Region_ID");
        boolean success = this.m_location.save();
        if (success) {
            int bplocname = MSysConfig.getIntValue((String)"START_VALUE_BPLOCATION_NAME", (int)0, (int)this.m_location.getAD_Client_ID(), (int)this.m_location.getAD_Org_ID());
            if (bplocname < 0 || bplocname > 4) {
                bplocname = 0;
            }
            if (changedCity || bplocname >= 1 && changedAddress1 || bplocname >= 2 && changedAddress2 || bplocname >= 3 && changedRegion) {
                if (this.m_GridField != null && this.m_GridField.getGridTab() != null && "C_BPartner_Location".equals(this.m_GridField.getGridTab().getTableName()) && !this.m_GridField.getGridTab().getValueAsBoolean("IsPreserveCustomName")) {
                    this.m_GridField.getGridTab().setValue("Name", (Object)".");
                } else {
                    int bplID = DB.getSQLValueEx((String)trx.getTrxName(), (String)"SELECT C_BPartner_Location_ID FROM C_BPartner_Location WHERE C_Location_ID = ? AND IsPreserveCustomName = 'N'", (Object[])new Object[]{this.m_location.getC_Location_ID()});
                    if (bplID > 0) {
                        MBPartnerLocation bpl = new MBPartnerLocation(Env.getCtx(), bplID, trx.getTrxName());
                        bpl.setName(bpl.getBPLocName(this.m_location));
                        success = bpl.save();
                    }
                }
            }
        }
        if (success) {
            trx.commit();
        } else {
            trx.rollback();
        }
        trx.close();
        return success;
    }

    public boolean isOnSaveError() {
        return this.onSaveError;
    }

    @Override
    public void dispose() {
        if (!this.m_change && this.m_location != null && !this.m_location.is_new()) {
            this.m_location = new MLocation(this.m_location.getCtx(), this.m_location.get_ID(), null);
        }
        super.dispose();
    }

    String getFullAdress() {
        MRegion region = null;
        if (this.lstRegion.getSelectedItem() != null) {
            region = new MRegion(Env.getCtx(), ((MRegion)this.lstRegion.getSelectedItem().getValue()).getC_Region_ID(), null);
        }
        MCountry c = (MCountry)this.lstCountry.getSelectedItem().getValue();
        String address = "";
        address = String.valueOf(address) + (this.txtAddress1.getText() != null ? String.valueOf(this.txtAddress1.getText()) + ", " : "");
        address = String.valueOf(address) + (this.txtAddress2.getText() != null ? String.valueOf(this.txtAddress2.getText()) + ", " : "");
        address = String.valueOf(address) + (this.txtAddress3.getText() != null ? String.valueOf(this.txtAddress3.getText()) + ", " : "");
        address = String.valueOf(address) + (this.txtAddress4.getText() != null ? String.valueOf(this.txtAddress4.getText()) + ", " : "");
        address = String.valueOf(address) + (this.txtCity.getText() != null ? String.valueOf(this.txtCity.getText()) + ", " : "");
        if (region != null) {
            address = String.valueOf(address) + (region.getName() != null ? String.valueOf(region.getName()) + ", " : "");
        }
        address = String.valueOf(address) + (c.getName() != null ? c.getName() : "");
        return address.replace(" ", "+");
    }

    void setPlaceholders() {
        this.txtAddress1.setPlaceholder(MCountry.get((Properties)Env.getCtx(), (int)this.s_oldCountry_ID).get_Translation("PlaceholderAddress1"));
        this.txtAddress2.setPlaceholder(MCountry.get((Properties)Env.getCtx(), (int)this.s_oldCountry_ID).get_Translation("PlaceholderAddress2"));
        this.txtAddress3.setPlaceholder(MCountry.get((Properties)Env.getCtx(), (int)this.s_oldCountry_ID).get_Translation("PlaceholderAddress3"));
        this.txtAddress4.setPlaceholder(MCountry.get((Properties)Env.getCtx(), (int)this.s_oldCountry_ID).get_Translation("PlaceholderAddress4"));
        this.txtAddress5.setPlaceholder(MCountry.get((Properties)Env.getCtx(), (int)this.s_oldCountry_ID).get_Translation("PlaceholderAddress5"));
        this.txtComments.setPlaceholder(MCountry.get((Properties)Env.getCtx(), (int)this.s_oldCountry_ID).get_Translation("PlaceholderComments"));
        this.txtCity.setPlaceholder(MCountry.get((Properties)Env.getCtx(), (int)this.s_oldCountry_ID).get_Translation("PlaceholderCity"));
        this.txtPostal.setPlaceholder(MCountry.get((Properties)Env.getCtx(), (int)this.s_oldCountry_ID).get_Translation("PlaceholderPostal"));
        this.txtPostalAdd.setPlaceholder(MCountry.get((Properties)Env.getCtx(), (int)this.s_oldCountry_ID).get_Translation("PlaceholderPostal_Add"));
    }
}

