/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.window;

import java.util.Properties;
import org.adempiere.webui.component.Column;
import org.adempiere.webui.component.Columns;
import org.adempiere.webui.component.ConfirmPanel;
import org.adempiere.webui.component.Grid;
import org.adempiere.webui.component.GridFactory;
import org.adempiere.webui.component.Row;
import org.adempiere.webui.component.Rows;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.Dialog;
import org.compiere.model.MField;
import org.compiere.model.MFieldSuggestion;
import org.compiere.model.PO;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Borderlayout;
import org.zkoss.zul.Center;
import org.zkoss.zul.Label;
import org.zkoss.zul.South;
import org.zkoss.zul.Textbox;

public class WFieldSuggestion
extends Window
implements EventListener<Event> {
    private static final long serialVersionUID = 6696533431007741092L;
    private ConfirmPanel confirmPanel;
    private MField field;
    private Textbox nameTextbox;
    private Textbox descriptionTextbox;
    private Textbox helpTextbox;

    public WFieldSuggestion(int AD_Field_ID) {
        this.field = new MField(Env.getCtx(), AD_Field_ID, null);
        this.layout();
    }

    private void layout() {
        Borderlayout borderlayout = new Borderlayout();
        this.appendChild((Component)borderlayout);
        borderlayout.setHflex("1");
        borderlayout.setVflex("1");
        Center center = new Center();
        center.setVflex("1");
        center.setHflex("1");
        borderlayout.appendChild((Component)center);
        Grid grid = GridFactory.newGridLayout();
        grid.setVflex(true);
        grid.setHflex("true");
        center.appendChild((Component)grid);
        Columns columns = new Columns();
        grid.appendChild((Component)columns);
        Column column = new Column();
        column.setWidth("25%");
        column.setAlign("right");
        columns.appendChild((Component)column);
        column = new Column();
        column.setWidth("75%");
        column.setAlign("left");
        columns.appendChild((Component)column);
        Rows rows = grid.newRows();
        Row row = rows.newRow();
        row.appendCellChild((Component)new Label(Msg.getElement((Properties)Env.getCtx(), (String)"AD_Field_ID")));
        row.appendCellChild((Component)new Label(this.field.get_Translation("Name")));
        row = rows.newRow();
        row.appendCellChild((Component)new Label(Msg.getElement((Properties)Env.getCtx(), (String)"Name")));
        this.nameTextbox = new Textbox(this.field.get_Translation("Name"));
        this.nameTextbox.setMaxlength(60);
        this.nameTextbox.setHflex("1");
        row.appendCellChild((Component)this.nameTextbox);
        row = rows.newRow();
        row.appendCellChild((Component)new Label(Msg.getElement((Properties)Env.getCtx(), (String)"Description")));
        this.descriptionTextbox = new Textbox(this.field.get_Translation("Description"));
        this.descriptionTextbox.setRows(4);
        this.descriptionTextbox.setMaxlength(255);
        this.descriptionTextbox.setHflex("1");
        this.descriptionTextbox.setMultiline(true);
        row.appendCellChild((Component)this.descriptionTextbox);
        row = rows.newRow();
        row.appendCellChild((Component)new Label(Msg.getElement((Properties)Env.getCtx(), (String)"Help")));
        this.helpTextbox = new Textbox(this.field.get_Translation("Help"));
        this.helpTextbox.setRows(8);
        this.helpTextbox.setMultiline(true);
        this.helpTextbox.setMaxlength(2000);
        this.helpTextbox.setHflex("1");
        row.appendCellChild((Component)this.helpTextbox);
        this.confirmPanel = new ConfirmPanel(true);
        this.confirmPanel.addActionListener(this);
        South southPane = new South();
        southPane.setSclass("dialog-footer");
        borderlayout.appendChild((Component)southPane);
        southPane.appendChild((Component)this.confirmPanel);
        this.setSclass("popup-dialog");
        this.setClosable(true);
        this.setBorder("normal");
        ZKUpdateUtil.setWindowWidthX((HtmlBasedComponent)this, 550);
        ZKUpdateUtil.setWindowHeightX((HtmlBasedComponent)this, 350);
        this.setShadow(true);
        this.setAttribute("mode", "highlighted");
        this.setSizable(true);
        this.setMaximizable(true);
        this.addEventListener("onCancel", e -> this.onCancel());
    }

    public void onEvent(Event event) throws Exception {
        if (event.getTarget() == this.confirmPanel.getButton("Ok")) {
            this.onSave();
        } else if (event.getTarget() == this.confirmPanel.getButton("Cancel")) {
            this.onCancel();
        }
    }

    private void onCancel() {
        this.detach();
    }

    private void onSave() {
        MFieldSuggestion suggestion = new MFieldSuggestion(Env.getCtx(), 0, null);
        suggestion.setClientOrg(0, 0);
        suggestion.setAD_Field_ID(this.field.getAD_Field_ID());
        suggestion.setAD_Language(Env.getAD_Language((Properties)Env.getCtx()));
        suggestion.setAD_Org_ID(0);
        suggestion.setAD_User_ID(Env.getAD_User_ID((Properties)Env.getCtx()));
        suggestion.set_ValueOfColumn("AD_UserClient_ID", (Object)Env.getAD_Client_ID((Properties)Env.getCtx()));
        suggestion.setDescription(this.descriptionTextbox.getText());
        suggestion.setHelp(this.helpTextbox.getText());
        suggestion.setName(this.nameTextbox.getText());
        suggestion.setIsApproved(false);
        suggestion.setIsUpdateBaseLanguage(false);
        suggestion.setProcessed(false);
        try {
            PO.setCrossTenantSafe();
            suggestion.saveEx();
        }
        finally {
            PO.clearCrossTenantSafe();
        }
        Dialog.info(0, Msg.getMsg((Properties)Env.getCtx(), (String)"Your suggestions have been submitted for review"));
        this.detach();
    }
}

