/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.window;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.MChangeLog;
import org.compiere.model.MColumn;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MUser;
import org.compiere.process.DocumentEngine;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.compiere.util.NamePair;
import org.zkoss.util.Pair;
import org.zkoss.zk.ui.Component;
import org.zkoss.zul.Hbox;
import org.zkoss.zul.Html;
import org.zkoss.zul.Vlayout;

public class RecordTimeLinePanel
extends Vlayout {
    private static final long serialVersionUID = 3420422470180313180L;
    private SimpleDateFormat m_dateTimeFormat = DisplayType.getDateFormat((int)16, (Language)Env.getLanguage((Properties)Env.getCtx()));
    private SimpleDateFormat m_dateFormat = DisplayType.getDateFormat((int)15, (Language)Env.getLanguage((Properties)Env.getCtx()));
    private DecimalFormat m_numberFormat = DisplayType.getNumberFormat((int)22, (Language)Env.getLanguage((Properties)Env.getCtx()));
    private DecimalFormat m_amtFormat = DisplayType.getNumberFormat((int)12, (Language)Env.getLanguage((Properties)Env.getCtx()));
    private DecimalFormat m_intFormat = DisplayType.getNumberFormat((int)11, (Language)Env.getLanguage((Properties)Env.getCtx()));

    public RecordTimeLinePanel() {
        this.setStyle("height:100%;width:100%;overflow:auto");
    }

    public void render(GridTab gridTab) {
        block25: {
            this.getChildren().clear();
            if (gridTab == null) {
                return;
            }
            if (gridTab.getRowCount() == 0 || gridTab.isNew()) {
                return;
            }
            int recordId = gridTab.getRecord_ID();
            int tableId = gridTab.getAD_Table_ID();
            ArrayList<String> docActionValues = new ArrayList<String>();
            ArrayList<String> docActionNames = new ArrayList<String>();
            DocumentEngine.readReferenceList(docActionValues, docActionNames, new ArrayList());
            ArrayList docStatusValues = new ArrayList();
            ArrayList docStatusNames = new ArrayList();
            DocumentEngine.readStatusReferenceList(docStatusValues, docStatusNames, new ArrayList());
            String reversedStatusName = null;
            int i = 0;
            while (i < docStatusValues.size()) {
                if ("RE".equals(docStatusValues.get(i))) {
                    reversedStatusName = (String)docStatusNames.get(i);
                }
                ++i;
            }
            StringBuilder sql = new StringBuilder("SELECT u.AD_User_ID, l.created, c.columnName, l.oldValue, l.newValue, l.trxname, l.AD_Column_ID ").append("FROM AD_ChangeLog l ").append("JOIN AD_Column c ON l.ad_column_id=c.ad_column_id ").append("JOIN AD_User u ON l.createdby=u.ad_user_id ").append("WHERE l.AD_Table_ID=? ").append("AND l.Record_ID=? ").append("ORDER BY l.created desc, l.trxName ");
            CPreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                try {
                    stmt = DB.prepareStatement((String)sql.toString(), null);
                    stmt.setInt(1, tableId);
                    stmt.setInt(2, recordId);
                    rs = stmt.executeQuery();
                    ArrayList<String> columns = null;
                    ArrayList<Integer> columnIds = null;
                    ArrayList<Object> changes = null;
                    String currentTrx = null;
                    String currentDocStatusOld = null;
                    String currentDocStatusNew = null;
                    Timestamp updated = null;
                    int userId = -1;
                    while (rs.next()) {
                        GridField field;
                        String columnName = rs.getString(3);
                        String trxName = rs.getString(6);
                        String oldValue = rs.getString(4);
                        String newValue = rs.getString(5);
                        int AD_Column_ID = rs.getInt(7);
                        if (columns == null) {
                            columns = new ArrayList<String>();
                            changes = new ArrayList<Pair<String, String>>();
                            columnIds = new ArrayList<Integer>();
                        }
                        if (currentTrx == null || currentTrx.equals(trxName)) {
                            if (currentTrx == null) {
                                currentTrx = trxName;
                            }
                            if (columnName.equals("DocAction")) continue;
                            if (columnName.equals("DocStatus")) {
                                if (currentDocStatusNew == null) {
                                    currentDocStatusNew = newValue;
                                }
                                currentDocStatusOld = oldValue;
                            } else {
                                field = gridTab.getField(columnName);
                                if (field != null && field.isDisplayed(true)) {
                                    columns.add(field.getHeader());
                                    changes.add((Pair<String, String>)new Pair((Object)oldValue, (Object)newValue));
                                    columnIds.add(AD_Column_ID);
                                }
                            }
                        } else {
                            this.buildChangeLogMessage(gridTab, docActionValues, docActionNames, reversedStatusName, columns, currentDocStatusOld, currentDocStatusNew, updated, userId, changes, columnIds);
                            currentTrx = trxName;
                            currentDocStatusOld = null;
                            currentDocStatusNew = null;
                            columns = new ArrayList();
                            changes = new ArrayList();
                            columnIds = new ArrayList();
                            if (columnName.equals("DocAction")) continue;
                            if (columnName.equals("DocStatus")) {
                                if (currentDocStatusOld == null) {
                                    currentDocStatusOld = oldValue;
                                }
                                currentDocStatusNew = newValue;
                            } else {
                                field = gridTab.getField(columnName);
                                if (field != null && field.isDisplayed(true)) {
                                    columns.add(field.getHeader());
                                    changes.add((Pair<String, String>)new Pair((Object)oldValue, (Object)newValue));
                                    columnIds.add(AD_Column_ID);
                                }
                            }
                        }
                        userId = rs.getInt(1);
                        updated = rs.getTimestamp(2);
                    }
                    this.buildChangeLogMessage(gridTab, docActionValues, docActionNames, reversedStatusName, columns, currentDocStatusOld, currentDocStatusNew, updated, userId, changes, columnIds);
                    if (gridTab != null && gridTab.getValue("CreatedBy") != null) {
                        MUser createdBy = MUser.get((Properties)Env.getCtx(), (int)((Integer)gridTab.getValue("CreatedBy")));
                        StringBuilder sb = new StringBuilder(" ").append(Msg.getMsg((Properties)Env.getCtx(), (String)"Created")).append(" ");
                        if (gridTab.getTabNo() == 0) {
                            sb.append(Env.getContext((Properties)Env.getCtx(), (int)gridTab.getWindowNo(), (String)"_WinInfo_WindowName", (boolean)true));
                        } else {
                            sb.append(gridTab.getName());
                        }
                        this.buildActivityMessage((Timestamp)gridTab.getValue("Created"), sb.toString(), createdBy);
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    DB.close(rs, (Statement)stmt);
                    break block25;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, stmt);
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)stmt);
        }
    }

    public void buildChangeLogMessage(GridTab gridTab, ArrayList<String> docActionValues, ArrayList<String> docActionNames, String reversedStatusName, List<String> columns, String currentDocStatusOld, String currentDocStatusNew, Timestamp updated, int userId, List<Pair<String, String>> changes, List<Integer> columnIds) {
        if (currentDocStatusOld != null && currentDocStatusNew != null) {
            this.buildDocActionMessage(docActionValues, docActionNames, reversedStatusName, updated, new MUser(Env.getCtx(), userId, null), currentDocStatusOld, currentDocStatusNew, gridTab.getWindowNo());
        } else if (columns != null && columns.size() > 0) {
            StringBuilder sb = new StringBuilder(" ");
            sb.append(Msg.getMsg((Properties)Env.getCtx(), (String)"Updated")).append(" ");
            int i = 0;
            while (i < columns.size()) {
                if (i > 0) {
                    if (i + 1 == columns.size()) {
                        sb.append(" ").append(Msg.getMsg((Properties)Env.getCtx(), (String)"AND").toLowerCase()).append(" ");
                    } else {
                        sb.append(", ");
                    }
                }
                MColumn column = MColumn.get((Properties)Env.getCtx(), (int)columnIds.get(i));
                Pair<String, String> change = changes.get(i);
                String oldValue = (String)change.getX();
                String newValue = (String)change.getY();
                if (oldValue != null && oldValue.equals(MChangeLog.NULL)) {
                    oldValue = null;
                }
                if (newValue != null && newValue.equals(MChangeLog.NULL)) {
                    newValue = null;
                }
                String showOldValue = oldValue;
                String showNewValue = newValue;
                try {
                    if (!DisplayType.isText((int)column.getAD_Reference_ID())) {
                        if (column.getAD_Reference_ID() == 20) {
                            boolean yes;
                            if (oldValue != null) {
                                yes = oldValue.equals("true") || oldValue.equals("Y");
                                showOldValue = Msg.getMsg((Properties)Env.getCtx(), (String)(yes ? "Y" : "N"));
                            }
                            if (newValue != null) {
                                yes = newValue.equals("true") || newValue.equals("Y");
                                showNewValue = Msg.getMsg((Properties)Env.getCtx(), (String)(yes ? "Y" : "N"));
                            }
                        } else if (column.getAD_Reference_ID() == 12) {
                            if (oldValue != null) {
                                showOldValue = this.m_amtFormat.format(new BigDecimal(oldValue));
                            }
                            if (newValue != null) {
                                showNewValue = this.m_amtFormat.format(new BigDecimal(newValue));
                            }
                        } else if (column.getAD_Reference_ID() == 11) {
                            if (oldValue != null) {
                                showOldValue = this.m_intFormat.format(Integer.valueOf(oldValue));
                            }
                            if (newValue != null) {
                                showNewValue = this.m_intFormat.format(Integer.valueOf(newValue));
                            }
                        } else if (DisplayType.isNumeric((int)column.getAD_Reference_ID())) {
                            if (oldValue != null) {
                                showOldValue = this.m_numberFormat.format(new BigDecimal(oldValue));
                            }
                            if (newValue != null) {
                                showNewValue = this.m_numberFormat.format(new BigDecimal(newValue));
                            }
                        } else if (column.getAD_Reference_ID() == 15) {
                            if (oldValue != null) {
                                showOldValue = this.m_dateFormat.format(Timestamp.valueOf(oldValue));
                            }
                            if (newValue != null) {
                                showNewValue = this.m_dateFormat.format(Timestamp.valueOf(newValue));
                            }
                        } else if (column.getAD_Reference_ID() == 16) {
                            if (oldValue != null) {
                                showOldValue = this.m_dateTimeFormat.format(Timestamp.valueOf(oldValue));
                            }
                            if (newValue != null) {
                                showNewValue = this.m_dateTimeFormat.format(Timestamp.valueOf(newValue));
                            }
                        } else if (DisplayType.isLookup((int)column.getAD_Reference_ID())) {
                            String key;
                            NamePair pp;
                            MLookup lookup = MLookupFactory.get((Properties)Env.getCtx(), (int)0, (int)column.getAD_Column_ID(), (int)column.getAD_Reference_ID(), (Language)Env.getLanguage((Properties)Env.getCtx()), (String)column.getColumnName(), (int)column.getAD_Reference_Value_ID(), (boolean)column.isParent(), null);
                            if (oldValue != null && (pp = lookup.get((Object)(key = oldValue))) != null) {
                                showOldValue = pp.getName();
                            }
                            if (newValue != null && (pp = lookup.get((Object)(key = newValue))) != null) {
                                showNewValue = pp.getName();
                            }
                        } else if (DisplayType.isLOB((int)column.getAD_Reference_ID())) {
                            // empty if block
                        }
                    }
                }
                catch (Exception e) {
                    CLogger.getCLogger(((Object)((Object)this)).getClass()).log(Level.WARNING, String.valueOf(oldValue) + "->" + newValue, (Throwable)e);
                }
                sb.append("<i>").append(columns.get(i));
                sb.append(" (").append(showOldValue != null ? showOldValue : "").append(" > ").append(showNewValue != null ? showNewValue : "").append(")");
                sb.append("</i>");
                ++i;
            }
            this.buildActivityMessage(updated, sb.toString(), new MUser(Env.getCtx(), userId, null));
        }
    }

    private void buildDocActionMessage(ArrayList<String> docActionValues, ArrayList<String> docActionNames, String reversedStatusName, Timestamp updated, MUser user, String fromStatus, String toStatus, int windowNo) {
        String docAction = null;
        if ("CO".equals(toStatus)) {
            docAction = "CO";
        } else if ("AP".equals(toStatus)) {
            docAction = "AP";
        } else if ("VO".equals(toStatus)) {
            docAction = "VO";
        } else if ("RE".equals(toStatus)) {
            docAction = "RA";
        } else if ("NA".equals(toStatus)) {
            docAction = "RJ";
        } else if ("IP".equals(toStatus)) {
            if ("CO".equals(fromStatus)) {
                docAction = "RE";
            } else if ("DR".equals(fromStatus) || "IN".equals(fromStatus)) {
                docAction = "PR";
            }
        } else if ("CL".equals(toStatus)) {
            docAction = "CL";
        } else if ("IN".equals(toStatus)) {
            docAction = "IN";
        }
        if (docAction == null) {
            return;
        }
        String docActionName = null;
        if ("RA".equals(docAction) || "RC".equals(docAction)) {
            docActionName = reversedStatusName;
        } else {
            int i = 0;
            while (i < docActionValues.size()) {
                if (docActionValues.get(i).equals(docAction)) {
                    docActionName = docActionNames.get(i);
                    break;
                }
                ++i;
            }
        }
        StringBuilder sb = new StringBuilder("<i>").append(docActionName).append("</i>").append(" ").append(Env.getContext((Properties)Env.getCtx(), (int)windowNo, (String)"_WinInfo_WindowName", (boolean)true));
        this.buildActivityMessage(updated, sb.toString(), user);
    }

    private void buildActivityMessage(Timestamp activityDate, String activityMessage, MUser user) {
        StringBuilder sb = new StringBuilder();
        sb.append("<div class=\"help-content\">\n");
        sb.append("<strong>").append(user.getName()).append("</strong> ").append(activityMessage);
        sb.append("<div>&nbsp;</div><div>").append(this.m_dateTimeFormat.format(activityDate)).append("</div>");
        sb.append("</div>");
        Hbox hlayout = new Hbox();
        hlayout.setHflex("1");
        String hlayoutClass = "activity-card";
        if (this.getChildren().size() > 0) {
            hlayoutClass = String.valueOf(hlayoutClass) + " activity-card-spacing";
        }
        hlayout.setSclass(hlayoutClass);
        this.appendChild((Component)hlayout);
        Html contents = new Html();
        contents.setContent(sb.toString());
        hlayout.appendChild((Component)contents);
    }
}

