/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.window;

import java.sql.Timestamp;
import java.util.Locale;
import java.util.Properties;
import javax.servlet.http.HttpSession;
import org.adempiere.util.Callback;
import org.adempiere.webui.IWebClient;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.panel.ChangePasswordPanel;
import org.adempiere.webui.panel.LoginPanel;
import org.adempiere.webui.panel.ResetPasswordPanel;
import org.adempiere.webui.panel.RolePanel;
import org.adempiere.webui.panel.ValidateMFAPanel;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.window.Dialog;
import org.compiere.model.MSysConfig;
import org.compiere.model.MUser;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Login;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;
import org.compiere.util.Util;
import org.zkoss.util.Locales;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.Session;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.metainfo.PageDefinition;
import org.zkoss.zk.ui.util.Clients;

public class LoginWindow
extends Window
implements EventListener<Event> {
    private static final long serialVersionUID = 8570332386555237381L;
    protected IWebClient app;
    protected Properties ctx;
    protected LoginPanel pnlLogin;
    protected ResetPasswordPanel pnlResetPassword;
    protected ChangePasswordPanel pnlChangePassword;
    protected ValidateMFAPanel pnlValidateMFA = null;
    protected RolePanel pnlRole;
    private static final String ON_DEFER_LOGOUT = "onDeferLogout";

    public void init(IWebClient app) {
        this.ctx = Env.getCtx();
        this.app = app;
        this.initComponents();
        this.appendChild((Component)this.pnlLogin);
        this.setStyle("background-color: transparent");
        this.addEventListener("onOK", this);
        this.addEventListener(ON_DEFER_LOGOUT, this);
        this.setWidgetListener("onOK", "zAu.cmd0.showBusy(null)");
    }

    private void initComponents() {
        this.createLoginPanel();
    }

    protected void createLoginPanel() {
        this.pnlLogin = new LoginPanel(this.ctx, this);
    }

    public void loginOk(String userName, boolean show, KeyNamePair[] clientsKNPairs) {
        boolean isClientDefined;
        boolean bl = isClientDefined = clientsKNPairs.length == 1 || !Util.isEmpty((String)Env.getContext((Properties)this.ctx, (String)"#AD_User_ID"));
        if (this.pnlRole == null) {
            this.pnlRole = new RolePanel(this.ctx, this, userName, show, clientsKNPairs, isClientDefined);
        }
        if (isClientDefined) {
            this.createValidateMFAPanel(null, isClientDefined, userName, show, clientsKNPairs);
        } else {
            this.showRolePanel(userName, show, clientsKNPairs, isClientDefined, false);
            if (!this.pnlRole.show()) {
                this.createValidateMFAPanel(null, isClientDefined, userName, show, clientsKNPairs);
            }
        }
    }

    public void showRolePanel(String userName, boolean show, KeyNamePair[] clientsKNPairs, boolean isClientDefined, boolean isMFAValidated) {
        this.getChildren().clear();
        if (this.pnlRole.show()) {
            this.appendChild((Component)this.pnlRole);
        } else if (isMFAValidated) {
            this.pnlRole.validateRoles(isMFAValidated);
        } else if (!isClientDefined) {
            if (this.pnlValidateMFA == null) {
                this.createValidateMFAPanel(null, isClientDefined, userName, show, clientsKNPairs);
            } else {
                this.appendChild((Component)this.pnlValidateMFA);
            }
        }
    }

    public void changePassword(String userName, String userPassword, boolean show, KeyNamePair[] clientsKNPairs) {
        Clients.clearBusy();
        this.createChangePasswordPanel(userName, userPassword, show, clientsKNPairs);
        this.getChildren().clear();
        this.appendChild((Component)this.pnlChangePassword);
    }

    protected void createChangePasswordPanel(String userName, String userPassword, boolean show, KeyNamePair[] clientsKNPairs) {
        this.pnlChangePassword = new ChangePasswordPanel(this.ctx, this, userName, userPassword, show, clientsKNPairs);
    }

    public void resetPassword(String userName, boolean noSecurityQuestion) {
        this.createResetPasswordPanel(userName, noSecurityQuestion);
        this.getChildren().clear();
        this.appendChild((Component)this.pnlResetPassword);
    }

    protected void createResetPasswordPanel(String userName, boolean noSecurityQuestion) {
        this.pnlResetPassword = new ResetPasswordPanel(this.ctx, this, userName, noSecurityQuestion);
    }

    public void validateMFA(KeyNamePair orgKNPair, boolean isClientDefined, String userName, boolean show, KeyNamePair[] clientsKNPairs) {
        Clients.clearBusy();
        this.createValidateMFAPanel(orgKNPair, isClientDefined, userName, show, clientsKNPairs);
    }

    private void createValidateMFAPanel(KeyNamePair orgKNPair, boolean isClientDefined, String userName, boolean show, KeyNamePair[] clientsKNPairs) {
        if (this.pnlValidateMFA == null) {
            this.pnlValidateMFA = new ValidateMFAPanel(this.ctx, this, orgKNPair, isClientDefined, userName, show, clientsKNPairs);
        }
        if (this.pnlValidateMFA.show()) {
            this.getChildren().clear();
            this.appendChild((Component)this.pnlValidateMFA);
        }
    }

    public void loginCompleted(Login login, KeyNamePair m_orgKNPair, final Window component) {
        String msg;
        Session currSess = Executions.getCurrent().getDesktop().getSession();
        HttpSession httpSess = (HttpSession)currSess.getNativeSession();
        int timeout = MSysConfig.getIntValue((String)"ZK_SESSION_TIMEOUT_IN_SECONDS", (int)-2, (int)Env.getAD_Client_ID((Properties)Env.getCtx()), (int)Env.getAD_Org_ID((Properties)Env.getCtx()));
        if (timeout != -2) {
            httpSess.setMaxInactiveInterval(timeout);
        }
        if (!Util.isEmpty((String)(msg = login.validateLogin(m_orgKNPair)))) {
            Env.getCtx().clear();
            Dialog.error(0, "Error", msg, new Callback<Integer>(){

                public void onCallback(Integer result) {
                    Events.echoEvent((Event)new Event(LoginWindow.ON_DEFER_LOGOUT, (Component)component));
                }
            });
            return;
        }
        if (!MUser.get((Properties)Env.getCtx()).isNoPasswordReset()) {
            int notifyDay = MSysConfig.getIntValue((String)"USER_LOCKING_PASSWORD_NOTIFY_DAY", (int)0);
            int pwdAgeDay = MSysConfig.getIntValue((String)"USER_LOCKING_MAX_PASSWORD_AGE_DAY", (int)0);
            if (notifyDay > 0 && pwdAgeDay > 0) {
                Timestamp limit = TimeUtil.addDays((Timestamp)MUser.get((Properties)Env.getCtx()).getDatePasswordChanged(), (int)pwdAgeDay);
                Timestamp notifyAfter = TimeUtil.addDays((Timestamp)limit, (int)(-notifyDay));
                Timestamp now = TimeUtil.getDay(null);
                if (now.after(notifyAfter)) {
                    Dialog.warn(0, "", Msg.getMsg((Properties)Env.getCtx(), (String)"YourPasswordWillExpireInDays", (Object[])new Object[]{TimeUtil.getDaysBetween((Timestamp)now, (Timestamp)limit)}));
                }
            }
        }
        this.app.loginCompleted();
    }

    public void loginCancelled() {
        this.createLoginPanel();
        this.getChildren().clear();
        this.appendChild((Component)this.pnlLogin);
    }

    public void onEvent(Event event) {
        if ("onOK".equals(event.getName())) {
            RolePanel rolePanel = (RolePanel)this.getFellowIfAny("rolePanel");
            if (rolePanel != null) {
                rolePanel.validateRoles(false);
                return;
            }
            LoginPanel loginPanel = (LoginPanel)this.getFellowIfAny("loginPanel");
            if (loginPanel != null) {
                loginPanel.validateLogin();
                return;
            }
            ChangePasswordPanel changePasswordPanel = (ChangePasswordPanel)this.getFellowIfAny("changePasswordPanel");
            if (changePasswordPanel != null) {
                changePasswordPanel.validateChangePassword();
                return;
            }
            ResetPasswordPanel resetPasswordPanel = (ResetPasswordPanel)this.getFellowIfAny("resetPasswordPanel");
            if (resetPasswordPanel != null) {
                resetPasswordPanel.validate();
                return;
            }
            ValidateMFAPanel validateMFAPanel = (ValidateMFAPanel)this.getFellowIfAny("validateMFAPanel");
            if (validateMFAPanel != null) {
                validateMFAPanel.validateMFAComplete(true);
                return;
            }
        } else if (ON_DEFER_LOGOUT.equals(event.getName())) {
            SessionManager.logoutSession();
        }
    }

    public void changeRole(Locale locale, Properties ctx) {
        Env.setCtx((Properties)ctx);
        Env.setContext((Properties)ctx, (String)"#AD_Org_ID_ChangeRole", (int)Env.getAD_Org_ID((Properties)ctx));
        Env.setContext((Properties)ctx, (String)"#AD_Org_ID", (String)"");
        this.getDesktop().getSession().setAttribute("WebUISessionContext", (Object)ctx);
        PageDefinition pageDefintion = Executions.getCurrent().getPageDefinition(ThemeManager.getThemeResource("preference.zul"));
        Executions.createComponents((PageDefinition)pageDefintion, (Component)this, null);
        this.getDesktop().getSession().setAttribute("org.zkoss.web.preferred.locale", (Object)locale);
        Locales.setThreadLocal((Locale)locale);
        Login login = new Login(Env.getCtx());
        MUser user = MUser.get((Properties)ctx, (int)Env.getAD_User_ID((Properties)ctx));
        boolean email_login = MSysConfig.getBooleanValue((String)"USE_EMAIL_FOR_LOGIN", (boolean)false);
        String loginName = email_login ? user.getEMail() : (user.getLDAPUser() != null ? user.getLDAPUser() : user.getName());
        this.loginOk(loginName, true, login.getClients());
        this.getDesktop().getSession().setAttribute("Check_AD_User_ID", (Object)Env.getAD_User_ID((Properties)ctx));
        this.pnlRole.setChangeRole(true);
        this.pnlRole.changeRole(ctx);
    }

    @Override
    public void onPageDetached(Page page) {
        this.setWidgetListener("onOK", null);
        super.onPageDetached(page);
    }
}

