/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.window;

import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.adempiere.exceptions.DBException;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.adwindow.AbstractADWindowContent;
import org.adempiere.webui.component.Button;
import org.adempiere.webui.component.Checkbox;
import org.adempiere.webui.component.Column;
import org.adempiere.webui.component.Columns;
import org.adempiere.webui.component.ComboItem;
import org.adempiere.webui.component.Combobox;
import org.adempiere.webui.component.DatetimeBox;
import org.adempiere.webui.component.Grid;
import org.adempiere.webui.component.Group;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.ListCell;
import org.adempiere.webui.component.ListHead;
import org.adempiere.webui.component.ListHeader;
import org.adempiere.webui.component.ListItem;
import org.adempiere.webui.component.Listbox;
import org.adempiere.webui.component.Panel;
import org.adempiere.webui.component.Row;
import org.adempiere.webui.component.Rows;
import org.adempiere.webui.component.Tabpanel;
import org.adempiere.webui.component.Textbox;
import org.adempiere.webui.component.ToolBar;
import org.adempiere.webui.component.ToolBarButton;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.editor.WDateEditor;
import org.adempiere.webui.editor.WEditor;
import org.adempiere.webui.editor.WNumberEditor;
import org.adempiere.webui.editor.WPaymentEditor;
import org.adempiere.webui.editor.WStringEditor;
import org.adempiere.webui.editor.WTableDirEditor;
import org.adempiere.webui.editor.WebEditorFactory;
import org.adempiere.webui.event.DialogEvents;
import org.adempiere.webui.event.ValueChangeEvent;
import org.adempiere.webui.event.ValueChangeListener;
import org.adempiere.webui.factory.ButtonFactory;
import org.adempiere.webui.panel.StatusBarPanel;
import org.adempiere.webui.part.MultiTabPart;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.DateRangeButton;
import org.adempiere.webui.window.Dialog;
import org.compiere.model.GridField;
import org.compiere.model.GridFieldVO;
import org.compiere.model.GridTab;
import org.compiere.model.Lookup;
import org.compiere.model.MAttribute;
import org.compiere.model.MColumn;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MLookupInfo;
import org.compiere.model.MQuery;
import org.compiere.model.MRole;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTab;
import org.compiere.model.MTable;
import org.compiere.model.MUserQuery;
import org.compiere.model.Query;
import org.compiere.util.AdempiereSystemError;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.compiere.util.ValueNamePair;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuFocus;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Components;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.Borderlayout;
import org.zkoss.zul.Cell;
import org.zkoss.zul.Center;
import org.zkoss.zul.Comboitem;
import org.zkoss.zul.Datebox;
import org.zkoss.zul.Div;
import org.zkoss.zul.Hbox;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.ListModelList;
import org.zkoss.zul.Listitem;
import org.zkoss.zul.North;
import org.zkoss.zul.Separator;
import org.zkoss.zul.SimpleListModel;
import org.zkoss.zul.South;
import org.zkoss.zul.Space;
import org.zkoss.zul.Tab;
import org.zkoss.zul.Vlayout;

public class FindWindow
extends Window
implements EventListener<Event>,
ValueChangeListener,
DialogEvents {
    private static final long serialVersionUID = -5087378621976257241L;
    private static final String FIND_ROW_EDITOR = "find.row.editor";
    private static final String FIND_ROW_EDITOR_TO = "find.row.editor.to";
    private static final String HISTORY_DAY_ALL = "All";
    private static final String HISTORY_DAY_YEAR = "Year";
    private static final String HISTORY_DAY_MONTH = "Month";
    private static final String HISTORY_DAY_WEEK = "Week";
    private static final String HISTORY_DAY_DAY = "Day";
    ValueNamePair[] historyItems = new ValueNamePair[]{new ValueNamePair("", " "), new ValueNamePair("All", Msg.getMsg((Properties)Env.getCtx(), (String)"All")), new ValueNamePair("Year", Msg.getMsg((Properties)Env.getCtx(), (String)"Year")), new ValueNamePair("Month", Msg.getMsg((Properties)Env.getCtx(), (String)"Month")), new ValueNamePair("Week", Msg.getMsg((Properties)Env.getCtx(), (String)"Week")), new ValueNamePair("Day", Msg.getMsg((Properties)Env.getCtx(), (String)"Day"))};
    private static final String HISTORY_LABEL = "History";
    private MultiTabPart winMain;
    private Window winLookupRecord;
    private Window winAdvanced;
    private Combobox fQueryName;
    private Listbox advancedPanel;
    private Grid contentSimple;
    private int m_targetWindowNo;
    private int m_targetTabNo;
    private int m_AD_Table_ID;
    private String m_tableName;
    private String m_whereExtended;
    private GridField[] m_findFields;
    private GridTab m_gridTab = null;
    private MQuery m_query = null;
    private boolean m_isCancel = false;
    private static final CLogger log = CLogger.getCLogger(FindWindow.class);
    private int m_total;
    private boolean initialSlowQuery = false;
    private MTab[] m_tabs;
    private ArrayList<WEditor> m_sEditors = new ArrayList();
    private ArrayList<ToolBarButton> m_sEditorsFlag = new ArrayList();
    private ArrayList<WEditor> m_sEditorsTo = new ArrayList();
    public static final int TABNO = 99;
    public static final int FIELDLENGTH = 20;
    private int m_AD_Tab_ID = 0;
    private String m_AD_Tab_UU = null;
    private MUserQuery[] userQueries;
    private Rows contentSimpleRows;
    private boolean m_createNew = false;
    private boolean isvalid = true;
    private int m_minRecords;
    private String m_title;
    private ToolBarButton btnSave;
    private ToolBarButton btnShare;
    private Label msgLabel;
    public static final int INDEX_COLUMNNAME = 0;
    public static final int INDEX_OPERATOR = 1;
    public static final int INDEX_VALUE = 2;
    public static final int INDEX_VALUE2 = 3;
    public static final int INDEX_ANDOR = 4;
    public static final int INDEX_LEFTBRACKET = 5;
    public static final int INDEX_RIGHTBRACKET = 6;
    public static final int INDEX_HISTORY = 1;
    public static final int INDEX_TABLE = 7;
    private String m_sNew;
    private static final String FIELD_SEPARATOR = "<^>";
    private static final String SEGMENT_SEPARATOR = "<~>";
    private static final String HISTORY_SEPARATOR = "<#>";
    private Combobox historyCombo = new Combobox();
    private Properties m_simpleCtx;
    private Properties m_advanceCtx;
    private int rowCount;
    private static final String ON_POST_VISIBLE_ATTR = "onPostVisible.Event.Posted";
    private static final int COUNTING_RECORDS_TIMED_OUT = -255;
    private StatusBarPanel statusBar = new StatusBarPanel();
    private String m_whereUserQuery;
    private ToolBar advancedPanelToolBar;
    private int m_AD_UserQuery_ID = 0;
    private AbstractADWindowContent m_windowPanel;
    private static final String COLUMNNAME_M_AttributeSetInstance_ID = "M_AttributeSetInstance_ID";

    public FindWindow(int targetWindowNo, int targetTabNo, String title, int AD_Table_ID, String tableName, String whereExtended, GridField[] findFields, int minRecords, int adTabId) {
        this(targetWindowNo, targetTabNo, title, AD_Table_ID, tableName, whereExtended, findFields, minRecords, adTabId, null);
    }

    public FindWindow(int targetWindowNo, int targetTabNo, String title, int AD_Table_ID, String tableName, String whereExtended, GridField[] findFields, int minRecords, int adTabId, AbstractADWindowContent windowPanel) {
        this.m_targetWindowNo = targetWindowNo;
        this.m_targetTabNo = targetTabNo;
        this.m_title = title;
        this.m_AD_Table_ID = AD_Table_ID;
        this.m_tableName = tableName;
        this.m_whereExtended = whereExtended;
        this.m_findFields = findFields;
        if (findFields != null && findFields.length > 0) {
            this.m_gridTab = findFields[0].getGridTab();
        }
        this.m_sNew = "** ".concat(Msg.getMsg((Properties)Env.getCtx(), (String)"New Query")).concat(" **");
        this.m_AD_Tab_ID = adTabId;
        this.m_AD_Tab_UU = MTab.get((int)adTabId).getAD_Tab_UU();
        this.m_minRecords = minRecords;
        this.m_isCancel = true;
        this.m_windowPanel = windowPanel;
        this.m_simpleCtx = new Properties(Env.getCtx());
        this.m_advanceCtx = new Properties(Env.getCtx());
        this.setBorder("normal");
        this.setShadow(false);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this, "900px");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this, "350px");
        this.setTitle(String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"Find").replaceAll("&", "")) + ": " + title);
        this.setClosable(false);
        this.setSizable(true);
        this.setMaximizable(false);
        this.setWidgetAttribute("instanceName", "findWindow");
        this.setId("findWindow_" + targetWindowNo + "_" + targetTabNo);
        LayoutUtils.addSclass("find-window", (HtmlBasedComponent)this);
        this.addEventListener("onCancel", e -> this.onCancel());
        this.setFireWindowCloseEventOnDetach(false);
    }

    public boolean initialize() {
        this.m_query = new MQuery(this.m_tableName);
        this.m_query.addRestriction(this.m_whereExtended);
        Env.setContext((Properties)Env.getCtx(), (int)this.m_targetWindowNo, (String)"Find_Table_ID", (int)this.m_AD_Table_ID);
        this.initPanel();
        this.initFind();
        this.initFindAdvanced();
        if (this.m_total != -255 && this.m_total < this.m_minRecords) {
            return false;
        }
        if (!this.winMain.getComponent().getTabpanel(0).isVisible()) {
            this.winMain.getComponent().setSelectedIndex(1);
            this.onAdvanceTabSelected();
        }
        return true;
    }

    public boolean validate(int targetWindowNo, String title, int AD_Table_ID, String tableName, String whereExtended, GridField[] findFields, int minRecords, int adTabId) {
        if (this.m_targetWindowNo != targetWindowNo) {
            return false;
        }
        if (title == null && this.m_title != null || title != null && this.m_title == null || !title.equals(this.m_title)) {
            return false;
        }
        if (AD_Table_ID != this.m_AD_Table_ID) {
            return false;
        }
        if (tableName == null && this.m_tableName != null || tableName != null && this.m_tableName == null || !tableName.equals(this.m_tableName)) {
            return false;
        }
        if (whereExtended.contains("@")) {
            whereExtended = Env.parseContext((Properties)Env.getCtx(), (int)targetWindowNo, (String)whereExtended, (boolean)false);
        }
        if (this.m_whereExtended.contains("@")) {
            this.m_whereExtended = Env.parseContext((Properties)Env.getCtx(), (int)targetWindowNo, (String)whereExtended, (boolean)false);
        }
        if (whereExtended == null && this.m_whereExtended != null || whereExtended != null && this.m_whereExtended == null || !whereExtended.equals(this.m_whereExtended)) {
            return false;
        }
        if (adTabId != this.m_AD_Tab_ID) {
            return false;
        }
        if (findFields == null && this.m_findFields != null || findFields != null && this.m_findFields == null || findFields.length != this.m_findFields.length) {
            return false;
        }
        if (findFields != null && findFields.length > 0) {
            int i = 0;
            while (i < findFields.length) {
                if (this.m_findFields[i] != null && findFields[i].getAD_Field_ID() != this.m_findFields[i].getAD_Field_ID()) {
                    return false;
                }
                ++i;
            }
        }
        this.m_minRecords = minRecords;
        this.m_total = this.getNoOfRecords(null, false);
        if (this.m_total != -255 && this.m_total < this.m_minRecords) {
            return false;
        }
        this.m_query = new MQuery(this.m_tableName);
        this.m_query.addRestriction(this.m_whereExtended);
        return true;
    }

    private void initSimple() {
        Button btnNew = ButtonFactory.createNamedButton("New");
        btnNew.setId("btnNew");
        btnNew.addEventListener("onClick", this);
        Button btnClear = ButtonFactory.createNamedButton("Reset");
        btnClear.setId("btnReset");
        btnClear.addEventListener("onClick", this);
        Button btnOk = ButtonFactory.createNamedButton("Ok");
        btnOk.setName("btnOkSimple");
        btnOk.setId("btnOk");
        btnOk.addEventListener("onClick", this);
        Button btnCancel = ButtonFactory.createNamedButton("Cancel");
        btnCancel.setId("btnCancel");
        btnCancel.addEventListener("onClick", this);
        Panel pnlButtonRight = new Panel();
        pnlButtonRight.appendChild((Component)btnOk);
        Separator sep = new Separator("vertical");
        sep.setWidth("2px");
        pnlButtonRight.appendChild((Component)sep);
        pnlButtonRight.appendChild((Component)btnCancel);
        pnlButtonRight.setStyle("text-align:right");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)pnlButtonRight, "100%");
        ZKUpdateUtil.setHflex((HtmlBasedComponent)pnlButtonRight, "1");
        Panel pnlButtonLeft = new Panel();
        pnlButtonLeft.appendChild((Component)btnNew);
        sep = new Separator("vertical");
        sep.setWidth("2px");
        pnlButtonLeft.appendChild((Component)sep);
        pnlButtonLeft.appendChild((Component)btnClear);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)pnlButtonLeft, "1");
        Hbox hboxButton = new Hbox();
        hboxButton.appendChild((Component)pnlButtonLeft);
        hboxButton.appendChild((Component)pnlButtonRight);
        this.contentSimple = new Grid();
        this.contentSimple.setId("contentSimple");
        this.contentSimple.makeNoStrip();
        Columns columns = new Columns();
        Column column = new Column();
        column.setAlign("right");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)column, "30%");
        columns.appendChild((Component)column);
        column = new Column();
        column.setAlign("left");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)column, "50%");
        columns.appendChild((Component)column);
        column = new Column();
        ZKUpdateUtil.setWidth((HtmlBasedComponent)column, "20%");
        columns.appendChild((Component)column);
        this.contentSimple.appendChild((Component)columns);
        this.contentSimpleRows = new Rows();
        this.contentSimple.appendChild((Component)this.contentSimpleRows);
        ZKUpdateUtil.setVflex(this.contentSimple, true);
        Borderlayout layout = new Borderlayout();
        ZKUpdateUtil.setHflex((HtmlBasedComponent)layout, "1");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)layout, "1");
        this.winLookupRecord.appendChild((Component)layout);
        Center center = new Center();
        layout.appendChild((Component)center);
        center.appendChild((Component)this.contentSimple);
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.contentSimple, "1");
        South south = new South();
        layout.appendChild((Component)south);
        south.appendChild((Component)hboxButton);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.winLookupRecord, "100%");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this.winLookupRecord, "100%");
        this.winLookupRecord.addEventListener("onOK", this);
        LayoutUtils.addSclass("find-window-simple", (HtmlBasedComponent)this.winLookupRecord);
    }

    private void initAdvanced() {
        ToolBarButton btnNew = new ToolBarButton();
        if (ThemeManager.isUseFontIconForImage()) {
            btnNew.setIconSclass("z-icon-New");
        } else {
            btnNew.setImage(ThemeManager.getThemeResource("images/New24.png"));
        }
        btnNew.setAttribute("name", "btnNewAdv");
        btnNew.addEventListener("onClick", this);
        ToolBarButton btnDelete = new ToolBarButton();
        btnDelete.setAttribute("name", "btnDeleteAdv");
        if (ThemeManager.isUseFontIconForImage()) {
            btnDelete.setIconSclass("z-icon-Delete");
        } else {
            btnDelete.setImage(ThemeManager.getThemeResource("images/Delete24.png"));
        }
        btnDelete.addEventListener("onClick", this);
        Button btnOk = ButtonFactory.createNamedButton("Ok");
        btnOk.setName("btnOkAdv");
        btnOk.addEventListener("onClick", this);
        Button btnCancel = ButtonFactory.createNamedButton("Cancel");
        btnCancel.addEventListener("onClick", this);
        Panel pnlButtonRight = new Panel();
        pnlButtonRight.appendChild((Component)btnOk);
        Separator sep = new Separator("vertical");
        sep.setWidth("2px");
        pnlButtonRight.appendChild((Component)sep);
        pnlButtonRight.appendChild((Component)btnCancel);
        pnlButtonRight.setStyle("text-align: right");
        this.advancedPanelToolBar = new ToolBar();
        this.advancedPanelToolBar.appendChild((Component)btnNew);
        this.advancedPanelToolBar.appendChild((Component)btnDelete);
        this.fQueryName.addEventListener("onSelect", this);
        Hbox confirmPanel = new Hbox();
        confirmPanel.appendChild((Component)pnlButtonRight);
        confirmPanel.setPack("end");
        this.advancedPanel = new Listbox();
        ListHead listhead = new ListHead();
        listhead.setSizable(true);
        ListHeader lstHAndOr = new ListHeader();
        lstHAndOr.setLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"And/Or"));
        ZKUpdateUtil.setWidth((HtmlBasedComponent)lstHAndOr, "60px");
        ListHeader lstHLeftBracket = new ListHeader();
        lstHLeftBracket.setLabel("(");
        lstHLeftBracket.setAlign("center");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)lstHLeftBracket, "50px");
        ListHeader lstHTable = new ListHeader();
        lstHTable.setLabel(Msg.translate((Properties)Env.getCtx(), (String)"AD_Tab_ID"));
        ZKUpdateUtil.setWidth((HtmlBasedComponent)lstHTable, "12%");
        ListHeader lstHColumn = new ListHeader();
        lstHColumn.setLabel(Msg.translate((Properties)Env.getCtx(), (String)"AD_Field_ID"));
        ZKUpdateUtil.setWidth((HtmlBasedComponent)lstHColumn, "18%");
        ListHeader lstHOperator = new ListHeader();
        lstHOperator.setLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"Operator"));
        ZKUpdateUtil.setWidth((HtmlBasedComponent)lstHOperator, "70px");
        ListHeader lstHQueryValue = new ListHeader();
        lstHQueryValue.setLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"QueryValue"));
        ZKUpdateUtil.setWidth((HtmlBasedComponent)lstHQueryValue, "24%");
        ListHeader lstHQueryTo = new ListHeader();
        lstHQueryTo.setLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"QueryValue2"));
        ZKUpdateUtil.setWidth((HtmlBasedComponent)lstHQueryTo, "20%");
        ListHeader lstHRightBracket = new ListHeader();
        lstHRightBracket.setLabel(")");
        lstHRightBracket.setAlign("center");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)lstHRightBracket, "50px");
        if (ClientInfo.maxWidth(699)) {
            ZKUpdateUtil.setWidth((HtmlBasedComponent)lstHColumn, "200px");
            ZKUpdateUtil.setWidth((HtmlBasedComponent)lstHQueryValue, "200px");
            ZKUpdateUtil.setWidth((HtmlBasedComponent)lstHQueryTo, "200px");
        }
        listhead.appendChild((Component)lstHAndOr);
        listhead.appendChild((Component)lstHLeftBracket);
        listhead.appendChild((Component)lstHTable);
        listhead.appendChild((Component)lstHColumn);
        listhead.appendChild((Component)lstHOperator);
        listhead.appendChild((Component)lstHQueryValue);
        listhead.appendChild((Component)lstHQueryTo);
        listhead.appendChild((Component)lstHRightBracket);
        this.advancedPanel.appendChild((Component)listhead);
        ZKUpdateUtil.setVflex(this.advancedPanel, true);
        Borderlayout layout = new Borderlayout();
        ZKUpdateUtil.setHflex((HtmlBasedComponent)layout, "1");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)layout, "1");
        this.winAdvanced.appendChild((Component)layout);
        North north = new North();
        layout.appendChild((Component)north);
        north.appendChild((Component)this.advancedPanelToolBar);
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.advancedPanelToolBar, "0");
        Center center = new Center();
        layout.appendChild((Component)center);
        center.appendChild((Component)this.advancedPanel);
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.advancedPanel, "1");
        South south = new South();
        layout.appendChild((Component)south);
        south.appendChild((Component)confirmPanel);
        ZKUpdateUtil.setVflex((HtmlBasedComponent)south, "min");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this.winAdvanced, "100%");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.winAdvanced, "100%");
        this.winAdvanced.addEventListener("onOK", this);
        LayoutUtils.addSclass("find-window-advanced", (HtmlBasedComponent)this.winAdvanced);
    }

    private void initPanel() {
        this.setShadow(true);
        Vlayout layout = new Vlayout();
        layout.setStyle("height: 100%; width: 100%; position: relative;");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)layout, "1");
        this.appendChild((Component)layout);
        Div div = new Div();
        ZKUpdateUtil.setVflex((HtmlBasedComponent)div, "0");
        layout.appendChild((Component)div);
        this.btnSave = new ToolBarButton();
        this.btnSave.setAttribute("name", "btnSaveAdv");
        if (ThemeManager.isUseFontIconForImage()) {
            this.btnSave.setIconSclass("z-icon-Save");
        } else {
            this.btnSave.setImage(ThemeManager.getThemeResource("images/Save24.png"));
        }
        this.btnSave.addEventListener("onClick", this);
        this.btnSave.setId("btnSave");
        this.btnSave.setStyle("vertical-align: middle;");
        if (ThemeManager.isUseFontIconForImage()) {
            LayoutUtils.addSclass("large-toolbarbutton", (HtmlBasedComponent)this.btnSave);
        }
        this.btnShare = new ToolBarButton();
        this.btnShare.setAttribute("name", "btnShareAdv");
        this.btnShare.setTooltiptext(Msg.getMsg((Properties)Env.getCtx(), (String)"ShareFilter"));
        if (ThemeManager.isUseFontIconForImage()) {
            this.btnShare.setIconSclass("z-icon-Share");
        } else {
            this.btnShare.setImage(ThemeManager.getThemeResource("images/Setup24.png"));
        }
        this.btnShare.addEventListener("onClick", this);
        this.btnShare.setId("btnShare");
        this.btnShare.setStyle("vertical-align: middle;");
        if (ThemeManager.isUseFontIconForImage()) {
            LayoutUtils.addSclass("large-toolbarbutton", (HtmlBasedComponent)this.btnShare);
        }
        this.fQueryName = new Combobox();
        this.fQueryName.setTooltiptext(Msg.getMsg((Properties)Env.getCtx(), (String)"QueryName"));
        this.fQueryName.setId("savedQueryCombo");
        this.userQueries = MUserQuery.get((Properties)Env.getCtx(), (int)this.m_AD_Tab_ID);
        int i = 0;
        while (i < this.userQueries.length) {
            this.fQueryName.appendItem(this.userQueries[i].getName(), this.userQueries[i].getAD_UserQuery_ID());
            ++i;
        }
        this.fQueryName.setValue("");
        this.fQueryName.addEventListener("onSelect", this);
        Label label = new Label(Msg.getMsg((Properties)Env.getCtx(), (String)"SavedQuery"));
        if (ClientInfo.maxWidth(639)) {
            label.setStyle("vertical-align: middle;display: block; padding-left: 4px; padding-top: 4px;");
        } else {
            label.setStyle("vertical-align: middle;");
        }
        div.appendChild((Component)label);
        div.appendChild((Component)this.fQueryName);
        div.appendChild((Component)this.btnSave);
        div.appendChild((Component)this.btnShare);
        if (!"C".equals(MRole.getDefault().getPreferenceType())) {
            this.btnShare.setVisible(false);
        }
        this.fQueryName.setStyle("margin-left: 3px; margin-right: 3px; position: relative; vertical-align: middle;");
        this.msgLabel = new Label("");
        this.msgLabel.setStyle("margin-left: 10px; margin-right: 20px; vertical-align: middle;");
        div.appendChild((Component)this.msgLabel);
        this.prepareHistoryCombo();
        Label labelHistory = new Label(Msg.getMsg((Properties)Env.getCtx(), (String)HISTORY_LABEL));
        if (ClientInfo.maxWidth(639)) {
            labelHistory.setStyle("vertical-align: middle; display: block;padding-left: 4px; padding-top: 4px;");
        } else {
            labelHistory.setStyle("vertical-align: middle;");
        }
        div.appendChild((Component)labelHistory);
        div.appendChild((Component)this.historyCombo);
        this.historyCombo.setStyle("margin-left: 3px; margin-right: 3px; position: relative; vertical-align: middle;");
        div.setClass("toolbar");
        this.winMain = new MultiTabPart();
        this.winMain.createPart(layout);
        this.winMain.getComponent().setStyle("position: relative; margin-left: auto; margin-right: auto; margin-top: 3px; margin-bottom: 3px;");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.winMain.getComponent(), "1");
        this.winMain.getComponent().addEventListener("onSelect", this);
        this.winAdvanced = new Window();
        this.winLookupRecord = new Window();
        Tabpanel tabPanel = new Tabpanel();
        tabPanel.setStyle("height: 100%; width: 100%;");
        tabPanel.appendChild((Component)this.winLookupRecord);
        tabPanel.setId("simpleSearch");
        this.winMain.addTab((Component)tabPanel, Msg.getMsg((Properties)Env.getCtx(), (String)"Find").replaceAll("&", ""), false, true);
        tabPanel = new Tabpanel();
        tabPanel.setStyle("height: 100%; width: 100%");
        tabPanel.appendChild((Component)this.winAdvanced);
        tabPanel.setId("advancedSearch");
        this.winMain.addTab((Component)tabPanel, Msg.getMsg((Properties)Env.getCtx(), (String)"Advanced").replaceAll("&", ""), false, false);
        this.initSimple();
        this.initAdvanced();
        if (!MRole.get((Properties)Env.getCtx(), (int)Env.getAD_Role_ID((Properties)Env.getCtx())).isAccessAdvanced() && !"Y".equals(Env.getContext((Properties)Env.getCtx(), (int)this.m_targetWindowNo, (int)this.m_targetTabNo, (String)"_TabInfo_IsAllowAdvancedLookup"))) {
            this.winMain.getComponent().getTabpanel(1).getLinkedTab().setDisabled(true);
            this.winMain.getComponent().getTabpanel(1).getLinkedTab().setVisible(false);
        }
        this.statusBar.setClass("statusbar");
        layout.appendChild((Component)this.statusBar);
    }

    private void prepareHistoryCombo() {
        this.historyCombo.setAutodrop(true);
        this.historyCombo.setAutocomplete(true);
        this.historyCombo.setButtonVisible(true);
        this.historyCombo.setReadonly(false);
        this.historyCombo.setId("historyCombo");
        ValueNamePair[] valueNamePairArray = this.historyItems;
        int n = this.historyItems.length;
        int n2 = 0;
        while (n2 < n) {
            ValueNamePair vnp = valueNamePairArray[n2];
            this.historyCombo.appendItem(vnp.getName(), vnp.getValue());
            ++n2;
        }
        this.historyCombo.addEventListener("onChange", this);
    }

    /*
     * WARNING - void declaration
     */
    private void initFind() {
        void var4_5;
        if (log.isLoggable(Level.CONFIG)) {
            log.config("");
        }
        ArrayList<Object> gridFieldList = new ArrayList<Object>();
        ArrayList<void> moreFieldList = new ArrayList<void>();
        boolean IsLookupOnlySelection = "Y".equals(Env.getContext((Properties)Env.getCtx(), (int)this.m_targetWindowNo, (int)this.m_targetTabNo, (String)"_TabInfo_IsLookupOnlySelection"));
        boolean bl = false;
        while (var4_5 < this.m_findFields.length) {
            void var5_11;
            String validationCode;
            GridField gridField = this.m_findFields[var4_5];
            boolean isDisplayed = gridField.isDisplayed();
            if (gridField.getVO().displayType == 20 || gridField.isEncrypted() || gridField.isEncryptedColumn()) {
                GridField ynfield;
                GridFieldVO gridFieldVO = gridField.getVO();
                GridFieldVO ynvo = gridFieldVO.clone(this.m_simpleCtx, gridFieldVO.WindowNo, gridFieldVO.TabNo, gridFieldVO.AD_Window_ID, gridFieldVO.AD_Tab_ID, gridFieldVO.tabReadOnly);
                ynvo.IsDisplayed = true;
                ynvo.displayType = 17;
                ynvo.AD_Reference_Value_ID = 319;
                validationCode = ynvo.ValidationCode;
                if (ynvo.ValidationCodeLookup != null && !ynvo.ValidationCodeLookup.isEmpty()) {
                    validationCode = ynvo.ValidationCodeLookup;
                }
                ynvo.lookupInfo = MLookupFactory.getLookupInfo((Properties)ynvo.ctx, (int)ynvo.WindowNo, (int)ynvo.AD_Column_ID, (int)ynvo.displayType, (Language)Env.getLanguage((Properties)ynvo.ctx), (String)ynvo.ColumnName, (int)ynvo.AD_Reference_Value_ID, (boolean)ynvo.IsParent, (String)validationCode);
                ynvo.lookupInfo.tabNo = 99;
                this.m_findFields[var4_5] = ynfield = new GridField(ynvo);
                GridField gridField2 = ynfield;
            } else if (gridField.getVO().displayType == 28) {
                GridFieldVO gridFieldVO = gridField.getVO();
                if (gridFieldVO.AD_Reference_Value_ID > 0) {
                    GridField postedfield;
                    GridFieldVO postedvo = gridFieldVO.clone(this.m_simpleCtx, gridFieldVO.WindowNo, gridFieldVO.TabNo, gridFieldVO.AD_Window_ID, gridFieldVO.AD_Tab_ID, gridFieldVO.tabReadOnly);
                    postedvo.IsDisplayed = true;
                    postedvo.displayType = 17;
                    validationCode = postedvo.ValidationCode;
                    if (postedvo.ValidationCodeLookup != null && !postedvo.ValidationCodeLookup.isEmpty()) {
                        validationCode = postedvo.ValidationCodeLookup;
                    }
                    postedvo.lookupInfo = MLookupFactory.getLookupInfo((Properties)postedvo.ctx, (int)postedvo.WindowNo, (int)postedvo.AD_Column_ID, (int)postedvo.displayType, (Language)Env.getLanguage((Properties)postedvo.ctx), (String)postedvo.ColumnName, (int)postedvo.AD_Reference_Value_ID, (boolean)postedvo.IsParent, (String)validationCode);
                    postedvo.lookupInfo.tabNo = 99;
                    this.m_findFields[var4_5] = postedfield = new GridField(postedvo);
                    GridField gridField3 = postedfield;
                }
            } else if (gridField.getVO().displayType == 25 || gridField.getVO().displayType == 33 || gridField.getVO().displayType == 53370 || gridField.getVO().displayType == 32 || gridField.getVO().displayType == 21 || gridField.getVO().displayType == 31 || gridField.getVO().displayType == 35) {
                GridField newfield;
                GridFieldVO gridFieldVO = gridField.getVO();
                GridFieldVO newvo = gridFieldVO.clone(this.m_simpleCtx, gridFieldVO.WindowNo, gridFieldVO.TabNo, gridFieldVO.AD_Window_ID, gridFieldVO.AD_Tab_ID, gridFieldVO.tabReadOnly);
                newvo.IsDisplayed = true;
                newvo.displayType = 30;
                switch (gridField.getVO().displayType) {
                    case 25: {
                        newvo.AD_Reference_Value_ID = 175;
                        break;
                    }
                    case 33: {
                        newvo.AD_Reference_Value_ID = 200181;
                        break;
                    }
                    case 53370: {
                        newvo.AD_Reference_Value_ID = 200183;
                        break;
                    }
                    case 32: {
                        newvo.AD_Reference_Value_ID = 200182;
                        break;
                    }
                    case 21: {
                        newvo.AD_Reference_Value_ID = 133;
                        break;
                    }
                    case 31: {
                        newvo.AD_Reference_Value_ID = 191;
                        break;
                    }
                    case 35: {
                        newvo.AD_Reference_Value_ID = 200180;
                    }
                }
                newvo.lookupInfo = MLookupFactory.getLookupInfo((Properties)newvo.ctx, (int)newvo.WindowNo, (int)newvo.AD_Column_ID, (int)newvo.displayType, (Language)Env.getLanguage((Properties)newvo.ctx), (String)newvo.ColumnName, (int)newvo.AD_Reference_Value_ID, (boolean)newvo.IsParent, null);
                newvo.lookupInfo.tabNo = 99;
                this.m_findFields[var4_5] = newfield = new GridField(newvo);
                GridField gridField4 = newfield;
            } else {
                Lookup lookup;
                GridField gridField5 = gridField.clone(this.m_simpleCtx);
                if (gridField5.isLookup() && (lookup = gridField5.getLookup()) != null && lookup instanceof MLookup) {
                    MLookup mLookup = (MLookup)lookup;
                    mLookup.getLookupInfo().ctx = this.m_simpleCtx;
                    mLookup.getLookupInfo().tabNo = 99;
                    if (gridField5.getVO().ValidationCodeLookup != null && !gridField5.getVO().ValidationCodeLookup.isEmpty()) {
                        mLookup.getLookupInfo().ValidationCode = gridField5.getVO().ValidationCodeLookup;
                        mLookup.getLookupInfo().IsValidated = false;
                    }
                }
                gridField5.setGridTab(null);
                this.m_findFields[var4_5] = gridField5;
                gridField5.setPlaceholder(null);
                GridField gridField6 = gridField5;
            }
            if (var5_11.isSelectionColumn()) {
                gridFieldList.add(var5_11);
            } else if (!IsLookupOnlySelection && (isDisplayed || var5_11.isVirtualSearchColumn()) && var5_11.getDisplayType() != 28 && !var5_11.getColumnName().equals("AD_Client_ID")) {
                moreFieldList.add(var5_11);
            }
            ++var4_5;
        }
        if (gridFieldList.isEmpty() && !moreFieldList.isEmpty()) {
            for (GridField gridField : moreFieldList) {
                if (!gridField.getColumnName().equals("Value") && !gridField.getColumnName().equals("Name") && !gridField.getColumnName().equals("DocumentNo") && !gridField.getColumnName().equals("Description")) continue;
                gridFieldList.add(gridField);
            }
            if (gridFieldList.isEmpty()) {
                boolean bl2 = false;
                for (GridField gridField : moreFieldList) {
                    void var4_8;
                    if (gridField.getColumnName().equals("AD_Client_ID") || gridField.getColumnName().equals("AD_Org_ID") || gridField.getDisplayType() == 13) continue;
                    gridFieldList.add(gridField);
                    if (++var4_8 == 2) break;
                }
            }
            for (GridField gridField : gridFieldList) {
                moreFieldList.remove(gridField);
            }
        }
        Collections.sort(gridFieldList, new Comparator<GridField>(){

            @Override
            public int compare(GridField o1, GridField o2) {
                return o1.getSeqNoSelection() - o2.getSeqNoSelection();
            }
        });
        ArrayList<GridField> arrayList = new ArrayList<GridField>();
        for (GridField gridField : gridFieldList) {
            if (gridField.isVirtualUIColumn() || !this.hasAccessSpecialFields(gridField) || this.addSelectionColumn(gridField)) continue;
            arrayList.add(gridField);
        }
        if (!moreFieldList.isEmpty() && !gridFieldList.isEmpty()) {
            Group group = new Group("...");
            this.contentSimpleRows.appendChild((Component)group);
            Cell cell = (Cell)group.getFirstChild();
            cell.setSclass("z-group-inner");
            cell.setColspan(3);
            cell.setAlign("left");
            for (GridField gridField : moreFieldList) {
                if (gridField.isVirtualUIColumn() || !this.hasAccessSpecialFields(gridField) || this.addSelectionColumn(gridField, group)) continue;
                arrayList.add(gridField);
            }
            group.setOpen(false);
        }
        if (!arrayList.isEmpty()) {
            block15: for (GridField gridField : arrayList) {
                void var7_40;
                boolean bl3 = false;
                while (var7_40 < this.m_findFields.length) {
                    if (this.m_findFields[var7_40] == gridField) {
                        this.m_findFields[var7_40] = null;
                        continue block15;
                    }
                    ++var7_40;
                }
            }
        }
        if (this.m_sEditors.isEmpty()) {
            Tabpanel tabpanel = this.winMain.getComponent().getTabpanel(0);
            tabpanel.getLinkedTab().setVisible(false);
            tabpanel.setVisible(false);
        }
        gridFieldList = null;
        this.m_total = this.getNoOfRecords(null, false);
        this.setStatusDB(this.m_total);
        this.statusBar.setStatusLine("");
    }

    private boolean hasAccessSpecialFields(GridField field) {
        int windowId = 0;
        switch (field.getAD_Reference_Value_ID()) {
            case 175: {
                windowId = 153;
                break;
            }
            case 200181: {
                windowId = 236;
                break;
            }
            case 200183: {
                windowId = 53124;
                break;
            }
            case 200182: {
                windowId = 227;
                break;
            }
            case 133: {
                windowId = 121;
                break;
            }
            case 191: {
                windowId = 139;
                break;
            }
            case 200180: {
                windowId = 358;
            }
        }
        if (windowId > 0) {
            Boolean access = MRole.getDefault().getWindowAccess(windowId);
            return access != null;
        }
        return true;
    }

    private void initFindAdvanced() {
        if (log.isLoggable(Level.CONFIG)) {
            log.config("");
        }
        this.createFields();
        this.refreshUserQueries();
    }

    private void createFields() {
        List rowList = this.advancedPanel.getChildren();
        int row = rowList.size() - 1;
        this.createFields(null, row);
    }

    private void createFields(String[] fields, int row) {
        ValueNamePair[] rightBracket;
        ValueNamePair[] leftBracket;
        ValueNamePair[] andOr;
        if (fields != null && fields.length >= 1 && fields[0].contains(HISTORY_SEPARATOR)) {
            return;
        }
        ListItem listItem = new ListItem();
        listItem.setId("Row" + this.rowCount++);
        int id = 0;
        if (this.advancedPanel.getItemCount() > 0) {
            String previousID = ((Listitem)this.advancedPanel.getItems().get(this.advancedPanel.getItemCount() - 1)).getId();
            previousID = previousID.substring(3, previousID.length());
            id = Integer.valueOf(previousID);
            ++id;
        }
        listItem.setId("Row" + id);
        Combobox listTable = new Combobox();
        listTable.setId("listTable" + listItem.getId());
        listTable.setName("listTable");
        listTable.addEventListener("onSelect", this);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)listTable, "true");
        listTable.setAutodrop(true);
        listTable.setAutocomplete(true);
        listTable.setInstantSelect(false);
        listTable.addEventListener("onBlur", e -> {
            if (listTable.getSelectedItem() == null) {
                listTable.setSelectedIndex(0);
            }
        });
        if (this.m_gridTab == null) {
            listTable.setDisabled(true);
        }
        Combobox listColumn = new Combobox();
        listColumn.setId("listColumn" + listItem.getId());
        listColumn.setName("listColumn");
        listColumn.addEventListener("onSelect", this);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)listColumn, "true");
        listColumn.setAutodrop(true);
        listColumn.setAutocomplete(true);
        listColumn.setInstantSelect(false);
        listColumn.addEventListener("onBlur", e -> {
            if (listColumn.getSelectedItem() == null) {
                listColumn.setValue(null);
            }
        });
        listColumn.addEventListener("onFocus", e -> listColumn.select());
        Combobox listOperator = new Combobox();
        listOperator.setId("listOperator" + listItem.getId());
        listOperator.setName("listOperator");
        listOperator.addEventListener("onSelect", this);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)listOperator, "true");
        listOperator.setInstantSelect(false);
        listOperator.setAutocomplete(true);
        listOperator.addEventListener("onBlur", e -> {
            if (listOperator.getSelectedItem() == null) {
                listOperator.setSelectedIndex(0);
            }
        });
        Listbox listAndOr = new Listbox();
        listAndOr.setId("listAndOr" + listItem.getId());
        listAndOr.setName("listAndOr");
        listAndOr.setMold("select");
        listAndOr.setRows(0);
        listAndOr.addEventListener("onSelect", this);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)listAndOr, "true");
        Listbox listLeftBracket = new Listbox();
        listLeftBracket.setId("listLeftBracket" + listItem.getId());
        listLeftBracket.setName("listLeftBracket");
        listLeftBracket.setMold("select");
        listLeftBracket.setRows(0);
        listLeftBracket.addEventListener("onSelect", this);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)listLeftBracket, "true");
        Listbox listRightBracket = new Listbox();
        listRightBracket.setId("listRightBracket" + listItem.getId());
        listRightBracket.setName("listRightBracket");
        listRightBracket.setMold("select");
        listRightBracket.setRows(0);
        listRightBracket.addEventListener("onSelect", this);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)listRightBracket, "true");
        this.setValues(this.m_findFields, listTable, listColumn, listOperator, fields);
        ValueNamePair[] valueNamePairArray = andOr = new ValueNamePair[]{new ValueNamePair("AND", Msg.getMsg((Properties)Env.getCtx(), (String)"AND")), new ValueNamePair("OR", Msg.getMsg((Properties)Env.getCtx(), (String)"OR")), new ValueNamePair("AND NOT", Msg.getMsg((Properties)Env.getCtx(), (String)"ANDNOT")), new ValueNamePair("OR NOT", Msg.getMsg((Properties)Env.getCtx(), (String)"ORNOT"))};
        int n = andOr.length;
        int n2 = 0;
        while (n2 < n) {
            ValueNamePair item = valueNamePairArray[n2];
            listAndOr.appendItem(item.getName(), item.getValue());
            ++n2;
        }
        listAndOr.setSelectedIndex(0);
        if (row <= 0) {
            listAndOr.setVisible(false);
        } else {
            listAndOr.setVisible(true);
        }
        ValueNamePair[] valueNamePairArray2 = leftBracket = new ValueNamePair[]{new ValueNamePair("", ""), new ValueNamePair("(", "("), new ValueNamePair("((", "(("), new ValueNamePair("(((", "(((")};
        int n3 = leftBracket.length;
        n = 0;
        while (n < n3) {
            ValueNamePair item = valueNamePairArray2[n];
            listLeftBracket.appendItem(item.getName(), item.getValue());
            ++n;
        }
        listLeftBracket.setSelectedIndex(0);
        ValueNamePair[] valueNamePairArray3 = rightBracket = new ValueNamePair[]{new ValueNamePair("", ""), new ValueNamePair(")", ")"), new ValueNamePair("))", "))"), new ValueNamePair(")))", ")))")};
        int n4 = rightBracket.length;
        n3 = 0;
        while (n3 < n4) {
            ValueNamePair item = valueNamePairArray3[n3];
            listRightBracket.appendItem(item.getName(), item.getValue());
            ++n3;
        }
        listRightBracket.setSelectedIndex(0);
        ListCell cellTable = new ListCell();
        cellTable.appendChild((Component)listTable);
        cellTable.setId("cellTable" + listItem.getId());
        ListCell cellColumn = new ListCell();
        cellColumn.appendChild((Component)listColumn);
        cellColumn.setId("cellColumn" + listItem.getId());
        ListCell cellOperator = new ListCell();
        cellOperator.appendChild((Component)listOperator);
        cellOperator.setId("cellOperator" + listItem.getId());
        ListCell cellQueryFrom = new ListCell();
        cellQueryFrom.setId("cellQueryFrom" + listItem.getId());
        ListCell cellQueryTo = new ListCell();
        cellQueryTo.setId("cellQueryTo" + listItem.getId());
        ListCell cellAndOr = new ListCell();
        cellAndOr.appendChild((Component)listAndOr);
        cellAndOr.setId("cellAndOr" + listItem.getId());
        ListCell cellLeftBracket = new ListCell();
        cellLeftBracket.appendChild((Component)listLeftBracket);
        cellLeftBracket.setId("cellLeftBracket" + listItem.getId());
        ListCell cellRightBracket = new ListCell();
        cellRightBracket.appendChild((Component)listRightBracket);
        cellRightBracket.setId("cellRightBracket" + listItem.getId());
        listItem.appendChild((Component)cellAndOr);
        listItem.appendChild((Component)cellLeftBracket);
        listItem.appendChild((Component)cellTable);
        listItem.appendChild((Component)cellColumn);
        listItem.appendChild((Component)cellOperator);
        listItem.appendChild((Component)cellQueryFrom);
        listItem.appendChild((Component)cellQueryTo);
        listItem.appendChild((Component)cellRightBracket);
        int selectedIndex = this.advancedPanel.getSelectedIndex();
        if (selectedIndex >= 0) {
            ListItem item = this.advancedPanel.getItemAtIndex(selectedIndex + 1);
            this.advancedPanel.insertBefore((Component)listItem, (Component)item);
        } else {
            this.advancedPanel.appendChild((Component)listItem);
        }
        this.advancedPanel.setSelectedItem(listItem);
        if (fields != null) {
            String sRightBracket;
            String sLeftBracket;
            String sandOr;
            String value2;
            String value;
            String tableName;
            ValueNamePair selected = (ValueNamePair)listColumn.getSelectedItem().getValue();
            String columnName = selected.getValue();
            String string = tableName = listTable != null && listTable.getSelectedItem() != null ? (String)listTable.getSelectedItem().getValue() : this.m_tableName;
            if (columnName == null || columnName == "") {
                return;
            }
            WEditor editorFrom = null;
            String string2 = value = fields.length > 2 ? fields[2] : "";
            if (value.length() > 0) {
                cellQueryFrom.setAttribute("value", value);
                if (tableName.equals("M_Attribute_ID")) {
                    cellQueryFrom.appendChild(this.parseAttributeString(Integer.valueOf(columnName), value, listItem, false));
                } else {
                    editorFrom = this.parseString(this.getTargetMField(columnName), value, listItem, false);
                    if (editorFrom != null) {
                        cellQueryFrom.appendChild(editorFrom.getComponent());
                    }
                }
            }
            WEditor editorTo = null;
            String string3 = value2 = fields.length > 3 ? fields[3] : "";
            if (value2.length() > 0) {
                cellQueryTo.setAttribute("value", value2);
                if (tableName.equals("M_Attribute_ID")) {
                    cellQueryTo.appendChild(this.parseAttributeString(Integer.valueOf(columnName), value2, listItem, true));
                } else {
                    editorTo = this.parseString(this.getTargetMField(columnName), value2, listItem, true);
                    if (editorTo != null) {
                        if (editorFrom != null && editorFrom.getGridField() != null && DisplayType.isDate((int)editorFrom.getGridField().getDisplayType())) {
                            Div div = this.createDateRangeWrapper(editorFrom, editorTo);
                            cellQueryTo.appendChild((Component)div);
                        } else {
                            cellQueryTo.appendChild(editorTo.getComponent());
                        }
                    }
                }
            }
            String string4 = sandOr = fields.length > 4 ? fields[4] : "";
            if (sandOr.length() > 0) {
                int i = 0;
                while (i < listAndOr.getItems().size()) {
                    if (listAndOr.getItemAtIndex(i).getValue().equals(sandOr)) {
                        listAndOr.setSelectedIndex(i);
                        break;
                    }
                    ++i;
                }
            }
            String string5 = sLeftBracket = fields.length > 5 ? fields[5] : "";
            if (sLeftBracket.length() > 0) {
                int i = 0;
                while (i < listLeftBracket.getItems().size()) {
                    if (listLeftBracket.getItemAtIndex(i).getValue().equals(sLeftBracket)) {
                        listLeftBracket.setSelectedIndex(i);
                        break;
                    }
                    ++i;
                }
            }
            String string6 = sRightBracket = fields.length > 6 ? fields[6] : "";
            if (sRightBracket.length() > 0) {
                int i = 0;
                while (i < listRightBracket.getItems().size()) {
                    if (listRightBracket.getItemAtIndex(i).getValue().equals(sRightBracket)) {
                        listRightBracket.setSelectedIndex(i);
                        break;
                    }
                    ++i;
                }
            }
        }
    }

    private Div createDateRangeWrapper(WEditor editorFrom, WEditor editorTo) {
        Div div = new Div();
        div.setWidth("100%");
        div.appendChild(editorTo.getComponent());
        div.appendChild((Component)new DateRangeButton(editorFrom, editorTo));
        return div;
    }

    private void setValues(GridField[] findFields, Combobox listTable, Combobox listColumn, Combobox listOperator, String[] fields) {
        ArrayList<ValueNamePair> tables = new ArrayList<ValueNamePair>();
        String columnName = "";
        String operator = "";
        String tableName = "";
        if (this.m_tabs == null || listTable.getItemCount() == 0) {
            this.initTabs();
            int c = 0;
            while (c < this.m_tabs.length) {
                String header = this.m_tabs[c].get_Translation("Name", Env.getAD_Language((Properties)Env.getCtx()));
                ValueNamePair pp = new ValueNamePair(this.m_tabs[c].getAD_Tab_UU(), header);
                tables.add(pp);
                ++c;
            }
            if (this.isAttributeTable()) {
                String header = Msg.translate((Properties)Env.getCtx(), (String)"M_Attribute_ID");
                ValueNamePair pp = new ValueNamePair("M_Attribute_ID", header);
                tables.add(pp);
            }
        }
        ValueNamePair tabs = new ValueNamePair[tables.size()];
        tables.toArray((T[])tabs);
        if (fields != null) {
            boolean selected = false;
            tableName = fields.length > 7 ? fields[7] : "";
            columnName = fields.length > 0 ? fields[0] : "";
            String string = operator = fields.length > 1 ? fields[1] : "";
            if (this.m_windowPanel != null) {
                int i = 0;
                while (i < ((ValueNamePair[])tabs).length) {
                    ValueNamePair item = tabs[i];
                    listTable.appendItem(item.getName(), item.getValue());
                    if (item.getValue().equals("M_Attribute_ID")) {
                        if (item.getValue().equals(tableName)) {
                            listTable.setSelectedIndex(listTable.getItemCount() - 1);
                            selected = true;
                        }
                    } else if (item.getValue().equals(tableName)) {
                        GridTab mtab = this.m_windowPanel.getGridWindow().getGridTab(tableName);
                        listTable.setSelectedIndex(listTable.getItemCount() - 1);
                        selected = true;
                        findFields = this.m_windowPanel.getGridWindow().getGridTab(mtab.getAD_Tab_ID()).getFields();
                        this.m_gridTab = this.m_windowPanel.getGridWindow().getGridTab(mtab.getAD_Tab_ID());
                    }
                    ++i;
                }
                if (!selected) {
                    listTable.setSelectedIndex(0);
                }
            }
        }
        if (!tableName.equals("M_Attribute_ID")) {
            ValueNamePair pp;
            ArrayList<ValueNamePair> columnItems = new ArrayList<ValueNamePair>();
            columnItems.add(new ValueNamePair("", " "));
            int c = 0;
            while (c < findFields.length) {
                GridField field = findFields[c];
                if (field != null && !field.isVirtualUIColumn() && this.hasAccessSpecialFields(field)) {
                    boolean IsLookupOnlySelection;
                    boolean bl = IsLookupOnlySelection = !MRole.get((Properties)Env.getCtx(), (int)Env.getAD_Role_ID((Properties)Env.getCtx())).isAccessAdvanced() && "Y".equals(Env.getContext((Properties)Env.getCtx(), (int)this.m_targetWindowNo, (int)this.m_targetTabNo, (String)"_TabInfo_IsLookupOnlySelection"));
                    if (!IsLookupOnlySelection || field.isSelectionColumn()) {
                        String l_columnName = field.getColumnName();
                        String header = field.getHeader();
                        if (header != null && header.length() != 0 || (header = Msg.translate((Properties)Env.getCtx(), (String)l_columnName)) != null && header.length() != 0) {
                            if (field.isKey()) {
                                header = String.valueOf(header) + " (ID)";
                            }
                            pp = new ValueNamePair(l_columnName, header.toString());
                            columnItems.add(pp);
                        }
                    }
                }
                ++c;
            }
            Object[] cols = new ValueNamePair[columnItems.size()];
            columnItems.toArray(cols);
            Arrays.sort(cols);
            ValueNamePair[] op = MQuery.OPERATORS;
            this.updateColumnListModel(listColumn, (ValueNamePair[])cols);
            if (!this.isFilterColumnList()) {
                listColumn.addScrollSelectedIntoViewListener();
            }
            if (fields == null) {
                ValueNamePair item;
                if (listTable.getItemCount() == 0) {
                    pp = tabs;
                    int header = ((ValueNamePair[])pp).length;
                    int l_columnName = 0;
                    while (l_columnName < header) {
                        item = pp[l_columnName];
                        listTable.appendItem(item.getName(), item.getValue());
                        ++l_columnName;
                    }
                    listTable.setSelectedIndex(0);
                }
                listColumn.setSelectedIndex(0);
                pp = op;
                int header = op.length;
                int l_columnName = 0;
                while (l_columnName < header) {
                    item = pp[l_columnName];
                    listOperator.appendItem(Msg.getMsg((Properties)Env.getCtx(), (String)item.getName()).trim(), item.getValue());
                    ++l_columnName;
                }
                listOperator.setSelectedIndex(0);
            } else {
                Comboitem li;
                columnName = fields.length > 0 ? fields[0] : "";
                operator = fields.length > 1 ? fields[1] : "";
                boolean selected = false;
                Comboitem selectedColumnItem = null;
                int i = 0;
                while (i < cols.length) {
                    Iterator columnValueName = cols[i];
                    if (columnValueName.getValue().equals(columnName)) {
                        listColumn.setSelectedIndex(i);
                        li = listColumn.getItemAtIndex(i);
                        selected = true;
                        selectedColumnItem = li;
                    }
                    ++i;
                }
                if (!selected) {
                    listColumn.setSelectedIndex(0);
                }
                selected = false;
                if (selectedColumnItem != null) {
                    this.addOperators(selectedColumnItem, listOperator);
                    for (Component listitem : listOperator.getChildren()) {
                        if (!(listitem instanceof ComboItem) || !((ComboItem)listitem).getValue().equals(operator)) continue;
                        listOperator.setSelectedItem((ComboItem)listitem);
                        selected = true;
                        break;
                    }
                } else {
                    i = 0;
                    while (i < op.length) {
                        ValueNamePair operatorValueName = op[i];
                        li = new ComboItem(Msg.getMsg((Properties)Env.getCtx(), (String)operatorValueName.getName()), operatorValueName.getValue());
                        listOperator.appendChild((Component)li);
                        if (operatorValueName.getValue().equals(operator)) {
                            listOperator.setSelectedItem(li);
                            selected = true;
                        }
                        ++i;
                    }
                }
                if (!selected) {
                    listOperator.setSelectedIndex(0);
                }
            }
        } else {
            this.setAttributes(listColumn, listOperator, fields);
        }
    }

    private void updateColumnListModel(Combobox listColumn, ValueNamePair[] cols) {
        Object columnListModel = null;
        columnListModel = this.isFilterColumnList() ? new SimpleListModel<ValueNamePair>(cols, true){
            private static final long serialVersionUID = -8319240524315831047L;

            protected boolean inSubModel(Object key, Object value) {
                if (key == null) {
                    return true;
                }
                if (key instanceof String && ((String)key).length() == 0) {
                    return true;
                }
                return value.toString().toLowerCase().startsWith(key.toString().toLowerCase());
            }

            protected int getMaxNumberInSubModel(int nRows) {
                return Integer.MAX_VALUE;
            }
        } : new ListModelList((Object[])cols);
        listColumn.setModel((ListModel)columnListModel);
        Events.sendEvent((String)"onInitRender", (Component)listColumn, null);
    }

    private boolean isFilterColumnList() {
        return MSysConfig.getBooleanValue((String)"ZK_ADVANCE_FIND_FILTER_COLUMN_LIST", (boolean)false, (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
    }

    public boolean addSelectionColumn(GridField mField) {
        return this.addSelectionColumn(mField, null);
    }

    public boolean addSelectionColumn(GridField mField, Group group) {
        int displayLength;
        if (log.isLoggable(Level.CONFIG)) {
            log.config(mField.getHeader());
        }
        if ((displayLength = mField.getDisplayLength()) <= 0 || displayLength > 20) {
            mField.setDisplayLength(20);
        } else {
            displayLength = 0;
        }
        WEditor editor = null;
        editor = WebEditorFactory.getEditor(mField, true);
        if (editor == null || !editor.isSearchable()) {
            return false;
        }
        editor.setMandatory(false);
        editor.setReadWrite(true);
        editor.dynamicDisplay();
        editor.updateStyle(false);
        editor.addValueChangeListener(this);
        Label label = editor.getLabel();
        Component fieldEditor = editor.getComponent();
        this.setLengthStringField(mField, fieldEditor);
        label.setValue(mField.getHeader());
        if (displayLength > 0) {
            mField.setDisplayLength(displayLength);
        }
        WEditor editorTo = null;
        Component fieldEditorTo = null;
        if (DisplayType.isDate((int)mField.getDisplayType()) || DisplayType.isNumeric((int)mField.getDisplayType())) {
            editorTo = WebEditorFactory.getEditor(mField, true);
            editorTo.setMandatory(false);
            editorTo.setReadWrite(true);
            editorTo.dynamicDisplay();
            editorTo.updateStyle(false);
            editorTo.addValueChangeListener(this);
            if (displayLength > 0) {
                mField.setDisplayLength(displayLength);
            }
            fieldEditorTo = editorTo.getComponent();
            fieldEditorTo.addEventListener("onOK", (EventListener)this);
        }
        Row panel = new Row();
        panel.appendChild((Component)label);
        Div div = new Div();
        panel.appendChild((Component)div);
        div.appendChild(fieldEditor);
        if (editorTo != null) {
            ToolBarButton editorFlag = new ToolBarButton();
            editorFlag.setLabel(".. " + Msg.getMsg((Properties)Env.getCtx(), (String)"search.result.to") + " ..");
            editorFlag.setStyle("margin-left: 5px; margin-right: 5px;");
            this.m_sEditorsFlag.add(editorFlag);
            editorFlag.setMode("toggle");
            div.appendChild((Component)editorFlag);
            div.appendChild(fieldEditorTo);
            DateRangeButton drb = null;
            if (editor.getGridField() != null && DisplayType.isDate((int)editor.getGridField().getDisplayType())) {
                drb = new DateRangeButton(editor, editorTo);
                div.appendChild((Component)drb);
                drb.setVisible(false);
            }
            fieldEditorTo.setVisible(false);
            final Component editorRef = fieldEditorTo;
            final DateRangeButton drbRef = drb;
            editorFlag.addEventListener("onCheck", (EventListener)new EventListener<Event>(){

                public void onEvent(Event event) throws Exception {
                    ToolBarButton btn = (ToolBarButton)event.getTarget();
                    editorRef.setVisible(btn.isChecked());
                    if (drbRef != null) {
                        drbRef.setVisible(editorRef.isVisible());
                    }
                }
            });
            this.m_sEditorsTo.add(editorTo);
        } else {
            this.m_sEditorsFlag.add(null);
            this.m_sEditorsTo.add(null);
            editor.fillHorizontal();
            editor.updateStyle(false);
        }
        panel.appendChild((Component)new Space());
        if (group != null) {
            panel.setGroup(group);
        }
        this.contentSimpleRows.appendChild((Component)panel);
        this.m_sEditors.add(editor);
        fieldEditor.addEventListener("onOK", (EventListener)this);
        return true;
    }

    private void setLengthStringField(GridField field, Component fieldEditor) {
        if (DisplayType.isText((int)field.getVO().displayType) && fieldEditor instanceof Textbox) {
            ((Textbox)fieldEditor).setMaxlength(Short.MAX_VALUE);
        }
    }

    public void onEvent(Event event) throws Exception {
        block40: {
            block47: {
                Button btn;
                block54: {
                    block53: {
                        block52: {
                            block51: {
                                block48: {
                                    ToolBarButton button;
                                    block50: {
                                        block49: {
                                            block41: {
                                                block43: {
                                                    Object componentTo;
                                                    WEditor editorTo;
                                                    Object componentFrom;
                                                    WEditor editorFrom;
                                                    Combobox listOperator;
                                                    Combobox listColumn;
                                                    Combobox eventTarget;
                                                    ListItem row;
                                                    block46: {
                                                        String betweenValue;
                                                        block44: {
                                                            Component componentTo2;
                                                            Component componentFrom2;
                                                            block45: {
                                                                Comboitem table2;
                                                                block42: {
                                                                    block39: {
                                                                        this.m_createNew = false;
                                                                        if (!"onChange".equals(event.getName())) break block39;
                                                                        if (event.getTarget() != this.historyCombo) break block40;
                                                                        String value = this.historyCombo.getValue();
                                                                        boolean valid = false;
                                                                        if (value == null) {
                                                                            valid = true;
                                                                        } else {
                                                                            ValueNamePair[] valueNamePairArray = this.historyItems;
                                                                            int n = this.historyItems.length;
                                                                            int n2 = 0;
                                                                            while (n2 < n) {
                                                                                ValueNamePair vnp = valueNamePairArray[n2];
                                                                                if (value.equals(vnp.getName())) {
                                                                                    valid = true;
                                                                                    break;
                                                                                }
                                                                                ++n2;
                                                                            }
                                                                        }
                                                                        if (!valid) {
                                                                            this.historyCombo.setSelectedIndex(0);
                                                                        }
                                                                        break block40;
                                                                    }
                                                                    if (!"onSelect".equals(event.getName())) break block41;
                                                                    if (event.getTarget() != this.fQueryName) break block42;
                                                                    int index = this.fQueryName.getSelectedIndex();
                                                                    if (index < 0) {
                                                                        return;
                                                                    }
                                                                    if (this.winMain.getComponent().getSelectedIndex() != 1) {
                                                                        this.winMain.getComponent().setSelectedIndex(1);
                                                                        this.btnSave.setDisabled(this.m_AD_Tab_ID <= 0);
                                                                        this.historyCombo.setSelectedItem(null);
                                                                        this.fQueryName.setReadonly(false);
                                                                    }
                                                                    this.msgLabel.setText("");
                                                                    if (index == 0) {
                                                                        List rowList = this.advancedPanel.getChildren();
                                                                        int rowIndex = rowList.size() - 1;
                                                                        while (rowIndex >= 1) {
                                                                            rowList.remove(rowIndex);
                                                                            --rowIndex;
                                                                        }
                                                                        this.createFields();
                                                                    } else {
                                                                        this.parseUserQuery(this.userQueries[index - 1]);
                                                                    }
                                                                    break block40;
                                                                }
                                                                if (!(event.getTarget() instanceof Combobox)) break block43;
                                                                row = (ListItem)event.getTarget().getParent().getParent();
                                                                eventTarget = (Combobox)event.getTarget();
                                                                this.advancedPanel.setSelectedItem(row);
                                                                listColumn = (Combobox)row.getFellow("listColumn" + row.getId());
                                                                listOperator = (Combobox)row.getFellow("listOperator" + row.getId());
                                                                Combobox listTable = (Combobox)row.getFellow("listTable" + row.getId());
                                                                if (eventTarget.getId().equals(listTable.getId())) {
                                                                    table2 = listTable.getSelectedItem();
                                                                    if (table2 != null && table2.getValue().equals("M_Attribute_ID")) {
                                                                        this.setAttributes(listColumn, listOperator, null);
                                                                    } else {
                                                                        this.m_gridTab = table2 != null && table2.getValue().toString().length() > 0 ? this.m_windowPanel.getGridWindow().getGridTab((String)table2.getValue()) : this.m_windowPanel.getGridWindow().getGridTab(this.m_AD_Tab_ID);
                                                                        this.setValues(this.m_gridTab.getFields(), listTable, listColumn, listOperator, null);
                                                                    }
                                                                } else if (eventTarget.getId().equals(listColumn.getId()) || eventTarget.getId().equals(listOperator.getId())) {
                                                                    ValueNamePair selected;
                                                                    Comboitem column;
                                                                    table2 = listTable.getSelectedItem();
                                                                    if (table2 != null && table2.getValue().equals("M_Attribute_ID")) {
                                                                        if (eventTarget.getId().equals(listColumn.getId())) {
                                                                            column = listColumn.getSelectedItem();
                                                                            selected = (ValueNamePair)column.getValue();
                                                                            if (column != null && selected.getValue().length() > 0) {
                                                                                this.addOperatorsAttribute(column, listOperator);
                                                                            }
                                                                        }
                                                                    } else {
                                                                        if (this.m_gridTab != null) {
                                                                            this.m_gridTab = table2 != null && table2.getValue().toString().length() > 0 ? this.m_windowPanel.getGridWindow().getGridTab((String)table2.getValue()) : this.m_windowPanel.getGridWindow().getGridTab(this.m_AD_Tab_ID);
                                                                        }
                                                                        if (eventTarget.getId().equals(listColumn.getId())) {
                                                                            column = listColumn.getSelectedItem();
                                                                            ValueNamePair valueNamePair = selected = column != null ? (ValueNamePair)column.getValue() : null;
                                                                            if (column != null && selected.getValue().length() > 0) {
                                                                                this.addOperators(column, listOperator);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                                table2 = listTable.getSelectedItem();
                                                                if (table2 == null || !table2.getValue().toString().equals("M_Attribute_ID")) break block44;
                                                                componentFrom2 = this.getAttributeValuesListComponent(row, false);
                                                                componentFrom2.setId("searchFieldFrom" + row.getId());
                                                                componentTo2 = this.getAttributeValuesListComponent(row, true);
                                                                componentTo2.setId("searchFieldTo" + row.getId());
                                                                Combobox listOp = (Combobox)row.getFellow("listOperator" + row.getId());
                                                                String betweenValue2 = listOp.getSelectedItem().getValue().toString();
                                                                if (!betweenValue2.equals(" IS NULL ") && !betweenValue2.equals(" IS NOT NULL ")) break block45;
                                                                row.getFellow("cellQueryFrom" + row.getId()).getChildren().clear();
                                                                row.getFellow("cellQueryTo" + row.getId()).getChildren().clear();
                                                                break block40;
                                                            }
                                                            if (!eventTarget.getId().equals(listColumn.getId()) && !eventTarget.getId().equals(listOperator.getId())) break block40;
                                                            this.addRowEditor(componentFrom2, (ListCell)row.getFellow("cellQueryFrom" + row.getId()));
                                                            this.addRowEditor(componentTo2, (ListCell)row.getFellow("cellQueryTo" + row.getId()));
                                                            break block40;
                                                        }
                                                        editorFrom = this.getEditor(row, false);
                                                        componentFrom = editorFrom != null ? editorFrom.getComponent() : new Label("");
                                                        componentFrom.setId("searchFieldFrom" + row.getId());
                                                        editorTo = this.getEditor(row, true);
                                                        componentTo = editorTo != null ? editorTo.getComponent() : new Label("");
                                                        componentTo.setId("searchFieldTo" + row.getId());
                                                        Combobox listOp = (Combobox)row.getFellow("listOperator" + row.getId());
                                                        String string = betweenValue = listOp.getSelectedItem() != null ? listOp.getSelectedItem().getValue().toString() : "";
                                                        if (!betweenValue.equals(" IS NULL ") && !betweenValue.equals(" IS NOT NULL ")) break block46;
                                                        row.getFellow("cellQueryFrom" + row.getId()).getChildren().clear();
                                                        row.getFellow("cellQueryTo" + row.getId()).getChildren().clear();
                                                        break block40;
                                                    }
                                                    if (!eventTarget.getId().equals(listColumn.getId()) && !eventTarget.getId().equals(listOperator.getId())) break block40;
                                                    this.addRowEditor((Component)componentFrom, (ListCell)row.getFellow("cellQueryFrom" + row.getId()));
                                                    if (editorTo != null && editorTo.getGridField() != null && DisplayType.isDate((int)editorTo.getGridField().getDisplayType())) {
                                                        Div div = this.createDateRangeWrapper(editorFrom, editorTo);
                                                        this.addRowEditor((Component)div, (ListCell)row.getFellow("cellQueryTo" + row.getId()));
                                                    } else {
                                                        this.addRowEditor((Component)componentTo, (ListCell)row.getFellow("cellQueryTo" + row.getId()));
                                                    }
                                                    break block40;
                                                }
                                                if (!(event.getTarget() instanceof Tab)) break block40;
                                                if (this.winMain.getComponent().getSelectedIndex() == 1) {
                                                    this.onAdvanceTabSelected();
                                                } else {
                                                    this.onSimpleTabSelected();
                                                }
                                                break block40;
                                            }
                                            if (!"onClick".equals(event.getName())) break block47;
                                            if (!(event.getTarget() instanceof ToolBarButton)) break block48;
                                            button = (ToolBarButton)event.getTarget();
                                            if (!"btnNewAdv".equals(button.getAttribute("name").toString())) break block49;
                                            this.createFields();
                                            this.focusToLastAdvanceRow();
                                            break block40;
                                        }
                                        if (!"btnDeleteAdv".equals(button.getAttribute("name").toString())) break block50;
                                        int index = this.advancedPanel.getSelectedIndex();
                                        if (this.advancedPanel.getSelectedItem() != null) {
                                            this.advancedPanel.getSelectedItem().detach();
                                            this.advancedPanel.setSelectedIndex(--index);
                                        }
                                        this.focusToLastAdvanceRow();
                                        break block40;
                                    }
                                    if (!"btnSaveAdv".equals(button.getAttribute("name").toString()) && !"btnShareAdv".equals(button.getAttribute("name").toString())) break block40;
                                    boolean shareAllUsers = "btnShareAdv".equals(button.getAttribute("name").toString());
                                    if (this.winMain.getComponent().getSelectedIndex() == 1) {
                                        this.cmd_saveAdvanced(true, shareAllUsers);
                                    } else {
                                        this.cmd_saveSimple(true, shareAllUsers);
                                    }
                                    if (shareAllUsers) {
                                        this.btnSave.setDisabled(true);
                                    }
                                    break block40;
                                }
                                if (!(event.getTarget() instanceof Button)) break block40;
                                btn = (Button)event.getTarget();
                                if (!"btnOkSimple".equals(btn.getName())) break block51;
                                this.fQueryName.setSelectedIndex(0);
                                this.cmd_ok_Simple();
                                this.fQueryName.setValue("");
                                break block40;
                            }
                            if (!"btnOkAdv".equals(btn.getName())) break block52;
                            this.cmd_ok_Advanced();
                            break block40;
                        }
                        if (!"btnCancel".equals(btn.getName())) break block53;
                        this.onCancel();
                        break block40;
                    }
                    if (!"btnNew".equals(btn.getName())) break block54;
                    this.m_query = MQuery.getNoRecordQuery((String)this.m_tableName, (boolean)true);
                    this.m_total = 0;
                    this.m_createNew = true;
                    this.m_isCancel = false;
                    this.dispose();
                    break block40;
                }
                if (!"btnReset".equals(btn.getName())) break block40;
                for (WEditor clearField : this.m_sEditors) {
                    clearField.setValue(null);
                }
                for (WEditor clearField : this.m_sEditorsTo) {
                    if (clearField == null) continue;
                    clearField.setValue(null);
                    clearField.setVisible(false);
                    ToolBarButton moreButtor = this.m_sEditorsFlag.get(this.m_sEditorsTo.indexOf(clearField));
                    moreButtor.setChecked(false);
                }
                break block40;
            }
            if ("onOK".equals(event.getName())) {
                if (this.winLookupRecord.equals(event.getTarget())) {
                    this.cmd_ok_Simple();
                } else if (this.winAdvanced.equals(event.getTarget())) {
                    this.cmd_ok_Advanced();
                }
                int i = 0;
                while (i < this.m_sEditors.size()) {
                    WEditor editorTo;
                    WEditor editor = this.m_sEditors.get(i);
                    if (editor.getComponent() == event.getTarget()) {
                        this.cmd_ok_Simple();
                    }
                    if ((editorTo = this.m_sEditorsTo.get(i)) != null && editor.getComponent() == event.getTarget()) {
                        this.cmd_ok_Simple();
                    }
                    ++i;
                }
            }
        }
    }

    private void onCancel() {
        this.m_isCancel = true;
        this.dispose();
    }

    public void onSelectedQueryChanged() {
        this.m_whereUserQuery = null;
        this.showAdvanced();
        this.btnSave.setDisabled(false);
        this.btnShare.setDisabled(false);
        int index = this.fQueryName.getSelectedIndex();
        if (index < 0) {
            return;
        }
        if (this.winMain.getComponent().getSelectedIndex() != 1) {
            this.winMain.getComponent().setSelectedIndex(1);
            this.btnSave.setDisabled(this.m_AD_Tab_ID <= 0);
            this.btnShare.setDisabled(this.m_AD_Tab_ID <= 0);
            this.historyCombo.setSelectedItem(null);
            this.fQueryName.setReadonly(false);
        }
        this.msgLabel.setText("");
        if (index == 0) {
            List rowList = this.advancedPanel.getChildren();
            int rowIndex = rowList.size() - 1;
            while (rowIndex >= 1) {
                rowList.remove(rowIndex);
                --rowIndex;
            }
            this.createFields();
        } else {
            MUserQuery uq = this.userQueries[index - 1];
            this.btnSave.setDisabled(!uq.userCanSave());
            this.btnShare.setDisabled(!uq.userCanShare());
            this.parseUserQuery(this.userQueries[index - 1]);
        }
    }

    private void onSimpleTabSelected() {
        this.historyCombo.setDisabled(false);
        if (this.m_sEditors.size() > 0) {
            Clients.response((AuResponse)new AuFocus(this.m_sEditors.get(0).getComponent()));
        }
    }

    private void onAdvanceTabSelected() {
        this.historyCombo.setSelectedItem(null);
        if (this.advancedPanel.getItems().size() == 0) {
            this.createFields();
        }
        this.focusToLastAdvanceRow();
    }

    private void focusToLastAdvanceRow() {
        if (this.advancedPanel.getItemCount() > 0) {
            ListItem li = this.advancedPanel.getItemAtIndex(this.advancedPanel.getItemCount() - 1);
            Combobox combo = (Combobox)li.getFellow("listColumn" + li.getId());
            combo.focus();
        }
    }

    private void parseUserQuery(MUserQuery userQuery) {
        if (userQuery == null) {
            return;
        }
        String code = userQuery.getCode();
        if (code.startsWith("@SQL=")) {
            this.m_whereUserQuery = "(" + code.substring(code.indexOf("=") + 1, code.length()) + ")";
            if (log.isLoggable(Level.INFO)) {
                log.log(Level.INFO, this.m_whereUserQuery);
            }
            this.hideAdvanced();
        } else {
            String history;
            String[] segments = code.split(Pattern.quote(SEGMENT_SEPARATOR));
            List rowList = this.advancedPanel.getChildren();
            int rowIndex = rowList.size() - 1;
            while (rowIndex >= 1) {
                rowList.remove(rowIndex);
                --rowIndex;
            }
            int i = 0;
            while (i < segments.length) {
                String[] fields = segments[i].split(Pattern.quote(FIELD_SEPARATOR));
                this.createFields(fields, i);
                ++i;
            }
            String[] historysegments = code.split(Pattern.quote(HISTORY_SEPARATOR));
            String string = history = historysegments.length > 1 ? historysegments[1] : "";
            if (history.length() > 0) {
                this.historyCombo.setAttribute("history", history);
                this.historyCombo.setSelectedIndex(this.getHistoryIndex(history) + 1);
            }
        }
        this.winAdvanced.invalidate();
    }

    private int getHistoryIndex(String value) {
        int myIndex = 0;
        if (value.equals(HISTORY_DAY_YEAR)) {
            myIndex = 1;
        } else if (value.equals(HISTORY_DAY_MONTH)) {
            myIndex = 2;
        } else if (value.equals(HISTORY_DAY_WEEK)) {
            myIndex = 3;
        } else if (value.equals(HISTORY_DAY_DAY)) {
            myIndex = 4;
        }
        return myIndex;
    }

    private WEditor parseString(GridField field, String in, ListItem listItem, boolean to) {
        if (in == null) {
            return null;
        }
        int dt = field.getDisplayType();
        try {
            WEditor editor = null;
            editor = field.isKey() ? new WNumberEditor(field) : WebEditorFactory.getEditor(field, true);
            if (editor == null) {
                editor = new WStringEditor(field);
            }
            if (dt == 11 || DisplayType.isID((int)dt) && field.getColumnName().endsWith("_ID")) {
                int i = Integer.parseInt(in);
                editor.setValue(i);
            } else if (DisplayType.isNumeric((int)dt)) {
                editor.setValue(DisplayType.getNumberFormat((int)dt).parse(in));
            } else if (DisplayType.isDate((int)dt)) {
                long time = 0L;
                try {
                    time = DisplayType.getTimestampFormat_Default().parse(in).getTime();
                    editor.setValue(new Timestamp(time));
                }
                catch (Exception e) {
                    StringBuilder msglog = new StringBuilder().append(in.toString()).append("(").append(in.getClass()).append(")").append(e);
                    log.log(Level.SEVERE, msglog.toString());
                    time = DisplayType.getDateFormat((int)dt).parse(in).getTime();
                }
                editor.setValue(new Timestamp(time));
            } else if (dt == 20) {
                boolean val = "Y".equalsIgnoreCase(in) || "true".equalsIgnoreCase(in);
                editor.setValue(val);
            } else {
                editor.setValue(in);
            }
            editor.addValueChangeListener(this);
            boolean between = false;
            Combobox listOp = (Combobox)listItem.getFellow("listOperator" + listItem.getId());
            String betweenValue = listOp.getSelectedItem() != null ? listOp.getSelectedItem().getValue().toString() : null;
            String opValue = MQuery.OPERATORS[8].getValue();
            if (to && betweenValue != null && betweenValue.equals(opValue)) {
                between = true;
            }
            boolean enabled = !to || to && between;
            editor.setReadWrite(enabled);
            editor.setVisible(enabled);
            editor.dynamicDisplay();
            return editor;
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Object=" + in, (Throwable)ex);
            return null;
        }
    }

    private void cmd_saveAdvanced(boolean saveQuery, boolean shareAllUsers) {
        block57: {
            block48: {
                this.m_query = new MQuery(this.m_tableName);
                this.m_query.addRestriction(Env.parseContext((Properties)Env.getCtx(), (int)this.m_targetWindowNo, (String)this.m_whereExtended, (boolean)false));
                if (this.m_whereUserQuery != null) break block48;
                StringBuilder code = new StringBuilder();
                int openBrackets = 0;
                boolean isCompositeExists = false;
                List rowList = this.advancedPanel.getChildren();
                int rowIndex = 1;
                while (rowIndex < rowList.size()) {
                    block49: {
                        Object value2;
                        Object value;
                        String Operator;
                        String andOr;
                        String rBrackets;
                        String lBrackets;
                        String tableUID;
                        String ColumnName;
                        boolean isRightBracketCompositeExists;
                        block55: {
                            String infoDisplay;
                            Object parsedValue;
                            boolean not;
                            boolean and;
                            String ColumnSQL;
                            GridField field;
                            String infoName;
                            boolean isExistCondition;
                            boolean isExists;
                            Combobox table2;
                            block56: {
                                boolean isProductCategoryField;
                                block54: {
                                    Component compo;
                                    ListItem row;
                                    block53: {
                                        Combobox op;
                                        Listbox listRightBracket;
                                        block52: {
                                            String exists;
                                            block51: {
                                                Combobox column;
                                                block50: {
                                                    row = (ListItem)((Object)rowList.get(rowIndex));
                                                    table2 = (Combobox)row.getFellow("listTable" + row.getId());
                                                    exists = "";
                                                    isExists = false;
                                                    isExistCondition = false;
                                                    isRightBracketCompositeExists = false;
                                                    if (table2.getSelectedItem() != null && !table2.getSelectedItem().getValue().toString().equals("M_Attribute_ID") && this.m_windowPanel != null) {
                                                        this.m_gridTab = !table2.getSelectedItem().getValue().toString().isEmpty() ? this.m_windowPanel.getGridWindow().getGridTab((String)table2.getSelectedItem().getValue()) : this.m_windowPanel.getGridWindow().getGridTab(this.m_AD_Tab_ID);
                                                    }
                                                    if ((column = (Combobox)row.getFellow("listColumn" + row.getId())) == null) break block49;
                                                    if (column.getSelectedItem() != null) break block50;
                                                    column.setSelectedIndex(0);
                                                    break block49;
                                                }
                                                ValueNamePair vnp = (ValueNamePair)column.getSelectedItem().getValue();
                                                ColumnName = vnp.getValue();
                                                tableUID = table2.getSelectedItem() != null ? table2.getSelectedItem().getValue().toString() : "";
                                                infoName = ColumnName;
                                                field = null;
                                                isProductCategoryField = false;
                                                ColumnSQL = null;
                                                if (table2.getSelectedItem() == null || !table2.getSelectedItem().getValue().toString().equals("M_Attribute_ID")) break block51;
                                                ColumnSQL = this.getAttributeSQL(Integer.valueOf(ColumnName));
                                                break block52;
                                            }
                                            field = this.getTargetMField(ColumnName);
                                            if (field == null || field.isVirtualUIColumn()) break block49;
                                            isProductCategoryField = this.isProductCategoryField(field.getColumnName());
                                            ColumnSQL = field.getColumnSQL(false);
                                            if (table2.getSelectedItem() != null && !table2.getSelectedItem().getValue().equals(this.m_AD_Tab_UU)) {
                                                if (!isCompositeExists) {
                                                    exists = "SELECT 1 FROM " + this.m_gridTab.getTableName() + " WHERE " + this.m_gridTab.getTableName() + "." + this.m_gridTab.getLinkColumnName() + " = " + this.m_tableName + "." + this.m_tableName + "_ID ";
                                                    ColumnSQL = String.valueOf(exists) + " AND " + ColumnSQL;
                                                }
                                                isExists = true;
                                            }
                                        }
                                        Listbox listLeftBracket = (Listbox)row.getFellow("listLeftBracket" + row.getId());
                                        lBrackets = listLeftBracket.getSelectedItem().getValue().toString();
                                        if (lBrackets != null) {
                                            openBrackets += lBrackets.length();
                                            if (isExists && !lBrackets.isEmpty()) {
                                                isCompositeExists = true;
                                                isExistCondition = true;
                                            }
                                        } else {
                                            lBrackets = "";
                                        }
                                        if ((rBrackets = (listRightBracket = (Listbox)row.getFellow("listRightBracket" + row.getId())).getSelectedItem().getValue().toString()) != null) {
                                            openBrackets -= rBrackets.length();
                                            if (isCompositeExists && !rBrackets.isEmpty()) {
                                                isRightBracketCompositeExists = true;
                                            }
                                        } else {
                                            rBrackets = "";
                                        }
                                        Listbox listAndOr = (Listbox)row.getFellow("listAndOr" + row.getId());
                                        andOr = listAndOr.getSelectedItem().getValue().toString();
                                        and = true;
                                        not = false;
                                        if (rowIndex > 1) {
                                            boolean bl = and = !"OR".contains(andOr);
                                        }
                                        if (andOr.contains("NOT")) {
                                            not = true;
                                        }
                                        if ((op = (Combobox)row.getFellow("listOperator" + row.getId())) == null) break block49;
                                        Operator = op.getSelectedItem() != null ? op.getSelectedItem().getValue().toString() : "";
                                        ListCell cellQueryFrom = (ListCell)row.getFellow("cellQueryFrom" + row.getId());
                                        value = null;
                                        compo = cellQueryFrom.getFirstChild();
                                        if (compo instanceof Datebox) {
                                            Datebox dbox = (Datebox)compo;
                                            if (dbox.getValue() != null) {
                                                value = new Timestamp(dbox.getValue().getTime());
                                            }
                                        } else if (compo instanceof DatetimeBox) {
                                            DatetimeBox dtbox = (DatetimeBox)compo;
                                            if (dtbox.getValue() != null) {
                                                value = new Timestamp(dtbox.getValue().getTime());
                                            }
                                        } else {
                                            value = compo instanceof Checkbox && cellQueryFrom.getAttribute("value") instanceof Boolean ? ((Boolean)cellQueryFrom.getAttribute("value") != false ? "Y" : "N") : cellQueryFrom.getAttribute("value");
                                        }
                                        if (value != null) break block53;
                                        if (Operator.equals(" IS NULL ") || Operator.equals(" IS NOT NULL ")) {
                                            if (table2.getSelectedItem().getValue().toString().equals("M_Attribute_ID") || isExists) {
                                                String where = "";
                                                if (!isCompositeExists) {
                                                    where = String.valueOf(where) + "EXISTS(";
                                                }
                                                where = String.valueOf(where) + this.m_query.getRestrictionSQL(ColumnSQL, Operator, null, infoName, null, and, openBrackets);
                                                if (!isCompositeExists) {
                                                    where = String.valueOf(where) + ")";
                                                }
                                                this.m_query.addRestriction(where, and, not, isExistCondition, openBrackets);
                                            } else {
                                                this.m_query.addRestriction(ColumnSQL, Operator, null, infoName, null, andOr, openBrackets);
                                            }
                                            this.appendCode(code, ColumnName, Operator, "", "", andOr, lBrackets, rBrackets, tableUID);
                                        }
                                        break block49;
                                    }
                                    parsedValue = null;
                                    parsedValue = table2.getSelectedItem() != null && table2.getSelectedItem().getValue().toString().equals("M_Attribute_ID") ? this.parseAttributeValue(Integer.valueOf(ColumnName), value) : this.parseValue(field, value);
                                    if (parsedValue == null) break block49;
                                    String string = infoDisplay = value == null ? "" : value.toString();
                                    if (table2.getSelectedItem() != null && !table2.getSelectedItem().getValue().toString().equals("M_Attribute_ID")) {
                                        if (field.isLookup()) {
                                            infoDisplay = field.getLookup().getDisplay(value);
                                        } else if (field.getDisplayType() == 20) {
                                            infoDisplay = Msg.getMsg((Properties)Env.getCtx(), (String)infoDisplay);
                                        }
                                    }
                                    value2 = null;
                                    if (!MQuery.OPERATORS[8].getValue().equals(Operator)) break block54;
                                    ListCell cellQueryTo = (ListCell)row.getFellow("cellQueryTo" + row.getId());
                                    compo = cellQueryTo.getFirstChild();
                                    if (compo instanceof Div && (compo.getFirstChild() instanceof Datebox || compo.getFirstChild() instanceof DatetimeBox)) {
                                        compo = compo.getFirstChild();
                                    }
                                    if (compo instanceof Datebox) {
                                        Datebox dbox = (Datebox)compo;
                                        if (dbox.getValue() != null) {
                                            value2 = new Timestamp(dbox.getValue().getTime());
                                        }
                                    } else if (compo instanceof DatetimeBox) {
                                        DatetimeBox dtbox = (DatetimeBox)compo;
                                        if (dtbox.getValue() != null) {
                                            value2 = new Timestamp(dtbox.getValue().getTime());
                                        }
                                    } else {
                                        value2 = compo instanceof Checkbox && cellQueryTo.getAttribute("value") instanceof Boolean ? ((Boolean)cellQueryTo.getAttribute("value") != false ? "Y" : "N") : cellQueryTo.getAttribute("value");
                                    }
                                    if (value2 == null) break block49;
                                    Object parsedValue2 = null;
                                    parsedValue2 = table2.getSelectedItem() != null && table2.getSelectedItem().getValue().toString().equals("M_Attribute_ID") ? this.parseAttributeValue(Integer.valueOf(ColumnName), value2) : this.parseValue(field, value2);
                                    String infoDisplay_to = value2.toString();
                                    if (parsedValue2 == null) break block49;
                                    if (table2.getSelectedItem() != null && table2.getSelectedItem().getValue().toString().equals("M_Attribute_ID") || isExists) {
                                        String where = "";
                                        if (!isCompositeExists) {
                                            where = String.valueOf(where) + "EXISTS(";
                                        }
                                        where = String.valueOf(where) + this.m_query.getRestrictionSQL(ColumnSQL, parsedValue, parsedValue2, infoName, infoDisplay, infoDisplay_to, and, openBrackets);
                                        if (!isCompositeExists) {
                                            where = String.valueOf(where) + ")";
                                        }
                                        this.m_query.addRestriction(where, and, not, isExistCondition, openBrackets);
                                    } else {
                                        this.m_query.addRangeRestriction(ColumnSQL, parsedValue, parsedValue2, infoName, infoDisplay, infoDisplay_to, andOr, openBrackets);
                                    }
                                    break block55;
                                }
                                if (!isProductCategoryField || !MQuery.OPERATORS[0].getValue().equals(Operator)) break block56;
                                if (!(parsedValue instanceof Integer)) break block49;
                                String where_rest = this.getSubCategoryWhereClause(field, (Integer)parsedValue);
                                if (isExists && !isCompositeExists) {
                                    where_rest = "EXISTS(" + where_rest + ")";
                                }
                                this.m_query.addRestriction(where_rest, and, not, isExistCondition, openBrackets);
                                break block55;
                            }
                            if (field != null && (field.getDisplayType() == 200161 || field.getDisplayType() == 200163 || field.getDisplayType() == 200162) && (MQuery.OPERATORS[0].getValue().equals(Operator) || MQuery.OPERATORS[1].getValue().equals(Operator))) {
                                String clause = DB.intersectClauseForCSV((String)ColumnSQL, (String)parsedValue.toString());
                                if (MQuery.OPERATORS[0].getValue().equals(Operator)) {
                                    this.m_query.addRestriction(clause, openBrackets, andOr);
                                } else {
                                    this.m_query.addRestriction("NOT (" + clause + ")", openBrackets, andOr);
                                }
                            } else if (table2.getSelectedItem() != null && table2.getSelectedItem().getValue().toString().equals("M_Attribute_ID") || isExists) {
                                String where = "";
                                if (!isCompositeExists) {
                                    where = String.valueOf(where) + "EXISTS(";
                                }
                                where = String.valueOf(where) + this.m_query.getRestrictionSQL(ColumnSQL, Operator, parsedValue, infoName, infoDisplay, and, openBrackets);
                                if (!isCompositeExists) {
                                    where = String.valueOf(where) + ")";
                                }
                                this.m_query.addRestriction(where, and, not, isExistCondition, openBrackets);
                            } else {
                                this.m_query.addRestriction(ColumnSQL, Operator, parsedValue, infoName, infoDisplay, and, not, openBrackets);
                            }
                        }
                        if (isRightBracketCompositeExists) {
                            isCompositeExists = false;
                        }
                        this.appendCode(code, ColumnName, Operator, value.toString(), value2 != null ? value2.toString() : "", andOr, lBrackets, rBrackets, tableUID);
                    }
                    ++rowIndex;
                }
                this.saveQuery(saveQuery, code, shareAllUsers);
                break block57;
            }
            this.m_query.addRestriction(Env.parseContext((Properties)Env.getCtx(), (int)this.m_targetWindowNo, (String)this.m_whereUserQuery, (boolean)false));
        }
    }

    private void appendCode(StringBuilder code, String columnName, String operator, String value1, String value2, String andOr, String lBrackets, String rBrackets, String tableUID) {
        if (code.length() > 0) {
            code.append(SEGMENT_SEPARATOR);
        }
        code.append(columnName).append(FIELD_SEPARATOR).append(operator).append(FIELD_SEPARATOR).append(value1).append(FIELD_SEPARATOR).append(value2).append(FIELD_SEPARATOR).append(andOr).append(FIELD_SEPARATOR).append(lBrackets).append(FIELD_SEPARATOR).append(rBrackets).append(FIELD_SEPARATOR).append(tableUID);
    }

    private void saveQuery(boolean saveQuery, StringBuilder code, boolean shareAllUsers) {
        String selected = this.fQueryName.getValue();
        if (selected != null) {
            String name = selected;
            if ((this.fQueryName.getSelectedIndex() == 0 || name.equals(this.m_sNew)) && saveQuery) {
                Dialog.warn(this.m_targetWindowNo, "NeedsName", name, null);
                return;
            }
            if (saveQuery) {
                if (this.historyCombo.getSelectedItem() != null) {
                    code.append(SEGMENT_SEPARATOR);
                    code.append(HISTORY_SEPARATOR);
                    code.append(this.historyCombo.getSelectedItem().getValue());
                }
                MUserQuery uq = MUserQuery.getUserQueryByName((Properties)Env.getCtx(), (int)this.m_AD_Tab_ID, (String)name);
                if (code.length() > 0) {
                    if (uq == null) {
                        uq = new MUserQuery(Env.getCtx(), 0, null);
                        uq.setName(name);
                        uq.setAD_Tab_ID(this.m_AD_Tab_ID);
                        uq.setAD_User_ID(Env.getAD_User_ID((Properties)Env.getCtx()));
                    }
                    if (shareAllUsers) {
                        uq.setAD_User_ID(-1);
                    }
                } else if (code.length() <= 0) {
                    if (uq == null) {
                        Dialog.warn(this.m_targetWindowNo, "NeedsQuery", name, null);
                        return;
                    }
                    if (uq.delete(true)) {
                        Dialog.info(this.m_targetWindowNo, "Deleted", name);
                        this.refreshUserQueries();
                    } else {
                        Dialog.warn(this.m_targetWindowNo, "DeleteError", name, null);
                    }
                    return;
                }
                uq.setCode(code.toString());
                uq.setAD_Table_ID(this.m_AD_Table_ID);
                if (uq.save()) {
                    this.msgLabel.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"Saved"));
                    this.refreshUserQueries();
                } else {
                    this.msgLabel.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"SaveError"));
                }
            }
        }
    }

    private void cmd_saveSimple(boolean saveQuery, boolean shareAllUsers) {
        this.m_query = new MQuery(this.m_tableName);
        this.m_query.addRestriction(Env.parseContext((Properties)Env.getCtx(), (int)this.m_targetWindowNo, (String)this.m_whereExtended, (boolean)false));
        StringBuilder code = new StringBuilder();
        int i = 0;
        while (i < this.m_sEditors.size()) {
            StringBuilder ColumnSQL;
            GridField field;
            StringBuilder msglog;
            WEditor wed = this.m_sEditors.get(i);
            Object value = wed.getValue();
            String ColumnName = wed.getColumnName();
            WEditor wedTo = this.m_sEditorsTo.get(i);
            Object valueTo = null;
            if (wedTo != null && wedTo.getComponent().isVisible()) {
                valueTo = wedTo.getValue();
            }
            if (value != null && value.toString().length() > 0) {
                if (valueTo != null && valueTo.toString().length() > 0) {
                    if (log.isLoggable(Level.FINE)) {
                        msglog = new StringBuilder(ColumnName).append(">=").append(value).append("<=").append(valueTo);
                        log.fine(msglog.toString());
                    }
                    if (!(field = this.getTargetMField(ColumnName)).isVirtualUIColumn()) {
                        ColumnSQL = new StringBuilder(field.getSearchColumnSQL());
                        this.m_query.addRangeRestriction(ColumnSQL.toString(), value, valueTo, ColumnName, wed.getDisplay(), wedTo.getDisplay(), true, 0);
                        this.appendCode(code, ColumnName, " BETWEEN ", value.toString(), valueTo.toString(), "AND", "", "", this.m_AD_Tab_UU);
                    }
                } else {
                    if (log.isLoggable(Level.FINE)) {
                        msglog = new StringBuilder(ColumnName).append("=").append(value);
                        log.fine(msglog.toString());
                    }
                    field = this.getTargetMField(ColumnName);
                    boolean isProductCategoryField = this.isProductCategoryField(field.getColumnName());
                    StringBuilder ColumnSQL2 = new StringBuilder(field.getSearchColumnSQL());
                    if (field.isEncrypted()) {
                        String Operator = " IS NULL ";
                        if ("Y".equals(value)) {
                            Operator = " IS NOT NULL ";
                        }
                        this.m_query.addRestriction(ColumnSQL2.toString(), Operator, null, ColumnName, wed.getDisplay());
                        this.appendCode(code, ColumnName, Operator, "", "", "AND", "", "", this.m_AD_Tab_UU);
                    } else if (field.getDisplayType() == 200161 || field.getDisplayType() == 200163 || field.getDisplayType() == 200162) {
                        String clause = DB.intersectClauseForCSV((String)ColumnSQL2.toString(), (String)value.toString());
                        this.m_query.addRestriction(clause);
                    } else {
                        isProductCategoryField = this.isProductCategoryField(field.getColumnName());
                        ColumnSQL2 = new StringBuilder(field.getColumnSQL(false));
                        if (this.isSearchLike(field)) {
                            StringBuilder valueStr = new StringBuilder(value.toString().toUpperCase());
                            if (!valueStr.toString().endsWith("%")) {
                                valueStr.append("%");
                            }
                            ColumnSQL2 = new StringBuilder("UPPER(").append((CharSequence)ColumnSQL2).append(")");
                            value = valueStr.toString();
                        }
                        if (value.toString().indexOf(37) != -1) {
                            this.m_query.addRestriction(ColumnSQL2.toString(), " LIKE ", value, ColumnName, wed.getDisplay());
                            this.appendCode(code, ColumnName, " LIKE ", value.toString(), "", "AND", "", "", this.m_AD_Tab_UU);
                        } else if (isProductCategoryField && value instanceof Integer) {
                            this.m_query.addRestriction(this.getSubCategoryWhereClause(field, (Integer)value));
                            this.appendCode(code, ColumnName, "=", value.toString(), "", "AND", "", "", this.m_AD_Tab_UU);
                        } else {
                            ToolBarButton wedFlag;
                            String oper = "=";
                            if (wedTo != null && (wedFlag = this.m_sEditorsFlag.get(i)).isChecked()) {
                                oper = ">=";
                            }
                            this.m_query.addRestriction(ColumnSQL2.toString(), oper, value, ColumnName, wed.getDisplay());
                            this.appendCode(code, ColumnName, oper, value.toString(), "", "AND", "", "", this.m_AD_Tab_UU);
                        }
                    }
                }
            } else if (valueTo != null && valueTo.toString().length() > 0) {
                if (log.isLoggable(Level.FINE)) {
                    msglog = new StringBuilder(ColumnName).append("<=").append(valueTo);
                    log.fine(msglog.toString());
                }
                field = this.getTargetMField(ColumnName);
                ColumnSQL = new StringBuilder(field.getSearchColumnSQL());
                this.m_query.addRestriction(ColumnSQL.toString(), "<=", valueTo, ColumnName, wed.getDisplay());
                this.appendCode(code, ColumnName, "<=", valueTo.toString(), "", "AND", "", "", this.m_AD_Tab_UU);
            }
            ++i;
        }
        if (this.historyCombo.getSelectedItem() != null) {
            this.addHistoryRestriction(this.historyCombo.getSelectedItem());
        }
        this.saveQuery(saveQuery, code, shareAllUsers);
    }

    private void refreshUserQueries() {
        String value = this.m_sNew;
        if (this.fQueryName.getItemCount() > 0) {
            value = this.fQueryName.getValue();
        }
        this.userQueries = MUserQuery.get((Properties)Env.getCtx(), (int)this.m_AD_Tab_ID);
        this.fQueryName.getItems().clear();
        boolean selected = false;
        this.fQueryName.appendItem(this.m_sNew, 0);
        int i = 0;
        while (i < this.userQueries.length) {
            Comboitem ci = this.fQueryName.appendItem(this.userQueries[i].getName());
            ci.setValue((Object)this.userQueries[i].getAD_UserQuery_ID());
            if (value.equals(this.userQueries[i].getName())) {
                this.fQueryName.setSelectedItem(ci);
                this.parseUserQuery(this.userQueries[i]);
                selected = true;
            }
            ++i;
        }
        if (!selected) {
            this.fQueryName.setSelectedIndex(0);
        }
    }

    private String getColumnName(ListItem row) {
        Combobox listColumn = (Combobox)row.getFellow("listColumn" + row.getId());
        String columnName = "";
        if (listColumn.getSelectedItem() != null) {
            ValueNamePair vnp = (ValueNamePair)listColumn.getSelectedItem().getValue();
            columnName = vnp.getValue();
        }
        return columnName;
    }

    private void addRowEditor(Component component, ListCell listcell) {
        listcell.setLabel("");
        listcell.getChildren().clear();
        listcell.appendChild(component);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)component, "1");
        listcell.invalidate();
    }

    private void addOperators(Comboitem column, Combobox listOperator) {
        ValueNamePair pair = (ValueNamePair)column.getValue();
        String columnName = pair.getValue();
        int referenceType = -1;
        boolean isEncrypted = false;
        if (columnName != null) {
            MTable table2 = null;
            table2 = this.m_gridTab != null ? MTable.get((Properties)Env.getCtx(), (String)this.m_gridTab.getTableName()) : MTable.get((Properties)Env.getCtx(), (String)this.m_tableName);
            MColumn col = table2.getColumn(columnName);
            referenceType = col.getAD_Reference_ID();
            GridField field = this.getTargetMField(columnName);
            boolean bl = isEncrypted = col.isEncrypted() || field.isEncrypted();
        }
        if (isEncrypted) {
            this.addOperators(MQuery.OPERATORS_ENCRYPTED, listOperator);
        } else if (DisplayType.isLookup((int)referenceType) || 20 == referenceType || 28 == referenceType || 25 == referenceType || 33 == referenceType || 53370 == referenceType || 32 == referenceType || 21 == referenceType || 31 == referenceType || 35 == referenceType) {
            this.addOperators(MQuery.OPERATORS_LOOKUP, listOperator);
        } else if (DisplayType.isNumeric((int)referenceType) || DisplayType.isID((int)referenceType)) {
            this.addOperators(MQuery.OPERATORS_NUMBERS, listOperator);
        } else if (DisplayType.isDate((int)referenceType)) {
            this.addOperators(MQuery.OPERATORS_DATES, listOperator);
        } else {
            this.addOperators(MQuery.OPERATORS_STRINGS, listOperator);
        }
    }

    private void addOperators(ValueNamePair[] op, Combobox listOperator) {
        List itemList = listOperator.getChildren();
        itemList.clear();
        ValueNamePair[] valueNamePairArray = op;
        int n = op.length;
        int n2 = 0;
        while (n2 < n) {
            ValueNamePair item = valueNamePairArray[n2];
            listOperator.appendItem(Msg.getMsg((Properties)Env.getCtx(), (String)item.getName()).trim(), item.getValue());
            ++n2;
        }
        listOperator.setSelectedIndex(0);
    }

    public WEditor getEditor(ListItem row, boolean to) {
        String columnName = this.getColumnName(row);
        boolean between = false;
        Combobox listOp = (Combobox)row.getFellow("listOperator" + row.getId());
        String betweenValue = listOp.getSelectedItem() != null ? listOp.getSelectedItem().getValue().toString() : null;
        String opValue = MQuery.OPERATORS[8].getValue();
        if (to && betweenValue != null && betweenValue.equals(opValue)) {
            between = true;
        }
        boolean enabled = !to || to && between;
        GridField field = this.getTargetMField(columnName);
        if (field == null) {
            return null;
        }
        GridField findField = field.clone(this.m_advanceCtx);
        findField.setGridTab(null);
        WEditor editor = null;
        if (findField.isKey() || !DisplayType.isLookup((int)findField.getDisplayType()) && DisplayType.isID((int)findField.getDisplayType()) && findField.getDisplayType() != 200202) {
            editor = new WNumberEditor(findField);
        } else if (findField.getDisplayType() == 28) {
            if (findField.getAD_Reference_Value_ID() > 0) {
                MLookupInfo info = MLookupFactory.getLookup_List((Language)Env.getLanguage((Properties)Env.getCtx()), (int)findField.getAD_Reference_Value_ID());
                info.tabNo = 99;
                MLookup mLookup = new MLookup(info, 0);
                editor = new WTableDirEditor(columnName, false, false, true, (Lookup)mLookup);
                findField.addPropertyChangeListener((PropertyChangeListener)editor);
            } else {
                editor = columnName.endsWith("_ID") ? new WNumberEditor(findField) : new WStringEditor(findField);
            }
        } else if (DisplayType.isLookup((int)findField.getDisplayType())) {
            findField.loadLookupNoValidate();
            Lookup lookup = findField.getLookup();
            if (lookup != null && lookup instanceof MLookup) {
                MLookup mLookup = (MLookup)lookup;
                mLookup.getLookupInfo().tabNo = 99;
                if (findField.getVO().ValidationCodeLookup != null && !findField.getVO().ValidationCodeLookup.isEmpty()) {
                    mLookup.getLookupInfo().ValidationCode = findField.getVO().ValidationCodeLookup;
                    mLookup.getLookupInfo().IsValidated = false;
                }
            }
            editor = WebEditorFactory.getEditor(findField, true);
            findField.addPropertyChangeListener((PropertyChangeListener)editor);
        } else {
            editor = WebEditorFactory.getEditor(findField, true);
            findField.addPropertyChangeListener((PropertyChangeListener)editor);
        }
        if (editor == null) {
            editor = new WStringEditor(findField);
            findField.addPropertyChangeListener((PropertyChangeListener)editor);
        }
        this.setLengthStringField(findField, editor.getComponent());
        editor.addValueChangeListener(this);
        editor.setValue(null);
        editor.setReadWrite(enabled);
        editor.setVisible(enabled);
        editor.dynamicDisplay();
        editor.updateStyle(false);
        if (editor instanceof WPaymentEditor) {
            ((WPaymentEditor)editor).getComponent().setEnabled(true, false);
        }
        if (to) {
            row.setAttribute(FIND_ROW_EDITOR_TO, editor);
        } else {
            row.setAttribute(FIND_ROW_EDITOR, editor);
        }
        return editor;
    }

    public Component getEditorComponent(ListItem row, boolean to) {
        WEditor editor = this.getEditor(row, to);
        return editor != null ? editor.getComponent() : new Label("");
    }

    public GridField getTargetMField(String columnName) {
        if (columnName == null) {
            return null;
        }
        if (this.m_gridTab == null) {
            int c = 0;
            while (c < this.m_findFields.length) {
                GridField field = this.m_findFields[c];
                if (field != null && columnName.equals(field.getColumnName())) {
                    return field;
                }
                ++c;
            }
        } else {
            int c = 0;
            while (c < this.m_gridTab.getFields().length) {
                GridField field = this.m_gridTab.getFields()[c];
                if (field != null && columnName.equals(field.getColumnName())) {
                    return field;
                }
                ++c;
            }
        }
        return null;
    }

    private void cmd_ok_Simple() {
        this.m_isCancel = false;
        this.cmd_saveSimple(false, false);
        if (this.getNoOfRecords(this.m_query, true) != 0) {
            if (this.m_total == -255) {
                Dialog.error(this.m_targetWindowNo, "InfoQueryTimeOutError");
            } else {
                if (this.advancedPanel != null) {
                    this.advancedPanel.getItems().clear();
                }
                this.dispose();
            }
        }
    }

    private int getHistoryDays(String selectedItem) {
        int retDays = 0;
        if (selectedItem.equals(HISTORY_DAY_DAY)) {
            retDays = 1;
        } else if (selectedItem.equals(HISTORY_DAY_WEEK)) {
            retDays = 7;
        } else if (selectedItem.equals(HISTORY_DAY_MONTH)) {
            retDays = 31;
        } else if (selectedItem.equals(HISTORY_DAY_YEAR)) {
            retDays = 365;
        }
        return retDays;
    }

    private void addHistoryRestriction(Comboitem selectedHistoryItem) {
        String selectedHistoryValue = (String)this.historyCombo.getSelectedItem().getValue();
        if (log.isLoggable(Level.INFO)) {
            log.info("History combo selected value  =" + selectedHistoryValue);
        }
        if (selectedHistoryItem != null && selectedHistoryItem.toString().length() > 0 && this.getHistoryDays(selectedHistoryValue) > 0) {
            StringBuilder where = new StringBuilder(this.m_tableName);
            where.append(".Created >= ");
            where.append("getDate()-").append(this.getHistoryDays(selectedHistoryValue));
            this.m_query.addRestriction(where.toString());
        }
    }

    @Override
    public void dispose() {
        this.setVisible(false);
        this.isvalid = false;
        Events.sendEvent((Component)this, (Event)new Event("onWindowClose", (Component)this, null));
    }

    private void cmd_ok_Advanced() {
        this.m_isCancel = false;
        this.cmd_saveAdvanced(false, false);
        if (this.historyCombo.getSelectedItem() != null) {
            this.addHistoryRestriction(this.historyCombo.getSelectedItem());
        }
        if (this.getNoOfRecords(this.m_query, true) != 0) {
            if (this.m_total == -255) {
                Dialog.error(this.m_targetWindowNo, "InfoQueryTimeOutError");
            } else {
                this.dispose();
            }
        }
    }

    public void advancedOkClick() {
        this.onSelectedQueryChanged();
        this.cmd_ok_Advanced();
    }

    private int getNoOfRecords(MQuery query, boolean alertRecords) {
        block21: {
            if (log.isLoggable(Level.CONFIG)) {
                log.config("" + query);
            }
            if (this.initialSlowQuery && (query == null || query.getRestrictionCount() == 0)) {
                return -255;
            }
            StringBuilder sql = new StringBuilder("SELECT COUNT(*) FROM ");
            sql.append(this.m_tableName);
            boolean hasWhere = false;
            if (this.m_whereExtended != null && this.m_whereExtended.length() > 0) {
                sql.append(" WHERE ").append(this.m_whereExtended);
                hasWhere = true;
            }
            if (query != null && query.isActive()) {
                if (hasWhere) {
                    sql.append(" AND ");
                } else {
                    sql.append(" WHERE ");
                }
                sql.append(query.getWhereClause());
            }
            String finalSQL = MRole.getDefault().addAccessSQL(sql.toString(), this.m_tableName, false, false);
            finalSQL = Env.parseContext((Properties)Env.getCtx(), (int)this.m_targetWindowNo, (String)finalSQL, (boolean)false);
            if (log.isLoggable(Level.INFO)) {
                Env.setContext((Properties)Env.getCtx(), (int)this.m_targetWindowNo, (int)99, (String)"_TabInfo_FindSQL", (String)finalSQL);
            }
            int timeout = MSysConfig.getIntValue((String)"GRIDTABLE_LOAD_TIMEOUT_IN_SECONDS", (int)30, (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
            this.m_total = 999999;
            Statement stmt = null;
            ResultSet rs = null;
            try {
                try {
                    stmt = DB.createStatement();
                    if (timeout > 0) {
                        stmt.setQueryTimeout(timeout);
                    }
                    if ((rs = stmt.executeQuery(finalSQL)).next()) {
                        this.m_total = rs.getInt(1);
                    }
                }
                catch (SQLException e) {
                    if (DB.getDatabase().isQueryTimeout(e)) {
                        this.m_total = -255;
                        if (query == null) {
                            this.initialSlowQuery = true;
                        }
                    } else {
                        throw new DBException((Exception)e);
                    }
                    DB.close((ResultSet)rs, (Statement)stmt);
                    rs = null;
                    stmt = null;
                    break block21;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)stmt);
                rs = null;
                stmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)stmt);
            rs = null;
            stmt = null;
        }
        if (this.m_total == 0 && alertRecords) {
            Dialog.warn(this.m_targetWindowNo, "FindZeroRecords", null);
        }
        if (this.m_gridTab != null && alertRecords && this.m_total != -255 && this.m_gridTab.isQueryMax(this.m_total)) {
            Dialog.error(this.m_targetWindowNo, "FindOverMax", String.valueOf(this.m_total) + " > " + this.m_gridTab.getMaxQueryRecords());
            this.m_total = 0;
        } else if (log.isLoggable(Level.CONFIG)) {
            log.config("#" + this.m_total);
        }
        return this.m_total;
    }

    private boolean isProductCategoryField(String columnName) {
        return "M_Product_Category_ID".equals(columnName);
    }

    private String getSubCategoryWhereClause(GridField field, int productCategoryId) {
        StringBuilder retString;
        block8: {
            int subTreeRootParentId = 0;
            retString = new StringBuilder(field.getSearchColumnSQL()).append(" IN (");
            String sql = "SELECT M_Product_Category_ID, M_Product_Category_Parent_ID FROM M_Product_Category WHERE AD_Client_ID=? AND IsActive='Y'";
            Vector<SimpleTreeNode> categories = new Vector<SimpleTreeNode>(100);
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                pstmt = DB.prepareStatement((String)sql, null);
                pstmt.setInt(1, Env.getAD_Client_ID((Properties)Env.getCtx()));
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    if (rs.getInt(1) == productCategoryId) {
                        subTreeRootParentId = rs.getInt(2);
                    }
                    categories.add(new SimpleTreeNode(rs.getInt(1), rs.getInt(2)));
                }
                retString.append(this.getSubCategoriesString(productCategoryId, categories, subTreeRootParentId)).append(") ");
            }
            catch (SQLException e) {
                log.log(Level.SEVERE, sql, (Throwable)e);
                retString = new StringBuilder();
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                break block8;
            }
            catch (AdempiereSystemError e) {
                try {
                    log.log(Level.SEVERE, sql, (Throwable)e);
                    retString = new StringBuilder();
                }
                catch (Throwable throwable) {
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                break block8;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        return retString.toString();
    }

    private String getSubCategoriesString(int productCategoryId, Vector<SimpleTreeNode> categories, int loopIndicatorId) throws AdempiereSystemError {
        StringBuilder ret = new StringBuilder();
        for (SimpleTreeNode node : categories) {
            if (node.getParentId() != productCategoryId) continue;
            if (node.getNodeId() == loopIndicatorId) {
                throw new AdempiereSystemError("The product category tree contains a loop on categoryId: " + loopIndicatorId);
            }
            ret.append(this.getSubCategoriesString(node.getNodeId(), categories, loopIndicatorId)).append(",");
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine(ret.toString());
        }
        StringBuilder msgreturn = new StringBuilder(ret.toString()).append(productCategoryId);
        return msgreturn.toString();
    }

    private Object parseValue(GridField field, Object in) {
        if (in == null) {
            return null;
        }
        int dt = field.getDisplayType();
        try {
            if (dt == 11 || DisplayType.isID((int)dt) && field.getColumnName().endsWith("_ID")) {
                if (in instanceof Integer) {
                    return in;
                }
                int i = Integer.parseInt(in.toString());
                return i;
            }
            if (DisplayType.isNumeric((int)dt)) {
                if (in instanceof BigDecimal) {
                    return in;
                }
                return DisplayType.getNumberFormat((int)dt).parse(in.toString());
            }
            if (DisplayType.isDate((int)dt)) {
                if (in instanceof Timestamp) {
                    return in;
                }
                long time = 0L;
                try {
                    time = DisplayType.getDateFormat_JDBC().parse(in.toString()).getTime();
                    return new Timestamp(time);
                }
                catch (Exception e) {
                    StringBuilder msglog = new StringBuilder(in.toString()).append("(").append(in.getClass()).append(")").append(e);
                    log.log(Level.SEVERE, msglog.toString());
                    time = DisplayType.getDateFormat((int)dt).parse(in.toString()).getTime();
                    return new Timestamp(time);
                }
            }
            if (in instanceof Boolean) {
                return (Boolean)in != false ? "Y" : "N";
            }
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Object=" + in, (Throwable)ex);
            String error = ex.getLocalizedMessage();
            if (error == null || error.length() == 0) {
                error = ex.toString();
            }
            StringBuilder errMsg = new StringBuilder();
            errMsg.append(field.getColumnName()).append(" = ").append(in).append(" - ").append(error);
            Dialog.error(0, "ValidationError", errMsg.toString());
            return null;
        }
        return in;
    }

    public MQuery getQuery() {
        if (this.m_gridTab != null && this.m_total != -255 && this.m_gridTab.isQueryMax(this.m_total) && !this.m_isCancel) {
            this.m_query = MQuery.getNoRecordQuery((String)this.m_tableName, (boolean)false);
            this.m_total = 0;
            if (log.isLoggable(Level.WARNING)) {
                log.warning("Query - over max");
            }
        } else if (log.isLoggable(Level.INFO)) {
            log.info("Query=" + this.m_query);
        }
        return this.m_query;
    }

    public int getTotalRecords() {
        return this.m_total;
    }

    @Override
    public void valueChange(ValueChangeEvent evt) {
        if (evt != null && evt.getSource() instanceof WEditor) {
            WEditor editor = (WEditor)evt.getSource();
            ListCell listcell = null;
            Properties ctx = null;
            if (this.winMain.getComponent().getSelectedIndex() == 1) {
                Component component = editor.getComponent();
                Component parent = component.getParent();
                if (parent != null) {
                    if (parent instanceof ListCell) {
                        listcell = (ListCell)parent;
                        listcell.setAttribute("value", evt.getNewValue());
                    } else {
                        Component secondParent = parent.getParent();
                        if (secondParent instanceof ListCell) {
                            listcell = (ListCell)secondParent;
                            listcell.setAttribute("value", evt.getNewValue());
                        }
                    }
                }
                ctx = this.m_advanceCtx;
            } else {
                ctx = this.m_simpleCtx;
            }
            if (evt.getNewValue() == null) {
                Env.setContext((Properties)ctx, (int)this.m_targetWindowNo, (String)editor.getColumnName(), (String)"");
                Env.setContext((Properties)ctx, (int)this.m_targetWindowNo, (int)99, (String)editor.getColumnName(), (String)"");
            } else if (evt.getNewValue() instanceof Boolean) {
                Env.setContext((Properties)ctx, (int)this.m_targetWindowNo, (String)editor.getColumnName(), (boolean)((Boolean)evt.getNewValue()));
                Env.setContext((Properties)ctx, (int)this.m_targetWindowNo, (int)99, (String)editor.getColumnName(), (boolean)((Boolean)evt.getNewValue()));
            } else if (evt.getNewValue() instanceof Timestamp) {
                Env.setContext((Properties)ctx, (int)this.m_targetWindowNo, (String)editor.getColumnName(), (Timestamp)((Timestamp)evt.getNewValue()));
                Env.setContext((Properties)ctx, (int)this.m_targetWindowNo, (String)("99|" + editor.getColumnName()), (Timestamp)((Timestamp)evt.getNewValue()));
            } else {
                Env.setContext((Properties)ctx, (int)this.m_targetWindowNo, (String)editor.getColumnName(), (String)evt.getNewValue().toString());
                Env.setContext((Properties)ctx, (int)this.m_targetWindowNo, (int)99, (String)editor.getColumnName(), (String)evt.getNewValue().toString());
            }
            this.dynamicDisplay(editor, listcell);
        }
    }

    private void dynamicDisplay(WEditor editor, ListCell listcell) {
        if (this.winMain.getComponent().getSelectedIndex() == 1) {
            List rowList = this.advancedPanel.getChildren();
            int rowIndex = 1;
            while (rowIndex < rowList.size()) {
                Lookup lookup;
                WEditor other;
                ListItem row = (ListItem)((Object)rowList.get(rowIndex));
                if (!Components.isAncestor((Component)row, (Component)listcell) && (other = (WEditor)row.getAttribute(FIND_ROW_EDITOR)) != null && other.getGridField() != null && other.getGridField().isLookup() && !Util.isEmpty((String)(lookup = other.getGridField().getLookup()).getValidation())) {
                    other.dynamicDisplay();
                    other = (WEditor)row.getAttribute(FIND_ROW_EDITOR_TO);
                    if (other != null) {
                        other.dynamicDisplay();
                    }
                }
                ++rowIndex;
            }
        } else {
            int i = 0;
            while (i < this.m_sEditors.size()) {
                Lookup lookup;
                WEditor wed = this.m_sEditors.get(i);
                if (wed != editor && wed.getGridField() != null && wed.getGridField().isLookup() && !Util.isEmpty((String)(lookup = wed.getGridField().getLookup()).getValidation())) {
                    wed.dynamicDisplay();
                    wed = this.m_sEditorsTo.get(i);
                    if (wed != null && wed != editor) {
                        wed.dynamicDisplay();
                    }
                }
                ++i;
            }
        }
    }

    public void OnPostVisible() {
        this.removeAttribute(ON_POST_VISIBLE_ATTR);
        if (this.winMain.getComponent().getSelectedIndex() == 0) {
            if (this.m_sEditors.size() > 0) {
                Clients.response((AuResponse)new AuFocus(this.m_sEditors.get(0).getComponent()));
            }
        } else {
            this.focusToLastAdvanceRow();
        }
    }

    public boolean isCancel() {
        return this.m_isCancel;
    }

    public boolean isCreateNew() {
        return this.m_createNew;
    }

    public boolean setVisible(boolean visible) {
        boolean ret = super.setVisible(visible);
        if (visible) {
            if (this.getAttribute(ON_POST_VISIBLE_ATTR) == null) {
                this.setAttribute(ON_POST_VISIBLE_ATTR, Boolean.TRUE);
                Events.echoEvent((String)"OnPostVisible", (Component)this, null);
            }
            this.isvalid = true;
        }
        return ret;
    }

    private boolean isSearchLike(GridField field) {
        return DisplayType.isText((int)field.getDisplayType()) && !field.isVirtualColumn() && (field.isSelectionColumn() || MColumn.isSuggestSelectionColumn((String)field.getColumnName(), (boolean)true));
    }

    public boolean isValid() {
        return this.isvalid;
    }

    private void setStatusDB(int currentCount) {
        StringBuilder text = new StringBuilder(" ").append(Msg.getMsg((Properties)Env.getCtx(), (String)"Records")).append(" = ").append(this.m_total == -255 ? "?" : Integer.valueOf(this.m_total)).append(" ");
        this.statusBar.setStatusDB(text.toString());
    }

    private void hideAdvanced() {
        this.advancedPanelToolBar.setVisible(false);
        this.advancedPanel.setVisible(false);
    }

    private void showAdvanced() {
        this.advancedPanelToolBar.setVisible(true);
        this.advancedPanel.setVisible(true);
    }

    public int getAD_UserQuery_ID() {
        if (this.fQueryName.getSelectedIndex() <= 0 || this.userQueries[this.fQueryName.getSelectedIndex() - 1] == null) {
            this.m_AD_UserQuery_ID = 0;
        } else if (this.m_AD_UserQuery_ID != this.userQueries[this.fQueryName.getSelectedIndex() - 1].getAD_UserQuery_ID()) {
            this.m_AD_UserQuery_ID = this.userQueries[this.fQueryName.getSelectedIndex() - 1].getAD_UserQuery_ID();
        }
        return this.m_AD_UserQuery_ID;
    }

    public void setAD_UserQuery_ID(int AD_UserQuery_ID) {
        this.m_AD_UserQuery_ID = AD_UserQuery_ID;
        for (Comboitem li : this.fQueryName.getItems()) {
            if (this.m_AD_UserQuery_ID != (Integer)li.getValue()) continue;
            this.fQueryName.setSelectedItem(li);
            break;
        }
    }

    private String getAttributeSQL(Integer M_Attribute_ID) {
        StringBuilder attributeSQL = new StringBuilder();
        MAttribute attribute = new MAttribute(Env.getCtx(), M_Attribute_ID.intValue(), null);
        attributeSQL.append(" SELECT 1 FROM M_AttributeInstance ").append(" WHERE ").append(" M_AttributeInstance.M_AttributeSetInstance_ID = ").append(String.valueOf(this.m_tableName) + ".M_AttributeSetInstance_ID ");
        attributeSQL.append(" AND ").append(" M_AttributeInstance.M_Attribute_ID  = ").append(M_Attribute_ID);
        if (!attribute.getAttributeValueType().equals(String.valueOf(326))) {
            if (attribute.getAttributeValueType().equals("D")) {
                attributeSQL.append(" AND datevalue ");
            } else if (attribute.getAttributeValueType().equals("L")) {
                attributeSQL.append(" AND M_AttributeValue_ID ");
            } else if (attribute.getAttributeValueType().equals("N")) {
                attributeSQL.append(" AND valuenumber ");
            } else if (attribute.getAttributeValueType().equals("S")) {
                attributeSQL.append(" AND value ");
            }
        }
        return attributeSQL.toString();
    }

    private Component parseAttributeString(int M_Attribute_ID, String value, ListItem listItem, boolean isValueTo) {
        if (value == null) {
            return null;
        }
        try {
            boolean between = false;
            Combobox listOp = (Combobox)listItem.getFellow("listOperator" + listItem.getId());
            String betweenValue = listOp.getSelectedItem().getValue().toString();
            String opValue = MQuery.OPERATORS[8].getValue();
            if (isValueTo && betweenValue != null && betweenValue.equals(opValue)) {
                between = true;
            }
            boolean enabled = !isValueTo || isValueTo && between;
            MAttribute attribute = new MAttribute(Env.getCtx(), M_Attribute_ID, null);
            WEditor editor = null;
            String attributeValue = attribute.getAttributeValueType();
            if (attributeValue.equals(String.valueOf(326))) {
                editor = new WNumberEditor();
                int i = Integer.parseInt(value);
                editor.setValue(i);
            } else if (attributeValue.equals("D")) {
                editor = new WDateEditor();
                long time = DisplayType.getDateFormat_JDBC().parse(value.toString()).getTime();
                editor.setValue(new Timestamp(time));
            } else if (attributeValue.equals("L")) {
                int AD_Column_ID = MColumn.getColumn_ID((String)"M_AttributeValue", (String)"M_AttributeValue_ID");
                MLookup attributeValues = MLookupFactory.get((Properties)Env.getCtx(), (int)this.m_targetWindowNo, (int)AD_Column_ID, (int)19, (Language)Env.getLanguage((Properties)Env.getCtx()), (String)"M_AttributeValue_ID", (int)0, (boolean)true, (String)(" M_AttributeValue.M_Attribute_ID = " + attribute.get_ID()));
                editor = new WTableDirEditor("M_AttributeValue_ID", true, false, true, (Lookup)attributeValues);
                editor.setValue(Integer.valueOf(value));
            } else if (attributeValue.equals("N")) {
                editor = new WNumberEditor();
                editor.setValue(new BigDecimal(value));
            } else if (attributeValue.equals("S")) {
                editor = new WStringEditor("Test", true, false, true, 40, 40, null, null);
                editor.setValue(value);
            }
            editor.addValueChangeListener(this);
            editor.setReadWrite(enabled);
            editor.setVisible(enabled);
            return editor.getComponent();
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Object=" + value, (Throwable)ex);
            return null;
        }
    }

    private void setAttributes(Combobox listColumn, Combobox listOperator, String[] fields) {
        String columnName = null;
        String operator = null;
        if (fields != null) {
            columnName = fields.length > 0 ? fields[0] : "";
            operator = fields.length > 1 ? fields[1] : "";
        }
        listColumn.getChildren().clear();
        ArrayList<ValueNamePair> items = new ArrayList<ValueNamePair>();
        items.add(new ValueNamePair("", " "));
        List attributes = new Query(Env.getCtx(), "M_Attribute", " AD_Client_ID IN (? , ?) ", null).setParameters(new Object[]{0, Env.getAD_Client_ID((Properties)Env.getCtx())}).list();
        for (MAttribute attribute : attributes) {
            String l_columnName = attribute.getName();
            String header = String.valueOf(attribute.get_ID());
            ValueNamePair pp = new ValueNamePair(header, l_columnName);
            items.add(pp);
        }
        Object[] cols = new ValueNamePair[items.size()];
        items.toArray(cols);
        Arrays.sort(cols);
        ValueNamePair[] operators = MQuery.OPERATORS;
        if (fields == null) {
            this.updateColumnListModel(listColumn, (ValueNamePair[])cols);
            listColumn.setSelectedIndex(0);
            listOperator.getItems().clear();
            ValueNamePair[] valueNamePairArray = operators;
            int pp = operators.length;
            int header = 0;
            while (header < pp) {
                ValueNamePair operatorValueName = valueNamePairArray[header];
                listOperator.appendItem(Msg.getMsg((Properties)Env.getCtx(), (String)operatorValueName.getName()).trim(), operatorValueName.getValue());
                ++header;
            }
            listOperator.setSelectedIndex(0);
        } else {
            Object item;
            boolean selected = false;
            this.updateColumnListModel(listColumn, (ValueNamePair[])cols);
            int i = 0;
            while (i < cols.length) {
                item = cols[i];
                if (item.getValue().equals(columnName)) {
                    listColumn.setSelectedIndex(i);
                    selected = true;
                }
                ++i;
            }
            if (!selected) {
                listColumn.setSelectedIndex(0);
            }
            selected = false;
            i = 0;
            while (i < operators.length) {
                item = operators[i];
                listOperator.appendItem(Msg.getMsg((Properties)Env.getCtx(), (String)item.getName()).trim(), item.getValue());
                Comboitem li = listOperator.getItemAtIndex(listOperator.getItemCount() - 1);
                if (item.getValue().equals(operator)) {
                    listOperator.setSelectedItem(li);
                    selected = true;
                }
                ++i;
            }
            if (!selected) {
                listOperator.setSelectedIndex(0);
            }
        }
    }

    private void addOperatorsAttribute(Comboitem column, Combobox listOperator) {
        ValueNamePair pair = (ValueNamePair)column.getValue();
        MAttribute attribute = new MAttribute(Env.getCtx(), Integer.valueOf(pair.getID()).intValue(), null);
        if (attribute.getAttributeValueType().equals("D") || attribute.getAttributeValueType().equals("N")) {
            this.addOperators(MQuery.OPERATORS_NUMBERS, listOperator);
        } else {
            this.addOperators(MQuery.OPERATORS_LOOKUP, listOperator);
        }
    }

    public Component getAttributeValuesListComponent(ListItem row, boolean isValueTo) throws Exception {
        String columnName = this.getColumnName(row);
        if (columnName == null || columnName.isEmpty()) {
            return new Label("");
        }
        boolean between = false;
        Combobox listOp = (Combobox)row.getFellow("listOperator" + row.getId());
        String betweenValue = listOp.getSelectedItem().getValue().toString();
        String opValue = MQuery.OPERATORS[8].getValue();
        if (isValueTo && betweenValue != null && betweenValue.equals(opValue)) {
            between = true;
        }
        boolean enabled = !isValueTo || isValueTo && between;
        MAttribute attribute = new MAttribute(Env.getCtx(), Integer.valueOf(columnName).intValue(), null);
        WEditor editor = null;
        String attributeValue = attribute.getAttributeValueType();
        if (attributeValue.equals(String.valueOf(326))) {
            editor = new WNumberEditor();
        } else if (attributeValue.equals("D")) {
            editor = new WDateEditor();
        } else if (attributeValue.equals("L")) {
            int AD_Column_ID = MColumn.getColumn_ID((String)"M_AttributeValue", (String)"M_AttributeValue_ID");
            MLookup attributeValues = MLookupFactory.get((Properties)Env.getCtx(), (int)this.m_targetWindowNo, (int)AD_Column_ID, (int)19, (Language)Env.getLanguage((Properties)Env.getCtx()), (String)"M_AttributeValue_ID", (int)0, (boolean)true, (String)(" M_AttributeValue.M_Attribute_ID = " + attribute.get_ID()));
            editor = new WTableDirEditor("M_AttributeValue_ID", true, false, true, (Lookup)attributeValues);
        } else if (attributeValue.equals("N")) {
            editor = new WNumberEditor();
        } else if (attributeValue.equals("S")) {
            editor = new WStringEditor("Test", true, false, true, 40, 40, null, null);
        }
        editor.addValueChangeListener(this);
        editor.setValue(null);
        editor.setReadWrite(enabled);
        editor.setVisible(enabled);
        return editor.getComponent();
    }

    private Object parseAttributeValue(int M_Attribute_ID, Object value) {
        MAttribute attribute = new MAttribute(Env.getCtx(), M_Attribute_ID, null);
        if (value == null) {
            return null;
        }
        String dt = attribute.getAttributeValueType();
        try {
            if (dt.equals(String.valueOf(326)) || dt.equals("L")) {
                if (value instanceof Integer) {
                    return value;
                }
                int i = Integer.parseInt(value.toString());
                return i;
            }
            if (dt.equals("N")) {
                if (value instanceof BigDecimal) {
                    return value;
                }
                return new BigDecimal(value.toString());
            }
            if (dt.equals("D")) {
                if (value instanceof Timestamp) {
                    return value;
                }
                long time = 0L;
                try {
                    time = DisplayType.getDateFormat_JDBC().parse(value.toString()).getTime();
                    return new Timestamp(time);
                }
                catch (Exception e) {
                    StringBuilder msglog = new StringBuilder(value.toString()).append("(").append(value.getClass()).append(")").append(e);
                    log.log(Level.SEVERE, msglog.toString());
                    return new Timestamp(time);
                }
            }
            if (value instanceof Boolean) {
                return (Boolean)value != false ? "Y" : "N";
            }
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Object=" + value, (Throwable)ex);
            String error = ex.getLocalizedMessage();
            if (error == null || error.length() == 0) {
                error = ex.toString();
            }
            StringBuilder errMsg = new StringBuilder();
            errMsg.append(attribute.getName()).append(" = ").append(value).append(" - ").append(error);
            Dialog.error(0, "ValidationError", errMsg.toString());
            return null;
        }
        return value;
    }

    private void initTabs() {
        MTab nextSameLevelTab;
        MTab tab = new MTab(Env.getCtx(), this.m_AD_Tab_ID, null);
        String whereClause = "AD_Window_ID=?";
        String whereID = " OR AD_Tab_ID = " + this.m_AD_Tab_ID;
        if (tab.getTabLevel() > 0 && (nextSameLevelTab = (MTab)new Query(Env.getCtx(), "AD_Tab", String.valueOf(whereClause) + " AND TabLevel=? AND SeqNo>?", null).setParameters(new Object[]{tab.getAD_Window_ID(), tab.getTabLevel(), tab.getSeqNo()}).setOrderBy("SeqNo").first()) != null) {
            whereClause = String.valueOf(whereClause) + " AND SeqNo<" + nextSameLevelTab.getSeqNo();
        }
        List list = new Query(Env.getCtx(), "AD_Tab", " ( " + whereClause + " AND TabLevel=? AND SeqNo>?)" + whereID, null).setParameters(new Object[]{tab.getAD_Window_ID(), tab.getTabLevel() + 1, tab.getSeqNo()}).setOnlyActiveRecords(true).setOrderBy("SeqNo ASC").list();
        this.m_tabs = new MTab[list.size()];
        list.toArray(this.m_tabs);
    }

    private boolean isAttributeTable() {
        MTable table2 = new MTable(Env.getCtx(), this.m_AD_Table_ID, null);
        return table2.getColumnIndex(COLUMNNAME_M_AttributeSetInstance_ID) > 0;
    }

    private static class SimpleTreeNode {
        private int nodeId;
        private int parentId;

        public SimpleTreeNode(int nodeId, int parentId) {
            this.nodeId = nodeId;
            this.parentId = parentId;
        }

        public int getNodeId() {
            return this.nodeId;
        }

        public int getParentId() {
            return this.parentId;
        }
    }
}

