/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.window;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.component.Button;
import org.adempiere.webui.component.ComboItem;
import org.adempiere.webui.component.Combobox;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.ListItem;
import org.adempiere.webui.component.Listbox;
import org.adempiere.webui.component.Tab;
import org.adempiere.webui.component.Tabbox;
import org.adempiere.webui.component.Tabpanel;
import org.adempiere.webui.component.Tabpanels;
import org.adempiere.webui.component.Tabs;
import org.adempiere.webui.component.Textbox;
import org.adempiere.webui.component.ZkCssHelper;
import org.adempiere.webui.editor.WEditor;
import org.adempiere.webui.event.ValueChangeEvent;
import org.adempiere.webui.event.ValueChangeListener;
import org.adempiere.webui.factory.ButtonFactory;
import org.compiere.model.MRefList;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.compiere.util.ValueNamePair;
import org.zkoss.zhtml.Br;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.InputEvent;
import org.zkoss.zul.Comboitem;
import org.zkoss.zul.Div;
import org.zkoss.zul.Popup;
import org.zkoss.zul.Spinner;

public class DateRangePicker
extends Popup
implements EventListener<Event>,
ValueChangeListener {
    private static final long serialVersionUID = -1674676283499219325L;
    private static final String DATESELECTIONMODE_PREVIOUS = "01";
    private static final String DATESELECTIONMODE_NEXT = "02";
    private static final String DATESELECTIONMODE_CURRENT = "03";
    private static final String DATESELECTIONMODE_BEFORE = "04";
    private static final String DATESELECTIONMODE_AFTER = "05";
    private static final String DATESELECTIONMODE_ON = "06";
    private static final String DATESELECTIONMODE_BETWEEN = "07";
    private static final String DATESELECTIONMODE_QUICK = "08";
    private Button okBtn;
    private Combobox modeCombobox;
    private Spinner numberBox;
    private Combobox unitCombobox;
    private Textbox dateTextBox;
    private org.zkoss.zul.Calendar cal;
    private org.zkoss.zul.Calendar cal2;
    private Div quickListBoxes;
    private Tabbox tabbox;
    private Tabs tabs;
    private Tabpanels tabpanels;
    private Tab fromTab;
    private Tab toTab;
    private Tabpanel fromTabPanel;
    private Tabpanel toTabPanel;
    private Div midDiv;
    private WEditor editor;
    private WEditor editor2;
    private Date dateFrom;
    private Date dateTo;
    private String displayValue;
    private String oldDisplayValue = "";
    private boolean enableValueChange = true;
    private boolean isMobile = ClientInfo.isMobile() && ClientInfo.maxWidth(699);
    protected ArrayList<ValueChangeListener> listeners = new ArrayList();
    private ArrayList<Listbox> quickListBoxesArray = new ArrayList();
    private ListItem selectedQuickListItem;

    public DateRangePicker(WEditor editor, WEditor editor2) {
        this.editor = editor;
        this.editor2 = editor2;
        this.init();
    }

    private void init() {
        ValueNamePair[] units;
        ValueNamePair[] modes;
        this.editor.addValueChangeListener(this);
        this.editor2.addValueChangeListener(this);
        Div div = new Div();
        this.okBtn = ButtonFactory.createNamedButton("ApplyFilter", true, false);
        this.modeCombobox = new Combobox();
        this.modeCombobox.setSclass("date-picker-component");
        this.modeCombobox.setWidth("120px");
        this.modeCombobox.addEventListener("onSelect", this);
        this.numberBox = new Spinner(1);
        this.numberBox.setConstraint("no empty, min 1");
        this.numberBox.setSclass("date-picker-component");
        this.numberBox.addEventListener("onChanging", (EventListener)this);
        this.unitCombobox = new Combobox();
        this.unitCombobox.setSclass("date-picker-component");
        this.unitCombobox.setWidth("90px");
        this.unitCombobox.addEventListener("onSelect", this);
        this.tabbox = new Tabbox();
        this.tabs = new Tabs();
        this.tabbox.appendChild((Component)this.tabs);
        this.tabpanels = new Tabpanels();
        this.tabbox.appendChild((Component)this.tabpanels);
        this.fromTab = new Tab(Msg.getMsg((Properties)Env.getCtx(), (String)"From"));
        this.tabs.appendChild((Component)this.fromTab);
        this.toTab = new Tab(Msg.getMsg((Properties)Env.getCtx(), (String)"To"));
        this.tabs.appendChild((Component)this.toTab);
        this.fromTabPanel = new Tabpanel();
        this.toTabPanel = new Tabpanel();
        this.tabpanels.appendChild((Component)this.fromTabPanel);
        this.tabpanels.appendChild((Component)this.toTabPanel);
        this.cal = new org.zkoss.zul.Calendar();
        this.cal.setSclass("date-picker-component");
        this.cal.addEventListener("onChange", (EventListener)this);
        this.cal2 = new org.zkoss.zul.Calendar();
        this.cal2.setSclass("date-picker-component");
        this.cal2.addEventListener("onChange", (EventListener)this);
        Label dateTextBoxLabel = new Label(Msg.getMsg((Properties)Env.getCtx(), (String)"SelectedTimeRange"));
        dateTextBoxLabel.setSclass("date-picker-label");
        this.dateTextBox = new Textbox();
        this.dateTextBox.setReadonly(true);
        this.dateTextBox.setSclass("date-picker-component");
        this.dateTextBox.setStyle("min-width: 170px; background: white !important");
        this.dateTextBox.setValue(DisplayType.getDateFormat().format(this.cal.getValue()));
        this.dateTextBox.addEventListener("onChange", this);
        this.okBtn.setSclass("date-picker-component");
        this.okBtn.addEventListener("onClick", event -> {
            this.setDateTextBoxAndDisplayValue();
            if (this.dateFrom != null && this.dateTo != null && this.dateTo.before(this.dateFrom)) {
                throw new WrongValueException((Component)this.dateTextBox, Msg.getMsg((Properties)Env.getCtx(), (String)"EndDateAfterStartDate"));
            }
            if (Util.isEmpty((String)this.dateTextBox.getValue())) {
                this.dateFrom = null;
                this.dateTo = null;
            }
            this.enableValueChange = false;
            this.editor.setValue(this.dateFrom);
            this.editor2.setValue(this.dateTo);
            this.fireValueChange(new ValueChangeEvent(this, "DateRangePicker", this.oldDisplayValue, this.displayValue));
            this.enableValueChange = true;
            this.detach();
        });
        this.quickListBoxes = new Div();
        this.quickListBoxes.appendChild((Component)this.getQuickModeContent());
        ValueNamePair[] valueNamePairArray = modes = MRefList.getList((Properties)Env.getCtx(), (int)200217, (boolean)false, (String)"Value");
        int n = modes.length;
        int n2 = 0;
        while (n2 < n) {
            ValueNamePair mode = valueNamePairArray[n2];
            ComboItem item = new ComboItem(mode.getName(), mode.getValue());
            this.modeCombobox.appendChild((Component)item);
            ++n2;
        }
        if (this.isMobile) {
            this.modeCombobox.removeItemAt(this.modeCombobox.getItemCount() - 1);
        }
        this.modeCombobox.setSelectedIndex(0);
        ValueNamePair[] valueNamePairArray2 = units = MRefList.getList((Properties)Env.getCtx(), (int)53376, (boolean)false);
        int n3 = units.length;
        n = 0;
        while (n < n3) {
            ValueNamePair timeUnit = valueNamePairArray2[n];
            ComboItem item = new ComboItem(timeUnit.getName(), timeUnit.getValue());
            this.unitCombobox.appendChild((Component)item);
            ++n;
        }
        this.unitCombobox.setSelectedIndex(0);
        div.setSclass("date-picker-container");
        div.appendChild((Component)this.modeCombobox);
        if (this.isMobile) {
            ZkCssHelper.appendStyle((HtmlBasedComponent)this.modeCombobox, "margin: 0px 5px 10px 0px !important;");
            div.appendChild((Component)new Br());
        }
        div.appendChild((Component)this.numberBox);
        div.appendChild((Component)this.unitCombobox);
        this.appendChild((Component)div);
        this.midDiv = new Div();
        this.midDiv.appendChild((Component)this.tabbox);
        this.midDiv.setSclass("date-picker-container");
        this.midDiv.setStyle("Margin-top: 10px;");
        this.midDiv.appendChild((Component)this.cal);
        this.midDiv.appendChild((Component)this.cal2);
        this.midDiv.appendChild((Component)this.quickListBoxes);
        this.appendChild((Component)this.midDiv);
        div = new Div();
        div.setSclass("date-picker-container");
        div.setStyle("margin: 10px 0 10px 0;");
        div.appendChild((Component)dateTextBoxLabel);
        div.appendChild((Component)this.dateTextBox);
        div.setSclass("date-picker-container");
        if (this.isMobile) {
            div.appendChild((Component)new Br());
            ZkCssHelper.appendStyle((HtmlBasedComponent)this.okBtn, "margin: 5px 5px 5px 0px !important;");
        } else {
            ZkCssHelper.appendStyle((HtmlBasedComponent)this.okBtn, "float: right;");
        }
        div.appendChild((Component)this.okBtn);
        this.appendChild((Component)div);
        if (this.isMobile) {
            this.setStyle("min-width: 350px;");
        } else {
            this.setStyle("min-width: 320px;");
        }
        this.dateFrom = (Date)this.editor.getValue();
        this.dateTo = (Date)this.editor2.getValue();
        if (this.dateFrom != null || this.dateTo != null) {
            Date[] dates = this.setTimesOnDates(this.dateFrom, this.dateTo);
            this.dateFrom = dates[0];
            this.dateTo = dates[1];
            this.loadPickerSelection();
        } else {
            this.setPickerSelection(DATESELECTIONMODE_CURRENT, "M", 0);
            Date[] dates = this.setTimesOnDates(this.dateFrom, this.dateTo);
            this.dateFrom = dates[0];
            this.dateTo = dates[1];
        }
        this.updateUI();
    }

    private void setPickerSelection(String mode, String unit, int offset) {
        for (Comboitem item : this.modeCombobox.getItems()) {
            if (!item.getValue().equals(mode)) continue;
            this.modeCombobox.setSelectedItem(item);
        }
        for (Comboitem item : this.unitCombobox.getItems()) {
            if (!item.getValue().equals(unit)) continue;
            this.unitCombobox.setSelectedItem(item);
        }
        int numBoxValue = Math.abs(offset) >= 1 ? Math.abs(offset) : 1;
        this.numberBox.setValue(Integer.valueOf(numBoxValue));
        this.setDateTextBoxAndDisplayValue();
    }

    private void updateUI() {
        String selectedMode = this.modeCombobox.getSelectedItem().getValue().toString();
        if (selectedMode.equalsIgnoreCase(DATESELECTIONMODE_BETWEEN) && this.isMobile) {
            this.updateCal1AndCal2();
            this.cal.detach();
            this.fromTabPanel.appendChild((Component)this.cal);
            this.cal2.detach();
            this.toTabPanel.appendChild((Component)this.cal2);
        } else {
            this.cal.detach();
            this.midDiv.appendChild((Component)this.cal);
            this.cal2.detach();
            this.midDiv.appendChild((Component)this.cal2);
        }
        switch (selectedMode) {
            case "04": 
            case "05": 
            case "06": {
                this.tabbox.setVisible(false);
                this.numberBox.setVisible(false);
                this.unitCombobox.setVisible(false);
                this.cal.setVisible(true);
                this.cal2.setVisible(false);
                this.quickListBoxes.setVisible(false);
                break;
            }
            case "07": {
                this.tabbox.setVisible(this.isMobile);
                this.numberBox.setVisible(false);
                this.unitCombobox.setVisible(false);
                this.cal.setVisible(true);
                this.cal2.setVisible(true);
                this.quickListBoxes.setVisible(false);
                break;
            }
            case "03": {
                this.tabbox.setVisible(false);
                this.numberBox.setVisible(false);
                this.unitCombobox.setVisible(true);
                this.cal.setVisible(false);
                this.cal2.setVisible(false);
                this.quickListBoxes.setVisible(false);
                break;
            }
            case "01": 
            case "02": {
                this.tabbox.setVisible(false);
                this.numberBox.setVisible(true);
                this.unitCombobox.setVisible(true);
                this.cal.setVisible(false);
                this.cal2.setVisible(false);
                this.quickListBoxes.setVisible(false);
                break;
            }
            case "08": {
                this.tabbox.setVisible(false);
                this.numberBox.setVisible(false);
                this.unitCombobox.setVisible(false);
                this.cal.setVisible(false);
                this.cal2.setVisible(false);
                this.quickListBoxes.setVisible(true);
                break;
            }
        }
    }

    public void onEvent(Event event) throws Exception {
        String actValue;
        Component target = event.getTarget();
        if (target.equals((Object)this.modeCombobox)) {
            this.updateUI();
        }
        if (target instanceof Listbox) {
            for (Listbox listBox : this.quickListBoxesArray) {
                if (!target.equals((Object)listBox)) {
                    listBox.setSelectedItem(null);
                    continue;
                }
                this.selectedQuickListItem = listBox.getSelectedItem();
            }
        }
        if (target instanceof Spinner && !Util.isEmpty((String)(actValue = String.valueOf(((InputEvent)event).getValue())))) {
            this.numberBox.setValue(Integer.valueOf(actValue));
        }
        this.dateTextBox.clearErrorMessage();
        if (!Util.isEmpty((String)this.dateTextBox.getValue()) || !event.getTarget().equals((Object)this.dateTextBox)) {
            this.setDateTextBoxAndDisplayValue();
        }
    }

    private void setDateTextBoxAndDisplayValue() {
        this.displayValue = "";
        String dateTextBoxValue = this.getDateTextBoxValue();
        this.dateTextBox.setValue(dateTextBoxValue);
        if (Util.isEmpty((String)this.displayValue)) {
            this.displayValue = dateTextBoxValue;
        }
    }

    public String getDateRangeText() {
        return this.dateTextBox.getValue();
    }

    private String getDateTextBoxValue() {
        String returnVal = "";
        switch (this.modeCombobox.getSelectedItem().getValue().toString()) {
            case "01": 
            case "02": 
            case "03": 
            case "04": 
            case "05": 
            case "06": {
                returnVal = this.getIntervalHumanReadable();
                break;
            }
            case "07": {
                returnVal = String.valueOf(DisplayType.getDateFormat().format(this.cal.getValue())) + " - " + DisplayType.getDateFormat().format(this.cal2.getValue());
                this.dateFrom = new Timestamp(this.cal.getValue().getTime());
                this.dateTo = new Timestamp(this.cal2.getValue().getTime());
                Date[] dates = this.setTimesOnDates(this.dateFrom, this.dateTo);
                this.dateFrom = dates[0];
                this.dateTo = dates[1];
                break;
            }
            case "08": {
                if (this.selectedQuickListItem == null) break;
                String unit = (String)this.selectedQuickListItem.getAttribute("TimeUnit");
                int offset = (Integer)this.selectedQuickListItem.getAttribute("Offset");
                Date dateFrom = (Date)this.selectedQuickListItem.getAttribute("DateFrom");
                Date[] dates = this.getInterval(unit, unit, offset, false, false, dateFrom);
                this.dateFrom = new Timestamp(dates[0].getTime());
                this.dateTo = new Timestamp(dates[1].getTime());
                dates = this.setTimesOnDates(dateFrom, this.dateTo);
                dateFrom = dates[0];
                this.dateTo = dates[1];
                returnVal = String.valueOf(DisplayType.getDateFormat().format(this.dateFrom)) + " - " + DisplayType.getDateFormat().format(this.dateTo);
                break;
            }
            default: {
                throw new AdempiereException("InvalidDateSelectionMode");
            }
        }
        return returnVal;
    }

    private void loadPickerSelection() {
        String[] arr;
        String detectedMode = null;
        String detectedUnit = null;
        int detectedOffset = 0;
        Timestamp today = new Timestamp(System.currentTimeMillis());
        detectedMode = this.autodetectMode(today = new Timestamp(this.setTimesOnDates(today, null)[0].getTime()));
        if (detectedMode != null && (arr = this.autodetectUnitAndCorrectMode(today, detectedMode)) != null) {
            detectedUnit = arr[0];
            if (!Util.isEmpty((String)arr[1])) {
                detectedMode = arr[1];
            }
        }
        if (!Util.isEmpty((String)detectedMode) && !Util.isEmpty(detectedUnit)) {
            detectedOffset = this.autodetectOffset(detectedMode, detectedUnit);
        }
        for (Comboitem item : this.modeCombobox.getItems()) {
            if (!item.getValue().equals(detectedMode)) continue;
            this.modeCombobox.setSelectedItem(item);
            break;
        }
        for (Comboitem item : this.unitCombobox.getItems()) {
            if (!item.getValue().equals(detectedUnit)) continue;
            this.unitCombobox.setSelectedItem(item);
            break;
        }
        int numBoxValue = Math.abs(detectedOffset) >= 1 ? Math.abs(detectedOffset) : 1;
        this.numberBox.setValue(Integer.valueOf(numBoxValue));
        this.updateCal1AndCal2();
        this.setDateTextBoxAndDisplayValue();
    }

    private void updateCal1AndCal2() {
        if (this.dateFrom == null) {
            this.cal.setValue(this.dateTo);
            this.cal2.setValue(this.dateTo);
        } else if (this.dateTo == null) {
            this.cal.setValue(this.dateFrom);
            this.cal2.setValue(this.dateFrom);
        } else {
            this.cal.setValue(this.dateFrom);
            this.cal2.setValue(this.dateTo);
        }
    }

    private String autodetectMode(Timestamp today) {
        Date d1 = this.dateFrom;
        Date d2 = this.dateTo;
        d1 = this.setTimesOnDates(d1, null)[0];
        d2 = this.setTimesOnDates(d2, null)[0];
        if (d1 != null && d2 == null) {
            return DATESELECTIONMODE_AFTER;
        }
        if (d1 == null && d2 != null) {
            return DATESELECTIONMODE_BEFORE;
        }
        if (d1.compareTo(d2) == 0) {
            return DATESELECTIONMODE_ON;
        }
        if (d1.after(d2)) {
            return null;
        }
        if (d1.before(today)) {
            if (d2.before(today)) {
                return DATESELECTIONMODE_PREVIOUS;
            }
            if (d2.after(today)) {
                return DATESELECTIONMODE_CURRENT;
            }
            return DATESELECTIONMODE_BETWEEN;
        }
        if (d1.after(today)) {
            return DATESELECTIONMODE_NEXT;
        }
        return DATESELECTIONMODE_BETWEEN;
    }

    private String[] autodetectUnitAndCorrectMode(Timestamp today, String predictedMode) {
        Date d1 = this.dateFrom;
        Date d2 = this.dateTo;
        d1 = this.setTimesOnDates(d1, null)[0];
        d2 = this.setTimesOnDates(d2, null)[0];
        if (d1 == null || d2 == null || d1.compareTo(d2) == 0) {
            return null;
        }
        if (this.dateFrom.after(this.dateTo)) {
            return null;
        }
        String detectedUnit = "";
        String correctedMode = predictedMode;
        Calendar calendar = Calendar.getInstance(Env.getLocale((Properties)Env.getCtx()));
        Calendar calendar2 = Calendar.getInstance(Env.getLocale((Properties)Env.getCtx()));
        Calendar calendarToday = Calendar.getInstance(Env.getLocale((Properties)Env.getCtx()));
        Calendar testCalendar = (Calendar)calendarToday.clone();
        int timeUnit = 0;
        calendar.setTime(this.dateFrom);
        calendar2.setTime(this.dateTo);
        calendarToday.setTime(today);
        if (calendar.get(6) == 1 && calendar2.get(6) == calendar2.getActualMaximum(6)) {
            detectedUnit = "Y";
            timeUnit = 1;
        } else if (calendar.get(5) == 1 && calendar2.get(5) == calendar2.getActualMaximum(5)) {
            detectedUnit = calendar.get(2) == 0 && calendar2.get(2) == 2 || calendar.get(2) == 3 && calendar2.get(2) == 5 || calendar.get(2) == 6 && calendar2.get(2) == 8 || calendar.get(2) == 9 && calendar2.get(2) == 11 && calendar.get(2) != calendar2.get(2) && calendar.get(1) == calendar2.get(1) ? "Q" : "M";
            timeUnit = 2;
        } else if (calendar.get(7) == calendar.getFirstDayOfWeek() && calendar2.get(7) == calendar2.getActualMaximum(7)) {
            detectedUnit = "W";
            timeUnit = 3;
        } else if (predictedMode.equalsIgnoreCase(DATESELECTIONMODE_CURRENT)) {
            correctedMode = DATESELECTIONMODE_BETWEEN;
        } else {
            detectedUnit = "D";
            timeUnit = 6;
        }
        int testOffset = 1;
        if (detectedUnit.equalsIgnoreCase("Q")) {
            testOffset = 3;
        }
        testCalendar.add(timeUnit, -testOffset);
        if (testCalendar.getTime().after(this.dateTo)) {
            detectedUnit = "D";
            correctedMode = DATESELECTIONMODE_BETWEEN;
        }
        testCalendar = (Calendar)calendarToday.clone();
        testCalendar.add(timeUnit, testOffset);
        if (testCalendar.getTime().before(this.dateFrom)) {
            detectedUnit = "D";
            correctedMode = DATESELECTIONMODE_BETWEEN;
        }
        if (detectedUnit == "M" && correctedMode.equalsIgnoreCase(DATESELECTIONMODE_CURRENT)) {
            if (calendar.get(2) != calendar2.get(2) || calendar.get(1) != calendar2.get(1)) {
                detectedUnit = "D";
                correctedMode = DATESELECTIONMODE_BETWEEN;
            } else if (calendar.get(2) != calendarToday.get(2) || calendar.get(1) != calendarToday.get(1)) {
                detectedUnit = "D";
                correctedMode = DATESELECTIONMODE_BETWEEN;
            }
        }
        return new String[]{detectedUnit, correctedMode};
    }

    private int autodetectOffset(String mode, String unit) {
        Date date = this.dateFrom;
        Date date2 = this.dateTo;
        long diffInMillies = Math.abs(date2.getTime() - date.getTime());
        long diff = TimeUnit.DAYS.convert(diffInMillies + 1L, TimeUnit.MILLISECONDS);
        switch (unit) {
            case "Y": {
                diff /= 365L;
                break;
            }
            case "Q": {
                diff /= 89L;
                break;
            }
            case "M": {
                diff /= 28L;
                break;
            }
            case "W": {
                diff /= 7L;
            }
        }
        if (mode.equalsIgnoreCase(DATESELECTIONMODE_PREVIOUS)) {
            diff = -diff;
        }
        return (int)diff;
    }

    private String getIntervalHumanReadable() {
        Timestamp ts = new Timestamp(this.cal.getValue().getTime());
        String mode = this.modeCombobox.getSelectedItem().getValue().toString();
        String unit = this.unitCombobox.getSelectedItem().getValue().toString();
        Integer numBoxValue = this.numberBox.getValue();
        if (numBoxValue == null) {
            numBoxValue = 1;
            this.numberBox.setValue(numBoxValue);
        }
        if (mode.equalsIgnoreCase(DATESELECTIONMODE_AFTER)) {
            this.displayValue = Msg.getMsg((Properties)Env.getCtx(), (String)"AfterDate", (Object[])new Object[]{DisplayType.getDateFormat().format(ts)});
            this.dateFrom = ts;
            this.dateFrom = this.setTimesOnDates(this.dateFrom, null)[0];
            this.dateTo = null;
            return this.displayValue;
        }
        if (mode.equalsIgnoreCase(DATESELECTIONMODE_BEFORE)) {
            this.displayValue = Msg.getMsg((Properties)Env.getCtx(), (String)"BeforeDate", (Object[])new Object[]{DisplayType.getDateFormat().format(ts)});
            this.dateFrom = null;
            this.dateTo = ts;
            this.dateTo = this.setTimesOnDates(null, this.dateTo)[1];
            return this.displayValue;
        }
        if (mode.equalsIgnoreCase(DATESELECTIONMODE_ON)) {
            this.displayValue = Msg.getMsg((Properties)Env.getCtx(), (String)"OnDate", (Object[])new Object[]{DisplayType.getDateFormat().format(ts)});
            this.dateFrom = ts;
            this.dateTo = ts;
            Date[] dates = this.setTimesOnDates(this.dateFrom, this.dateTo);
            this.dateFrom = dates[0];
            this.dateTo = dates[1];
            return this.displayValue;
        }
        if (mode.equalsIgnoreCase(DATESELECTIONMODE_PREVIOUS)) {
            numBoxValue = -numBoxValue.intValue();
        }
        Date[] dates = mode.equalsIgnoreCase(DATESELECTIONMODE_CURRENT) ? this.getInterval(unit, 0) : this.getInterval(unit, numBoxValue);
        this.dateFrom = new Timestamp(dates[0].getTime());
        this.dateTo = new Timestamp(dates[1].getTime());
        dates = this.setTimesOnDates(this.dateFrom, this.dateTo);
        this.dateFrom = dates[0];
        this.dateTo = dates[1];
        this.displayValue = this.datesToHumanReadable(mode, unit, numBoxValue);
        return String.valueOf(DisplayType.getDateFormat().format(this.dateFrom)) + " - " + DisplayType.getDateFormat().format(this.dateTo);
    }

    private Date[] getInterval(String timeUnit, int offset) {
        return this.getInterval(timeUnit, null, offset, false, false, null);
    }

    private Date[] getInterval(String timeUnit, String timeUnitForRange, int offset, boolean isToDate, boolean includeThis, Date dateFrom) {
        int iDayUnit;
        int iUnit;
        if (dateFrom == null) {
            dateFrom = new Date(System.currentTimeMillis());
        }
        Calendar cal1 = Calendar.getInstance(Env.getLocale((Properties)Env.getCtx()));
        Calendar cal2 = Calendar.getInstance(Env.getLocale((Properties)Env.getCtx()));
        cal1.setTime(dateFrom);
        cal2.setTime(dateFrom);
        switch (timeUnit) {
            case "D": {
                iUnit = 6;
                iDayUnit = 6;
                break;
            }
            case "M": {
                iUnit = 2;
                iDayUnit = 5;
                break;
            }
            case "Q": {
                iUnit = 2;
                iDayUnit = 5;
                offset *= 3;
                break;
            }
            case "W": {
                iUnit = 3;
                iDayUnit = 7;
                break;
            }
            case "Y": {
                iUnit = 1;
                iDayUnit = 6;
                break;
            }
            default: {
                throw new AdempiereException("TimeUnitNotSupported");
            }
        }
        if (!Util.isEmpty((String)timeUnitForRange) || !isToDate) {
            boolean hasTimeUnitForRange = true;
            if (Util.isEmpty((String)timeUnitForRange)) {
                timeUnitForRange = timeUnit;
                hasTimeUnitForRange = false;
            }
            if (hasTimeUnitForRange && offset != 0) {
                cal1.add(iUnit, offset);
                cal2.add(iUnit, offset);
            } else if (!hasTimeUnitForRange && !isToDate) {
                if (offset < 0) {
                    cal1.add(iUnit, offset);
                    if (!includeThis) {
                        if (timeUnitForRange.equalsIgnoreCase("Q")) {
                            cal2.add(iUnit, -3);
                        } else {
                            cal2.add(iUnit, -1);
                        }
                    }
                } else if (offset > 0) {
                    if (!includeThis) {
                        if (timeUnitForRange.equalsIgnoreCase("Q")) {
                            cal1.add(iUnit, 3);
                        } else {
                            cal1.add(iUnit, 1);
                        }
                    }
                    cal2.add(iUnit, offset);
                }
            }
            if (timeUnitForRange.equalsIgnoreCase("W")) {
                cal1.set(iDayUnit, cal1.getFirstDayOfWeek());
                cal2.set(iDayUnit, cal2.getFirstDayOfWeek());
                cal2.add(iDayUnit, 6);
            } else if (timeUnitForRange.equalsIgnoreCase("Q")) {
                if (cal1.after(new GregorianCalendar(cal1.get(1), 9, 1))) {
                    cal1.set(2, 9);
                    cal2.set(2, 11);
                } else if (cal1.after(new GregorianCalendar(cal1.get(1), 6, 1))) {
                    cal1.set(2, 6);
                    cal2.set(2, 8);
                } else if (cal1.after(new GregorianCalendar(cal1.get(1), 3, 1))) {
                    cal1.set(2, 3);
                    cal2.set(2, 5);
                } else {
                    cal1.set(2, 0);
                    cal2.set(2, 2);
                }
                cal1.set(5, cal1.getActualMinimum(iDayUnit));
                cal2.set(5, cal2.getActualMaximum(5));
            } else if (!timeUnitForRange.equalsIgnoreCase("D")) {
                cal1.set(iDayUnit, cal1.getActualMinimum(iDayUnit));
                cal2.set(iDayUnit, cal2.getActualMaximum(iDayUnit));
            }
        } else if (isToDate) {
            if (offset < 0) {
                cal1.add(iUnit, offset);
            } else if (offset > 0) {
                cal2.add(iUnit, offset);
            }
        }
        Date date1 = cal1.getTime();
        Date date2 = cal2.getTime();
        return new Date[]{date1, date2};
    }

    private String datesToHumanReadable(String mode, String unit, Integer offset) {
        String msgVal = "";
        String modeVal = "";
        if (offset < 0) {
            offset = -offset.intValue();
        }
        if (mode.equalsIgnoreCase(DATESELECTIONMODE_CURRENT)) {
            offset = -1;
        }
        switch (unit) {
            case "D": {
                msgVal = "DatePickerDay";
                break;
            }
            case "M": {
                msgVal = "DatePickerMonth";
                break;
            }
            case "Q": {
                msgVal = "DatePickerQuarter";
                break;
            }
            case "W": {
                msgVal = "DatePickerWeek";
                break;
            }
            case "Y": {
                msgVal = "DatePickerYear";
                break;
            }
            default: {
                throw new AdempiereException("TimeUnitNotSupported");
            }
        }
        for (Comboitem item : this.modeCombobox.getItems()) {
            if (!item.getValue().equals(mode)) continue;
            modeVal = item.getLabel();
        }
        return Msg.getMsg((Properties)Env.getCtx(), (String)msgVal, (Object[])new Object[]{modeVal, offset});
    }

    private Date[] setTimesOnDates(Date dateFrom, Date dateTo) {
        Calendar cal = Calendar.getInstance(Env.getLocale((Properties)Env.getCtx()));
        if (dateFrom != null) {
            cal.setTime(dateFrom);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            dateFrom = new Timestamp(cal.getTime().getTime());
        }
        if (dateTo != null) {
            cal.setTime(dateTo);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            cal.add(5, 1);
            cal.add(14, -1);
            dateTo = new Timestamp(cal.getTime().getTime());
        }
        return new Date[]{dateFrom, dateTo};
    }

    private ListItem createItem(String value, String timeUnit, int offset, Date dateFrom) {
        ListItem item = new ListItem(value, value);
        item.setAttribute("Offset", offset);
        item.setAttribute("TimeUnit", timeUnit);
        item.setAttribute("DateFrom", dateFrom);
        return item;
    }

    private Div getQuickModeContent() {
        ListItem item;
        Listbox box;
        Div innerDiv;
        Calendar cNow = Calendar.getInstance(Env.getLocale((Properties)Env.getCtx()));
        cNow.setTime(new Date(System.currentTimeMillis()));
        Calendar c = Calendar.getInstance(Env.getLocale((Properties)Env.getCtx()));
        c.setTime(new Date(System.currentTimeMillis()));
        Div wrapperDiv1 = new Div();
        wrapperDiv1.setStyle("width: 420px; display: flex; border-top: 2px solid #CFCFCF;");
        Div wrapperDiv2 = new Div();
        wrapperDiv2.setStyle("width: 420px; display: flex;");
        Label label = new Label(Msg.getMsg((Properties)Env.getCtx(), (String)"CurrentYearMonths"));
        label.setSclass("date-picker-label");
        Div monthLabelDiv = new Div();
        monthLabelDiv.setStyle("margin-top: 10px;");
        monthLabelDiv.appendChild((Component)label);
        c = cNow;
        int idx = 0;
        int monthIdx = 3;
        while (monthIdx <= 11) {
            innerDiv = new Div();
            innerDiv.setSclass("date-picker-component");
            innerDiv.setStyle("margin: 5px 5px 16px 5px !important; width: 33%;");
            box = new Listbox();
            box.addEventListener("onSelect", this);
            box.setCheckmark(true);
            ValueNamePair[] months = MRefList.getList((Properties)Env.getCtx(), (int)200221, (boolean)false, (String)"Value");
            int i = idx;
            while (i <= monthIdx) {
                c.set(2, i);
                item = this.createItem(months[i].getName(), "M", 0, new Date(c.getTimeInMillis()));
                box.appendChild((Component)item);
                idx = i++;
            }
            innerDiv.appendChild((Component)box);
            this.quickListBoxesArray.add(box);
            wrapperDiv1.appendChild((Component)innerDiv);
            ++idx;
            monthIdx += 4;
        }
        c = cNow;
        innerDiv = new Div();
        innerDiv.setSclass("date-picker-component");
        innerDiv.setStyle("width: 50%;");
        label = new Label(Msg.getMsg((Properties)Env.getCtx(), (String)"CurrentYearQuarters"));
        label.setSclass("date-picker-label");
        innerDiv.appendChild((Component)label);
        box = new Listbox();
        box.setStyle("border-top: 2px solid #CFCFCF;");
        box.addEventListener("onSelect", this);
        box.setCheckmark(true);
        ValueNamePair[] quarters = MRefList.getList((Properties)Env.getCtx(), (int)200222, (boolean)false, (String)"Value");
        idx = 0;
        ValueNamePair[] valueNamePairArray = quarters;
        int n = quarters.length;
        int n2 = 0;
        while (n2 < n) {
            ValueNamePair quarter = valueNamePairArray[n2];
            c.set(2, idx);
            item = this.createItem(quarter.getName(), "Q", 0, new Date(c.getTimeInMillis()));
            box.appendChild((Component)item);
            idx += 3;
            ++n2;
        }
        innerDiv.appendChild((Component)box);
        this.quickListBoxesArray.add(box);
        wrapperDiv2.appendChild((Component)innerDiv);
        innerDiv = new Div();
        innerDiv.setSclass("date-picker-component");
        innerDiv.setStyle("width: 50%;");
        label = new Label(Msg.getMsg((Properties)Env.getCtx(), (String)"Year"));
        label.setSclass("date-picker-label");
        innerDiv.appendChild((Component)label);
        box = new Listbox();
        box.setStyle("border-top: 2px solid #CFCFCF;");
        box.addEventListener("onSelect", this);
        box.setCheckmark(true);
        int i = 0;
        while (i >= -3) {
            item = this.createItem(String.valueOf(c.get(1)), "Y", i, null);
            box.appendChild((Component)item);
            c.add(1, -1);
            --i;
        }
        innerDiv.appendChild((Component)box);
        this.quickListBoxesArray.add(box);
        wrapperDiv2.appendChild((Component)innerDiv);
        Div div = new Div();
        div.appendChild((Component)monthLabelDiv);
        div.appendChild((Component)wrapperDiv1);
        div.appendChild((Component)wrapperDiv2);
        return div;
    }

    public String getDisplayValue() {
        return this.displayValue;
    }

    public void addValueChangeListener(ValueChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public boolean removeValuechangeListener(ValueChangeListener listener) {
        return this.listeners.remove(listener);
    }

    protected void fireValueChange(ValueChangeEvent event) {
        ValueChangeListener[] vcl = new ValueChangeListener[this.listeners.size()];
        this.listeners.toArray(vcl);
        ValueChangeListener[] valueChangeListenerArray = vcl;
        int n = vcl.length;
        int n2 = 0;
        while (n2 < n) {
            ValueChangeListener listener = valueChangeListenerArray[n2];
            listener.valueChange(event);
            ++n2;
        }
    }

    @Override
    public void valueChange(ValueChangeEvent evt) {
        if (this.enableValueChange) {
            this.dateFrom = (Date)this.editor.getValue();
            this.dateTo = (Date)this.editor2.getValue();
            if (this.dateFrom != null || this.dateTo != null) {
                Date[] dates = this.setTimesOnDates(this.dateFrom, this.dateTo);
                this.dateFrom = dates[0];
                this.dateTo = dates[1];
                this.loadPickerSelection();
            } else {
                this.setPickerSelection(DATESELECTIONMODE_CURRENT, "M", 0);
                Date[] dates = this.setTimesOnDates(this.dateFrom, this.dateTo);
                this.dateFrom = dates[0];
                this.dateTo = dates[1];
            }
            this.updateUI();
            this.fireValueChange(new ValueChangeEvent(this, "DateRangePicker", this.oldDisplayValue, this.displayValue));
        }
    }
}

