/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.window;

import java.util.Properties;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.component.ToolBarButton;
import org.adempiere.webui.editor.WDateEditor;
import org.adempiere.webui.editor.WEditor;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.window.DateRangePicker;
import org.compiere.util.Env;
import org.zkoss.zk.ui.Component;

public class DateRangeButton
extends ToolBarButton
implements WEditor.DynamicDisplayListener {
    private static final long serialVersionUID = -4404182204288841866L;
    private static final String IMAGES_CONTEXT_HISTORY_PNG = "images/History16.png";
    private WEditor editor;
    private WEditor editor2;

    public DateRangeButton(WEditor editor, WEditor editor2) {
        this.editor = editor;
        this.editor2 = editor2;
        this.init();
    }

    private void init() {
        if (ThemeManager.isUseFontIconForImage()) {
            this.setIconSclass("z-icon-History");
        } else {
            this.setImage(ThemeManager.getThemeResource(IMAGES_CONTEXT_HISTORY_PNG));
        }
        DateRangePicker popup = new DateRangePicker(this.editor, this.editor2);
        this.setTooltip(popup);
        this.addEventListener("onClick", event -> {
            popup.setPage(this.getPage());
            popup.open((Component)this, "after_center");
            LayoutUtils.autoDetachOnClose(popup);
        });
        this.editor.addDynamicDisplayListener(this);
        this.onDynamicDisplay(Env.getCtx(), this.editor);
    }

    @Override
    public void onDynamicDisplay(Properties ctx, WEditor editor) {
        this.setVisible(this.editor.isVisible() && this.editor2.isVisible());
        this.setDisabled(!this.editor.isReadWrite() || !this.editor2.isReadWrite());
    }

    public void setDateButtonVisible(boolean visible) {
        if (this.editor instanceof WDateEditor && this.editor2 instanceof WDateEditor) {
            WDateEditor de1 = (WDateEditor)this.editor;
            WDateEditor de2 = (WDateEditor)this.editor2;
            de1.getComponent().setButtonVisible(visible);
            de2.getComponent().setButtonVisible(visible);
        }
    }
}

