/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Level;
import org.apache.commons.codec.binary.Base64;
import org.compiere.Adempiere;
import org.compiere.model.MSession;
import org.compiere.model.MSystem;
import org.compiere.model.MUser;
import org.compiere.util.CLogger;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuScript;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.util.Clients;

public final class BrowserToken {
    private static final CLogger log = CLogger.getCLogger(BrowserToken.class);

    private BrowserToken() {
    }

    public static void save(MSession session, MUser user) {
        try {
            String home = BrowserToken.getHomeToken();
            String hash = BrowserToken.getPasswordHash(session, user);
            String script = "adempiere.saveUserToken('" + home + "', '" + hash + "', '" + session.getAD_Session_ID() + "');";
            AuScript aus = new AuScript(null, script);
            Clients.response((String)"saveUserToken", (AuResponse)aus);
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public static void remove() {
        try {
            String home = BrowserToken.getHomeToken();
            String script = "adempiere.removeUserToken('" + home + "');";
            AuScript aus = new AuScript(null, script);
            Clients.response((String)"removeUserToken", (AuResponse)aus);
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public static void load(Component component) {
        try {
            String home = BrowserToken.getHomeToken();
            String script = "adempiere.findUserToken('" + component.getUuid() + "', '" + home + "');";
            AuScript aus = new AuScript(component, script);
            Clients.response((String)"findUserToken", (AuResponse)aus);
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public static boolean validateToken(MSession session, MUser user, String token) {
        try {
            String hash = BrowserToken.getPasswordHash(session, user);
            return hash.equals(token);
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.getLocalizedMessage(), (Throwable)e);
            return false;
        }
    }

    private static String getHomeToken() throws UnsupportedEncodingException {
        String home = Adempiere.getAdempiereHome();
        Base64 encoder = new Base64();
        home = new String(encoder.encode(home.getBytes("UTF-8")), "UTF-8");
        home = URLEncoder.encode(home, "UTF-8");
        return home;
    }

    private static String getPasswordHash(MSession session, MUser user) throws UnsupportedEncodingException, NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance("SHA-512");
        Base64 encoder = new Base64();
        digest.reset();
        if (session.getWebSession() != null) {
            digest.update(session.getWebSession().getBytes("UTF-8"));
        }
        String password = null;
        password = MSystem.isZKRememberPasswordAllowed() ? user.getPassword() : new String("");
        byte[] input = digest.digest(password.getBytes("UTF-8"));
        String hash = new String(encoder.encode(input), "UTF-8");
        hash = URLEncoder.encode(hash, "UTF-8");
        return hash;
    }
}

