/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.session;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import javax.servlet.http.HttpSession;
import org.adempiere.util.ServerContext;
import org.adempiere.util.ServerContextURLHandler;
import org.adempiere.webui.AdempiereWebUI;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.session.ValidateReadonlyComponent;
import org.compiere.model.MSession;
import org.compiere.util.Env;
import org.zkoss.util.Locales;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.Session;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventThreadInit;
import org.zkoss.zk.ui.sys.DesktopCache;
import org.zkoss.zk.ui.sys.DesktopCtrl;
import org.zkoss.zk.ui.sys.ServerPush;
import org.zkoss.zk.ui.sys.SessionCtrl;
import org.zkoss.zk.ui.util.DesktopCleanup;
import org.zkoss.zk.ui.util.DesktopInit;
import org.zkoss.zk.ui.util.ExecutionCleanup;
import org.zkoss.zk.ui.util.ExecutionInit;

public class SessionContextListener
implements ExecutionInit,
ExecutionCleanup,
EventThreadInit,
DesktopCleanup,
DesktopInit {
    public static final String SERVLET_SESSION_ID = "servlet.sessionId";
    public static final String SESSION_CTX = "WebUISessionContext";

    public static void setupExecutionContextFromSession(Execution exec) {
        String cacheId;
        HttpSession httpSession;
        Session session = exec.getDesktop().getSession();
        Properties ctx = null;
        boolean sessionInvalidated = false;
        try {
            ctx = (Properties)session.getAttribute(SESSION_CTX);
        }
        catch (IllegalStateException e) {
            sessionInvalidated = true;
        }
        HttpSession httpSession2 = httpSession = sessionInvalidated ? null : (HttpSession)session.getNativeSession();
        if (httpSession == null) {
            ctx = new Properties();
            ctx.put("SERVER_CONTEXT_URL_HANDLER", new ServerContextURLHandler(){

                public void showURL(String url) {
                    SessionManager.getAppDesktop().showURL(url, true);
                }
            });
            ServerContext.setCurrentInstance((Properties)ctx);
            return;
        }
        if (!(ctx == null || (cacheId = ctx.getProperty(SERVLET_SESSION_ID)) != null && cacheId.equals(httpSession.getId()))) {
            ctx = null;
            session.removeAttribute(SESSION_CTX);
        }
        if (ctx == null) {
            ctx = new Properties();
            ctx.put("SERVER_CONTEXT_URL_HANDLER", new ServerContextURLHandler(){

                public void showURL(String url) {
                    SessionManager.getAppDesktop().showURL(url, true);
                }
            });
            ctx.setProperty(SERVLET_SESSION_ID, httpSession.getId());
            session.setAttribute(SESSION_CTX, (Object)ctx);
        }
        ServerContext.setCurrentInstance((Properties)ctx);
    }

    public void init(Execution exec, Execution parent) {
        ServerPush serverPush;
        if (!(parent != null || (serverPush = ((DesktopCtrl)exec.getDesktop()).getServerPush()) != null && serverPush.isActive())) {
            SessionContextListener.setupExecutionContextFromSession(Executions.getCurrent());
            Locales.setThreadLocal((Locale)Env.getLanguage((Properties)ServerContext.getCurrentInstance()).getLocale());
        }
    }

    public void cleanup(Execution exec, Execution parent, List<Throwable> errs) {
        ServerPush serverPush;
        if (!(parent != null || (serverPush = ((DesktopCtrl)exec.getDesktop()).getServerPush()) != null && serverPush.isActive())) {
            ServerContext.dispose();
        }
    }

    public void prepare(Component comp, Event evt) {
        if (ServerContext.getCurrentInstance().isEmpty() || !SessionContextListener.isContextValid()) {
            SessionContextListener.setupExecutionContextFromSession(Executions.getCurrent());
        }
        Locales.setThreadLocal((Locale)Env.getLanguage((Properties)ServerContext.getCurrentInstance()).getLocale());
    }

    public boolean init(Component comp, Event evt) {
        return true;
    }

    public static boolean isContextValid() {
        Execution exec = Executions.getCurrent();
        Properties ctx = ServerContext.getCurrentInstance();
        if (ctx == null) {
            return false;
        }
        if (exec == null || exec.getDesktop() == null) {
            return false;
        }
        Session session = exec.getDesktop().getSession();
        HttpSession httpSession = (HttpSession)session.getNativeSession();
        String cacheId = ctx.getProperty(SERVLET_SESSION_ID);
        if (cacheId == null || httpSession == null || !cacheId.equals(httpSession.getId())) {
            return false;
        }
        Properties sessionCtx = null;
        try {
            sessionCtx = (Properties)session.getAttribute(SESSION_CTX);
        }
        catch (IllegalStateException e) {
            return false;
        }
        if (sessionCtx != null) {
            if (Env.getAD_Client_ID((Properties)sessionCtx) != Env.getAD_Client_ID((Properties)ctx)) {
                return false;
            }
            if (Env.getAD_User_ID((Properties)sessionCtx) != Env.getAD_User_ID((Properties)ctx)) {
                return false;
            }
            if (Env.getAD_Role_ID((Properties)sessionCtx) != Env.getAD_Role_ID((Properties)ctx)) {
                return false;
            }
        }
        return true;
    }

    public void cleanup(Desktop desktop) throws Exception {
        int AD_Session_ID;
        if (Executions.getCurrent() == null) {
            if (!ServerContext.getCurrentInstance().isEmpty()) {
                ServerContext.dispose();
            }
            return;
        }
        Object sessionInvalidated = desktop.getAttribute("DesktopSessionInvalidated");
        if (sessionInvalidated != null) {
            return;
        }
        if (ServerContext.getCurrentInstance().isEmpty() || !SessionContextListener.isContextValid()) {
            SessionContextListener.setupExecutionContextFromSession(Executions.getCurrent());
            if (Env.getCtx().getProperty(SERVLET_SESSION_ID) == null) {
                return;
            }
        }
        if ((AD_Session_ID = Env.getContextAsInt((Properties)Env.getCtx(), (String)"#AD_Session_ID")) > 0) {
            MSession mSession;
            Thread.sleep(1000L);
            String key = SessionContextListener.getSessionDesktopListKey(AD_Session_ID);
            List list = (List)Env.getCtx().get(key);
            if (list != null) {
                list.remove(desktop.getId());
                if (!this.isEmpty(list, desktop.getSession())) {
                    return;
                }
                Env.getCtx().remove(key);
            }
            if ((mSession = MSession.get((Properties)Env.getCtx())) != null && !mSession.isProcessed()) {
                mSession = new MSession(Env.getCtx(), mSession.getAD_Session_ID(), null);
                mSession.setProcessed(true);
                mSession.saveEx();
            }
            SessionManager.logoutSessionAfterBrowserDestroyed();
        }
    }

    private boolean isEmpty(List<String> list, Session session) {
        if (list.isEmpty()) {
            return true;
        }
        if (session == null) {
            return false;
        }
        DesktopCache desktopCache = ((SessionCtrl)session).getDesktopCache();
        if (desktopCache == null) {
            return false;
        }
        int count = 0;
        for (String dtid : list) {
            Collection roots;
            Desktop desktop = desktopCache.getDesktopIfAny(dtid);
            if (desktop == null || desktop.getFirstPage() == null || (roots = desktop.getFirstPage().getRoots()) == null || roots.isEmpty()) continue;
            boolean found = false;
            for (Component root : roots) {
                if (!(root instanceof AdempiereWebUI)) continue;
                found = true;
                break;
            }
            if (!found) continue;
            ++count;
        }
        return count == 0;
    }

    public void init(Desktop desktop, Object request) throws Exception {
        MSession mSession;
        if (Executions.getCurrent() == null) {
            return;
        }
        desktop.addListener((Object)new ValidateReadonlyComponent());
        if (ServerContext.getCurrentInstance().isEmpty() || !SessionContextListener.isContextValid()) {
            SessionContextListener.setupExecutionContextFromSession(Executions.getCurrent());
        }
        if ((mSession = MSession.get((Properties)Env.getCtx())) != null) {
            if (mSession.isProcessed()) {
                mSession = new MSession(Env.getCtx(), mSession.getAD_Session_ID(), null);
                mSession.setProcessed(false);
                mSession.saveEx();
            }
            SessionContextListener.addDesktopId(mSession.getAD_Session_ID(), desktop.getId());
        }
    }

    public static synchronized void addDesktopId(int AD_Session_ID, String dtid) {
        String key = SessionContextListener.getSessionDesktopListKey(AD_Session_ID);
        ArrayList<String> list = (ArrayList<String>)Env.getCtx().get(key);
        if (list == null) {
            list = new ArrayList<String>();
            Env.getCtx().put(key, list);
        }
        if (!list.contains(dtid)) {
            list.add(dtid);
        }
    }

    public static String getSessionDesktopListKey(int AD_Session_ID) {
        String key = "ad_session." + AD_Session_ID + ".desktop";
        return key;
    }
}

