/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.panel.action;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.adempiere.base.IGridTabExporter;
import org.adempiere.base.equinox.EquinoxExtensionLocator;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.adwindow.AbstractADWindowContent;
import org.adempiere.webui.adwindow.IADTabbox;
import org.adempiere.webui.adwindow.IADTabpanel;
import org.adempiere.webui.component.Checkbox;
import org.adempiere.webui.component.Column;
import org.adempiere.webui.component.Columns;
import org.adempiere.webui.component.ConfirmPanel;
import org.adempiere.webui.component.Grid;
import org.adempiere.webui.component.GridFactory;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.ListItem;
import org.adempiere.webui.component.Listbox;
import org.adempiere.webui.component.Row;
import org.adempiere.webui.component.Rows;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.Dialog;
import org.compiere.model.GridTab;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.zkoss.util.media.AMedia;
import org.zkoss.util.media.Media;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zul.Filedownload;
import org.zkoss.zul.Space;
import org.zkoss.zul.Vbox;
import org.zkoss.zul.Vlayout;

public class ExportAction
implements EventListener<Event> {
    private AbstractADWindowContent panel;
    private Map<String, IGridTabExporter> exporterMap = null;
    private Map<String, String> extensionMap = null;
    private Window winExportFile = null;
    private ConfirmPanel confirmPanel = new ConfirmPanel(true);
    private Listbox cboType = new Listbox();
    private Checkbox chkCurrentRow = new Checkbox();
    private int indxDetailSelected = 0;
    private List<GridTab> childs;
    private Row selectionTabRow = null;
    private List<Checkbox> chkSelectionTabForExport = null;
    private IGridTabExporter exporter;

    public ExportAction(AbstractADWindowContent panel) {
        this.panel = panel;
    }

    public void export() {
        this.exporterMap = new HashMap<String, IGridTabExporter>();
        this.extensionMap = new HashMap<String, String>();
        List exporterList = EquinoxExtensionLocator.instance().list(IGridTabExporter.class).getExtensions();
        for (IGridTabExporter iGridTabExporter : exporterList) {
            String extension = iGridTabExporter.getFileExtension();
            if (this.extensionMap.containsKey(extension)) continue;
            this.extensionMap.put(extension, iGridTabExporter.getFileExtensionLabel());
            this.exporterMap.put(extension, iGridTabExporter);
        }
        if (this.winExportFile == null) {
            this.winExportFile = new Window();
            this.winExportFile.setTitle(String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"Export")) + ": " + this.panel.getActiveGridTab().getName());
            ZKUpdateUtil.setWindowWidthX((HtmlBasedComponent)this.winExportFile, 450);
            this.winExportFile.setClosable(true);
            this.winExportFile.setBorder("normal");
            this.winExportFile.setStyle("position:absolute");
            this.winExportFile.setSclass("popup-dialog");
            this.winExportFile.setWidgetAttribute("instanceName", "exportAction");
            this.cboType.setMold("select");
            this.cboType.getItems().clear();
            for (Map.Entry entry : this.extensionMap.entrySet()) {
                this.cboType.appendItem(String.valueOf((String)entry.getKey()) + " - " + (String)entry.getValue(), (String)entry.getKey());
            }
            this.cboType.setSelectedIndex(0);
            this.cboType.addActionListener(this);
            Vbox vbox = new Vbox();
            ZKUpdateUtil.setWidth((HtmlBasedComponent)vbox, "100%");
            this.winExportFile.appendChild((Component)vbox);
            Vlayout vlayout = new Vlayout();
            vlayout.setSclass("dialog-content");
            vbox.appendChild((Component)vlayout);
            Grid grid = GridFactory.newGridLayout();
            vlayout.appendChild((Component)grid);
            Columns columns = new Columns();
            Column column = new Column();
            ZKUpdateUtil.setHflex((HtmlBasedComponent)column, "min");
            columns.appendChild((Component)column);
            column = new Column();
            ZKUpdateUtil.setHflex((HtmlBasedComponent)column, "1");
            columns.appendChild((Component)column);
            grid.appendChild((Component)columns);
            Rows rows = new Rows();
            grid.appendChild((Component)rows);
            Row row = new Row();
            rows.appendChild((Component)row);
            row.appendChild((Component)new Label(Msg.getMsg((Properties)Env.getCtx(), (String)"FilesOfType")));
            row.appendChild((Component)this.cboType);
            ZKUpdateUtil.setHflex((HtmlBasedComponent)this.cboType, "1");
            row = new Row();
            rows.appendChild((Component)row);
            row.appendChild((Component)new Space());
            this.chkCurrentRow.setLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"ExportCurrentRowOnly"));
            this.chkCurrentRow.setSelected(true);
            row.appendChild((Component)this.chkCurrentRow);
            this.selectionTabRow = new Row();
            rows.appendChild((Component)this.selectionTabRow);
            LayoutUtils.addSclass("dialog-footer", (HtmlBasedComponent)this.confirmPanel);
            vbox.appendChild((Component)this.confirmPanel);
            this.confirmPanel.addActionListener(this);
            this.winExportFile.addEventListener("onCancel", e -> this.onCancel());
        }
        this.displayExportTabSelection();
        this.panel.getComponent().getParent().appendChild((Component)this.winExportFile);
        this.panel.showBusyMask(this.winExportFile);
        LayoutUtils.openOverlappedWindow(this.panel.getComponent(), this.winExportFile, "middle_center");
        this.winExportFile.addEventListener("onWindowClose", this);
        this.winExportFile.addEventListener("onExporterException", this);
        this.winExportFile.focus();
    }

    protected void displayExportTabSelection() {
        this.initTabInfo();
        this.exporter = this.getExporter();
        if (this.exporter == null) {
            Events.echoEvent((String)"onExporterException", (Component)this.winExportFile, null);
        }
        this.selectionTabRow.getChildren().clear();
        Vlayout vlayout = new Vlayout();
        this.selectionTabRow.appendChild((Component)new Space());
        this.selectionTabRow.appendChild((Component)vlayout);
        vlayout.appendChild((Component)new Label(Msg.getMsg((Properties)Env.getCtx(), (String)"SelectTabToExport")));
        this.chkSelectionTabForExport = new ArrayList<Checkbox>();
        boolean isHasSelectionTab = false;
        boolean isSelectTabDefault = false;
        if (this.exporter.getClass().getName().equals("org.adempiere.pipo2.GridTab2PackExporter")) {
            isSelectTabDefault = true;
        }
        for (GridTab child : this.childs) {
            Checkbox chkSelectionTab = new Checkbox();
            chkSelectionTab.setLabel(child.getName());
            if (!this.exporter.isExportableTab(child)) continue;
            if (child.getTabNo() == this.indxDetailSelected || isSelectTabDefault) {
                chkSelectionTab.setSelected(true);
            }
            chkSelectionTab.setAttribute("tabBinding", child);
            vlayout.appendChild((Component)chkSelectionTab);
            this.chkSelectionTabForExport.add(chkSelectionTab);
            chkSelectionTab.addEventListener("onCheck", this);
            isHasSelectionTab = true;
        }
        if (!isHasSelectionTab) {
            this.selectionTabRow.getChildren().clear();
        }
    }

    public void onEvent(Event event) throws Exception {
        if (event.getTarget().getId().equals("Cancel")) {
            this.onCancel();
        } else if (event.getTarget().getId().equals("Ok")) {
            this.exportFile();
        } else if (event.getName().equals("onWindowClose")) {
            this.panel.hideBusyMask();
            this.panel.focusToLastFocusEditor();
        } else if (event.getTarget().equals((Object)this.cboType) && event.getName().equals("onSelect")) {
            this.displayExportTabSelection();
        } else if (event.getTarget() instanceof Checkbox) {
            Checkbox cbSel = (Checkbox)event.getTarget();
            GridTab gtSel = (GridTab)cbSel.getAttribute("tabBinding");
            boolean found = false;
            for (Checkbox cb : this.chkSelectionTabForExport) {
                if (cb == cbSel) {
                    found = true;
                    continue;
                }
                GridTab gt = (GridTab)cb.getAttribute("tabBinding");
                if (!found) continue;
                if (gt.getTabLevel() > gtSel.getTabLevel()) {
                    cb.setChecked(cbSel.isChecked());
                    cb.setEnabled(cbSel.isChecked());
                    continue;
                }
                break;
            }
        } else if (event.getName().equals("onExporterException")) {
            Dialog.error(0, "FileInvalidExtension");
            this.winExportFile.onClose();
        }
    }

    private void onCancel() {
        this.winExportFile.onClose();
    }

    protected void initTabInfo() {
        String tableName;
        IADTabbox adTab = this.panel.getADTab();
        int selected = adTab.getSelectedIndex();
        int tabLevel = this.panel.getActiveGridTab().getTabLevel();
        HashSet<String> tables = new HashSet<String>();
        this.childs = new ArrayList<GridTab>();
        List includedList = this.panel.getActiveGridTab().getIncludedTabs();
        for (GridTab included : includedList) {
            tableName = included.getTableName();
            if (tables.contains(tableName)) continue;
            tables.add(tableName);
            this.childs.add(included);
        }
        int i = selected + 1;
        while (i < adTab.getTabCount()) {
            IADTabpanel adTabPanel = adTab.getADTabpanel(i);
            if (!adTabPanel.getGridTab().isSortTab()) {
                if (adTabPanel.getGridTab().getTabLevel() <= tabLevel) break;
                tableName = adTabPanel.getGridTab().getTableName();
                if (!tables.contains(tableName)) {
                    tables.add(tableName);
                    this.childs.add(adTabPanel.getGridTab());
                }
            }
            ++i;
        }
        this.indxDetailSelected = 0;
        if (adTab.getSelectedDetailADTabpanel() != null) {
            this.indxDetailSelected = adTab.getSelectedDetailADTabpanel().getGridTab().getTabNo();
        }
    }

    protected IGridTabExporter getExporter() {
        ListItem li = this.cboType.getSelectedItem();
        if (li == null || li.getValue() == null) {
            return null;
        }
        String ext = li.getValue().toString();
        IGridTabExporter exporter = this.exporterMap.get(ext);
        return exporter;
    }

    private void exportFile() {
        try {
            try {
                boolean currentRowOnly = this.chkCurrentRow.isSelected();
                File file = File.createTempFile("Export", "." + this.cboType.getSelectedItem().getValue().toString());
                this.childs.clear();
                for (Checkbox chkSeletionTab : this.chkSelectionTabForExport) {
                    if (!chkSeletionTab.isChecked()) continue;
                    this.childs.add((GridTab)chkSeletionTab.getAttribute("tabBinding"));
                }
                this.exporter.export(this.panel.getActiveGridTab(), this.childs, currentRowOnly, file, this.indxDetailSelected);
                this.winExportFile.onClose();
                this.winExportFile = null;
                AMedia media = null;
                media = new AMedia(this.exporter.getSuggestedFileName(this.panel.getActiveGridTab()), null, this.exporter.getContentType(), file, true);
                Filedownload.save((Media)media);
            }
            catch (Exception e) {
                Dialog.error(0, e.getLocalizedMessage());
                if (this.winExportFile != null) {
                    this.winExportFile.onClose();
                }
            }
        }
        finally {
            if (this.winExportFile != null) {
                this.winExportFile.onClose();
            }
        }
    }
}

