/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.panel;

import java.io.Serializable;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Properties;
import java.util.TimeZone;
import java.util.logging.Level;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.component.Tabpanel;
import org.adempiere.webui.component.ToolBarButton;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.component.ZkCssHelper;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.InfoSchedule;
import org.compiere.model.MAssignmentSlot;
import org.compiere.model.ScheduleUtil;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.zkoss.calendar.Calendars;
import org.zkoss.calendar.api.CalendarEvent;
import org.zkoss.calendar.api.CalendarModel;
import org.zkoss.calendar.impl.SimpleCalendarEvent;
import org.zkoss.calendar.impl.SimpleCalendarModel;
import org.zkoss.util.Locales;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.util.Callback;
import org.zkoss.zul.Borderlayout;
import org.zkoss.zul.Button;
import org.zkoss.zul.Label;
import org.zkoss.zul.North;
import org.zkoss.zul.South;

public class WSchedule
extends Window
implements EventListener<Event> {
    private static final long serialVersionUID = -4819513326165148245L;
    private static final String ON_MOBILE_SET_SELECTED_TAB_ECHO = "onMobileSetSelectedTabEcho";
    private InfoSchedule infoSchedule;
    private static final CLogger log = CLogger.getCLogger(WSchedule.class);
    private ToolBarButton button;
    private Date m_center;
    private Component calendarContainer;
    private Calendars calendars;
    private SimpleCalendarModel scm;
    private Button btnCurrentDate;
    private Label lblDate;
    private int S_Resource_ID;
    private Component divArrowLeft;
    private Component divArrowRight;
    private Component divTabDay;
    private Component divTabWeek;
    private Component divTabWeekdays;
    private Component divTabMonth;
    private Borderlayout borderlayout;
    private Component btnRefresh;

    public WSchedule(InfoSchedule is) {
        this.infoSchedule = is;
        try {
            this.init();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "VSchedule", (Throwable)e);
        }
    }

    private void init() throws Exception {
        Component tmp;
        this.getChildren().clear();
        this.calendarContainer = Executions.createComponents((String)ThemeManager.getThemeResource("zul/calendar/calendar.zul"), (Component)this, null);
        this.borderlayout = (Borderlayout)this.calendarContainer.getFellow("main");
        this.borderlayout.setStyle("position: absolute; width: 98%; margin: auto;");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this.borderlayout, "100%");
        if (this.borderlayout.getSouth() != null) {
            this.borderlayout.getSouth().detach();
        }
        if ((tmp = this.calendarContainer.getFellow("btnSwitchTimeZone")) != null) {
            tmp.detach();
        }
        if ((tmp = this.calendarContainer.getFellow("lbxRequestTypes")) != null) {
            tmp.getParent().detach();
        }
        if ((tmp = this.calendarContainer.getFellow("FDOW")) != null) {
            tmp.detach();
        }
        this.calendars = (Calendars)this.calendarContainer.getFellow("cal");
        TimeZone timezone = SessionManager.getAppDesktop().getClientInfo().timeZone;
        this.calendars.addTimeZone(timezone.getID(), timezone);
        this.calendars.addEventListener("onEventCreate", (EventListener)this);
        this.calendars.addEventListener("onEventEdit", (EventListener)this);
        this.calendars.addEventListener("onEventUpdate", (EventListener)this);
        this.appendChild(this.calendarContainer);
        this.btnCurrentDate = (Button)this.calendarContainer.getFellow("btnCurrentDate");
        this.btnCurrentDate.addEventListener("onClick", (EventListener)this);
        this.btnRefresh = this.calendarContainer.getFellow("btnRefresh");
        this.btnRefresh.addEventListener("onClick", (EventListener)this);
        this.lblDate = (Label)this.calendarContainer.getFellow("lblDate");
        this.lblDate.addEventListener("onCreate", (EventListener)this);
        this.divArrowLeft = this.calendarContainer.getFellow("divArrowLeft");
        this.divArrowLeft.addEventListener("onMoveDate", (EventListener)this);
        this.divArrowRight = this.calendarContainer.getFellow("divArrowRight");
        this.divArrowRight.addEventListener("onMoveDate", (EventListener)this);
        this.divTabDay = this.calendarContainer.getFellow("divTabDay");
        this.divTabDay.addEventListener("onUpdateView", (EventListener)this);
        this.divTabWeek = this.calendarContainer.getFellow("divTabWeek");
        this.divTabWeek.addEventListener("onUpdateView", (EventListener)this);
        this.divTabWeekdays = this.calendarContainer.getFellow("divTabWeekdays");
        this.divTabWeekdays.addEventListener("onUpdateView", (EventListener)this);
        this.divTabMonth = this.calendarContainer.getFellow("divTabMonth");
        this.divTabMonth.addEventListener("onUpdateView", (EventListener)this);
        this.button = new ToolBarButton();
        this.button.setLabel("Edit");
        this.button.setStyle("visibility: hidden; height: 0px; width: 0px");
        this.button.addEventListener("onClick", this);
        this.appendChild((Component)this.button);
        this.divTabClicked(7);
        this.addEventListener("onAfterReCreate", this);
        if (ClientInfo.isMobile()) {
            this.addCallback("afterPageAttached", (Callback & Serializable)t -> this.afterPageAttached());
            this.addEventListener(ON_MOBILE_SET_SELECTED_TAB_ECHO, evt -> this.calendars.invalidate());
        }
    }

    private void afterPageAttached() {
        Component p2 = this.getParent();
        while (p2 != null) {
            if (p2 instanceof Tabpanel) {
                p2.addEventListener("onMobileSetSelectedTab", evt -> this.onMobileSelected());
                break;
            }
            p2 = p2.getParent();
        }
    }

    private void onMobileSelected() {
        Events.echoEvent((String)ON_MOBILE_SET_SELECTED_TAB_ECHO, (Component)this, null);
    }

    public void recreate(int S_Resource_ID, Date date) {
        this.S_Resource_ID = S_Resource_ID;
        this.calendars.setCurrentDate(date);
        Events.echoEvent((String)"onAfterReCreate", (Component)this, null);
    }

    private void updateModel() {
        ScheduleUtil m_model = new ScheduleUtil(Env.getCtx());
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(this.calendars.getCurrentDate());
        cal.set(10, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        cal.set(5, 1);
        cal.add(5, -7);
        Timestamp startDate = new Timestamp(cal.getTimeInMillis());
        cal.add(2, 1);
        cal.add(5, 14);
        Timestamp endDate = new Timestamp(cal.getTimeInMillis());
        this.scm = new SimpleCalendarModel();
        if (this.S_Resource_ID > 0) {
            MAssignmentSlot[] list;
            MAssignmentSlot[] mAssignmentSlotArray = list = m_model.getAssignmentSlots(this.S_Resource_ID, startDate, endDate, null, true, null);
            int n = list.length;
            int n2 = 0;
            while (n2 < n) {
                MAssignmentSlot mas = mAssignmentSlotArray[n2];
                SimpleCalendarEvent event = new SimpleCalendarEvent();
                event.setBeginDate((Date)mas.getStartTime());
                event.setEndDate((Date)mas.getEndTime());
                event.setTitle(mas.getName());
                event.setContent(mas.getDescription() != null ? mas.getDescription() : mas.getName());
                event.setHeaderColor(String.valueOf('#') + ZkCssHelper.createHexColorString(mas.getColor(true)));
                event.setContentColor(String.valueOf('#') + ZkCssHelper.createHexColorString(mas.getColor(true)));
                if (!mas.isAssignment() || mas.getMAssignment().isConfirmed()) {
                    event.setLocked(true);
                }
                this.scm.add((CalendarEvent)event);
                ++n2;
            }
        }
        this.calendars.setModel((CalendarModel)this.scm);
    }

    public SimpleCalendarModel getModel() {
        return this.scm;
    }

    public void onEvent(Event event) throws Exception {
        String type = event.getName();
        if (type.equals("onClick")) {
            if (event.getTarget() == this.btnCurrentDate) {
                this.btnCurrentDateClicked();
            } else if (event.getTarget() == this.btnRefresh) {
                this.updateModel();
            }
        } else if (type.equals("onCreate")) {
            if (event.getTarget() == this.lblDate) {
                this.updateDateLabel();
            }
        } else if (type.equals("onMoveDate")) {
            if (event.getTarget() == this.divArrowLeft) {
                this.divArrowClicked(false);
            } else if (event.getTarget() == this.divArrowRight) {
                this.divArrowClicked(true);
            }
        } else if (type.equals("onUpdateView")) {
            String text = String.valueOf(event.getData());
            int days = Msg.getMsg((Properties)Env.getCtx(), (String)"Day").equals(text) ? 1 : (Msg.getMsg((Properties)Env.getCtx(), (String)"5Days").equals(text) ? 5 : (Msg.getMsg((Properties)Env.getCtx(), (String)"Week").equals(text) ? 7 : 0));
            this.divTabClicked(days);
        } else if (type.equals("onAfterReCreate")) {
            this.updateModel();
        } else {
            Events.sendEvent((Component)this, (Event)event);
        }
    }

    private void btnCurrentDateClicked() {
        this.calendars.setCurrentDate(Calendar.getInstance(this.calendars.getDefaultTimeZone()).getTime());
        this.updateDateLabel();
        this.updateModel();
    }

    private void updateDateLabel() {
        Date b = this.calendars.getBeginDate();
        Date e = this.calendars.getEndDate();
        SimpleDateFormat sdfV = new SimpleDateFormat("yyyy/MMM/dd", Locales.getCurrent());
        sdfV.setTimeZone(this.calendars.getDefaultTimeZone());
        this.lblDate.setValue(String.valueOf(sdfV.format(b)) + " - " + sdfV.format(e));
    }

    private void divArrowClicked(boolean isNext) {
        if (isNext) {
            this.calendars.nextPage();
        } else {
            this.calendars.previousPage();
        }
        this.updateDateLabel();
        this.updateModel();
    }

    private void divTabClicked(int days) {
        if (days > 0) {
            this.calendars.setMold("default");
            this.calendars.setDays(days);
        } else {
            this.calendars.setMold("month");
        }
        this.updateDateLabel();
        this.updateModel();
    }

    public void addNorthPane(Component pane) {
        if (this.borderlayout != null) {
            if (this.borderlayout.getNorth() != null) {
                this.borderlayout.getNorth().detach();
            }
            North north = new North();
            north.appendChild(pane);
            this.borderlayout.appendChild((Component)north);
        }
    }

    public void addSouthPane(Component pane, String height) {
        if (this.borderlayout != null) {
            if (this.borderlayout.getSouth() != null) {
                this.borderlayout.getSouth().detach();
            }
            South south = new South();
            south.appendChild(pane);
            if (!Util.isEmpty((String)height)) {
                ZKUpdateUtil.setHeight((HtmlBasedComponent)south, height);
            }
            this.borderlayout.appendChild((Component)south);
        }
    }

    public void removeRefreshButton() {
        if (this.btnRefresh != null) {
            this.btnRefresh.detach();
            this.btnRefresh = null;
        }
    }
}

