/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.panel;

import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.util.Callback;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.component.ConfirmPanel;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.Messagebox;
import org.adempiere.webui.component.Textbox;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.LoginWindow;
import org.compiere.model.MClient;
import org.compiere.model.MMailText;
import org.compiere.model.MPasswordRule;
import org.compiere.model.MSysConfig;
import org.compiere.model.MUser;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.EMail;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.compiere.util.Util;
import org.zkoss.zhtml.Div;
import org.zkoss.zhtml.Table;
import org.zkoss.zhtml.Td;
import org.zkoss.zhtml.Tr;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.Image;

public class ResetPasswordPanel
extends Window
implements EventListener<Event> {
    private static final long serialVersionUID = -657724758165769510L;
    private static final CLogger logger = CLogger.getCLogger(ResetPasswordPanel.class);
    protected static final int MAX_RESET_PASSWORD_TRIES = 3;
    protected static final int NO_OF_SECURITY_QUESTION = 5;
    protected static final String SECURITY_QUESTION_PREFIX = "SecurityQuestion_";
    protected static final String RESET_PASSWORD_MAIL_TEXT_NAME = "Reset Password";
    protected LoginWindow wndLogin;
    protected Properties m_ctx;
    protected String m_userName;
    protected boolean m_noSecurityQuestion;
    protected int counter;
    protected boolean m_email_login = false;
    protected Label lblSecurityQuestion;
    protected Label lblAnswer;
    protected Label lblUserId;
    protected Label lblEmail;
    protected Textbox txtSecurityQuestion;
    protected Textbox txtAnswer;
    protected Textbox txtUserId;
    protected Textbox txtEmail;

    public ResetPasswordPanel(Properties ctx, LoginWindow loginWindow, String userName, boolean noSecurityQuestion) {
        this.wndLogin = loginWindow;
        this.m_ctx = ctx;
        this.m_userName = userName;
        this.m_noSecurityQuestion = noSecurityQuestion;
        this.m_email_login = MSysConfig.getBooleanValue((String)"USE_EMAIL_FOR_LOGIN", (boolean)false);
        this.initComponents();
        this.init();
        this.setId("resetPasswordPanel");
        this.setSclass("login-box");
        this.loadData();
    }

    private void init() {
        this.createUI();
    }

    protected void createUI() {
        Div div = new Div();
        div.setSclass("login-box-header");
        Label label = new Label(Msg.getMsg((Properties)this.m_ctx, (String)"ForgotMyPassword"));
        label.setSclass("login-box-header-txt");
        div.appendChild((Component)label);
        this.appendChild((Component)div);
        Table table2 = new Table();
        table2.setId("grdResetPassword");
        table2.setDynamicProperty("cellpadding", (Object)"0");
        table2.setDynamicProperty("cellspacing", (Object)"5");
        table2.setSclass("login-box-body");
        this.appendChild((Component)table2);
        Tr tr2 = new Tr();
        table2.appendChild((Component)tr2);
        Td td2 = new Td();
        td2.setSclass("login-box-header-logo");
        tr2.appendChild((Component)td2);
        td2.setDynamicProperty("colspan", (Object)"2");
        Image image = new Image();
        image.setSrc(ThemeManager.getLargeLogo());
        td2.appendChild((Component)image);
        tr2 = new Tr();
        tr2.setId("rowUser");
        table2.appendChild((Component)tr2);
        td2 = new Td();
        tr2.appendChild((Component)td2);
        td2.setSclass("login-label");
        td2.appendChild((Component)this.lblUserId);
        td2 = new Td();
        td2.setSclass("login-field");
        tr2.appendChild((Component)td2);
        td2.appendChild((Component)this.txtUserId);
        tr2 = new Tr();
        tr2.setId("rowEmail");
        table2.appendChild((Component)tr2);
        td2 = new Td();
        tr2.appendChild((Component)td2);
        td2.setSclass("login-label");
        td2.appendChild((Component)this.lblEmail);
        td2 = new Td();
        td2.setSclass("login-field");
        tr2.appendChild((Component)td2);
        td2.appendChild((Component)this.txtEmail);
        if (this.m_email_login) {
            this.lblEmail.setVisible(false);
            this.txtEmail.setVisible(false);
        } else {
            this.lblUserId.setVisible(false);
            this.txtUserId.setVisible(false);
        }
        if (!this.m_noSecurityQuestion) {
            tr2 = new Tr();
            tr2.setId("rowSecurityQuestion");
            table2.appendChild((Component)tr2);
            td2 = new Td();
            tr2.appendChild((Component)td2);
            td2.setSclass("login-label");
            td2.appendChild((Component)this.lblSecurityQuestion);
            td2 = new Td();
            td2.setSclass("login-field");
            tr2.appendChild((Component)td2);
            td2.appendChild((Component)this.txtSecurityQuestion);
            tr2 = new Tr();
            tr2.setId("rowAnswer");
            table2.appendChild((Component)tr2);
            td2 = new Td();
            tr2.appendChild((Component)td2);
            td2.setSclass("login-label");
            td2.appendChild((Component)this.lblAnswer);
            td2 = new Td();
            td2.setSclass("login-field");
            tr2.appendChild((Component)td2);
            td2.appendChild((Component)this.txtAnswer);
        }
        div = new Div();
        div.setSclass("login-box-footer");
        ConfirmPanel pnlButtons = new ConfirmPanel(true);
        pnlButtons.addActionListener(this);
        LayoutUtils.addSclass("login-box-footer-pnl", (HtmlBasedComponent)pnlButtons);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)pnlButtons, null);
        pnlButtons.getButton("Ok").setSclass("login-btn");
        pnlButtons.getButton("Cancel").setSclass("login-btn");
        div.appendChild((Component)pnlButtons);
        this.appendChild((Component)div);
    }

    private void initComponents() {
        this.lblEmail = new Label();
        this.lblEmail.setId("lblEmail");
        this.lblEmail.setValue(Msg.getMsg((Properties)this.m_ctx, (String)"EMail"));
        this.txtEmail = new Textbox();
        this.txtEmail.setId("txtEmail");
        this.txtEmail.setCols(25);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.txtEmail, "220px");
        this.txtEmail.setReadonly(false);
        this.lblUserId = new Label();
        this.lblUserId.setId("lblUserId");
        this.lblUserId.setValue(Msg.getMsg((Properties)this.m_ctx, (String)"User"));
        this.txtUserId = new Textbox();
        this.txtUserId.setId("txtUserId");
        this.txtUserId.setCols(25);
        this.txtUserId.setMaxlength(40);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.txtUserId, "220px");
        this.txtUserId.setReadonly(false);
        if (!this.m_noSecurityQuestion) {
            this.lblSecurityQuestion = new Label();
            this.lblSecurityQuestion.setId("lblSecurityQuestion");
            this.lblSecurityQuestion.setValue(Msg.getMsg((Properties)this.m_ctx, (String)"SecurityQuestion"));
            this.lblSecurityQuestion.setVisible(false);
            this.lblAnswer = new Label();
            this.lblAnswer.setId("lblAnswer");
            this.lblAnswer.setValue(Msg.getMsg((Properties)this.m_ctx, (String)"Answer"));
            this.lblAnswer.setVisible(false);
            this.txtSecurityQuestion = new Textbox();
            this.txtSecurityQuestion.setId("txtSecurityQuestion");
            this.txtSecurityQuestion.setCols(25);
            ZKUpdateUtil.setWidth((HtmlBasedComponent)this.txtSecurityQuestion, "220px");
            this.txtSecurityQuestion.setReadonly(true);
            this.txtSecurityQuestion.setVisible(false);
            this.txtAnswer = new Textbox();
            this.txtAnswer.setType("password");
            this.txtAnswer.setId("txtAnswer");
            this.txtAnswer.setCols(25);
            ZKUpdateUtil.setWidth((HtmlBasedComponent)this.txtAnswer, "220px");
            this.txtAnswer.setReadonly(true);
            this.txtAnswer.setVisible(false);
        }
    }

    private void loadData() {
        if (this.m_email_login) {
            this.txtEmail.setText(this.m_userName);
        } else {
            this.txtUserId.setText(this.m_userName);
        }
    }

    protected void loadSecurityQuestion() {
        String email = this.txtEmail.getValue();
        String userid = this.txtUserId.getValue();
        if (Util.isEmpty((String)email) || Util.isEmpty((String)userid)) {
            throw new IllegalArgumentException(String.valueOf(Msg.getMsg((Properties)this.m_ctx, (String)"FillMandatory")) + " " + (this.m_email_login ? this.lblUserId.getValue() : this.lblEmail.getValue()));
        }
        StringBuilder sql = new StringBuilder("SELECT SecurityQuestion ");
        sql.append("FROM AD_User ");
        sql.append("WHERE IsActive='Y' ");
        sql.append("AND COALESCE(LDAPUser,Name)=? ");
        sql.append("AND EMail=? ");
        sql.append("AND SecurityQuestion IS NOT NULL ");
        sql.append("ORDER BY AD_Client_ID DESC");
        String securityQuestion = DB.getSQLValueString(null, (String)sql.toString(), (Object[])new Object[]{userid, email});
        if (securityQuestion == null) {
            this.m_noSecurityQuestion = true;
            this.validateResetPassword();
            return;
        }
        this.txtSecurityQuestion.setValue(securityQuestion);
        this.txtUserId.setReadonly(true);
        this.txtEmail.setReadonly(true);
        this.txtAnswer.setReadonly(false);
        this.lblSecurityQuestion.setVisible(true);
        this.lblAnswer.setVisible(true);
        this.txtSecurityQuestion.setVisible(true);
        this.txtAnswer.setVisible(true);
    }

    public void onEvent(Event event) {
        if (event.getTarget().getId().equals("Ok")) {
            this.validate();
        } else if (event.getTarget().getId().equals("Cancel")) {
            SessionManager.logoutSession();
        }
    }

    public void validate() {
        Clients.clearBusy();
        if (this.txtAnswer != null && this.txtAnswer.isReadonly()) {
            this.validateEmail();
        } else {
            this.validateResetPassword();
        }
    }

    protected void validateEmail() {
        String email = this.txtEmail.getValue();
        String userid = this.txtUserId.getValue();
        if (Util.isEmpty((String)email) || Util.isEmpty((String)userid)) {
            throw new IllegalArgumentException(String.valueOf(Msg.getMsg((Properties)this.m_ctx, (String)"FillMandatory")) + " " + (this.m_email_login ? this.lblUserId.getValue() : this.lblEmail.getValue()));
        }
        StringBuilder whereClause = new StringBuilder("Password IS NOT NULL ");
        whereClause.append("AND COALESCE(LDAPUser,Name)=? ");
        whereClause.append("AND EMail=? ");
        whereClause.append(" AND").append(" EXISTS (SELECT * FROM AD_User_Roles ur").append("         INNER JOIN AD_Role r ON (ur.AD_Role_ID=r.AD_Role_ID)").append("         WHERE ur.AD_User_ID=AD_User.AD_User_ID AND ur.IsActive='Y' AND r.IsActive='Y') AND ").append(" EXISTS (SELECT * FROM AD_Client c").append("         WHERE c.AD_Client_ID=AD_User.AD_Client_ID").append("         AND c.IsActive='Y') AND ").append(" AD_User.IsActive='Y'");
        List users = new Query(this.m_ctx, "AD_User", whereClause.toString(), null).setParameters(new Object[]{userid, email}).setOrderBy("AD_User_ID").list();
        if (users.size() == 0) {
            throw new AdempiereException(Msg.getMsg((Properties)this.m_ctx, (String)"InvalidUserNameAndEmail"));
        }
        this.loadSecurityQuestion();
    }

    protected void validateResetPassword() {
        String errorMsg;
        String email;
        block22: {
            String newPassword;
            email = this.txtEmail.getValue();
            String userid = this.txtUserId.getValue();
            if (Util.isEmpty((String)email) || Util.isEmpty((String)userid)) {
                throw new IllegalArgumentException(String.valueOf(Msg.getMsg((Properties)this.m_ctx, (String)"FillMandatory")) + " " + (this.m_email_login ? this.lblUserId.getValue() : this.lblEmail.getValue()));
            }
            List users = null;
            if (this.m_noSecurityQuestion) {
                StringBuilder whereClause = new StringBuilder("Password IS NOT NULL ");
                whereClause.append("AND COALESCE(LDAPUser,Name)=? ");
                whereClause.append("AND EMail=? ");
                whereClause.append(" AND").append(" EXISTS (SELECT * FROM AD_User_Roles ur").append("         INNER JOIN AD_Role r ON (ur.AD_Role_ID=r.AD_Role_ID)").append("         WHERE ur.AD_User_ID=AD_User.AD_User_ID AND ur.IsActive='Y' AND r.IsActive='Y') AND ").append(" EXISTS (SELECT * FROM AD_Client c").append("         WHERE c.AD_Client_ID=AD_User.AD_Client_ID").append("         AND c.IsActive='Y') AND ").append(" AD_User.IsActive='Y'");
                users = new Query(this.m_ctx, "AD_User", whereClause.toString(), null).setParameters(new Object[]{userid, email}).setOrderBy("AD_User_ID").list();
            } else {
                String securityQuestion = this.txtSecurityQuestion.getValue();
                String answer = this.txtAnswer.getValue();
                if (Util.isEmpty((String)securityQuestion)) {
                    throw new IllegalArgumentException(Msg.getMsg((Properties)this.m_ctx, (String)"SecurityQuestionMandatory"));
                }
                if (Util.isEmpty((String)answer)) {
                    throw new IllegalArgumentException(Msg.getMsg((Properties)this.m_ctx, (String)"AnswerMandatory"));
                }
                StringBuilder whereClause = new StringBuilder("Password IS NOT NULL AND ");
                whereClause.append("EMail=?");
                whereClause.append(" AND").append(" EXISTS (SELECT * FROM AD_User_Roles ur").append("         INNER JOIN AD_Role r ON (ur.AD_Role_ID=r.AD_Role_ID)").append("         WHERE ur.AD_User_ID=AD_User.AD_User_ID AND ur.IsActive='Y' AND r.IsActive='Y') AND ").append(" EXISTS (SELECT * FROM AD_Client c").append("         WHERE c.AD_Client_ID=AD_User.AD_Client_ID").append("         AND c.IsActive='Y') AND ").append(" AD_User.IsActive='Y'").append(" AND AD_User.SecurityQuestion=?").append(" AND AD_User.Answer=?");
                users = new Query(this.m_ctx, "AD_User", whereClause.toString(), null).setParameters(new Object[]{email, securityQuestion, answer}).setOrderBy("AD_User_ID").list();
            }
            if (users.size() == 0) {
                String errMsg = this.m_noSecurityQuestion ? Msg.getMsg((Properties)this.m_ctx, (String)"InvalidUserNameAndEmail") : Msg.getMsg((Properties)this.m_ctx, (String)"InvalidSecurityQuestionAndAnswer");
                ++this.counter;
                if (this.counter >= 3) {
                    this.counter = 0;
                    SessionManager.logoutSession();
                    this.wndLogin.loginCancelled();
                }
                throw new AdempiereException(errMsg);
            }
            MPasswordRule pwdrule = MPasswordRule.getRules((Properties)Env.getCtx(), null);
            if (pwdrule != null) {
                newPassword = pwdrule.generate();
            } else {
                SecureRandom random = new SecureRandom();
                newPassword = BigInteger.probablePrime(50, random).toString(36);
            }
            errorMsg = "";
            Trx trx = null;
            try {
                try {
                    String trxName = Trx.createTrxName((String)"ResetPasswordTrx");
                    trx = Trx.get((String)trxName, (boolean)true);
                    trx.setDisplayName(String.valueOf(this.getClass().getName()) + "_validateResetPassword");
                    for (MUser user : users) {
                        user.set_TrxName(trx.getTrxName());
                        user.set_ValueOfColumn("Password", (Object)newPassword);
                        user.setIsExpired(true);
                        user.saveEx();
                        if (this.sendEmail(user, newPassword)) {
                            if (!logger.isLoggable(Level.FINE)) continue;
                            logger.fine(user.getEMail());
                            continue;
                        }
                        if (errorMsg.length() > 0) {
                            errorMsg = String.valueOf(errorMsg) + ", ";
                        }
                        errorMsg = String.valueOf(errorMsg) + user.getEMail();
                        throw new AdempiereException(String.valueOf(Msg.getMsg((Properties)this.m_ctx, (String)"RequestActionEMailError")) + ": " + user.getEMail());
                    }
                    trx.commit();
                }
                catch (Exception e) {
                    if (trx != null) {
                        trx.rollback();
                    }
                    if (trx != null) {
                        trx.close();
                    }
                    break block22;
                }
            }
            catch (Throwable throwable) {
                if (trx != null) {
                    trx.close();
                }
                throw throwable;
            }
            if (trx != null) {
                trx.close();
            }
        }
        if (errorMsg.length() > 0) {
            throw new AdempiereException(String.valueOf(Msg.getMsg((Properties)this.m_ctx, (String)"RequestActionEMailError")) + ": " + errorMsg);
        }
        String msg = Msg.getMsg((Properties)this.m_ctx, (String)"PasswordsForAllTenantsReset", (Object[])new Object[]{email});
        Messagebox.showDialog(msg, AEnv.getDialogHeader(Env.getCtx(), 0), 1, "~./zul/img/msgbox/info-btn.png", new Callback<Integer>(){

            public void onCallback(Integer result) {
                SessionManager.logoutSession();
            }
        });
    }

    protected boolean sendEmail(MUser to, String newPassword) {
        MClient client = MClient.get((Properties)this.m_ctx, (int)0);
        StringBuilder sql = new StringBuilder("SELECT R_MailText_ID ");
        sql.append("FROM R_MailText ");
        sql.append("WHERE IsActive='Y' ");
        sql.append("AND Name=? ");
        sql.append("AND AD_Client_ID IN (?, 0) ");
        sql.append("ORDER BY AD_Client_ID ");
        int R_MailText_ID = DB.getSQLValue(null, (String)sql.toString(), (Object[])new Object[]{RESET_PASSWORD_MAIL_TEXT_NAME, to.getAD_Client_ID()});
        if (R_MailText_ID <= 0) {
            return false;
        }
        MMailText mailText = new MMailText(this.m_ctx, R_MailText_ID, null);
        mailText.setLanguage(Env.getContext((Properties)this.m_ctx, (String)"#AD_Language"));
        to.set_ValueOfColumn("Password", (Object)newPassword);
        mailText.setUser(to);
        String message = mailText.getMailText(true);
        Env.setContext((Properties)this.m_ctx, (String)"#NewPassword", (String)newPassword);
        message = Env.parseVariable((String)message, (PO)to, (String)to.get_TrxName(), (boolean)true);
        Env.setContext((Properties)this.m_ctx, (String)"#NewPassword", (String)"");
        EMail email = client.createEMail(to.getEMail(), mailText.getMailHeader(), message, mailText.isHtml());
        if (mailText.isHtml()) {
            email.setMessageHTML(mailText.getMailHeader(), message);
        } else {
            email.setSubject(mailText.getMailHeader());
            email.setMessageText(message);
        }
        if (!email.isValid() && !email.isValid(true)) {
            logger.warning("NOT VALID - " + email);
            return Boolean.FALSE;
        }
        return "OK".equals(email.send());
    }
}

