/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.panel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import org.adempiere.exceptions.DBException;
import org.adempiere.model.MTabCustomization;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.adwindow.QuickGridView;
import org.adempiere.webui.component.Borderlayout;
import org.adempiere.webui.component.Button;
import org.adempiere.webui.component.Checkbox;
import org.adempiere.webui.component.ConfirmPanel;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.ListHead;
import org.adempiere.webui.component.ListHeader;
import org.adempiere.webui.component.ListItem;
import org.adempiere.webui.component.Listbox;
import org.adempiere.webui.component.Panel;
import org.adempiere.webui.component.SimpleListModel;
import org.adempiere.webui.factory.ButtonFactory;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.Dialog;
import org.compiere.model.MField;
import org.compiere.model.MRole;
import org.compiere.model.MTab;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.NamePair;
import org.zkoss.zhtml.Span;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuFocus;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.DropEvent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.Hbox;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.North;
import org.zkoss.zul.Separator;
import org.zkoss.zul.South;
import org.zkoss.zul.Vbox;

public class QuickCustomizeGridViewPanel
extends Panel {
    private static final long serialVersionUID = 7566420005952940208L;
    static CLogger log = CLogger.getCLogger(QuickCustomizeGridViewPanel.class);
    private Map<Integer, String> m_columnsWidth;
    ArrayList<Integer> tableSeqs;
    QuickGridView gridview = null;
    private int m_WindowNo;
    private int m_AD_Tab_ID;
    private int m_AD_User_ID;
    private Label yesLabel = new Label();
    private Button bDown = ButtonFactory.createNamedButton("MoveDown");
    private Button bUp = ButtonFactory.createNamedButton("MoveUp");
    private Checkbox chkSaveWidth = new Checkbox();
    SimpleListModel yesModel = new SimpleListModel();
    Listbox yesList = new Listbox();
    private boolean uiCreated;
    private boolean m_saved = false;
    private ConfirmPanel confirmPanel = new ConfirmPanel(true, false, true, false, false, false);

    public QuickCustomizeGridViewPanel(int WindowNo, int AD_Tab_ID, int AD_User_ID, Map<Integer, String> columnsWidth, ArrayList<Integer> gridFieldIds) {
        this.m_WindowNo = WindowNo;
        this.m_AD_Tab_ID = AD_Tab_ID;
        this.m_AD_User_ID = AD_User_ID;
        this.m_columnsWidth = columnsWidth;
        this.tableSeqs = gridFieldIds;
        this.setStyle("position: relative; height: 100%; width: 100%; margin: none; border: none; padding: none;");
    }

    private void init() throws Exception {
        Borderlayout layout = new Borderlayout();
        layout.setStyle("height: 100%; width: 100%; border: none; margin: none; padding: 2px;");
        this.yesLabel.setValue(Msg.getMsg((Properties)Env.getCtx(), (String)"Selected"));
        ZKUpdateUtil.setVflex(this.yesList, true);
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this.yesList, "300px");
        this.yesList.setSeltype("multiple");
        DragListener crossListMouseListener = new DragListener();
        this.yesList.addOnDropListener(crossListMouseListener);
        this.yesList.setItemDraggable(true);
        EventListener<Event> actionListener = new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                QuickCustomizeGridViewPanel.this.migrateValueWithinYesList(event);
            }
        };
        this.bUp.addEventListener("onClick", (EventListener)actionListener);
        this.bDown.addEventListener("onClick", (EventListener)actionListener);
        Panel northPanel = new Panel();
        ListHead listHead = new ListHead();
        listHead.setParent((Component)this.yesList);
        ListHeader listHeader = new ListHeader();
        listHeader.appendChild((Component)this.yesLabel);
        listHeader.setParent((Component)listHead);
        Span span = new Span();
        span.setParent((Component)northPanel);
        span.setStyle("height: 99%; display: inline-block; width: 86%; float: left;");
        span.appendChild((Component)this.yesList);
        Vbox vbox = new Vbox();
        vbox.appendChild((Component)this.bUp);
        vbox.appendChild((Component)this.bDown);
        span = new Span();
        span.setParent((Component)northPanel);
        span.setStyle("height: 99%; display: inline-block; width: 60px;  float: left;");
        span.appendChild((Component)vbox);
        North north = new North();
        north.setStyle("border: none; margin: 0; padding: 0; ");
        north.appendChild((Component)northPanel);
        layout.appendChild((Component)north);
        South south = new South();
        south.setStyle("border: none; margin: 0; padding: 0; ");
        Separator sep = new Separator();
        sep.setSpacing("2px");
        Panel southPanel = new Panel();
        southPanel.appendChild((Component)sep);
        this.chkSaveWidth.setLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"SaveColumnWidth"));
        vbox = new Vbox();
        Hbox hbox = new Hbox();
        hbox.appendChild((Component)this.chkSaveWidth);
        vbox.appendChild((Component)hbox);
        vbox.appendChild((Component)sep);
        hbox = new Hbox();
        vbox.appendChild((Component)hbox);
        southPanel.appendChild((Component)vbox);
        southPanel.appendChild((Component)sep);
        LayoutUtils.addSclass("dialog-footer", (HtmlBasedComponent)this.confirmPanel);
        EventListener<Event> onClickListener = new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                MTabCustomization tabCust;
                if (event.getTarget().equals((Object)QuickCustomizeGridViewPanel.this.confirmPanel.getButton("Ok"))) {
                    QuickCustomizeGridViewPanel.this.saveData();
                } else if (event.getTarget().equals((Object)QuickCustomizeGridViewPanel.this.confirmPanel.getButton("Cancel"))) {
                    if (QuickCustomizeGridViewPanel.this.gridview != null) {
                        Events.postEvent((String)"onCustomizeGrid", (Component)QuickCustomizeGridViewPanel.this.gridview, null);
                    }
                    QuickCustomizeGridViewPanel.this.getParent().detach();
                } else if (event.getTarget().equals((Object)QuickCustomizeGridViewPanel.this.confirmPanel.getButton("Reset")) && (tabCust = MTabCustomization.get((Properties)Env.getCtx(), (int)QuickCustomizeGridViewPanel.this.m_AD_User_ID, (int)QuickCustomizeGridViewPanel.this.m_AD_Tab_ID, null, (boolean)true)) != null && tabCust.getAD_Tab_Customization_ID() > 0) {
                    tabCust.deleteEx(true);
                }
            }
        };
        this.confirmPanel.addActionListener(onClickListener);
        southPanel.appendChild((Component)this.confirmPanel);
        south.appendChild((Component)southPanel);
        layout.appendChild((Component)south);
        this.appendChild((Component)layout);
    }

    public void loadData() {
        MTabCustomization tabCust = MTabCustomization.get((Properties)Env.getCtx(), (int)this.m_AD_User_ID, (int)this.m_AD_Tab_ID, null, (boolean)true);
        boolean baseLanguage = Env.isBaseLanguage((Properties)Env.getCtx(), (String)"AD_Field");
        this.yesModel.removeAllElements();
        Query query = null;
        query = new Query(Env.getCtx(), "AD_Field", "AD_Tab_ID=? AND (IsDisplayed='Y' OR IsDisplayedGrid='Y') AND IsActive='Y' AND IsQuickForm='Y'", null);
        query.setOrderBy("SeqNoGrid, Name, SeqNo");
        query.setParameters(new Object[]{this.m_AD_Tab_ID});
        query.setApplyAccessFilter(true);
        try {
            List lsFieldsOfGrid = query.list();
            HashMap<Integer, ListElement> curTabSel = new HashMap<Integer, ListElement>();
            MTab tab = MTab.get((int)this.m_AD_Tab_ID);
            for (MField field : lsFieldsOfGrid) {
                if (!MRole.getDefault((Properties)Env.getCtx(), (boolean)false).isColumnAccess(tab.getAD_Table_ID(), field.getAD_Column_ID(), true)) continue;
                int key = field.get_ID();
                String name = null;
                name = baseLanguage ? field.getName() : field.get_Translation("Name");
                ListElement pp = new ListElement(key, name);
                if (this.tableSeqs == null || this.tableSeqs.size() <= 0 || !this.tableSeqs.contains(key)) continue;
                curTabSel.put(key, pp);
            }
            if (this.tableSeqs != null) {
                Iterator<Object> iterator = this.tableSeqs.iterator();
                while (iterator.hasNext()) {
                    int key = (Integer)iterator.next();
                    if (curTabSel.get(key) == null) continue;
                    this.yesModel.addElement(curTabSel.get(key));
                }
            }
        }
        catch (DBException e) {
            log.log(Level.SEVERE, e.getMessage(), (Throwable)e);
        }
        this.bUp.setEnabled(true);
        this.bDown.setEnabled(true);
        this.yesList.setEnabled(true);
        this.yesList.setItemRenderer(this.yesModel);
        this.yesList.setModel((ListModel)this.yesModel);
        if (tabCust != null && tabCust.getCustom().indexOf("px") > 0) {
            this.chkSaveWidth.setChecked(true);
        }
    }

    void migrateLists(Listbox listFrom, Listbox listTo, int endIndex) {
        int index = 0;
        SimpleListModel lmFrom = (SimpleListModel)listFrom.getModel();
        SimpleListModel lmTo = (SimpleListModel)listTo.getModel();
        Set selectedItems = listFrom.getSelectedItems();
        ArrayList<ListElement> selObjects = new ArrayList<ListElement>();
        for (Object obj : selectedItems) {
            ListItem listItem = (ListItem)((Object)obj);
            index = listFrom.getIndexOfItem(listItem);
            ListElement selObject = (ListElement)((Object)lmFrom.getElementAt(index));
            selObjects.add(selObject);
        }
        for (ListElement selObject : selObjects) {
            if (selObject == null || !selObject.isUpdateable()) continue;
            lmFrom.removeElement((Object)selObject);
            lmTo.add(endIndex, (Object)selObject);
            ++endIndex;
            index = lmTo.indexOf((Object)selObject);
            listTo.setSelectedIndex(index);
        }
    }

    void migrateValueWithinYesList(int endIndex, List<ListElement> selObjects) {
        int iniIndex = 0;
        Arrays.sort(selObjects.toArray());
        ListElement endObject = (ListElement)((Object)this.yesModel.getElementAt(endIndex));
        for (ListElement selected : selObjects) {
            iniIndex = this.yesModel.indexOf((Object)selected);
            ListElement selObject = (ListElement)((Object)this.yesModel.getElementAt(iniIndex));
            this.yesModel.removeElement((Object)selObject);
            endIndex = this.yesModel.indexOf((Object)endObject);
            this.yesModel.add(endIndex, (Object)selObject);
        }
    }

    void migrateValueWithinYesList(Event event) {
        int i;
        Object[] selObjects = this.yesList.getSelectedItems().toArray();
        if (selObjects == null) {
            return;
        }
        int length = selObjects.length;
        if (length == 0) {
            return;
        }
        int[] indices = this.yesList.getSelectedIndices();
        Arrays.sort(indices);
        boolean change = false;
        Component source = event.getTarget();
        if (source == this.bUp) {
            i = 0;
            while (i < length) {
                int index = indices[i];
                if (index == 0) break;
                ListElement selObject = (ListElement)((Object)this.yesModel.getElementAt(index));
                ListElement newObject = (ListElement)((Object)this.yesModel.getElementAt(index - 1));
                if (selObject.isUpdateable() && newObject.isUpdateable()) {
                    this.yesModel.setElementAt((Object)newObject, index);
                    this.yesModel.setElementAt((Object)selObject, index - 1);
                    indices[i] = index - 1;
                    change = true;
                    ++i;
                    continue;
                }
                break;
            }
        } else if (source == this.bDown) {
            i = length - 1;
            while (i >= 0) {
                int index = indices[i];
                if (index >= this.yesModel.getSize() - 1) break;
                ListElement selObject = (ListElement)((Object)this.yesModel.getElementAt(index));
                ListElement newObject = (ListElement)((Object)this.yesModel.getElementAt(index + 1));
                if (selObject.isUpdateable() && newObject.isUpdateable()) {
                    this.yesModel.setElementAt((Object)newObject, index);
                    this.yesModel.setElementAt((Object)selObject, index + 1);
                    this.yesList.setSelectedIndex(index + 1);
                    indices[i] = index + 1;
                    change = true;
                    --i;
                    continue;
                }
                break;
            }
        }
        if (change) {
            this.yesList.setSelectedIndices(indices);
            if (this.yesList.getSelectedItem() != null) {
                AuFocus focus = new AuFocus((Component)this.yesList.getSelectedItem());
                Clients.response((AuResponse)focus);
            }
        }
    }

    public void saveData() {
        ListElement pp;
        boolean ok = true;
        StringBuilder custom = new StringBuilder();
        int i = 0;
        while (i < this.yesModel.getSize()) {
            pp = (ListElement)((Object)this.yesModel.getElementAt(i));
            if (pp.isUpdateable()) {
                if (i > 0) {
                    custom.append(",");
                }
                custom.append(pp.getKey());
            }
            ++i;
        }
        if (this.chkSaveWidth.isSelected() && this.m_columnsWidth != null && !this.m_columnsWidth.isEmpty()) {
            i = 0;
            while (i < this.yesModel.getSize()) {
                if (i > 0) {
                    custom.append(",");
                } else {
                    custom.append(";");
                }
                pp = (ListElement)((Object)this.yesModel.getElementAt(i));
                int fieldId = pp.getKey();
                String width = this.m_columnsWidth.get(fieldId);
                if (width == null) {
                    width = "";
                }
                custom.append(width);
                ++i;
            }
        }
        if (ok = MTabCustomization.saveData((Properties)Env.getCtx(), (int)this.m_AD_Tab_ID, (int)this.m_AD_User_ID, (String)custom.toString(), null, null, (boolean)true)) {
            this.m_saved = true;
            this.gridview.setStatusLine("Customize Preference Saved.", false);
            if (this.gridview != null) {
                Events.postEvent((String)"onCustomizeGrid", (Component)this.gridview, null);
            }
            this.getParent().detach();
        } else {
            Dialog.error(this.m_WindowNo, "SaveError", custom.toString());
        }
    }

    public void activate(boolean b) {
        if (b && !this.uiCreated) {
            this.createUI();
        }
    }

    public void createUI() {
        if (this.uiCreated) {
            return;
        }
        try {
            this.init();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", (Throwable)e);
        }
        this.uiCreated = true;
    }

    public boolean isSaved() {
        return this.m_saved;
    }

    public void setGridPanel(QuickGridView quickGridView) {
        this.gridview = quickGridView;
    }

    private class DragListener
    implements EventListener<Event> {
        public void onEvent(Event event) throws Exception {
            if (event instanceof DropEvent) {
                int endIndex = 0;
                DropEvent me = (DropEvent)event;
                ListItem endItem = (ListItem)me.getTarget();
                ListItem startItem = (ListItem)me.getDragged();
                if (!startItem.isSelected()) {
                    startItem.setSelected(true);
                }
                if (startItem.getListbox() != endItem.getListbox()) {
                    Listbox listFrom = (Listbox)startItem.getListbox();
                    Listbox listTo = (Listbox)endItem.getListbox();
                    endIndex = QuickCustomizeGridViewPanel.this.yesList.getIndexOfItem(endItem);
                    QuickCustomizeGridViewPanel.this.migrateLists(listFrom, listTo, endIndex);
                } else if (startItem.getListbox() == endItem.getListbox() && startItem.getListbox() == QuickCustomizeGridViewPanel.this.yesList) {
                    ArrayList<ListElement> selObjects = new ArrayList<ListElement>();
                    endIndex = QuickCustomizeGridViewPanel.this.yesList.getIndexOfItem(endItem);
                    for (Object obj : QuickCustomizeGridViewPanel.this.yesList.getSelectedItems()) {
                        ListItem listItem = (ListItem)((Object)obj);
                        int index = QuickCustomizeGridViewPanel.this.yesList.getIndexOfItem(listItem);
                        ListElement selObject = (ListElement)((Object)QuickCustomizeGridViewPanel.this.yesModel.getElementAt(index));
                        selObjects.add(selObject);
                    }
                    QuickCustomizeGridViewPanel.this.migrateValueWithinYesList(endIndex, selObjects);
                    QuickCustomizeGridViewPanel.this.yesList.clearSelection();
                }
            }
        }
    }

    private static class ListElement
    extends NamePair {
        private static final long serialVersionUID = -4428985595605126841L;
        private int m_key;
        private boolean m_updateable;

        public ListElement(int key, String name) {
            super(name);
            this.m_key = key;
            this.m_updateable = true;
        }

        public int getKey() {
            return this.m_key;
        }

        public boolean isUpdateable() {
            return this.m_updateable;
        }

        public String getID() {
            return this.m_key != -1 ? String.valueOf(this.m_key) : null;
        }

        public int hashCode() {
            return this.m_key;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ListElement) {
                ListElement li = (ListElement)((Object)obj);
                return li.getKey() == this.m_key && li.getName() != null && li.getName().equals(this.getName());
            }
            return false;
        }

        public String toString() {
            String s = super.toString();
            if (s == null || s.trim().length() == 0) {
                s = "<" + this.getKey() + ">";
            }
            return s;
        }
    }
}

