/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.panel;

import java.util.List;
import java.util.Properties;
import org.adempiere.webui.panel.TreeSearchPanel;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.TreeItemAction;
import org.adempiere.webui.util.TreeUtils;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.IdSpace;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.EventQueues;
import org.zkoss.zul.Checkbox;
import org.zkoss.zul.Popup;
import org.zkoss.zul.Tree;
import org.zkoss.zul.Treechildren;
import org.zkoss.zul.Treeitem;
import org.zkoss.zul.Vbox;

public class MenuTreeFilterPanel
extends Popup
implements EventListener<Event>,
IdSpace {
    private static final String ORIGINAL_SIBLING = "original.sibling";
    private static final String FLAT_VIEW_PARENT = "flatView.parent";
    private static final long serialVersionUID = 5884898489357885711L;
    public static final String MENU_TREE_FILTER_CHECKED_QUEUE = "MENU_TREE_FILTER_CHECKED_QUEUE";
    private Tree tree;
    private TreeSearchPanel searchPanel;
    private Checkbox flatView;

    public MenuTreeFilterPanel(Tree tree, TreeSearchPanel panel) {
        this.tree = tree;
        this.searchPanel = panel;
        Vbox box = new Vbox();
        Checkbox report = new Checkbox();
        if (ThemeManager.isUseFontIconForImage()) {
            report.setIconSclass("z-icon-Report");
        } else {
            report.setImage(ThemeManager.getThemeResource("images/mReport.png"));
        }
        report.setChecked(true);
        report.setId("report");
        report.addEventListener("onCheck", (EventListener)this);
        box.appendChild((Component)report);
        Checkbox process = new Checkbox();
        if (ThemeManager.isUseFontIconForImage()) {
            process.setIconSclass("z-icon-Process");
        } else {
            process.setImage(ThemeManager.getThemeResource("images/mProcess.png"));
        }
        process.setChecked(true);
        process.setId("process");
        process.addEventListener("onCheck", (EventListener)this);
        box.appendChild((Component)process);
        Checkbox workflow = new Checkbox();
        if (ThemeManager.isUseFontIconForImage()) {
            workflow.setIconSclass("z-icon-WorkFlow");
        } else {
            workflow.setImage(ThemeManager.getThemeResource("images/mWorkFlow.png"));
        }
        workflow.setChecked(true);
        workflow.setId("workflow");
        workflow.addEventListener("onCheck", (EventListener)this);
        box.appendChild((Component)workflow);
        Checkbox window = new Checkbox();
        if (ThemeManager.isUseFontIconForImage()) {
            window.setIconSclass("z-icon-Window");
        } else {
            window.setImage(ThemeManager.getThemeResource("images/mWindow.png"));
        }
        window.setChecked(true);
        window.setId("window");
        window.addEventListener("onCheck", (EventListener)this);
        box.appendChild((Component)window);
        Checkbox form = new Checkbox();
        if (ThemeManager.isUseFontIconForImage()) {
            form.setIconSclass("z-icon-Form");
        } else {
            form.setImage(ThemeManager.getThemeResource("images/mForm.png"));
        }
        form.setChecked(true);
        form.setId("form");
        form.addEventListener("onCheck", (EventListener)this);
        box.appendChild((Component)form);
        Checkbox info = new Checkbox();
        if (ThemeManager.isUseFontIconForImage()) {
            info.setIconSclass("z-icon-Info");
        } else {
            info.setImage(ThemeManager.getThemeResource("images/mInfo.png"));
        }
        info.setChecked(true);
        info.setId("info");
        info.addEventListener("onCheck", (EventListener)this);
        box.appendChild((Component)info);
        this.flatView = new Checkbox();
        this.flatView.setLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"FlatView"));
        this.flatView.setId("flatView");
        this.flatView.setChecked(false);
        this.flatView.addEventListener("onCheck", (EventListener)this);
        box.appendChild((Component)this.flatView);
        this.appendChild((Component)box);
    }

    public void onEvent(Event event) throws Exception {
        Checkbox chk = (Checkbox)event.getTarget();
        EventQueues.lookup((String)MENU_TREE_FILTER_CHECKED_QUEUE, (String)"desktop", (boolean)true).publish(new Event("onCheck", null, (Object)chk));
    }

    public void switchToFlatView() {
        if (!this.flatView.isChecked()) {
            this.flatView.setChecked(true);
            MenuTreeFilterPanel.toggleFlatView(this.tree, this.flatView);
        }
    }

    public static void toggleFlatView(Tree tree, final Checkbox chk) {
        final Treeitem[] lastVisitedItem = new Treeitem[1];
        final Treeitem[] lastVisitedParent = new Treeitem[1];
        TreeUtils.traverse(tree, new TreeItemAction(){

            @Override
            public void run(Treeitem treeItem) {
                Treeitem currentParent = treeItem.getParentItem();
                if (treeItem.getAttribute("menu.type") == null) {
                    if (chk.isChecked()) {
                        if (treeItem.getLevel() > 0) {
                            treeItem.setVisible(false);
                        }
                    } else {
                        treeItem.setVisible(true);
                    }
                    if (lastVisitedParent[0] == treeItem.getParentItem() && lastVisitedItem[0] != null && lastVisitedItem[0].getAttribute(MenuTreeFilterPanel.ORIGINAL_SIBLING) == null) {
                        lastVisitedItem[0].setAttribute(MenuTreeFilterPanel.ORIGINAL_SIBLING, (Object)treeItem);
                    }
                } else if (chk.isChecked()) {
                    if (treeItem.getParentItem() != null && !treeItem.getParentItem().isVisible()) {
                        Treeitem parent = treeItem.getParentItem();
                        treeItem.setAttribute(MenuTreeFilterPanel.FLAT_VIEW_PARENT, (Object)parent);
                        while (parent != null) {
                            if (parent.isVisible()) {
                                if (lastVisitedParent[0] == treeItem.getParentItem() && lastVisitedItem[0] != null && lastVisitedItem[0].getAttribute(MenuTreeFilterPanel.ORIGINAL_SIBLING) == null) {
                                    lastVisitedItem[0].setAttribute(MenuTreeFilterPanel.ORIGINAL_SIBLING, (Object)treeItem);
                                }
                                treeItem.detach();
                                parent.getTreechildren().insertBefore((Component)treeItem, MenuTreeFilterPanel.findFlatViewSibling(parent.getTreechildren(), treeItem));
                                break;
                            }
                            parent = parent.getParentItem();
                        }
                    } else {
                        Treeitem parent = treeItem.getParentItem();
                        if (parent != null) {
                            if (lastVisitedParent[0] == treeItem.getParentItem() && lastVisitedItem[0] != null && lastVisitedItem[0].getAttribute(MenuTreeFilterPanel.ORIGINAL_SIBLING) == null) {
                                lastVisitedItem[0].setAttribute(MenuTreeFilterPanel.ORIGINAL_SIBLING, (Object)treeItem);
                            }
                            treeItem.detach();
                            parent.getTreechildren().insertBefore((Component)treeItem, MenuTreeFilterPanel.findFlatViewSibling(parent.getTreechildren(), treeItem));
                        }
                    }
                } else if (treeItem.getAttribute(MenuTreeFilterPanel.FLAT_VIEW_PARENT) != null) {
                    Treeitem parent = (Treeitem)treeItem.getAttribute(MenuTreeFilterPanel.FLAT_VIEW_PARENT);
                    treeItem.detach();
                    Treeitem sibling = (Treeitem)treeItem.getAttribute(MenuTreeFilterPanel.ORIGINAL_SIBLING);
                    if (sibling != null) {
                        MenuTreeFilterPanel.reattachSibling(parent.getTreechildren(), sibling);
                    }
                    parent.getTreechildren().insertBefore((Component)treeItem, (Component)sibling);
                    treeItem.removeAttribute(MenuTreeFilterPanel.FLAT_VIEW_PARENT);
                } else {
                    Treeitem parent = treeItem.getParentItem();
                    Treeitem sibling = (Treeitem)treeItem.getAttribute(MenuTreeFilterPanel.ORIGINAL_SIBLING);
                    if (sibling != null) {
                        MenuTreeFilterPanel.reattachSibling(parent.getTreechildren(), sibling);
                    }
                    parent.getTreechildren().insertBefore((Component)treeItem, (Component)sibling);
                }
                lastVisitedItem[0] = treeItem;
                lastVisitedParent[0] = currentParent;
            }
        });
    }

    private static void reattachSibling(Treechildren treechildren, Treeitem treeItem) {
        Treeitem sibling = (Treeitem)treeItem.getAttribute(ORIGINAL_SIBLING);
        if (sibling != null) {
            MenuTreeFilterPanel.reattachSibling(treechildren, sibling);
        }
        treechildren.insertBefore((Component)treeItem, (Component)sibling);
    }

    private static Component findFlatViewSibling(Treechildren treechildren, Treeitem treeItem) {
        List childrens = treechildren.getChildren();
        if (childrens.isEmpty()) {
            return null;
        }
        String menuType = (String)treeItem.getAttribute("menu.type");
        String label = (String)treeItem.getAttribute("menu.label");
        int i = 0;
        while (i < childrens.size()) {
            String tiLabel;
            Treeitem ti;
            String tiType;
            Component child = (Component)childrens.get(i);
            if (child instanceof Treeitem && (tiType = (String)(ti = (Treeitem)child).getAttribute("menu.type")) != null && (menuType.equals(tiType) ? !Util.isEmpty((String)(tiLabel = (String)ti.getAttribute("menu.label"))) && label.compareTo(tiLabel) < 0 : menuType.compareTo(tiType) < 0)) {
                return child;
            }
            ++i;
        }
        return null;
    }

    public static void toggle(Tree tree, final Checkbox chk) {
        TreeUtils.traverse(tree, new TreeItemAction(){

            @Override
            public void run(Treeitem treeItem) {
                if (treeItem.getAttribute("menu.type") != null) {
                    String menuType = (String)treeItem.getAttribute("menu.type");
                    if (chk.isChecked()) {
                        if (chk.getId().equals(menuType)) {
                            boolean open = false;
                            Treeitem parent = treeItem.getParentItem();
                            if (parent != null) {
                                open = parent.isOpen();
                            }
                            treeItem.setVisible(true);
                            if (parent != null) {
                                parent.setOpen(open);
                            }
                        }
                    } else if (chk.getId().equals(menuType)) {
                        boolean open = false;
                        Treeitem parent = treeItem.getParentItem();
                        if (parent != null) {
                            open = parent.isOpen();
                        }
                        treeItem.setVisible(false);
                        if (parent != null) {
                            parent.setOpen(open);
                        }
                    }
                }
            }
        });
    }
}

