/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.panel;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.component.ConfirmPanel;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.ListModelTable;
import org.adempiere.webui.component.ListboxFactory;
import org.adempiere.webui.component.Tab;
import org.adempiere.webui.component.Tabbox;
import org.adempiere.webui.component.Tabpanel;
import org.adempiere.webui.component.Tabpanels;
import org.adempiere.webui.component.Tabs;
import org.adempiere.webui.component.WListbox;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.info.InfoProductWindow;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.compiere.model.MPriceList;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.util.Callback;
import org.zkoss.zul.Borderlayout;
import org.zkoss.zul.Center;
import org.zkoss.zul.North;
import org.zkoss.zul.South;

public class InvoiceHistory
extends Window
implements EventListener<Event> {
    private static final long serialVersionUID = 8742214467478030802L;
    boolean showDetailATP = false;
    private int m_C_BPartner_ID;
    private int m_M_Product_ID;
    private int m_M_Warehouse_ID;
    private int m_M_AttributeSetInstance_ID;
    private static final CLogger log = CLogger.getCLogger(InvoiceHistory.class);
    private Label label = new Label();
    private ConfirmPanel confirmPanel = new ConfirmPanel();
    private Tabbox tabbox = new Tabbox();
    private Tabpanel pricePane = new Tabpanel();
    private WListbox m_tablePrice = ListboxFactory.newDataTable();
    private ListModelTable m_modelPrice = null;
    private Tabpanel reservedPane = new Tabpanel();
    private WListbox m_tableReserved = ListboxFactory.newDataTable();
    private ListModelTable m_modelReserved = null;
    private Tabpanel orderedPane = new Tabpanel();
    private WListbox m_tableOrdered = ListboxFactory.newDataTable();
    private ListModelTable m_modelOrdered = null;
    private Tabpanel unconfirmedPane = new Tabpanel();
    private WListbox m_tableUnconfirmed = ListboxFactory.newDataTable();
    private ListModelTable m_modelUnconfirmed = null;
    private Tabpanel atpPane = new Tabpanel();
    private WListbox m_tableAtp = ListboxFactory.newDataTable();
    private ListModelTable m_modelAtp = null;

    public InvoiceHistory(Window parent, int C_BPartner_ID, int M_Product_ID, int M_Warehouse_ID, int M_AttributeSetInstance_ID) {
        this.setTitle(Msg.getMsg((Properties)Env.getCtx(), (String)"PriceHistory"));
        if (log.isLoggable(Level.CONFIG)) {
            log.config("C_BPartner_ID=" + C_BPartner_ID + ", M_Product_ID=" + M_Product_ID + ", M_Warehouse_ID=" + M_Warehouse_ID + ", M_AttributeSetInstance_ID=" + M_AttributeSetInstance_ID);
        }
        this.m_C_BPartner_ID = C_BPartner_ID;
        this.m_M_Product_ID = M_Product_ID;
        this.m_M_Warehouse_ID = M_Warehouse_ID;
        this.m_M_AttributeSetInstance_ID = M_AttributeSetInstance_ID;
        try {
            this.jbInit();
            this.dynInit();
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "", (Throwable)ex);
        }
        this.setSclass("popup-dialog invoice-history-dialog");
        AEnv.showCenterWindow(parent, this);
        if (parent instanceof InfoProductWindow) {
            this.showDetailATP = ((InfoProductWindow)parent).isShowDetailATP();
        }
    }

    void jbInit() throws Exception {
        this.label.setText("Label");
        Tabs tabs = new Tabs();
        this.tabbox.appendChild((Component)tabs);
        Tabpanels tabpanels = new Tabpanels();
        this.tabbox.appendChild((Component)tabpanels);
        tabs.appendChild((Component)new Tab(Msg.getMsg((Properties)Env.getCtx(), (String)"PriceHistory")));
        tabs.appendChild((Component)new Tab(Msg.translate((Properties)Env.getCtx(), (String)"QtyReserved")));
        tabs.appendChild((Component)new Tab(Msg.translate((Properties)Env.getCtx(), (String)"QtyOrdered")));
        tabs.appendChild((Component)new Tab(Msg.getMsg((Properties)Env.getCtx(), (String)"QtyUnconfirmed")));
        if (this.m_M_Product_ID != 0) {
            tabs.appendChild((Component)new Tab(Msg.getMsg((Properties)Env.getCtx(), (String)"ATP")));
        }
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this.pricePane, "100%");
        this.pricePane.appendChild((Component)this.m_tablePrice);
        tabpanels.appendChild((Component)this.pricePane);
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this.reservedPane, "100%");
        this.reservedPane.appendChild((Component)this.m_tableReserved);
        tabpanels.appendChild((Component)this.reservedPane);
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this.orderedPane, "100%");
        this.orderedPane.appendChild((Component)this.m_tableOrdered);
        tabpanels.appendChild((Component)this.orderedPane);
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this.unconfirmedPane, "100%");
        this.unconfirmedPane.appendChild((Component)this.m_tableUnconfirmed);
        tabpanels.appendChild((Component)this.unconfirmedPane);
        if (this.m_M_Product_ID != 0) {
            ZKUpdateUtil.setHeight((HtmlBasedComponent)this.atpPane, "100%");
            this.atpPane.appendChild((Component)this.m_tableAtp);
            tabpanels.appendChild((Component)this.atpPane);
        }
        this.tabbox.setSelectedIndex(0);
        this.tabbox.addEventListener("onSelect", this);
        this.confirmPanel.addActionListener(this);
        Borderlayout borderlayout = new Borderlayout();
        if (!ThemeManager.isUseCSSForWindowSize()) {
            ZKUpdateUtil.setWindowWidthX((HtmlBasedComponent)this, 700);
            ZKUpdateUtil.setWindowHeightX((HtmlBasedComponent)this, 400);
        } else {
            this.addCallback("afterPageAttached", (Callback & Serializable)t -> {
                ZKUpdateUtil.setCSSHeight((HtmlBasedComponent)this);
                ZKUpdateUtil.setCSSWidth((HtmlBasedComponent)this);
                this.invalidate();
            });
        }
        borderlayout.setStyle("border: none; position: relative");
        this.appendChild((Component)borderlayout);
        this.setClosable(true);
        this.setSizable(true);
        this.setMaximizable(true);
        this.setBorder("normal");
        North north = new North();
        north.setStyle("border: none");
        borderlayout.appendChild((Component)north);
        north.appendChild((Component)this.label);
        Center center = new Center();
        center.setSclass("dialog-content");
        center.setAutoscroll(true);
        borderlayout.appendChild((Component)center);
        center.appendChild((Component)this.tabbox);
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.tabbox, "1");
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.tabbox, "1");
        South south = new South();
        south.setSclass("dialog-footer");
        borderlayout.appendChild((Component)south);
        south.appendChild((Component)this.confirmPanel);
    }

    private boolean dynInit() {
        Vector<String> columnNames = new Vector<String>();
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)(this.m_C_BPartner_ID == 0 ? "C_BPartner_ID" : "M_Product_ID")));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"PriceActual"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"C_Currency_ID"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"QtyInvoiced"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"Discount"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"DocumentNo"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"DateInvoiced"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"AD_Org_ID"));
        Vector<Vector<Object>> data = null;
        data = this.m_C_BPartner_ID == 0 ? this.queryBPartner() : this.queryProduct();
        this.m_modelPrice = new ListModelTable(data);
        this.m_tablePrice.setData(this.m_modelPrice, columnNames);
        this.m_tablePrice.setColumnClass(0, String.class, true);
        this.m_tablePrice.setColumnClass(1, Double.class, true);
        this.m_tablePrice.setColumnClass(2, String.class, true);
        this.m_tablePrice.setColumnClass(3, Double.class, true);
        this.m_tablePrice.setColumnClass(4, BigDecimal.class, true);
        this.m_tablePrice.setColumnClass(5, String.class, true);
        this.m_tablePrice.setColumnClass(6, Timestamp.class, true);
        this.m_tablePrice.setColumnClass(7, String.class, true);
        return data.size() != 0;
    }

    private Vector<Vector<Object>> queryProduct() {
        String sql = "SELECT p.Name,l.PriceActual,c.Iso_Code,l.PriceList,l.QtyInvoiced,i.DateInvoiced,dt.PrintName || ' ' || i.DocumentNo As DocumentNo,o.Name, NULL, i.M_PriceList_ID FROM C_Invoice i INNER JOIN C_InvoiceLine l ON (i.C_Invoice_ID=l.C_Invoice_ID) INNER JOIN C_DocType dt ON (i.C_DocType_ID=dt.C_DocType_ID) INNER JOIN AD_Org o ON (i.AD_Org_ID=o.AD_Org_ID) INNER JOIN M_Product p  ON (l.M_Product_ID=p.M_Product_ID)  INNER JOIN C_Currency c ON (i.C_Currency_ID=c.C_Currency_ID) WHERE i.C_BPartner_ID=? ORDER BY i.DateInvoiced DESC";
        Vector<Vector<Object>> data = this.fillTable(sql, this.m_C_BPartner_ID);
        sql = "SELECT Name from C_BPartner WHERE C_BPartner_ID=?";
        this.fillLabel(sql, this.m_C_BPartner_ID);
        return data;
    }

    private Vector<Vector<Object>> queryBPartner() {
        String sql = "SELECT bp.Name,l.PriceActual,c.Iso_Code,l.PriceList,l.QtyInvoiced,i.DateInvoiced,dt.PrintName || ' ' || i.DocumentNo As DocumentNo,o.Name,NULL, i.M_PriceList_ID FROM C_Invoice i INNER JOIN C_InvoiceLine l ON (i.C_Invoice_ID=l.C_Invoice_ID) INNER JOIN C_DocType dt ON (i.C_DocType_ID=dt.C_DocType_ID) INNER JOIN AD_Org o ON (i.AD_Org_ID=o.AD_Org_ID) INNER JOIN C_BPartner bp ON (i.C_BPartner_ID=bp.C_BPartner_ID)  INNER JOIN C_Currency c ON (i.C_Currency_ID=c.C_Currency_ID) WHERE l.M_Product_ID=? ORDER BY i.DateInvoiced DESC";
        Vector<Vector<Object>> data = this.fillTable(sql, this.m_M_Product_ID);
        sql = "SELECT Name from M_Product WHERE M_Product_ID=?";
        this.fillLabel(sql, this.m_M_Product_ID);
        return data;
    }

    private Vector<Vector<Object>> fillTable(String sql, int parameter) {
        Vector<Vector<Object>> data;
        block12: {
            if (log.isLoggable(Level.FINE)) {
                log.fine(String.valueOf(sql) + "; Parameter=" + parameter);
            }
            data = new Vector<Vector<Object>>();
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    pstmt.setInt(1, parameter);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        Vector<Object> line = new Vector<Object>(6);
                        line.add(rs.getString(1));
                        line.add(rs.getBigDecimal(2));
                        line.add(rs.getString(3));
                        line.add(rs.getDouble(5));
                        BigDecimal discountBD = rs.getBigDecimal(9);
                        if (discountBD == null) {
                            double priceList = rs.getDouble(4);
                            double priceActual = rs.getDouble(2);
                            if (priceList != 0.0) {
                                discountBD = BigDecimal.valueOf((priceList - priceActual) / priceList * 100.0);
                                int precision = MPriceList.getStandardPrecision((Properties)Env.getCtx(), (int)rs.getInt(10));
                                if (discountBD.scale() > precision) {
                                    discountBD = discountBD.setScale(precision, RoundingMode.HALF_UP);
                                }
                            } else {
                                discountBD = Env.ZERO;
                            }
                        }
                        line.add(discountBD);
                        line.add(rs.getString(7));
                        line.add(rs.getTimestamp(6));
                        line.add(rs.getString(8));
                        data.add(line);
                    }
                }
                catch (SQLException e) {
                    log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block12;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("#" + data.size());
        }
        return data;
    }

    private void fillLabel(String sql, int parameter) {
        String retValue;
        if (log.isLoggable(Level.FINE)) {
            log.fine(String.valueOf(sql) + "; Parameter=" + parameter);
        }
        if ((retValue = DB.getSQLValueString(null, (String)sql, (int)parameter)) != null) {
            this.label.setText(retValue);
        }
    }

    public void onEvent(Event e) throws Exception {
        Component component = e.getTarget();
        if (component.equals((Object)this.confirmPanel.getButton("Ok"))) {
            this.dispose();
        } else if (component instanceof Tab) {
            if (this.tabbox.getSelectedIndex() == 1) {
                this.initReservedOrderedTab(true);
            } else if (this.tabbox.getSelectedIndex() == 2) {
                this.initReservedOrderedTab(false);
            } else if (this.tabbox.getSelectedIndex() == 3) {
                this.initUnconfirmedTab();
            } else if (this.tabbox.getSelectedIndex() == 4) {
                this.initAtpTab();
            }
        }
    }

    private void initReservedOrderedTab(boolean reserved) {
        if (reserved && this.m_modelReserved != null) {
            return;
        }
        if (!reserved && this.m_modelOrdered != null) {
            return;
        }
        Vector<String> columnNames = new Vector<String>();
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)(this.m_C_BPartner_ID == 0 ? "C_BPartner_ID" : "M_Product_ID")));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"PriceActual"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"C_Currency_ID"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)(reserved ? "QtyReserved" : "QtyOrdered")));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"Discount"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"DocumentNo"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"DateOrdered"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"M_Warehouse_ID"));
        Vector<Vector<Object>> data = null;
        if (this.m_C_BPartner_ID == 0) {
            String sql = "SELECT bp.Name, ol.PriceActual,c.Iso_Code,ol.PriceList,ol.QtyReserved,o.DateOrdered,dt.PrintName || ' ' || o.DocumentNo As DocumentNo, w.Name,ol.Discount, 0 FROM C_Order o INNER JOIN C_OrderLine ol ON (o.C_Order_ID=ol.C_Order_ID) INNER JOIN C_DocType dt ON (o.C_DocType_ID=dt.C_DocType_ID) INNER JOIN M_Warehouse w ON (ol.M_Warehouse_ID=w.M_Warehouse_ID) INNER JOIN C_BPartner bp  ON (o.C_BPartner_ID=bp.C_BPartner_ID)  INNER JOIN C_Currency c ON (o.C_Currency_ID=c.C_Currency_ID) WHERE ol.QtyReserved<>0 AND ol.M_Product_ID=? AND o.IsSOTrx=" + (reserved ? "'Y'" : "'N'") + " ORDER BY o.DateOrdered";
            data = this.fillTable(sql, this.m_M_Product_ID);
        } else {
            String sql = "SELECT p.Name, ol.PriceActual,c.Iso_Code,ol.PriceList,ol.QtyReserved,o.DateOrdered,dt.PrintName || ' ' || o.DocumentNo As DocumentNo, w.Name,ol.Discount, 0 FROM C_Order o INNER JOIN C_OrderLine ol ON (o.C_Order_ID=ol.C_Order_ID) INNER JOIN C_DocType dt ON (o.C_DocType_ID=dt.C_DocType_ID) INNER JOIN M_Warehouse w ON (ol.M_Warehouse_ID=w.M_Warehouse_ID) INNER JOIN M_Product p  ON (ol.M_Product_ID=p.M_Product_ID)  INNER JOIN C_Currency c ON (o.C_Currency_ID=c.C_Currency_ID) WHERE ol.QtyReserved<>0 AND o.C_BPartner_ID=? AND o.IsSOTrx=" + (reserved ? "'Y'" : "'N'") + " ORDER BY o.DateOrdered";
            data = this.fillTable(sql, this.m_C_BPartner_ID);
        }
        if (reserved) {
            this.m_modelReserved = new ListModelTable(data);
            this.m_tableReserved.setData(this.m_modelReserved, columnNames);
            this.m_tableReserved.setColumnClass(0, String.class, true);
            this.m_tableReserved.setColumnClass(1, BigDecimal.class, true);
            this.m_tableReserved.setColumnClass(2, String.class, true);
            this.m_tableReserved.setColumnClass(3, Double.class, true);
            this.m_tableReserved.setColumnClass(4, BigDecimal.class, true);
            this.m_tableReserved.setColumnClass(5, String.class, true);
            this.m_tableReserved.setColumnClass(6, Timestamp.class, true);
            this.m_tableReserved.setColumnClass(7, String.class, true);
        } else {
            this.m_modelOrdered = new ListModelTable(data);
            this.m_tableOrdered.setData(this.m_modelOrdered, columnNames);
            this.m_tableOrdered.setColumnClass(0, String.class, true);
            this.m_tableOrdered.setColumnClass(1, BigDecimal.class, true);
            this.m_tableOrdered.setColumnClass(2, String.class, true);
            this.m_tableOrdered.setColumnClass(3, Double.class, true);
            this.m_tableOrdered.setColumnClass(4, BigDecimal.class, true);
            this.m_tableOrdered.setColumnClass(5, String.class, true);
            this.m_tableOrdered.setColumnClass(6, Timestamp.class, true);
            this.m_tableOrdered.setColumnClass(7, String.class, true);
        }
    }

    private void initUnconfirmedTab() {
        Vector data;
        Vector<String> columnNames;
        block10: {
            if (this.m_modelUnconfirmed != null) {
                return;
            }
            columnNames = new Vector<String>();
            columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)(this.m_C_BPartner_ID == 0 ? "C_BPartner_ID" : "M_Product_ID")));
            columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"MovementQty"));
            columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"MovementDate"));
            columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"IsSOTrx"));
            columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"DocumentNo"));
            columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"M_Warehouse_ID"));
            String sql = null;
            int parameter = 0;
            if (this.m_C_BPartner_ID == 0) {
                sql = "SELECT bp.Name, CASE WHEN io.IsSOTrx='Y' THEN iol.MovementQty*-1 ELSE iol.MovementQty END AS MovementQty, io.MovementDate,io.IsSOTrx, dt.PrintName || ' ' || io.DocumentNo As DocumentNo, w.Name FROM M_InOutLine iol INNER JOIN M_InOut io ON (iol.M_InOut_ID=io.M_InOut_ID) INNER JOIN C_BPartner bp  ON (io.C_BPartner_ID=bp.C_BPartner_ID) INNER JOIN C_DocType dt ON (io.C_DocType_ID=dt.C_DocType_ID) INNER JOIN M_Warehouse w ON (io.M_Warehouse_ID=w.M_Warehouse_ID) INNER JOIN M_InOutLineConfirm lc ON (iol.M_InOutLine_ID=lc.M_InOutLine_ID) WHERE iol.M_Product_ID=? AND lc.Processed='N' ORDER BY io.MovementDate,io.IsSOTrx";
                parameter = this.m_M_Product_ID;
            } else {
                sql = "SELECT p.Name, CASE WHEN io.IsSOTrx='Y' THEN iol.MovementQty*-1 ELSE iol.MovementQty END AS MovementQty, io.MovementDate,io.IsSOTrx, dt.PrintName || ' ' || io.DocumentNo As DocumentNo, w.Name FROM M_InOutLine iol INNER JOIN M_InOut io ON (iol.M_InOut_ID=io.M_InOut_ID) INNER JOIN M_Product p  ON (iol.M_Product_ID=p.M_Product_ID) INNER JOIN C_DocType dt ON (io.C_DocType_ID=dt.C_DocType_ID) INNER JOIN M_Warehouse w ON (io.M_Warehouse_ID=w.M_Warehouse_ID) INNER JOIN M_InOutLineConfirm lc ON (iol.M_InOutLine_ID=lc.M_InOutLine_ID) WHERE io.C_BPartner_ID=? AND lc.Processed='N' ORDER BY io.MovementDate,io.IsSOTrx";
                parameter = this.m_C_BPartner_ID;
            }
            data = new Vector();
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    pstmt.setInt(1, parameter);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        Vector<Object> line = new Vector<Object>(6);
                        line.add(rs.getString(1));
                        line.add(rs.getDouble(2));
                        line.add(rs.getTimestamp(3));
                        line.add("Y".equals(rs.getString(4)));
                        line.add(rs.getString(5));
                        line.add(rs.getString(6));
                        data.add(line);
                    }
                }
                catch (SQLException e) {
                    log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block10;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("#" + data.size());
        }
        this.m_modelUnconfirmed = new ListModelTable(data);
        this.m_tableUnconfirmed.setData(this.m_modelUnconfirmed, columnNames);
        this.m_tableUnconfirmed.setColumnClass(0, String.class, true);
        this.m_tableUnconfirmed.setColumnClass(1, Double.class, true);
        this.m_tableUnconfirmed.setColumnClass(2, Timestamp.class, true);
        this.m_tableUnconfirmed.setColumnClass(3, Boolean.class, true);
        this.m_tableUnconfirmed.setColumnClass(4, String.class, true);
    }

    private void initAtpTab() {
        Vector data;
        Vector<String> columnNames;
        block28: {
            Vector<Object> line;
            ResultSet rs;
            CPreparedStatement pstmt;
            double qty;
            String sql;
            block26: {
                if (this.m_modelAtp != null) {
                    return;
                }
                columnNames = new Vector<String>();
                columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"Date"));
                columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"QtyOnHand"));
                columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"C_BPartner_ID"));
                columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"QtyOrdered"));
                columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"QtyReserved"));
                columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"M_Locator_ID"));
                columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"M_AttributeSetInstance_ID"));
                columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"DocumentNo"));
                columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"M_Warehouse_ID"));
                sql = "SELECT s.QtyOnHand, s.QtyReserved, s.QtyOrdered, productAttribute(s.M_AttributeSetInstance_ID), s.M_AttributeSetInstance_ID,";
                if (!this.showDetailATP) {
                    sql = "SELECT SUM(s.QtyOnHand), SUM(s.QtyReserved), SUM(s.QtyOrdered), productAttribute(s.M_AttributeSetInstance_ID), 0,";
                }
                sql = String.valueOf(sql) + " w.Name, l.Value FROM M_Storage s INNER JOIN M_Locator l ON (s.M_Locator_ID=l.M_Locator_ID) LEFT JOIN M_LocatorType lt ON (l.M_LocatorType_ID=lt.M_LocatorType_ID) INNER JOIN M_Warehouse w ON (l.M_Warehouse_ID=w.M_Warehouse_ID) WHERE M_Product_ID=?";
                if (this.m_M_Warehouse_ID != 0) {
                    sql = String.valueOf(sql) + " AND l.M_Warehouse_ID=?";
                }
                if (this.m_M_AttributeSetInstance_ID > 0) {
                    sql = String.valueOf(sql) + " AND s.M_AttributeSetInstance_ID=?";
                }
                sql = String.valueOf(sql) + " AND (s.QtyOnHand<>0 OR s.QtyReserved<>0 OR s.QtyOrdered<>0)";
                sql = String.valueOf(sql) + " AND COALESCE(lt.IsAvailableForReservation,'Y')='Y'";
                if (!this.showDetailATP) {
                    sql = String.valueOf(sql) + " GROUP BY productAttribute(s.M_AttributeSetInstance_ID), w.Name, l.Value";
                }
                sql = String.valueOf(sql) + " ORDER BY l.Value";
                data = new Vector();
                qty = 0.0;
                pstmt = null;
                rs = null;
                try {
                    try {
                        pstmt = DB.prepareStatement((String)sql, null);
                        pstmt.setInt(1, this.m_M_Product_ID);
                        if (this.m_M_Warehouse_ID != 0) {
                            pstmt.setInt(2, this.m_M_Warehouse_ID);
                        }
                        if (this.m_M_AttributeSetInstance_ID > 0) {
                            pstmt.setInt(3, this.m_M_AttributeSetInstance_ID);
                        }
                        rs = pstmt.executeQuery();
                        while (rs.next()) {
                            line = new Vector<Object>(9);
                            line.add(null);
                            double qtyOnHand = rs.getDouble(1);
                            qty += qtyOnHand;
                            line.add(qtyOnHand);
                            line.add(null);
                            line.add(rs.getDouble(3));
                            line.add(rs.getDouble(2));
                            line.add(rs.getString(7));
                            String asi = rs.getString(4);
                            if (this.showDetailATP && (asi == null || asi.length() == 0)) {
                                asi = "{" + rs.getInt(5) + "}";
                            }
                            line.add(asi);
                            line.add(null);
                            line.add(rs.getString(6));
                            data.add(line);
                        }
                    }
                    catch (SQLException e) {
                        log.log(Level.SEVERE, sql, (Throwable)e);
                        DB.close(rs, (Statement)pstmt);
                        rs = null;
                        pstmt = null;
                        break block26;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
            }
            sql = "SELECT o.DatePromised, ol.QtyReserved, productAttribute(ol.M_AttributeSetInstance_ID), ol.M_AttributeSetInstance_ID, dt.DocBaseType, bp.Name, dt.PrintName || ' ' || o.DocumentNo As DocumentNo, w.Name FROM C_Order o INNER JOIN C_OrderLine ol ON (o.C_Order_ID=ol.C_Order_ID) INNER JOIN C_DocType dt ON (o.C_DocType_ID=dt.C_DocType_ID) INNER JOIN M_Warehouse w ON (ol.M_Warehouse_ID=w.M_Warehouse_ID) INNER JOIN C_BPartner bp  ON (o.C_BPartner_ID=bp.C_BPartner_ID) WHERE ol.QtyReserved<>0 AND ol.M_Product_ID=?";
            if (this.m_M_Warehouse_ID != 0) {
                sql = String.valueOf(sql) + " AND ol.M_Warehouse_ID=?";
            }
            if (this.m_M_AttributeSetInstance_ID > 0) {
                sql = String.valueOf(sql) + " AND ol.M_AttributeSetInstance_ID=?";
            }
            sql = String.valueOf(sql) + " ORDER BY o.DatePromised";
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    pstmt.setInt(1, this.m_M_Product_ID);
                    if (this.m_M_Warehouse_ID != 0) {
                        pstmt.setInt(2, this.m_M_Warehouse_ID);
                    }
                    if (this.m_M_AttributeSetInstance_ID > 0) {
                        pstmt.setInt(3, this.m_M_AttributeSetInstance_ID);
                    }
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        line = new Vector(9);
                        line.add(rs.getTimestamp(1));
                        double oq = rs.getDouble(2);
                        String DocBaseType = rs.getString(5);
                        Double qtyReserved = null;
                        Double qtyOrdered = null;
                        if ("POO".equals(DocBaseType)) {
                            qtyOrdered = oq;
                            qty += oq;
                        } else {
                            qtyReserved = oq;
                            qty -= oq;
                        }
                        line.add(qty);
                        line.add(rs.getString(6));
                        line.add(qtyOrdered);
                        line.add(qtyReserved);
                        line.add(null);
                        String asi = rs.getString(3);
                        if (this.showDetailATP && (asi == null || asi.length() == 0)) {
                            asi = "{" + rs.getInt(4) + "}";
                        }
                        line.add(asi);
                        line.add(rs.getString(7));
                        line.add(rs.getString(8));
                        data.add(line);
                    }
                }
                catch (SQLException e) {
                    log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block28;
                }
            }
            catch (Throwable throwable) {
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        this.m_modelAtp = new ListModelTable(data);
        this.m_tableAtp.setData(this.m_modelAtp, columnNames);
        this.m_tableAtp.setColumnClass(0, Timestamp.class, true);
        this.m_tableAtp.setColumnClass(1, Double.class, true);
        this.m_tableAtp.setColumnClass(2, String.class, true);
        this.m_tableAtp.setColumnClass(3, Double.class, true);
        this.m_tableAtp.setColumnClass(4, Double.class, true);
        this.m_tableAtp.setColumnClass(5, String.class, true);
        this.m_tableAtp.setColumnClass(6, String.class, true);
        this.m_tableAtp.setColumnClass(7, String.class, true);
        this.m_tableAtp.setColumnClass(8, String.class, true);
    }
}

