/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.panel;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.component.ConfirmPanel;
import org.adempiere.webui.component.Datebox;
import org.adempiere.webui.component.Grid;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.ListItem;
import org.adempiere.webui.component.Listbox;
import org.adempiere.webui.component.NumberBox;
import org.adempiere.webui.component.Row;
import org.adempiere.webui.component.Rows;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.editor.WDateEditor;
import org.adempiere.webui.editor.WNumberEditor;
import org.adempiere.webui.editor.WStringEditor;
import org.adempiere.webui.panel.InfoProductPanel;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.compiere.model.MAttributeSet;
import org.compiere.model.MRole;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Div;
import org.zkoss.zul.Separator;
import org.zkoss.zul.Textbox;
import org.zkoss.zul.Vbox;

public class InfoPAttributePanel
extends Window
implements EventListener<Event> {
    private static final long serialVersionUID = -4922961793415942591L;
    private int p_M_AttributeSet_ID = 0;
    private String m_query = "";
    private ArrayList<Component> m_productEditors = new ArrayList();
    private ArrayList<Component> m_productEditorsTo = new ArrayList();
    private ArrayList<Component> m_instanceEditors = new ArrayList();
    private ArrayList<Component> m_instanceEditorsTo = new ArrayList();
    private static final CLogger log = CLogger.getCLogger(InfoPAttributePanel.class);
    private Rows rows = null;
    private ConfirmPanel confirmPanel = new ConfirmPanel(true);
    private Label serNoLabel = new Label(Msg.translate((Properties)Env.getCtx(), (String)"SerNo"));
    private WStringEditor serNoField = new WStringEditor("SerNo", false, false, true, 10, 20, null, null);
    private Label lotLabel = new Label(Msg.translate((Properties)Env.getCtx(), (String)"Lot"));
    private WStringEditor lotField = new WStringEditor("Lot", false, false, true, 10, 20, null, null);
    private Listbox guaranteeDateSelection = null;
    private Datebox guaranteeDateField = new Datebox();
    private Label lotLabel2 = new Label(Msg.translate((Properties)Env.getCtx(), (String)"M_Lot_ID"));
    private Listbox lotSelection = null;

    public InfoPAttributePanel(Object input) {
        if (input != null) {
            if (input instanceof InfoProductPanel) {
                this.p_M_AttributeSet_ID = ((InfoProductPanel)input).getM_AttributeSet_ID();
            } else if (input instanceof Integer) {
                this.p_M_AttributeSet_ID = (Integer)input;
            }
        }
        this.setTitle(Msg.getMsg((Properties)Env.getCtx(), (String)"InfoPAttribute"));
        this.setBorder("normal");
        this.setMaximizable(true);
        this.setSizable(true);
        try {
            this.jbInit();
            this.dynInit();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "InfoPAttribute", (Throwable)e);
        }
        if (input instanceof Window) {
            AEnv.showCenterWindow((Window)input, this);
        } else {
            AEnv.showWindow(this);
        }
    }

    private void jbInit() throws Exception {
        Vbox vbox = new Vbox();
        this.appendChild((Component)vbox);
        Grid grid = new Grid();
        ZKUpdateUtil.setWidth((HtmlBasedComponent)grid, "400px");
        grid.setStyle("margin:0; padding:0;");
        grid.makeNoStrip();
        grid.setOddRowSclass("even");
        vbox.appendChild((Component)grid);
        this.rows = new Rows();
        grid.appendChild((Component)this.rows);
        this.confirmPanel.addActionListener(this);
        vbox.appendChild((Component)this.confirmPanel);
    }

    private void dynInit() {
        Div div;
        Row row;
        this.addAttributes();
        boolean isGuarantee = true;
        boolean isSerial = true;
        boolean isLot = true;
        if (this.p_M_AttributeSet_ID > 0) {
            MAttributeSet as = new MAttributeSet(Env.getCtx(), this.p_M_AttributeSet_ID, null);
            isGuarantee = as.isGuaranteeDate();
            isSerial = as.isSerNo();
            isLot = as.isLot();
        }
        String s = Msg.translate((Properties)Env.getCtx(), (String)"GuaranteeDate");
        this.guaranteeDateSelection = new Listbox();
        this.guaranteeDateSelection.setRows(0);
        this.guaranteeDateSelection.setMultiple(false);
        this.guaranteeDateSelection.setMold("select");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.guaranteeDateSelection, "150px");
        this.guaranteeDateSelection.appendItem(String.valueOf(s) + " <", String.valueOf(s) + " <");
        this.guaranteeDateSelection.appendItem(String.valueOf(s) + " =", String.valueOf(s) + " =");
        this.guaranteeDateSelection.appendItem(String.valueOf(s) + " >", String.valueOf(s) + " >");
        this.initLotSelection();
        if (isSerial) {
            row = new Row();
            this.rows.appendChild((Component)row);
            div = new Div();
            div.setStyle("text-align: right;");
            div.appendChild((Component)this.serNoLabel);
            row.appendChild((Component)div);
            row.appendChild((Component)this.serNoField.getComponent());
            ZKUpdateUtil.setWidth((HtmlBasedComponent)this.serNoField.getComponent(), "150px");
        }
        if (isLot) {
            row = new Row();
            this.rows.appendChild((Component)row);
            div = new Div();
            div.setStyle("text-align: right;");
            div.appendChild((Component)this.lotLabel);
            row.appendChild((Component)div);
            row.appendChild((Component)this.lotField.getComponent());
            ZKUpdateUtil.setWidth((HtmlBasedComponent)this.lotField.getComponent(), "150px");
            row = new Row();
            this.rows.appendChild((Component)row);
            div = new Div();
            div.setStyle("text-align: right;");
            div.appendChild((Component)this.lotLabel2);
            row.appendChild((Component)div);
            row.appendChild((Component)this.lotSelection);
        }
        if (isGuarantee) {
            row = new Row();
            this.rows.appendChild((Component)row);
            div = new Div();
            div.setStyle("text-align: right;");
            div.appendChild((Component)this.guaranteeDateSelection);
            row.appendChild((Component)div);
            row.appendChild((Component)this.guaranteeDateField);
        }
    }

    private int addAttributes() {
        boolean instanceLine;
        block18: {
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            String joinAttributeSet = this.p_M_AttributeSet_ID > 0 ? "JOIN M_AttributeUse mau ON (a.M_Attribute_ID = mau.M_Attribute_ID AND mau.M_AttributeSet_ID=" + this.p_M_AttributeSet_ID + ")" : "";
            String sql = MRole.getDefault().addAccessSQL("SELECT a.M_Attribute_ID, a.Name, a.Description, a.AttributeValueType, a.IsInstanceAttribute FROM M_Attribute a " + joinAttributeSet + " WHERE a.IsActive='Y' " + " ORDER BY " + (this.p_M_AttributeSet_ID > 0 ? "mau.SeqNo, " : "") + "a.IsInstanceAttribute, a.Name", "a", true, false);
            instanceLine = false;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        Row row;
                        int attribute_ID = rs.getInt(1);
                        String name = rs.getString(2);
                        String description = rs.getString(3);
                        String attributeValueType = rs.getString(4);
                        boolean isInstanceAttribute = "Y".equals(rs.getString(5));
                        if (!instanceLine && isInstanceAttribute) {
                            row = new Row();
                            this.rows.appendChild((Component)row);
                            Div div = new Div();
                            div.setStyle("text-align: left;width: 100%");
                            Label group = new Label(Msg.translate((Properties)Env.getCtx(), (String)"IsInstanceAttribute"));
                            div.appendChild((Component)group);
                            row.appendCellChild((Component)div, 2);
                            row = new Row();
                            this.rows.appendChild((Component)row);
                            Separator separator = new Separator();
                            separator.setBar(true);
                            row.appendCellChild((Component)separator, 2);
                            instanceLine = true;
                        }
                        row = new Row();
                        this.rows.appendChild((Component)row);
                        Label label = new Label(name);
                        if (description != null && description.length() > 0) {
                            label.setTooltiptext(description);
                        }
                        Div div = new Div();
                        div.setStyle("text-align: right;");
                        div.appendChild((Component)label);
                        row.appendChild((Component)div);
                        Object field = null;
                        if ("L".equals(attributeValueType)) {
                            field = new Listbox();
                            field.setRows(0);
                            field.setMultiple(false);
                            field.setMold("select");
                            KeyNamePair[] knp = this.getAttributeList(attribute_ID);
                            int i = 0;
                            while (i < knp.length) {
                                field.appendItem(knp[i].getName(), knp[i]);
                                ++i;
                            }
                        } else {
                            field = "N".equals(attributeValueType) ? new WNumberEditor(name, false, false, true, 22, name).getComponent() : ("D".equals(attributeValueType) ? new WDateEditor(name, false, false, true, name).getComponent() : new WStringEditor(name, false, false, true, 10, 40, null, null).getComponent());
                        }
                        ZKUpdateUtil.setWidth((HtmlBasedComponent)field, "96%");
                        row.appendChild((Component)field);
                        field.setId(String.valueOf(attribute_ID));
                        if (isInstanceAttribute) {
                            this.m_instanceEditors.add((Component)field);
                        } else {
                            this.m_productEditors.add((Component)field);
                        }
                        NumberBox fieldTo = null;
                        if ("N".equals(attributeValueType)) {
                            fieldTo = new WNumberEditor(name, false, false, true, 22, name).getComponent();
                            ZKUpdateUtil.setWidth((HtmlBasedComponent)fieldTo, "150px");
                            row = new Row();
                            this.rows.appendChild((Component)row);
                            div = new Div();
                            div.setStyle("text-align: right;");
                            div.appendChild((Component)new Label("-"));
                            row.appendChild((Component)div);
                            row.appendChild((Component)fieldTo);
                        }
                        if (isInstanceAttribute) {
                            this.m_instanceEditorsTo.add((Component)fieldTo);
                            continue;
                        }
                        this.m_productEditorsTo.add((Component)fieldTo);
                    }
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block18;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        if (!instanceLine) {
            boolean isGuarantee = true;
            boolean isSerial = true;
            boolean isLot = true;
            if (this.p_M_AttributeSet_ID > 0) {
                MAttributeSet as = new MAttributeSet(Env.getCtx(), this.p_M_AttributeSet_ID, null);
                isGuarantee = as.isGuaranteeDate();
                isSerial = as.isSerNo();
                isLot = as.isLot();
            }
            if (isGuarantee || isSerial || isLot) {
                Row row = new Row();
                this.rows.appendChild((Component)row);
                Label group = new Label(Msg.translate((Properties)Env.getCtx(), (String)"IsInstanceAttribute"));
                row.appendCellChild((Component)group, 2);
                row = new Row();
                this.rows.appendChild((Component)row);
                Separator separator = new Separator();
                separator.setBar(true);
                row.appendCellChild((Component)separator, 2);
                instanceLine = true;
            }
        }
        return 0;
    }

    private KeyNamePair[] getAttributeList(int M_Attribute_ID) {
        ArrayList<KeyNamePair> list;
        block6: {
            list = new ArrayList<KeyNamePair>();
            list.add(new KeyNamePair(-1, ""));
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            String sql = MRole.getDefault().addAccessSQL("SELECT M_AttributeValue_ID, Value, Name FROM M_AttributeValue WHERE M_Attribute_ID=? ORDER BY 2", "M_AttributeValue", false, false);
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    pstmt.setInt(1, M_Attribute_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new KeyNamePair(rs.getInt(1), rs.getString(3)));
                    }
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        KeyNamePair[] retValue = new KeyNamePair[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    private void initLotSelection() {
        ArrayList<KeyNamePair> list;
        block7: {
            list = new ArrayList<KeyNamePair>();
            list.add(new KeyNamePair(-1, ""));
            String whereAttributeSet = this.p_M_AttributeSet_ID > 0 ? " AND M_Product_ID IN (SELECT M_Product_ID FROM M_Product WHERE M_AttributeSet_ID=" + this.p_M_AttributeSet_ID + ")" : "";
            String sql = MRole.getDefault().addAccessSQL("SELECT M_Lot_ID, Name FROM M_Lot WHERE IsActive='Y' " + whereAttributeSet + " ORDER BY 2", "M_Lot", false, false);
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new KeyNamePair(rs.getInt(1), rs.getString(2)));
                    }
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        KeyNamePair[] items = new KeyNamePair[list.size()];
        list.toArray(items);
        this.lotSelection = new Listbox();
        this.lotSelection.setRows(0);
        this.lotSelection.setMultiple(false);
        this.lotSelection.setMold("select");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.lotSelection, "150px");
        int i = 0;
        while (i < items.length) {
            this.lotSelection.appendItem(items[i].getName(), items[i]);
            ++i;
        }
    }

    public void onEvent(Event e) throws Exception {
        if (e.getTarget().getId().equals("Ok")) {
            this.createQuery();
            this.dispose();
        } else if (e.getTarget().getId().equals("Cancel")) {
            this.m_query = null;
            this.dispose();
        }
    }

    private String createQuery() {
        BigDecimal valueTo;
        NumberBox fieldTo;
        Object value;
        KeyNamePair pp;
        Object field;
        int M_Attribute_ID;
        Component cTo;
        Component c;
        KeyNamePair pp2;
        ListItem li;
        StringBuilder sb = new StringBuilder();
        String s = this.serNoField.getComponent().getText();
        if (s != null && s.length() > 0) {
            sb.append(" AND asi.SerNo");
            if (s.indexOf(37) == -1 && s.indexOf(95) == 1) {
                sb.append("=");
            } else {
                sb.append(" LIKE ");
            }
            sb.append(DB.TO_STRING((String)s));
        }
        if ((s = this.lotField.getComponent().getText()) != null && s.length() > 0) {
            sb.append(" AND asi.Lot");
            if (s.indexOf(37) == -1 && s.indexOf(95) == 1) {
                sb.append("=");
            } else {
                sb.append(" LIKE ");
            }
            sb.append(DB.TO_STRING((String)s));
        }
        if ((li = this.lotSelection.getSelectedItem()) != null && li.getValue() != null && (pp2 = (KeyNamePair)li.getValue()) != null && pp2.getKey() != -1) {
            int ID = pp2.getKey();
            sb.append(" AND asi.M_Lot_ID=").append(ID);
        }
        if (this.guaranteeDateField.getValue() != null) {
            Timestamp ts = new Timestamp(this.guaranteeDateField.getValue().getTime());
            sb.append(" AND TRUNC(asi.GuaranteeDate)");
            int index = this.guaranteeDateSelection.getSelectedIndex();
            if (index == 0) {
                sb.append("<");
            } else if (index == 1) {
                sb.append("=");
            } else {
                sb.append(">");
            }
            sb.append(DB.TO_DATE((Timestamp)ts, (boolean)true));
        }
        int i = 0;
        while (i < this.m_instanceEditors.size()) {
            StringBuffer iAttr = new StringBuffer();
            c = this.m_instanceEditors.get(i);
            cTo = this.m_instanceEditorsTo.get(i);
            M_Attribute_ID = Integer.parseInt(c.getId());
            if (c instanceof Listbox) {
                field = (Listbox)c;
                li = field.getSelectedItem();
                if (li != null && li.getValue() != null && (pp = (KeyNamePair)li.getValue()) != null && pp.getKey() != -1) {
                    iAttr.append("M_Attribute_ID=").append(M_Attribute_ID).append(" AND M_AttributeValue_ID=").append(pp.getKey());
                }
            } else if (c instanceof NumberBox) {
                field = (NumberBox)c;
                value = ((NumberBox)((Object)field)).getValue();
                fieldTo = (NumberBox)cTo;
                valueTo = fieldTo.getValue();
                if (value != null || valueTo != null) {
                    iAttr.append("M_Attribute_ID=").append(M_Attribute_ID).append(" AND ValueNumber");
                    if (value != null && valueTo == null) {
                        iAttr.append("=").append(value);
                    } else if (value == null && valueTo != null) {
                        iAttr.append("<=").append(valueTo);
                    } else if (value != null && valueTo != null) {
                        iAttr.append(" BETWEEN ").append(value).append(" AND ").append(valueTo);
                    }
                }
            } else {
                field = (Textbox)c;
                value = field.getText();
                if (value != null && ((String)value).length() > 0) {
                    iAttr.append("M_Attribute_ID=").append(M_Attribute_ID).append(" AND Value");
                    if (((String)value).indexOf(37) == -1 && ((String)value).indexOf(95) == -1) {
                        iAttr.append("=");
                    } else {
                        iAttr.append(" LIKE ");
                    }
                    iAttr.append(DB.TO_STRING((String)value));
                }
            }
            if (iAttr.length() > 0) {
                sb.append(" AND asi.M_AttributeSetInstance_ID IN (SELECT M_AttributeSetInstance_ID FROM M_AttributeInstance WHERE ").append(iAttr).append(")");
            }
            ++i;
        }
        if (sb.length() > 0) {
            sb.insert(0, " AND EXISTS (SELECT * FROM M_Storage s INNER JOIN M_AttributeSetInstance asi ON (s.M_AttributeSetInstance_ID=asi.M_AttributeSetInstance_ID) WHERE s.M_Product_ID=p.M_Product_ID");
            sb.append(")");
        }
        i = 0;
        while (i < this.m_productEditors.size()) {
            StringBuffer pAttr = new StringBuffer();
            c = this.m_productEditors.get(i);
            cTo = this.m_productEditorsTo.get(i);
            M_Attribute_ID = Integer.parseInt(c.getId());
            if (c instanceof Listbox) {
                field = (Listbox)c;
                li = field.getSelectedItem();
                if (li != null && li.getValue() != null && (pp = (KeyNamePair)li.getValue()) != null && pp.getKey() != -1) {
                    pAttr.append("M_Attribute_ID=").append(M_Attribute_ID).append(" AND M_AttributeValue_ID=").append(pp.getKey());
                }
            } else if (c instanceof NumberBox) {
                field = (NumberBox)c;
                value = ((NumberBox)((Object)field)).getValue();
                fieldTo = (NumberBox)cTo;
                valueTo = fieldTo.getValue();
                if (value != null || valueTo != null) {
                    pAttr.append("M_Attribute_ID=").append(M_Attribute_ID).append(" AND ValueNumber");
                    if (value != null && valueTo == null) {
                        pAttr.append("=").append(value);
                    } else if (value == null && valueTo != null) {
                        pAttr.append("<=").append(valueTo);
                    } else if (value != null && valueTo != null) {
                        pAttr.append(" BETWEEN ").append(value).append(" AND ").append(valueTo);
                    }
                }
            } else {
                field = (Textbox)c;
                value = field.getText();
                if (value != null && ((String)value).length() > 0) {
                    pAttr.append("M_Attribute_ID=").append(M_Attribute_ID).append(" AND Value");
                    if (((String)value).indexOf(37) == -1 && ((String)value).indexOf(95) == -1) {
                        pAttr.append("=");
                    } else {
                        pAttr.append(" LIKE ");
                    }
                    pAttr.append(DB.TO_STRING((String)value));
                }
            }
            if (pAttr.length() > 0) {
                sb.append(" AND p.M_AttributeSetInstance_ID IN (SELECT M_AttributeSetInstance_ID FROM M_AttributeInstance WHERE ").append(pAttr).append(")");
            }
            ++i;
        }
        this.m_query = null;
        if (sb.length() > 0) {
            this.m_query = sb.toString();
        }
        log.config(this.m_query);
        return this.m_query;
    }

    public String getWhereClause() {
        return this.m_query;
    }
}

