/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.panel;

import java.util.Properties;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.apps.GlobalSearch;
import org.adempiere.webui.apps.MenuSearchController;
import org.adempiere.webui.component.Panel;
import org.adempiere.webui.panel.MenuTreePanel;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.AboutWindow;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.KeyEvent;
import org.zkoss.zk.ui.event.OpenEvent;
import org.zkoss.zul.Image;
import org.zkoss.zul.Popup;
import org.zkoss.zul.impl.LabelImageElement;

public class HeaderPanel
extends Panel
implements EventListener<Event> {
    private static final long serialVersionUID = -2351317624519209484L;
    protected Image image;
    protected LabelImageElement btnMenu;
    protected Popup popMenu;
    private MenuTreePanel menuTreePanel;

    public HeaderPanel() {
        this.addEventListener("onCreate", this);
    }

    protected void onCreate() {
        this.image = (Image)this.getFellow("logo");
        this.image.setSrc(ThemeManager.getSmallLogo());
        this.image.addEventListener("onClick", (EventListener)this);
        this.image.setStyle("cursor: pointer;");
        this.createPopupMenu();
        this.createSearchPanel();
        this.btnMenu = (LabelImageElement)this.getFellow("menuButton");
        this.btnMenu.setIconSclass("z-icon-sitemap");
        this.btnMenu.setTooltiptext(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"Menu")));
        this.btnMenu.addEventListener("onClick", (EventListener)this);
        if (ClientInfo.isMobile()) {
            LayoutUtils.addSclass("mobile", (HtmlBasedComponent)this);
            ClientInfo.onClientInfo((Component)this, this::onClientInfo);
        }
        SessionManager.getSessionApplication().getKeylistener().addEventListener("onCtrlKey", this);
    }

    protected void createPopupMenu() {
        this.popMenu = new Popup();
        this.popMenu.setId("menuTreePopup");
        this.menuTreePanel = new MenuTreePanel((Component)this.popMenu);
        this.popMenu.setSclass("desktop-menu-popup");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this.popMenu, "90%");
        ZKUpdateUtil.setWindowWidthX((HtmlBasedComponent)this.popMenu, 600);
        this.popMenu.setPage(this.getPage());
        this.popMenu.addEventListener("onOpen", evt -> this.popMenuOpenEvent((OpenEvent)evt));
    }

    private void popMenuOpenEvent(OpenEvent evt) {
        this.popMenu.setAttribute(this.popMenu.getUuid(), (Object)System.currentTimeMillis());
    }

    protected void createSearchPanel() {
        GlobalSearch globalSearch = new GlobalSearch(new MenuSearchController(this.menuTreePanel.getMenuTree()));
        Component stub = this.getFellow("menuLookup");
        stub.getParent().insertBefore((Component)globalSearch, stub);
        stub.detach();
        globalSearch.setId("menuLookup");
    }

    public void onEvent(Event event) throws Exception {
        if ("onClick".equals(event.getName())) {
            if (event.getTarget() == this.image) {
                AboutWindow w = new AboutWindow();
                w.setPage(this.getPage());
                w.doHighlighted();
            } else if (event.getTarget() == this.btnMenu) {
                Long ts = (Long)this.popMenu.removeAttribute(this.popMenu.getUuid());
                if (ts != null && System.currentTimeMillis() - ts < 500L) {
                    return;
                }
                this.popMenu.open((Component)this.btnMenu, "after_start");
            }
        } else if ("onCreate".equals(event.getName())) {
            this.onCreate();
        } else if (event instanceof KeyEvent) {
            KeyEvent ke = (KeyEvent)event;
            if (ke.getKeyCode() == 77) {
                this.popMenu.open((Component)this.btnMenu, "after_start");
                this.popMenu.setFocus(true);
            } else if (ke.getKeyCode() == 27) {
                this.popMenu.close();
            }
        }
    }

    public void onPageAttached(Page newpage, Page oldpage) {
        super.onPageAttached(newpage, oldpage);
        if (newpage != null && this.popMenu != null) {
            this.popMenu.setPage(newpage);
        }
    }

    public void onPageDetached(Page page) {
        super.onPageDetached(page);
        if (this.popMenu != null) {
            this.popMenu.setPage(null);
        }
    }

    public Image getLogo() {
        return this.image;
    }

    public void closeSearchPopup() {
        Component c = this.getFellow("menuLookup");
        if (c != null && c instanceof GlobalSearch) {
            ((GlobalSearch)c).closePopup();
        }
    }

    protected void onClientInfo() {
        ZKUpdateUtil.setWindowWidthX((HtmlBasedComponent)this.popMenu, 600);
        Component c = this.getFellow("menuLookup");
        if (c != null && c instanceof GlobalSearch) {
            ((GlobalSearch)c).onClientInfo();
        }
    }
}

