/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.factory;

import java.util.ArrayList;
import java.util.List;
import org.adempiere.base.IServiceReferenceHolder;
import org.adempiere.base.Service;
import org.adempiere.webui.factory.IInfoFactory;
import org.adempiere.webui.info.InfoWindow;
import org.adempiere.webui.panel.InfoPanel;
import org.compiere.model.GridField;
import org.compiere.model.Lookup;
import org.compiere.model.MLookup;
import org.compiere.util.CCache;

public class InfoManager {
    private static final CCache<Long, IServiceReferenceHolder<IInfoFactory>> s_infoFactoryCache = new CCache(null, "IInfoFactory", 10, false);

    public static InfoPanel create(int WindowNo, String tableName, String keyColumn, String value, boolean multiSelection, String whereClause, boolean lookup) {
        InfoPanel info = null;
        ArrayList<Long> visitedIds = new ArrayList<Long>();
        if (!s_infoFactoryCache.isEmpty()) {
            Long[] keys;
            Long[] longArray = keys = s_infoFactoryCache.keySet().toArray(new Long[0]);
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                Long key = longArray[n2];
                IServiceReferenceHolder serviceReference = (IServiceReferenceHolder)s_infoFactoryCache.get((Object)key);
                if (serviceReference != null) {
                    IInfoFactory service = (IInfoFactory)serviceReference.getService();
                    if (service != null) {
                        visitedIds.add(key);
                        info = service.create(WindowNo, tableName, keyColumn, value, multiSelection, whereClause, 0, lookup);
                        if (info != null) {
                            return info;
                        }
                    } else {
                        s_infoFactoryCache.remove((Object)key);
                    }
                }
                ++n2;
            }
        }
        List serviceReferences = Service.locator().list(IInfoFactory.class).getServiceReferences();
        for (IServiceReferenceHolder serviceReference : serviceReferences) {
            IInfoFactory service;
            Long serviceId = (Long)serviceReference.getServiceReference().getProperty("service.id");
            if (visitedIds.contains(serviceId) || (service = (IInfoFactory)serviceReference.getService()) == null) continue;
            s_infoFactoryCache.put((Object)serviceId, (Object)serviceReference);
            info = service.create(WindowNo, tableName, keyColumn, value, multiSelection, whereClause, 0, lookup);
            if (info != null) break;
        }
        return info;
    }

    public static InfoPanel create(Lookup lookup, GridField field, String tableName, String keyColumn, String queryValue, boolean multiSelection, String whereClause) {
        InfoPanel ip = null;
        int AD_InfoWindow_ID = 0;
        if (lookup instanceof MLookup) {
            AD_InfoWindow_ID = ((MLookup)lookup).getAD_InfoWindow_ID();
        }
        ArrayList<Long> visitedIds = new ArrayList<Long>();
        if (!s_infoFactoryCache.isEmpty()) {
            Long[] keys;
            Long[] longArray = keys = s_infoFactoryCache.keySet().toArray(new Long[0]);
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                Long key = longArray[n2];
                IServiceReferenceHolder serviceReference = (IServiceReferenceHolder)s_infoFactoryCache.get((Object)key);
                if (serviceReference != null) {
                    IInfoFactory service = (IInfoFactory)serviceReference.getService();
                    if (service != null) {
                        visitedIds.add(key);
                        ip = service.create(lookup, field, tableName, keyColumn, queryValue, multiSelection, whereClause, AD_InfoWindow_ID);
                        if (ip != null) {
                            return ip;
                        }
                    } else {
                        s_infoFactoryCache.remove((Object)key);
                    }
                }
                ++n2;
            }
        }
        List serviceReferences = Service.locator().list(IInfoFactory.class).getServiceReferences();
        for (IServiceReferenceHolder serviceReference : serviceReferences) {
            IInfoFactory service;
            Long serviceId = (Long)serviceReference.getServiceReference().getProperty("service.id");
            if (visitedIds.contains(serviceId) || (service = (IInfoFactory)serviceReference.getService()) == null) continue;
            s_infoFactoryCache.put((Object)serviceId, (Object)serviceReference);
            ip = service.create(lookup, field, tableName, keyColumn, queryValue, false, whereClause, AD_InfoWindow_ID);
            if (ip != null) break;
        }
        return ip;
    }

    public static InfoWindow create(int AD_InfoWindow_ID) {
        return InfoManager.create(AD_InfoWindow_ID, null);
    }

    public static InfoWindow create(int AD_InfoWindow_ID, String predefinedContextVariables) {
        return InfoManager.create(-1, AD_InfoWindow_ID, predefinedContextVariables);
    }

    public static InfoWindow create(int windowNo, int AD_InfoWindow_ID, String predefinedContextVariables) {
        InfoWindow info = null;
        ArrayList<Long> visitedIds = new ArrayList<Long>();
        if (!s_infoFactoryCache.isEmpty()) {
            Long[] keys;
            Long[] longArray = keys = s_infoFactoryCache.keySet().toArray(new Long[0]);
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                Long key = longArray[n2];
                IServiceReferenceHolder serviceReference = (IServiceReferenceHolder)s_infoFactoryCache.get((Object)key);
                if (serviceReference != null) {
                    IInfoFactory service = (IInfoFactory)serviceReference.getService();
                    if (service != null) {
                        visitedIds.add(key);
                        info = service.create(windowNo, AD_InfoWindow_ID, predefinedContextVariables);
                        if (info != null) {
                            return info;
                        }
                    } else {
                        s_infoFactoryCache.remove((Object)key);
                    }
                }
                ++n2;
            }
        }
        List serviceReferences = Service.locator().list(IInfoFactory.class).getServiceReferences();
        for (IServiceReferenceHolder serviceReference : serviceReferences) {
            IInfoFactory service;
            Long serviceId = (Long)serviceReference.getServiceReference().getProperty("service.id");
            if (visitedIds.contains(serviceId) || (service = (IInfoFactory)serviceReference.getService()) == null) continue;
            s_infoFactoryCache.put((Object)serviceId, (Object)serviceReference);
            info = service.create(windowNo, AD_InfoWindow_ID, predefinedContextVariables);
            if (info != null) break;
        }
        return info;
    }
}

