/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.editor.grid.selection;

import java.util.Properties;
import org.adempiere.webui.ValuePreference;
import org.adempiere.webui.component.Textbox;
import org.adempiere.webui.editor.IEditorConfiguration;
import org.adempiere.webui.editor.WEditor;
import org.adempiere.webui.editor.WEditorPopupMenu;
import org.adempiere.webui.editor.grid.selection.GridTabSelectionListView;
import org.adempiere.webui.event.ContextMenuEvent;
import org.adempiere.webui.event.ContextMenuListener;
import org.adempiere.webui.event.ValueChangeEvent;
import org.adempiere.webui.window.WFieldRecordInfo;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.GridTabVO;
import org.compiere.model.GridWindow;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Menuitem;
import org.zkoss.zul.Popup;

public class WGridTabSingleSelectionEditor
extends WEditor
implements ContextMenuListener {
    private static final String[] LISTENER_EVENTS = new String[]{"onSelect"};
    private Object oldValue;
    private GridTab listViewGridTab = null;
    private String currentLinkValue = null;
    private boolean readWrite;

    public WGridTabSingleSelectionEditor(GridField gridField) {
        this(gridField, false);
    }

    public WGridTabSingleSelectionEditor(GridField gridField, boolean tableEditor) {
        this(gridField, tableEditor, null);
    }

    public WGridTabSingleSelectionEditor(GridField gridField, boolean tableEditor, IEditorConfiguration editorConfiguration) {
        super((Component)(tableEditor ? new Textbox() : new GridTabSelectionListView(false, gridField.getWindowNo())), gridField, tableEditor, editorConfiguration);
        this.init();
    }

    public HtmlBasedComponent getComponent() {
        return (HtmlBasedComponent)this.component;
    }

    @Override
    public boolean isReadWrite() {
        return this.readWrite;
    }

    @Override
    public void setReadWrite(boolean readWrite) {
        if (this.getComponent() instanceof GridTabSelectionListView) {
            GridTabSelectionListView listView = (GridTabSelectionListView)this.getComponent();
            listView.getListbox().setEnabled(readWrite);
        }
        this.readWrite = readWrite;
    }

    private void init() {
        if (this.tableEditor) {
            ((Textbox)this.getComponent()).setReadonly(true);
        } else if (this.gridField != null && this.gridField.getGridTab() != null) {
            int AD_Tab_ID = this.gridField.getIncluded_Tab_ID();
            GridWindow gridWindow = this.gridField.getGridTab().getGridWindow();
            int count = gridWindow.getTabCount();
            GridTabSelectionListView listView = (GridTabSelectionListView)this.getComponent();
            int i = 0;
            while (i < count) {
                GridTab t = gridWindow.getTab(i);
                if (t.getAD_Tab_ID() == AD_Tab_ID) {
                    GridTabVO vo = t.getVO();
                    this.listViewGridTab = new GridTab(vo, gridWindow);
                    String lcn = t.getLinkColumnName();
                    if (Util.isEmpty((String)lcn)) {
                        t.setLinkColumnName(null);
                        lcn = t.getLinkColumnName();
                    }
                    this.listViewGridTab.setLinkColumnName(lcn);
                    listView.init(this.listViewGridTab);
                    break;
                }
                ++i;
            }
            this.popupMenu = new WEditorPopupMenu(false, false, this.isShowPreference());
            Menuitem clear = new Menuitem(Msg.getMsg((Properties)Env.getCtx(), (String)"ClearSelection"), null);
            clear.setAttribute("EVENT", (Object)"onClearSelection");
            clear.addEventListener("onClick", (EventListener)this.popupMenu);
            this.popupMenu.appendChild((Component)clear);
            listView.getListbox().setContext((Popup)this.popupMenu);
        }
    }

    public void onEvent(Event event) {
        if ("onSelect".equals(event.getName())) {
            String newValue;
            GridTabSelectionListView listView = (GridTabSelectionListView)this.getComponent();
            int selected = listView.getListbox().getSelectedIndex();
            String string = newValue = selected >= 0 ? Integer.toString(this.listViewGridTab.getKeyID(selected)) : null;
            if (this.oldValue != null && newValue != null && this.oldValue.equals(newValue)) {
                return;
            }
            if (this.oldValue == null && newValue == null) {
                return;
            }
            ValueChangeEvent changeEvent = new ValueChangeEvent(this, this.getColumnName(), this.oldValue, newValue);
            super.fireValueChange(changeEvent);
            this.oldValue = newValue;
        }
    }

    @Override
    public String getDisplay() {
        return this.oldValue != null ? this.oldValue.toString() : "";
    }

    @Override
    public Object getValue() {
        return this.oldValue;
    }

    @Override
    public void setValue(Object value) {
        if (value == null && this.oldValue == null) {
            return;
        }
        if (value != null && this.oldValue != null && value.equals(this.oldValue)) {
            return;
        }
        this.oldValue = value;
        if (!this.tableEditor) {
            this.updateSlectedIndices();
        } else {
            ((Textbox)this.getComponent()).setValue(this.oldValue != null ? this.oldValue.toString() : "");
        }
    }

    private void updateSlectedIndices() {
        GridTabSelectionListView listView = (GridTabSelectionListView)this.getComponent();
        listView.clearSelection();
        if (!Util.isEmpty((String)((String)this.oldValue))) {
            int id = Integer.parseInt((String)this.oldValue);
            int i = 0;
            while (i < this.listViewGridTab.getRowCount()) {
                if (this.listViewGridTab.getKeyID(i) == id) {
                    listView.setSelectedIndex(i);
                    return;
                }
                ++i;
            }
        }
    }

    @Override
    public String[] getEvents() {
        return LISTENER_EVENTS;
    }

    @Override
    public void onMenu(ContextMenuEvent evt) {
        if ("VALUE_PREFERENCE".equals(evt.getContextEvent())) {
            if (this.isShowPreference()) {
                ValuePreference.start((Component)this.getComponent(), this.getGridField(), this.getValue());
            }
            return;
        }
        if ("CHANGE_LOG".equals(evt.getContextEvent())) {
            WFieldRecordInfo.start(this.gridField);
        } else if ("onClearSelection".equals(evt.getContextEvent())) {
            ValueChangeEvent changeEvent = new ValueChangeEvent(this, this.getColumnName(), this.oldValue, null);
            super.fireValueChange(changeEvent);
            this.oldValue = null;
        }
    }

    @Override
    public void dynamicDisplay() {
        if (!this.tableEditor && this.listViewGridTab != null) {
            String name = this.listViewGridTab.getLinkColumnName();
            String linkValue = Env.getContext((Properties)Env.getCtx(), (int)this.gridField.getWindowNo(), (String)name);
            if (this.currentLinkValue == null && linkValue != null || this.currentLinkValue != null && linkValue == null || this.currentLinkValue != null && linkValue != null && !this.currentLinkValue.equals(linkValue)) {
                GridTabSelectionListView listView = (GridTabSelectionListView)this.getComponent();
                listView.refresh(this.listViewGridTab);
                this.updateSlectedIndices();
            }
        }
    }
}

