/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.editor.grid.selection;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.adempiere.webui.component.ListCell;
import org.adempiere.webui.component.ListItem;
import org.adempiere.webui.editor.WEditor;
import org.adempiere.webui.editor.WebEditorFactory;
import org.adempiere.webui.editor.grid.selection.GridTabSelectionListView;
import org.adempiere.webui.editor.grid.selection.GridTableRow;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.util.DisplayType;
import org.zkoss.zk.ui.Component;
import org.zkoss.zul.Listbox;
import org.zkoss.zul.Listcell;
import org.zkoss.zul.Listitem;
import org.zkoss.zul.ListitemRenderer;
import org.zkoss.zul.ListitemRendererExt;
import org.zkoss.zul.RendererCtrl;

public class GridTabSelectionListViewRenderer
implements ListitemRenderer<GridTableRow>,
ListitemRendererExt,
RendererCtrl {
    private static final int MAX_TEXT_LENGTH = 60;
    private GridTab gridTab;
    private int windowNo;
    private Map<GridField, WEditor> editors = new HashMap<GridField, WEditor>();
    private GridTabSelectionListView listView;

    public GridTabSelectionListViewRenderer(GridTab gridTab, int windowNo) {
        this.gridTab = gridTab;
        this.windowNo = windowNo;
    }

    public void render(Listitem listitem, GridTableRow data, int index) throws Exception {
        boolean isGridViewCustomized;
        if (this.listView != null && !this.listView.isVisible()) {
            return;
        }
        GridField[] listViewFields = this.listView.getFields();
        int columnCount = listViewFields.length;
        GridField[] gridTabFields = this.gridTab.getFields();
        boolean bl = isGridViewCustomized = gridTabFields.length != listViewFields.length;
        if (!isGridViewCustomized) {
            int i = 0;
            while (i < gridTabFields.length) {
                if (listViewFields[i].getAD_Field_ID() != gridTabFields[i].getAD_Field_ID()) {
                    isGridViewCustomized = true;
                    break;
                }
                ++i;
            }
        }
        Component c = listitem.getParent();
        while (c != null) {
            if (!c.isVisible()) {
                return;
            }
            c = c.getParent();
        }
        Object[] values = null;
        if (!isGridViewCustomized) {
            values = data.getValues();
        } else {
            ArrayList<Object> dataList = new ArrayList<Object>();
            GridField[] gridFieldArray = listViewFields;
            int n = listViewFields.length;
            int n2 = 0;
            while (n2 < n) {
                GridField gridField = gridFieldArray[n2];
                int i = 0;
                while (i < gridTabFields.length) {
                    if (gridField.getAD_Field_ID() == gridTabFields[i].getAD_Field_ID()) {
                        dataList.add(data.getValues()[i]);
                        break;
                    }
                    ++i;
                }
                ++n2;
            }
            values = dataList.toArray(new Object[0]);
        }
        Listcell selectionCell = new Listcell();
        listitem.appendChild((Component)selectionCell);
        int i = 0;
        while (i < columnCount) {
            if (listViewFields[i].isDisplayedGrid()) {
                if (!this.editors.containsKey(listViewFields[i])) {
                    WEditor editor = null;
                    int displayType = listViewFields[i].getDisplayType();
                    if (displayType != 20 && displayType != 32 && displayType != 53370 && displayType != 28 && displayType != 200122) {
                        editor = WebEditorFactory.getEditor(listViewFields[i], true);
                        editor.setReadWrite(false);
                    }
                    this.editors.put(listViewFields[i], editor);
                }
                Listcell cell = this.renderCell(listViewFields[i], values[i]);
                cell.setParent((Component)listitem);
            }
            ++i;
        }
    }

    private Listcell renderCell(GridField gridField, Object value) {
        Listcell cell;
        if (gridField.getDisplayType() == 20) {
            cell = new Listcell("", null);
            cell.setStyle("text-align:center");
            WEditor editor = WebEditorFactory.getEditor(gridField, true);
            editor.setReadWrite(false);
            editor.setValue(value);
            cell.appendChild(editor.getComponent());
        } else if (gridField.getDisplayType() == 32 || gridField.getDisplayType() == 53370) {
            WEditor editor = WebEditorFactory.getEditor(gridField, true);
            editor.setReadWrite(false);
            editor.setValue(value);
            cell = new Listcell("", null);
            cell.appendChild(editor.getComponent());
        } else {
            String text;
            String display = text = this.getDisplayText(gridField, value);
            if (text != null && text.length() > 60) {
                display = String.valueOf(text.substring(0, 57)) + "...";
            }
            cell = new Listcell(display, null);
            if (text != null && text.length() > 60) {
                cell.setTooltiptext(text);
            }
            if (DisplayType.isNumeric((int)gridField.getDisplayType())) {
                cell.setStyle("text-align:right");
            } else if (gridField.getDisplayType() == 32) {
                cell.setStyle("text-align:center");
            }
        }
        return cell;
    }

    public int getControls() {
        return 1;
    }

    public Listcell newListcell(Listitem item) {
        ListCell listCell = new ListCell();
        listCell.applyProperties();
        listCell.setParent((Component)item);
        return listCell;
    }

    public Listitem newListitem(Listbox listbox) {
        ListItem item = new ListItem();
        item.applyProperties();
        return item;
    }

    private String getDisplayText(GridField gridField, Object value) {
        if (value == null) {
            return "";
        }
        if (gridField.isEncryptedField()) {
            return "********";
        }
        if (28 == gridField.getDisplayType()) {
            return "";
        }
        WEditor editor = this.editors.get(gridField);
        if (editor != null) {
            return editor.getDisplayTextForGridView(value);
        }
        return value.toString();
    }

    public boolean isInitialize() {
        return !this.editors.isEmpty();
    }

    public List<WEditor> getEditors() {
        ArrayList<WEditor> editorList = new ArrayList<WEditor>();
        if (!this.editors.isEmpty()) {
            editorList.addAll(this.editors.values());
        }
        return editorList;
    }

    public void doCatch(Throwable ex) throws Throwable {
    }

    public void doFinally() {
    }

    public void doTry() {
    }

    public void setListView(GridTabSelectionListView listView) {
        this.listView = listView;
    }

    public GridTabSelectionListView getListView() {
        return this.listView;
    }
}

