/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.editor;

import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.component.PAttributebox;
import org.adempiere.webui.editor.IEditorConfiguration;
import org.adempiere.webui.editor.WEditor;
import org.adempiere.webui.editor.WEditorPopupMenu;
import org.adempiere.webui.event.ContextMenuEvent;
import org.adempiere.webui.event.ContextMenuListener;
import org.adempiere.webui.event.ValueChangeEvent;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.window.WFieldRecordInfo;
import org.adempiere.webui.window.WPAttributeDialog;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.Lookup;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;

public class WPAttributeEditor
extends WEditor
implements ContextMenuListener {
    private static final String[] LISTENER_EVENTS = new String[]{"onClick", "onChange", "onOK"};
    private static final CLogger log = CLogger.getCLogger(WPAttributeEditor.class);
    private int m_WindowNo;
    private Lookup m_mPAttribute;
    private int m_C_BPartner_ID;
    private Object m_value;
    private GridTab m_GridTab;
    private static Integer NO_INSTANCE = 0;

    public WPAttributeEditor(GridTab gridTab, GridField gridField) {
        this(gridTab, gridField, false, null);
    }

    public WPAttributeEditor(GridTab gridTab, GridField gridField, boolean tableEditor, IEditorConfiguration editorConfiguration) {
        super((Component)new PAttributebox(), gridField, tableEditor, editorConfiguration);
        this.m_GridTab = gridTab;
        this.initComponents();
    }

    private void initComponents() {
        if (ThemeManager.isUseFontIconForImage()) {
            this.getComponent().getButton().setIconSclass("z-icon-PAttribute");
        } else {
            this.getComponent().setButtonImage(ThemeManager.getThemeResource("images/PAttribute16.png"));
        }
        this.m_WindowNo = this.gridField.getWindowNo();
        this.m_mPAttribute = this.gridField.getLookup();
        this.m_C_BPartner_ID = Env.getContextAsInt((Properties)Env.getCtx(), (int)this.m_WindowNo, (String)"C_BPartner_ID");
        this.popupMenu = new WEditorPopupMenu(true, false, false);
        this.addChangeLogMenu(this.popupMenu);
        this.getComponent().getTextbox().setReadonly(true);
        if (this.gridField != null) {
            this.getComponent().getTextbox().setPlaceholder(this.gridField.getPlaceholder());
        }
    }

    public PAttributebox getComponent() {
        return (PAttributebox)this.component;
    }

    @Override
    public void setValue(Object value) {
        if (value == null || NO_INSTANCE.equals(value)) {
            this.getComponent().setText("");
            this.m_value = value;
            return;
        }
        if (value.equals(this.m_value)) {
            return;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Value=" + value);
        }
        this.m_value = value;
        this.getComponent().setText(this.m_mPAttribute.getDisplay(value));
    }

    @Override
    public Object getValue() {
        return this.m_value;
    }

    @Override
    public String getDisplay() {
        return this.getComponent().getText();
    }

    public void onEvent(Event event) {
        if ("onChange".equals(event.getName()) || "onOK".equals(event.getName())) {
            String newText = this.getComponent().getText();
            String oldText = null;
            if (this.m_value != null) {
                oldText = this.m_mPAttribute.getDisplay(this.m_value);
            }
            if (oldText != null && newText != null && oldText.equals(newText)) {
                return;
            }
            if (oldText == null && newText == null) {
                return;
            }
            ValueChangeEvent changeEvent = new ValueChangeEvent(this, this.getColumnName(), oldText, newText);
            this.fireValueChange(changeEvent);
        } else if ("onClick".equals(event.getName())) {
            this.cmd_dialog();
        }
    }

    private void cmd_dialog() {
        boolean productWindow;
        int oldValueInt;
        Integer oldValue = (Integer)this.getValue();
        int M_AttributeSetInstance_ID = oldValueInt = oldValue == null ? 0 : oldValue;
        int M_Product_ID = 0;
        int M_ProductBOM_ID = 0;
        if (this.m_GridTab != null) {
            int tmp;
            M_Product_ID = Env.getContextAsInt((Properties)Env.getCtx(), (int)this.m_WindowNo, (int)this.m_GridTab.getTabNo(), (String)"M_Product_ID");
            M_ProductBOM_ID = Env.getContextAsInt((Properties)Env.getCtx(), (int)this.m_WindowNo, (int)this.m_GridTab.getTabNo(), (String)"M_ProductBOM_ID");
            if (this.m_GridTab.getTabLevel() > 1 && this.m_GridTab.getParentTab() != null && this.m_GridTab.getField("M_Product_ID") == null && (tmp = Env.getContextAsInt((Properties)Env.getCtx(), (int)this.m_WindowNo, (int)this.m_GridTab.getParentTab().getTabNo(), (String)"M_Product_ID")) > 0) {
                M_Product_ID = tmp;
            }
        } else {
            M_Product_ID = Env.getContextAsInt((Properties)Env.getCtx(), (int)this.m_WindowNo, (String)"M_Product_ID");
            M_ProductBOM_ID = Env.getContextAsInt((Properties)Env.getCtx(), (int)this.m_WindowNo, (String)"M_ProductBOM_ID");
        }
        if (log.isLoggable(Level.CONFIG)) {
            log.config("M_Product_ID=" + M_Product_ID + "/" + M_ProductBOM_ID + ",M_AttributeSetInstance_ID=" + M_AttributeSetInstance_ID + ", AD_Column_ID=" + this.gridField.getAD_Column_ID());
        }
        boolean bl = productWindow = this.gridField.getAD_Column_ID() == 8418;
        if (M_ProductBOM_ID != 0) {
            M_Product_ID = M_ProductBOM_ID;
        }
        if (!productWindow && M_Product_ID == 0) {
            this.getComponent().setText(null);
            M_AttributeSetInstance_ID = 0;
            this.processChanges(oldValueInt, M_AttributeSetInstance_ID);
        } else {
            final WPAttributeDialog vad = new WPAttributeDialog(M_AttributeSetInstance_ID, M_Product_ID, this.m_C_BPartner_ID, productWindow, this.gridField.getAD_Column_ID(), this.m_WindowNo);
            vad.addEventListener("onWindowClose", (EventListener)new EventListener<Event>(){

                public void onEvent(Event event) throws Exception {
                    boolean changed = false;
                    int M_AttributeSetInstance_ID = 0;
                    if (vad.isChanged()) {
                        WPAttributeEditor.this.getComponent().setText(vad.getM_AttributeSetInstanceName());
                        M_AttributeSetInstance_ID = vad.getM_AttributeSetInstance_ID();
                        if (WPAttributeEditor.this.m_GridTab != null && !productWindow && vad.getM_Locator_ID() > 0) {
                            if (WPAttributeEditor.this.gridField.getColumnName().equals("M_AttributeSetInstanceTo_ID")) {
                                WPAttributeEditor.this.m_GridTab.setValue("M_LocatorTo_ID", (Object)vad.getM_Locator_ID());
                            } else {
                                WPAttributeEditor.this.m_GridTab.setValue("M_Locator_ID", (Object)vad.getM_Locator_ID());
                            }
                        }
                        changed = true;
                    }
                    if (changed) {
                        WPAttributeEditor.this.processChanges(oldValueInt, M_AttributeSetInstance_ID);
                    }
                }
            });
        }
    }

    private void processChanges(int oldValueInt, int M_AttributeSetInstance_ID) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Changed M_AttributeSetInstance_ID=" + M_AttributeSetInstance_ID);
        }
        this.m_value = new Object();
        if (M_AttributeSetInstance_ID == 0) {
            this.setValue(null);
        } else {
            this.setValue(M_AttributeSetInstance_ID);
        }
        ValueChangeEvent vce = new ValueChangeEvent(this, this.gridField.getColumnName(), new Object(), this.getValue());
        this.fireValueChange(vce);
        if (M_AttributeSetInstance_ID == oldValueInt && this.m_GridTab != null && this.gridField != null) {
            this.m_GridTab.processFieldChange(this.gridField);
        }
    }

    @Override
    public String[] getEvents() {
        return LISTENER_EVENTS;
    }

    @Override
    public void onMenu(ContextMenuEvent evt) {
        if ("ZOOM".equals(evt.getContextEvent())) {
            this.actionZoom();
        } else if ("CHANGE_LOG".equals(evt.getContextEvent())) {
            WFieldRecordInfo.start(this.gridField);
        }
    }

    public void actionZoom() {
        AEnv.actionZoom(this.m_mPAttribute, this.getValue());
    }

    @Override
    public boolean isReadWrite() {
        return this.getComponent().getButton().isEnabled();
    }

    @Override
    public void setReadWrite(boolean readWrite) {
        this.getComponent().setEnabled(readWrite);
        this.getComponent().getTextbox().setReadonly(true);
    }

    @Override
    public void setTableEditor(boolean b) {
        super.setTableEditor(b);
        this.getComponent().setTableEditorMode(b);
    }
}

