/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.ValuePreference;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.component.EditorBox;
import org.adempiere.webui.editor.IEditorConfiguration;
import org.adempiere.webui.editor.IZoomableEditor;
import org.adempiere.webui.editor.WEditor;
import org.adempiere.webui.editor.WEditorPopupMenu;
import org.adempiere.webui.event.ContextMenuEvent;
import org.adempiere.webui.event.ContextMenuListener;
import org.adempiere.webui.event.ValueChangeEvent;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.WFieldRecordInfo;
import org.adempiere.webui.window.WLocatorDialog;
import org.compiere.model.GridField;
import org.compiere.model.MLocator;
import org.compiere.model.MLocatorLookup;
import org.compiere.model.MQuery;
import org.compiere.model.MRole;
import org.compiere.model.MTable;
import org.compiere.model.MWarehouse;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Window;

public class WLocatorEditor
extends WEditor
implements EventListener<Event>,
PropertyChangeListener,
ContextMenuListener,
IZoomableEditor {
    private static final String[] LISTENER_EVENTS = new String[]{"onClick"};
    private MLocatorLookup m_mLocator;
    private Object m_value;
    private int m_WindowNo;
    private static final CLogger log = CLogger.getCLogger(WLocatorEditor.class);

    public WLocatorEditor() {
        this("M_Locator_ID", false, false, true, null, 0);
    }

    public WLocatorEditor(String columnName, boolean mandatory, boolean isReadOnly, boolean isUpdateable, MLocatorLookup mLocator, int windowNo) {
        super((Component)new EditorBox(), "Locator", "", mandatory, isReadOnly, isUpdateable);
        this.setColumnName(columnName);
        this.m_mLocator = mLocator;
        if (ThemeManager.isUseFontIconForImage()) {
            this.getComponent().getButton().setIconSclass("z-icon-Locator");
        } else {
            this.getComponent().setButtonImage(ThemeManager.getThemeResource("images/Locator16.png"));
        }
        this.getComponent().getTextbox().setReadonly(true);
        this.m_WindowNo = windowNo;
        this.setDefault_Locator_ID();
    }

    public WLocatorEditor(GridField gridField) {
        this(gridField, false, null);
    }

    public WLocatorEditor(GridField gridField, boolean tableEditor, IEditorConfiguration editorConfiguration) {
        super((Component)new EditorBox(), gridField, tableEditor, editorConfiguration);
        this.m_mLocator = (MLocatorLookup)gridField.getLookup();
        if (ThemeManager.isUseFontIconForImage()) {
            this.getComponent().getButton().setIconSclass("z-icon-Locator");
        } else {
            this.getComponent().setButtonImage(ThemeManager.getThemeResource("images/Locator16.png"));
        }
        this.getComponent().getTextbox().setReadonly(true);
        this.setDefault_Locator_ID();
        this.m_WindowNo = gridField.getWindowNo();
        if (gridField != null) {
            this.popupMenu = new WEditorPopupMenu(true, true, this.isShowPreference());
            this.addChangeLogMenu(this.popupMenu);
            this.getComponent().getTextbox().setPlaceholder(gridField.getPlaceholder());
        }
    }

    @Override
    public void setValue(Object value) {
        this.setValue(value, false);
    }

    private void setValue(Object value, boolean fire) {
        if (this.m_mLocator == null) {
            return;
        }
        if (value != null) {
            this.m_mLocator.setOnly_Warehouse_ID(this.getOnly_Warehouse_ID());
            this.m_mLocator.setOnly_Product_ID(this.getOnly_Product_ID());
            if (!this.m_mLocator.isValid(value)) {
                value = null;
            }
        }
        this.m_value = value;
        this.getComponent().setText(this.m_mLocator.getDisplay(value));
        if (fire) {
            ValueChangeEvent val = new ValueChangeEvent(this, this.getColumnName(), null, value);
            this.fireValueChange(val);
        }
    }

    @Override
    public Object getValue() {
        if (this.getM_Locator_ID() == 0) {
            return null;
        }
        return this.m_value;
    }

    public EditorBox getComponent() {
        return (EditorBox)this.component;
    }

    @Override
    public boolean isReadWrite() {
        return this.getComponent().isEnabled();
    }

    @Override
    public void setReadWrite(boolean readWrite) {
        this.getComponent().setEnabled(readWrite);
        this.getComponent().getTextbox().setReadonly(true);
    }

    public int getM_Locator_ID() {
        if (this.m_value != null && this.m_value instanceof Integer) {
            return (Integer)this.m_value;
        }
        return 0;
    }

    @Override
    public String getDisplay() {
        return this.getComponent().getText();
    }

    public void onEvent(Event event) throws Exception {
        if ("onClick".equalsIgnoreCase(event.getName())) {
            int only_Warehouse_ID = this.getOnly_Warehouse_ID();
            int only_Product_ID = this.getOnly_Product_ID();
            if (log.isLoggable(Level.CONFIG)) {
                log.config("Only Warehouse_ID=" + only_Warehouse_ID + ", Product_ID=" + only_Product_ID);
            }
            if (event.getTarget() == this.getComponent() && this.actionText(only_Warehouse_ID, only_Product_ID)) {
                return;
            }
            int M_Locator_ID = 0;
            if (this.m_value instanceof Integer) {
                M_Locator_ID = (Integer)this.m_value;
            }
            this.m_mLocator.setOnly_Warehouse_ID(only_Warehouse_ID);
            this.m_mLocator.setOnly_Product_ID(this.getOnly_Product_ID());
            final WLocatorDialog ld = new WLocatorDialog(Msg.translate((Properties)Env.getCtx(), (String)this.getColumnName()), this.m_mLocator, M_Locator_ID, this.isMandatory(), only_Warehouse_ID, this.m_WindowNo);
            ld.addEventListener("onWindowClose", (EventListener)new EventListener<Event>(){

                public void onEvent(Event event) throws Exception {
                    WLocatorEditor.this.m_mLocator.setOnly_Warehouse_ID(0);
                    if (!ld.isChanged()) {
                        return;
                    }
                    WLocatorEditor.this.setValue(ld.getValue(), true);
                }
            });
            ld.setTitle(null);
            LayoutUtils.openPopupWindow((Component)this.getComponent(), ld);
            if (ClientInfo.isMobile()) {
                ld.setAttribute("mobile.orientation", ClientInfo.get().orientation);
                ClientInfo.onClientInfo((Component)ld, () -> {
                    String orientation;
                    String newOrientation;
                    if (ld.getPage() != null && !(newOrientation = ClientInfo.get().orientation).equals(orientation = (String)ld.getAttribute("mobile.orientation"))) {
                        ld.setAttribute("mobile.orientation", newOrientation);
                        ZKUpdateUtil.setCSSHeight((HtmlBasedComponent)ld);
                        ZKUpdateUtil.setCSSWidth((HtmlBasedComponent)ld);
                        ld.invalidate();
                        LayoutUtils.openPopupWindow((Component)this.getComponent(), (Window)ld, 100);
                    }
                });
            }
        }
    }

    public void actionRefresh() {
        if (this.m_mLocator != null) {
            Object curValue = this.getValue();
            if (this.isReadWrite()) {
                this.m_mLocator.refresh();
            }
            if (curValue != null) {
                this.setValue(curValue);
            }
        }
    }

    @Override
    public void actionZoom() {
        int AD_Window_ID = MTable.get((Properties)Env.getCtx(), (int)207).getAD_Window_ID();
        if (AD_Window_ID <= 0) {
            AD_Window_ID = 139;
        }
        log.info("");
        MQuery zoomQuery = new MQuery();
        zoomQuery.addRestriction("M_Locator_ID", "=", this.getValue());
        zoomQuery.setRecordCount(1);
        AEnv.zoom(AD_Window_ID, zoomQuery);
    }

    @Override
    public void onMenu(ContextMenuEvent evt) {
        if ("REQUERY".equals(evt.getContextEvent())) {
            this.actionRefresh();
        } else if ("ZOOM".equals(evt.getContextEvent())) {
            this.actionZoom();
        } else if ("CHANGE_LOG".equals(evt.getContextEvent())) {
            WFieldRecordInfo.start(this.gridField);
        } else if ("VALUE_PREFERENCE".equals(evt.getContextEvent()) && this.isShowPreference()) {
            ValuePreference.start((Component)this.getComponent(), this.getGridField(), this.getValue());
        }
    }

    private boolean actionText(int only_Warehouse_ID, int only_Product_ID) {
        int M_Locator_ID;
        block16: {
            String text = this.getComponent().getText();
            log.fine(text);
            if (text == null || text.length() == 0) {
                if (this.isMandatory()) {
                    return false;
                }
                this.setValue(null, true);
                return true;
            }
            text = text.endsWith("%") ? text.toUpperCase() : String.valueOf(text.toUpperCase()) + "%";
            StringBuffer sql = new StringBuffer("SELECT M_Locator_ID FROM M_Locator ").append(" WHERE IsActive='Y' AND UPPER(Value) LIKE ").append(DB.TO_STRING((String)text));
            if (this.getOnly_Warehouse_ID() != 0) {
                sql.append(" AND M_Warehouse_ID=?");
            }
            if (this.getOnly_Product_ID() != 0) {
                sql.append(" AND (IsDefault='Y' ").append("OR EXISTS (SELECT * FROM M_Product p ").append("WHERE p.M_Locator_ID=M_Locator.M_Locator_ID AND p.M_Product_ID=?) ").append("OR EXISTS (SELECT * FROM M_StorageOnHand s ").append("WHERE s.M_Locator_ID=M_Locator.M_Locator_ID AND s.M_Product_ID=?))");
            }
            String finalSql = MRole.getDefault((Properties)Env.getCtx(), (boolean)false).addAccessSQL(sql.toString(), "M_Locator", false, false);
            M_Locator_ID = 0;
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)finalSql, null);
                    int index = 1;
                    if (only_Warehouse_ID != 0) {
                        pstmt.setInt(index++, only_Warehouse_ID);
                    }
                    if (only_Product_ID != 0) {
                        pstmt.setInt(index++, only_Product_ID);
                        pstmt.setInt(index++, only_Product_ID);
                    }
                    if ((rs = pstmt.executeQuery()).next()) {
                        M_Locator_ID = rs.getInt(1);
                        if (rs.next()) {
                            M_Locator_ID = 0;
                        }
                    }
                }
                catch (SQLException ex) {
                    log.log(Level.SEVERE, finalSql, (Throwable)ex);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block16;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        if (M_Locator_ID > 0) {
            this.m_mLocator.refreshIfNeeded();
            boolean valid = this.m_mLocator.containsKey((Object)M_Locator_ID);
            if (!valid) {
                M_Locator_ID = 0;
            }
        }
        if (M_Locator_ID == 0) {
            return false;
        }
        this.setValue(M_Locator_ID, true);
        return true;
    }

    public void setField(GridField mField) {
    }

    private int getOnly_Warehouse_ID() {
        String only_Warehouse = null;
        only_Warehouse = this.gridField != null && "M_LocatorTo_ID".equals(this.gridField.getColumnName()) ? (this.gridField.getVO().TabNo > 0 ? Env.getContext((Properties)Env.getCtx(), (int)this.m_WindowNo, (int)this.gridField.getVO().TabNo, (String)"M_WarehouseTo_ID", (boolean)false, (boolean)true) : Env.getContext((Properties)Env.getCtx(), (int)this.m_WindowNo, (String)"M_WarehouseTo_ID", (boolean)true)) : (this.gridField != null && this.gridField.getVO().TabNo > 0 ? Env.getContext((Properties)Env.getCtx(), (int)this.m_WindowNo, (int)this.gridField.getVO().TabNo, (String)"M_Warehouse_ID", (boolean)false, (boolean)true) : Env.getContext((Properties)Env.getCtx(), (int)this.m_WindowNo, (String)"M_Warehouse_ID", (boolean)true));
        int only_Warehouse_ID = 0;
        try {
            if (only_Warehouse != null && only_Warehouse.length() > 0) {
                only_Warehouse_ID = Integer.parseInt(only_Warehouse);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return only_Warehouse_ID;
    }

    private int getOnly_Product_ID() {
        if (!Env.isSOTrx((Properties)Env.getCtx(), (int)this.m_WindowNo)) {
            return 0;
        }
        String ignoreProduct = Env.getContext((Properties)Env.getCtx(), (int)this.m_WindowNo, (String)"+IgnoreProductInLocatorEditor");
        if ("Y".equalsIgnoreCase(ignoreProduct)) {
            return 0;
        }
        String only_Product = null;
        only_Product = this.gridField != null && this.gridField.getVO().TabNo > 0 ? Env.getContext((Properties)Env.getCtx(), (int)this.m_WindowNo, (int)this.gridField.getVO().TabNo, (String)"M_Product_ID", (boolean)false, (boolean)true) : Env.getContext((Properties)Env.getCtx(), (int)this.m_WindowNo, (String)"M_Product_ID", (boolean)true);
        int only_Product_ID = 0;
        try {
            if (only_Product != null && only_Product.length() > 0) {
                only_Product_ID = Integer.parseInt(only_Product);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return only_Product_ID;
    }

    private void setDefault_Locator_ID() {
        if (!this.isMandatory() || this.m_mLocator == null) {
            return;
        }
        int M_Warehouse_ID = this.getOnly_Warehouse_ID();
        if (M_Warehouse_ID <= 0) {
            return;
        }
        MWarehouse wh = MWarehouse.get((Properties)Env.getCtx(), (int)M_Warehouse_ID);
        if (wh == null || wh.get_ID() <= 0) {
            return;
        }
        MLocator loc = wh.getDefaultLocator();
        if (loc == null || loc.get_ID() <= 0) {
            return;
        }
        this.setValue(loc.get_ID());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("FieldValue")) {
            this.setValue(evt.getNewValue());
        }
    }

    @Override
    public String[] getEvents() {
        return LISTENER_EVENTS;
    }

    @Override
    public void setTableEditor(boolean b) {
        super.setTableEditor(b);
        this.getComponent().setTableEditorMode(b);
    }

    @Override
    public void dynamicDisplay(Properties ctx) {
        super.dynamicDisplay(ctx);
        this.m_mLocator.dynamicDisplay(ctx);
    }
}

