/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.ValuePreference;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.component.Locationbox;
import org.adempiere.webui.editor.IEditorConfiguration;
import org.adempiere.webui.editor.IZoomableEditor;
import org.adempiere.webui.editor.WEditor;
import org.adempiere.webui.editor.WEditorPopupMenu;
import org.adempiere.webui.event.ContextMenuEvent;
import org.adempiere.webui.event.ContextMenuListener;
import org.adempiere.webui.event.ValueChangeEvent;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.WFieldRecordInfo;
import org.adempiere.webui.window.WLocationDialog;
import org.compiere.model.GridField;
import org.compiere.model.Lookup;
import org.compiere.model.MLocation;
import org.compiere.model.MLocationLookup;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.OpenEvent;
import org.zkoss.zul.Window;

public class WLocationEditor
extends WEditor
implements EventListener<Event>,
PropertyChangeListener,
ContextMenuListener,
IZoomableEditor {
    private static final String[] LISTENER_EVENTS = new String[]{"onClick"};
    private static final CLogger log = CLogger.getCLogger(WLocationEditor.class);
    private MLocationLookup m_Location;
    private MLocation m_value;

    public WLocationEditor(String columnName, boolean mandatory, boolean isReadOnly, boolean isUpdateable, MLocationLookup mLocation) {
        super((Component)new Locationbox(), "Address", "", mandatory, isReadOnly, isUpdateable);
        this.setColumnName(columnName);
        this.m_Location = mLocation;
        this.init();
    }

    public WLocationEditor(GridField gridField) {
        this(gridField, false, null);
    }

    public WLocationEditor(GridField gridField, boolean tableEditor, IEditorConfiguration editorConfiguration) {
        super((Component)new Locationbox(), gridField, tableEditor, editorConfiguration);
        this.m_Location = (MLocationLookup)gridField.getLookup();
        this.init();
    }

    private void init() {
        if (ThemeManager.isUseFontIconForImage()) {
            this.getComponent().getButton().setIconSclass("z-icon-Location");
        } else {
            this.getComponent().setButtonImage(ThemeManager.getThemeResource("images/Location16.png"));
        }
        this.popupMenu = new WEditorPopupMenu(true, false, this.isShowPreference(), false, false, false, this.gridField != null ? this.gridField.getLookup() : null);
        this.popupMenu.addMenuListener(this);
        this.addChangeLogMenu(this.popupMenu);
        if (this.gridField != null) {
            this.getComponent().getTextbox().setPlaceholder(this.gridField.getPlaceholder());
        }
    }

    @Override
    public String getDisplay() {
        return this.getComponent().getText();
    }

    @Override
    public Object getValue() {
        if (this.m_value == null) {
            return null;
        }
        return this.m_value.getC_Location_ID();
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            this.m_value = null;
            this.getComponent().setText(null);
        } else {
            String trxName = null;
            if (this.gridField != null) {
                trxName = this.gridField.getGridTab().getTableModel().get_TrxName();
            }
            this.m_value = this.m_Location.getLocation(value, trxName);
            if (this.m_value == null) {
                this.getComponent().setText("<" + value + ">");
            } else {
                this.getComponent().setText(this.m_value.toString());
            }
        }
    }

    public Locationbox getComponent() {
        return (Locationbox)this.component;
    }

    @Override
    public boolean isReadWrite() {
        return this.getComponent().isEnabled();
    }

    @Override
    public void setReadWrite(boolean readWrite) {
        this.getComponent().setEnabled(readWrite);
    }

    public int getC_Location_ID() {
        if (this.m_value == null) {
            return 0;
        }
        return this.m_value.getC_Location_ID();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("FieldValue")) {
            this.setValue(evt.getNewValue());
        }
    }

    public void onEvent(Event event) throws Exception {
        if ("onClick".equals(event.getName())) {
            if (log.isLoggable(Level.CONFIG)) {
                log.config("actionPerformed - " + this.m_value);
            }
            final WLocationDialog ld = new WLocationDialog(Msg.getMsg((Properties)Env.getCtx(), (String)"Location"), this.m_value, this.gridField);
            final int oldValue = this.m_value == null ? 0 : this.m_value.getC_Location_ID();
            ld.addEventListener("onWindowClose", (EventListener)new EventListener<Event>(){

                public void onEvent(Event event) throws Exception {
                    WLocationEditor.this.getComponent().getTextbox().focus();
                    WLocationEditor.this.m_value = ld.getValue();
                    if (!ld.isChanged()) {
                        return;
                    }
                    int C_Location_ID = 0;
                    if (WLocationEditor.this.m_value != null) {
                        C_Location_ID = WLocationEditor.this.m_value.getC_Location_ID();
                    }
                    Integer ii = C_Location_ID;
                    if (C_Location_ID != 0 && oldValue == 0) {
                        ValueChangeEvent vc = new ValueChangeEvent(WLocationEditor.this, WLocationEditor.this.getColumnName(), null, ii);
                        WLocationEditor.this.fireValueChange(vc);
                    }
                    WLocationEditor.this.setValue(ii);
                }
            });
            ld.addEventListener("onOpen", (EventListener)new EventListener<OpenEvent>(){

                public void onEvent(OpenEvent event) throws Exception {
                    if (!event.isOpen() && !ld.isOnSaveError()) {
                        ld.detach();
                    }
                }
            });
            ld.setTitle(null);
            LayoutUtils.openPopupWindow((Component)this.getComponent(), ld);
            if (ClientInfo.isMobile()) {
                ld.setAttribute("mobile.orientation", ClientInfo.get().orientation);
                ClientInfo.onClientInfo((Component)ld, () -> {
                    String orientation;
                    String newOrientation;
                    if (ld.getPage() != null && !(newOrientation = ClientInfo.get().orientation).equals(orientation = (String)ld.getAttribute("mobile.orientation"))) {
                        ld.setAttribute("mobile.orientation", newOrientation);
                        ZKUpdateUtil.setCSSHeight((HtmlBasedComponent)ld);
                        ZKUpdateUtil.setCSSWidth((HtmlBasedComponent)ld);
                        ld.invalidate();
                        LayoutUtils.openPopupWindow((Component)this.getComponent(), (Window)ld, 100);
                    }
                });
            }
        }
    }

    @Override
    public String[] getEvents() {
        return LISTENER_EVENTS;
    }

    @Override
    public void onMenu(ContextMenuEvent evt) {
        if ("CHANGE_LOG".equals(evt.getContextEvent())) {
            WFieldRecordInfo.start(this.gridField);
        } else if ("VALUE_PREFERENCE".equals(evt.getContextEvent())) {
            if (this.isShowPreference()) {
                ValuePreference.start((Component)this.getComponent(), this.getGridField(), this.getValue());
            }
        } else if ("ZOOM".equals(evt.getContextEvent())) {
            this.actionZoom();
        }
    }

    @Override
    public void setTableEditor(boolean b) {
        super.setTableEditor(b);
        this.getComponent().setTableEditorMode(b);
    }

    @Override
    public void actionZoom() {
        AEnv.actionZoom((Lookup)this.m_Location, this.getValue());
    }
}

