/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.editor;

import java.beans.PropertyChangeEvent;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.webui.ValuePreference;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.component.ChosenSearchBox;
import org.adempiere.webui.editor.IEditorConfiguration;
import org.adempiere.webui.editor.InfoListSubModel;
import org.adempiere.webui.editor.WEditor;
import org.adempiere.webui.editor.WEditorPopupMenu;
import org.adempiere.webui.event.ContextMenuEvent;
import org.adempiere.webui.event.ContextMenuListener;
import org.adempiere.webui.event.ValueChangeEvent;
import org.adempiere.webui.factory.InfoManager;
import org.adempiere.webui.panel.IHelpContext;
import org.adempiere.webui.panel.InfoPanel;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.window.WFieldRecordInfo;
import org.compiere.model.GridField;
import org.compiere.model.Lookup;
import org.compiere.model.MColumn;
import org.compiere.model.MLookup;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTable;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.compiere.util.ValueNamePair;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.ListModelList;
import org.zkoss.zul.ListSubModel;

public class WChosenboxSearchEditor
extends WEditor
implements ContextMenuListener {
    private static final String[] LISTENER_EVENTS = new String[]{"onClick", "onSelect"};
    private Lookup lookup;
    private String m_tableName = null;
    private String m_keyColumnName = null;
    private String columnName;
    private String value;
    private InfoPanel infoPanel = null;
    private String imageUrl;
    private MyListModel model = new MyListModel();
    private InfoListSubModel subModel = null;
    private static final CLogger log = CLogger.getCLogger(WChosenboxSearchEditor.class);
    private static final int DEFAULT_MAX_AUTO_COMPLETE_ROWS = 500;
    private boolean onselecting;

    public WChosenboxSearchEditor(GridField gridField) {
        this(gridField, false, null);
    }

    public WChosenboxSearchEditor(GridField gridField, boolean tableEditor, IEditorConfiguration editorConfiguration) {
        super((Component)new ChosenSearchBox(), gridField, tableEditor, editorConfiguration);
        this.lookup = gridField.getLookup();
        if (this.lookup != null) {
            this.columnName = this.lookup.getColumnName();
        }
        this.init();
    }

    public ChosenSearchBox getComponent() {
        return (ChosenSearchBox)super.getComponent();
    }

    @Override
    public boolean isReadWrite() {
        return this.getComponent().isEnabled();
    }

    @Override
    public void setReadWrite(boolean readWrite) {
        this.getComponent().setEnabled(readWrite);
    }

    public WChosenboxSearchEditor(Lookup lookup, String label, String description, boolean mandatory, boolean readonly, boolean updateable) {
        super((Component)new ChosenSearchBox(), label, description, mandatory, readonly, updateable);
        if (lookup == null) {
            throw new IllegalArgumentException("Lookup cannot be null");
        }
        this.lookup = lookup;
        this.columnName = lookup.getColumnName();
        super.setColumnName(this.columnName);
        this.init();
    }

    public WChosenboxSearchEditor(String columnName, boolean mandatory, boolean readonly, boolean updateable, Lookup lookup) {
        super((Component)new ChosenSearchBox(), null, null, mandatory, readonly, updateable);
        if (lookup == null) {
            throw new IllegalArgumentException("Lookup cannot be null");
        }
        this.lookup = lookup;
        this.columnName = columnName;
        super.setColumnName(columnName);
        this.init();
    }

    private void init() {
        this.columnName = this.getColumnName();
        this.imageUrl = ThemeManager.isUseFontIconForImage() ? "z-icon-More" : ThemeManager.getThemeResource("images/PickOpen16.png");
        if (this.lookup instanceof MLookup) {
            MLookup mlookup = (MLookup)this.lookup;
            if ("C_BPartner_ID".equals(mlookup.getLookupInfo().KeyColumn)) {
                this.imageUrl = ThemeManager.isUseFontIconForImage() ? "z-icon-BPartner" : ThemeManager.getThemeResource("images/BPartner16.png");
            } else if ("M_Product_ID".equals(mlookup.getLookupInfo().KeyColumn)) {
                this.imageUrl = ThemeManager.isUseFontIconForImage() ? "z-icon-Product" : ThemeManager.getThemeResource("images/Product16.png");
            }
        }
        this.popupMenu = new WEditorPopupMenu(false, true, this.isShowPreference(), false, false, false, this.lookup);
        if (ThemeManager.isUseFontIconForImage()) {
            this.getComponent().getButton().setIconSclass(this.imageUrl);
        } else {
            this.getComponent().getButton().setImage(this.imageUrl);
        }
        this.setTableAndKeyColumn();
        this.subModel = new InfoListSubModel(this.lookup, this.gridField, this.m_tableName, this.m_keyColumnName);
        this.getComponent().getChosenbox().setModel(this.model);
        this.addChangeLogMenu(this.popupMenu);
    }

    @Override
    public void setValue(Object value) {
        if (this.onselecting) {
            return;
        }
        if (value != null && value instanceof Integer) {
            value = value.toString();
        }
        if (value != null && value instanceof String && !Util.isEmpty((String)((String)value), (boolean)true)) {
            String[] values = ((String)value).split("[,]");
            LinkedHashSet<ValueNamePair> selected = new LinkedHashSet<ValueNamePair>();
            String[] stringArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                if (!Util.isEmpty((String)key)) {
                    if (key.startsWith("\"") && key.endsWith("\"")) {
                        key = key.substring(1, key.length() - 1);
                    }
                    String name = this.lookup.getDisplay((Object)key);
                    ValueNamePair pair = new ValueNamePair(key, name);
                    selected.add(pair);
                }
                ++n2;
            }
            this.model.clear();
            this.model.addAll(selected);
            this.getComponent().getChosenbox().setSelectedObjects(selected);
            this.value = (String)value;
        } else {
            this.model.clear();
            this.getComponent().getChosenbox().setSelectedObjects(new LinkedHashSet());
            this.value = null;
        }
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    private String getValueFromComponent() {
        StringBuilder retVal = new StringBuilder();
        LinkedHashSet<ValueNamePair> selected = this.getComponent().getChosenbox().getSelectedObjects();
        if (selected != null && selected.size() > 0) {
            for (ValueNamePair pair : selected) {
                StringBuilder builder;
                if (retVal.length() > 0) {
                    retVal.append(",");
                }
                if ((builder = new StringBuilder(pair.getValue())).indexOf(",") >= 0) {
                    builder.insert(0, "\"");
                    builder.append("\"");
                }
                retVal.append(builder.toString());
            }
        }
        return retVal.length() > 0 ? retVal.toString() : null;
    }

    @Override
    public String getDisplay() {
        StringBuilder display = new StringBuilder();
        LinkedHashSet<ValueNamePair> selected = this.getComponent().getChosenbox().getSelectedObjects();
        if (selected != null && selected.size() > 0) {
            for (ValueNamePair pair : selected) {
                if (display.length() > 0) {
                    display.append(", ");
                }
                display.append(pair.getName());
            }
        }
        return display.toString();
    }

    public void onEvent(Event e) {
        block12: {
            if ("onClick".equals(e.getName())) {
                if (this.infoPanel != null) {
                    this.infoPanel.detach();
                    this.infoPanel = null;
                }
                this.actionButton();
            } else if ("onSelect".equalsIgnoreCase(e.getName())) {
                try {
                    this.onselecting = true;
                    String newValue = this.getValueFromComponent();
                    if (!this.isValueChange(newValue)) break block12;
                    try {
                        if (this.gridField != null) {
                            this.gridField.setLookupEditorSettingValue(true);
                        }
                        ValueChangeEvent changeEvent = new ValueChangeEvent(this, this.getColumnName(), this.value, newValue);
                        super.fireValueChange(changeEvent);
                        this.value = newValue;
                    }
                    finally {
                        if (this.gridField != null) {
                            this.gridField.setLookupEditorSettingValue(false);
                        }
                    }
                }
                finally {
                    this.onselecting = false;
                }
            }
        }
    }

    private boolean isValueChange(Object newValue) {
        return this.value == null && newValue != null || this.value != null && newValue == null || this.value != null && newValue != null && !this.value.equals(newValue);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("FieldValue".equals(evt.getPropertyName())) {
            this.setValue(evt.getNewValue());
        }
    }

    @Override
    public void onMenu(ContextMenuEvent evt) {
        if ("VALUE_PREFERENCE".equals(evt.getContextEvent())) {
            if (this.isShowPreference()) {
                ValuePreference.start((Component)this.getComponent(), this.getGridField(), this.getValue());
            }
            return;
        }
        if ("CHANGE_LOG".equals(evt.getContextEvent())) {
            WFieldRecordInfo.start(this.gridField);
        }
    }

    private void processSelectedKeys(Object value) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Value=" + value);
        }
        try {
            StringBuilder builder;
            String newValue;
            if (this.gridField != null) {
                this.gridField.setLookupEditorSettingValue(true);
            }
            if ((newValue = this.value) == null) {
                if (value instanceof Object[]) {
                    if (((Object[])value).length > 0) {
                        builder = new StringBuilder();
                        Object[] objectArray = (Object[])value;
                        int n = objectArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object obj = objectArray[n2];
                            if (obj != null) {
                                if (builder.length() > 0) {
                                    builder.append(",");
                                }
                                builder.append(obj.toString());
                            }
                            ++n2;
                        }
                        newValue = builder.toString();
                    }
                } else {
                    newValue = value != null ? value.toString() : null;
                }
            } else if (value != null) {
                if (value instanceof Object[]) {
                    if (((Object[])value).length > 0) {
                        builder = new StringBuilder(newValue);
                        Object[] objectArray = (Object[])value;
                        int n = objectArray.length;
                        int n3 = 0;
                        while (n3 < n) {
                            Object obj = objectArray[n3];
                            if (obj != null) {
                                if (builder.length() > 0) {
                                    builder.append(",");
                                }
                                builder.append(obj.toString());
                            }
                            ++n3;
                        }
                        newValue = builder.toString();
                    }
                } else {
                    newValue = String.valueOf(newValue) + "," + value.toString();
                }
            }
            this.fireValueChangeEvent(newValue);
            boolean updated = false;
            if (newValue == null && this.getValue() == null) {
                updated = true;
            } else if (newValue != null && newValue.equals(this.getValue())) {
                updated = true;
            }
            if (!updated) {
                this.setValue(newValue);
            }
        }
        finally {
            if (this.gridField != null) {
                this.gridField.setLookupEditorSettingValue(false);
            }
        }
    }

    protected void fireValueChangeEvent(Object newValue) {
        ValueChangeEvent evt = new ValueChangeEvent(this, this.getColumnName(), this.getValue(), newValue);
        this.fireValueChange(evt);
    }

    private void actionButton() {
        InfoPanel ip;
        if (this.lookup == null) {
            return;
        }
        String whereClause = this.getWhereClause();
        if (this.m_tableName == null) {
            this.setTableAndKeyColumn();
        }
        if ((ip = InfoManager.create(this.lookup, this.gridField, this.m_tableName, this.m_keyColumnName, null, true, whereClause)) != null) {
            this.showInfoPanel(ip);
        }
    }

    protected void showInfoPanel(final InfoPanel ip) {
        ip.setVisible(true);
        ip.setStyle("border: 2px");
        ip.setClosable(true);
        this.infoPanel = ip;
        ip.addEventListener("onWindowClose", (EventListener)new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                Component component = SessionManager.getAppDesktop().getActiveWindow();
                if (component instanceof IHelpContext) {
                    Events.sendEvent((Event)new Event("onWindowContainerSelectionChanged", component));
                } else {
                    SessionManager.getAppDesktop().updateHelpContext("H", 0);
                }
                boolean cancelled = ip.isCancelled();
                Object[] result = ip.getSelectedKeys();
                WChosenboxSearchEditor.this.infoPanel = null;
                if (!cancelled && result != null && result.length > 0) {
                    if (result.length > 1) {
                        WChosenboxSearchEditor.this.processSelectedKeys(result);
                    } else {
                        WChosenboxSearchEditor.this.processSelectedKeys(result[0]);
                    }
                }
                WChosenboxSearchEditor.this.getComponent().getChosenbox().focus();
            }
        });
        ip.setId(String.valueOf(ip.getTitle()) + "_" + ip.getWindowNo());
        AEnv.showWindow(ip);
    }

    private void setTableAndKeyColumn() {
        if (this.lookup != null && this.lookup instanceof MLookup) {
            this.m_keyColumnName = ((MLookup)this.lookup).getColumnName();
            if (this.m_keyColumnName.contains(".")) {
                this.m_tableName = this.m_keyColumnName.substring(0, this.m_keyColumnName.indexOf("."));
                this.m_keyColumnName = this.m_keyColumnName.substring(this.m_keyColumnName.indexOf(".") + 1);
            } else {
                this.m_tableName = this.m_keyColumnName.substring(0, this.m_keyColumnName.length() - 3);
            }
        } else if (this.getGridField() != null && this.getGridField().getGridTab() != null && this.getGridField().getAD_Column_ID() > 0) {
            MColumn column = MColumn.get((Properties)Env.getCtx(), (int)this.getGridField().getAD_Column_ID());
            this.m_tableName = column.getReferenceTableName();
            MTable table2 = MTable.get((Properties)Env.getCtx(), (String)this.m_tableName);
            this.m_keyColumnName = table2.getKeyColumns()[0];
        } else {
            this.m_keyColumnName = this.getColumnName();
            this.m_tableName = this.m_keyColumnName.substring(0, this.m_keyColumnName.length() - 3);
        }
        if (this.m_keyColumnName.equals("M_Product_ID")) {
            Env.setContext((Properties)Env.getCtx(), (int)this.lookup.getWindowNo(), (int)1113, (String)"M_Product_ID", (String)"0");
            Env.setContext((Properties)Env.getCtx(), (int)this.lookup.getWindowNo(), (int)1113, (String)"M_AttributeSetInstance_ID", (String)"0");
            Env.setContext((Properties)Env.getCtx(), (int)this.lookup.getWindowNo(), (int)1113, (String)"M_Locator_ID", (String)"0");
        }
    }

    private String getWhereClause() {
        String whereClause = "";
        if (this.lookup == null) {
            return "";
        }
        String validation = this.lookup.getValidation();
        if (validation == null) {
            validation = "";
        }
        if (whereClause.length() == 0) {
            whereClause = validation;
        } else if (validation.length() > 0) {
            whereClause = String.valueOf(whereClause) + " AND " + validation;
        }
        if (whereClause.indexOf(64) != -1) {
            Properties ctx = this.lookup instanceof MLookup ? ((MLookup)this.lookup).getLookupInfo().ctx : Env.getCtx();
            String validated = Env.parseContext((Properties)ctx, (int)this.lookup.getWindowNo(), (String)whereClause, (boolean)false);
            if (validated.length() == 0) {
                log.severe(String.valueOf(this.getColumnName()) + " - Cannot Parse=" + whereClause);
            } else {
                if (log.isLoggable(Level.FINE)) {
                    log.fine(String.valueOf(this.getColumnName()) + " - Parsed: " + validated);
                }
                return validated;
            }
        }
        return whereClause;
    }

    @Override
    public String[] getEvents() {
        return LISTENER_EVENTS;
    }

    @Override
    public void setTableEditor(boolean b) {
        super.setTableEditor(b);
        this.getComponent().setTableEditorMode(b);
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    @Override
    public void dynamicDisplay(Properties ctx) {
        if (this.lookup instanceof MLookup) {
            ((MLookup)this.lookup).getLookupInfo().ctx = ctx;
        }
        super.dynamicDisplay(ctx);
    }

    private class MyListModel
    extends ListModelList<ValueNamePair>
    implements ListSubModel<ValueNamePair> {
        private static final long serialVersionUID = -1210525428410505409L;

        private MyListModel() {
        }

        public ListModel<ValueNamePair> getSubModel(Object value, int nRows) {
            WChosenboxSearchEditor.this.subModel.setWhereClause(WChosenboxSearchEditor.this.getWhereClause());
            int maxRows = MSysConfig.getIntValue((String)"ZK_SEARCH_AUTO_COMPLETE_MAX_ROWS", (int)500, (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
            ListModel<ValueNamePair> model = WChosenboxSearchEditor.this.subModel.getSubModel(value, maxRows);
            WChosenboxSearchEditor.this.getComponent().getChosenbox().setSubListModel(model);
            return model;
        }
    }
}

