/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.desktop;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.adempiere.webui.AdempiereWebUI;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.desktop.IDesktop;
import org.adempiere.webui.exception.ApplicationException;
import org.adempiere.webui.part.AbstractUIPart;
import org.compiere.model.MMenu;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.Session;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Window;

public abstract class AbstractDesktop
extends AbstractUIPart
implements IDesktop {
    private transient ClientInfo clientInfo;
    private String predefinedContextVariables;
    private boolean menuIsSOTrx;
    private static final CLogger logger = CLogger.getCLogger(AbstractDesktop.class);

    @Override
    public void onMenuSelected(int menuId) {
        block9: {
            MMenu menu = MMenu.get((int)menuId);
            try {
                this.setPredefinedContextVariables(menu.getPredefinedContextVariables());
                this.setMenuIsSOTrx(menu.isSOTrx());
                if (menu.getAction().equals("W")) {
                    this.openWindow(menu.getAD_Window_ID(), null);
                    break block9;
                }
                if (menu.getAction().equals("P") || menu.getAction().equals("R")) {
                    this.openProcessDialog(menu.getAD_Process_ID(), menu.isSOTrx());
                    break block9;
                }
                if (menu.getAction().equals("X")) {
                    this.openForm(menu.getAD_Form_ID());
                    break block9;
                }
                if (menu.getAction().equals("I")) {
                    this.openInfo(menu.getAD_InfoWindow_ID());
                    break block9;
                }
                if (menu.getAction().equals("F")) {
                    this.openWorkflow(menu.getAD_Workflow_ID());
                    break block9;
                }
                if (menu.getAction().equals("T")) {
                    this.openTask(menu.getAD_Task_ID());
                    break block9;
                }
                throw new ApplicationException("Menu Action not yet implemented: " + menu.getAction());
            }
            finally {
                this.setPredefinedContextVariables(null);
            }
        }
    }

    @Override
    public ClientInfo getClientInfo() {
        return this.clientInfo;
    }

    @Override
    public void setClientInfo(ClientInfo clientInfo) {
        this.clientInfo = clientInfo;
    }

    @Override
    public int registerWindow(Object win) {
        List<Object> windows = this.getWindows();
        int retValue = windows.size();
        windows.add(win);
        return retValue;
    }

    @Override
    public void unregisterWindow(int WindowNo) {
        List<Object> windows = this.getWindows();
        if (windows != null && WindowNo < windows.size()) {
            windows.set(WindowNo, null);
        }
        Env.clearWinContext((int)WindowNo);
    }

    @Override
    public Object findWindow(int WindowNo) {
        List<Object> windows = this.getWindows();
        if (windows != null && WindowNo < windows.size()) {
            return windows.get(WindowNo);
        }
        return null;
    }

    @Override
    public int findWindowNo(Component component) {
        if (component == null) {
            return -1;
        }
        List<Object> windows = this.getWindows();
        if (windows != null) {
            if (windows.contains(component)) {
                return windows.indexOf(component);
            }
            Component parent = component.getParent();
            while (parent != null) {
                if (windows.contains(parent)) {
                    return windows.indexOf(parent);
                }
                parent = parent.getParent();
            }
        }
        return -1;
    }

    @Override
    public void showWindow(Window win) {
        String pos = win.getPosition();
        this.showWindow(win, pos);
    }

    @Override
    public void showWindow(final Window win, final String pos) {
        final Window.Mode windowMode = win.getModeAttribute();
        if (Window.Mode.MODAL == windowMode) {
            if (pos != null) {
                win.setPosition(pos);
            }
            this.showModal(win);
        } else if (Executions.getCurrent() != null) {
            this.showNonModalWindow(win, pos, windowMode);
        } else {
            Executions.schedule((Desktop)this.getComponent().getDesktop(), (EventListener)new EventListener<Event>(){

                public void onEvent(Event event) throws Exception {
                    AbstractDesktop.this.showNonModalWindow(win, pos, windowMode);
                }
            }, (Event)new Event("onExecute"));
        }
    }

    private void showNonModalWindow(Window win, String pos, Window.Mode mode) {
        if (Window.Mode.POPUP == mode) {
            this.showPopup(win, pos);
        } else if (Window.Mode.OVERLAPPED == mode) {
            this.showOverlapped(win, pos);
        } else if (Window.Mode.EMBEDDED == mode) {
            this.showEmbedded(win);
        } else if (Window.Mode.HIGHLIGHTED == mode) {
            this.showHighlighted(win, pos);
        }
    }

    protected abstract void showEmbedded(Window var1);

    protected void showModal(final Window win) {
        if (AdempiereWebUI.isEventThreadEnabled()) {
            win.setPage(this.page);
            win.doModal();
            win.focus();
        } else {
            if (Executions.getCurrent() != null) {
                throw new RuntimeException("When event thread is disabled, you can only show modal window in background thread that doesn't update Desktop.");
            }
            final StringBuffer buffer = new StringBuffer();
            win.addEventListener("onWindowClose", (EventListener)new EventListener<Event>(){

                public void onEvent(Event event) throws Exception {
                    buffer.append("*");
                }
            });
            Executions.schedule((Desktop)this.getComponent().getDesktop(), (EventListener)new EventListener<Event>(){

                public void onEvent(Event event) throws Exception {
                    AbstractDesktop.this.showHighlighted(win, null);
                    if (win.getPage() == null) {
                        buffer.append("*");
                    }
                }
            }, (Event)new Event("onExecute"));
            while (buffer.length() == 0) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                }
            }
        }
    }

    protected void showPopup(Window win, String position) {
        if (position == null) {
            win.setPosition("center");
        } else {
            win.setPosition(position);
        }
        win.setPage(this.page);
        win.doPopup();
        win.focus();
    }

    protected void showOverlapped(Window win, String position) {
        if (position == null) {
            win.setPosition("center");
        } else {
            win.setPosition(position);
        }
        win.setPage(this.page);
        win.doOverlapped();
        win.focus();
    }

    protected void showHighlighted(Window win, String position) {
        if (position == null) {
            win.setPosition("center");
        } else {
            win.setPosition(position);
        }
        win.setPage(this.page);
        win.doHighlighted();
        win.focus();
    }

    protected List<Object> getWindows() {
        if (this.getComponent() == null) {
            return null;
        }
        Desktop desktop = this.getComponent().getDesktop();
        if (desktop != null) {
            Session session = desktop.getSession();
            ArrayList list = (ArrayList)session.getAttribute("windows.list");
            if (list == null) {
                list = new ArrayList();
                session.setAttribute("windows.list", list);
            }
            return Collections.synchronizedList(list);
        }
        return null;
    }

    public void setPredefinedContextVariables(String predefinedVariables) {
        this.predefinedContextVariables = predefinedVariables;
    }

    protected String getPredefinedContextVariables() {
        return this.predefinedContextVariables;
    }

    public void setMenuIsSOTrx(boolean isSOTrx) {
        this.menuIsSOTrx = isSOTrx;
    }

    protected boolean isMenuSOTrx() {
        return this.menuIsSOTrx;
    }
}

