/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.dashboard;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.webui.component.Borderlayout;
import org.adempiere.webui.component.Column;
import org.adempiere.webui.component.Columns;
import org.adempiere.webui.component.ConfirmPanel;
import org.adempiere.webui.component.Datebox;
import org.adempiere.webui.component.Grid;
import org.adempiere.webui.component.GridFactory;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.Row;
import org.adempiere.webui.component.Rows;
import org.adempiere.webui.component.Textbox;
import org.adempiere.webui.component.Timebox;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.editor.WTableDirEditor;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.Dialog;
import org.compiere.model.Lookup;
import org.compiere.model.MColumn;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MRequest;
import org.compiere.model.MRole;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.zkoss.calendar.event.CalendarsEvent;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.util.Callback;
import org.zkoss.zul.Center;
import org.zkoss.zul.South;

public class RequestWindow
extends Window
implements EventListener<Event> {
    private static final long serialVersionUID = 7757368164776005797L;
    private static final CLogger log = CLogger.getCLogger(RequestWindow.class);
    private boolean m_readOnly = false;
    private WTableDirEditor requestTypeField;
    private WTableDirEditor dueTypeField;
    private WTableDirEditor priorityField;
    private WTableDirEditor confidentialField;
    private WTableDirEditor salesRepField;
    private WTableDirEditor entryConfidentialField;
    private Textbox txtSummary;
    private Datebox dbxStartPlan;
    private Datebox dbxCompletePlan;
    private Timebox tbxStartTime;
    private Timebox tbxEndTime;
    private ConfirmPanel confirmPanel;
    private Window parent;
    private Calendar calBegin;
    private Calendar calEnd;

    public RequestWindow(CalendarsEvent ce, Window parent) {
        this.parent = parent;
        Properties ctx = Env.getCtx();
        this.setTitle(Msg.getMsg((Properties)Env.getCtx(), (String)"Event"));
        this.setAttribute("mode", "highlighted");
        if (!ThemeManager.isUseCSSForWindowSize()) {
            ZKUpdateUtil.setWindowWidthX((HtmlBasedComponent)this, 400);
            ZKUpdateUtil.setWindowHeightX((HtmlBasedComponent)this, 550);
        } else {
            this.addCallback("afterPageAttached", (Callback & Serializable)t -> {
                ZKUpdateUtil.setCSSHeight((HtmlBasedComponent)this);
                ZKUpdateUtil.setCSSWidth((HtmlBasedComponent)this);
            });
        }
        this.setSclass("popup-dialog request-dialog");
        this.setBorder("normal");
        this.setShadow(true);
        this.setClosable(true);
        this.m_readOnly = !MRole.getDefault().canUpdate(Env.getAD_Client_ID((Properties)ctx), Env.getAD_Org_ID((Properties)ctx), 417, 0, false);
        Label lblDueType = new Label(Msg.getElement((Properties)ctx, (String)"DueType"));
        Label lblRequestType = new Label(Msg.getElement((Properties)ctx, (String)"R_RequestType_ID"));
        Label lblPriority = new Label(Msg.getElement((Properties)ctx, (String)"Priority"));
        Label lblSummary = new Label(Msg.getElement((Properties)ctx, (String)"Summary"));
        Label lblConfidential = new Label(Msg.getElement((Properties)ctx, (String)"ConfidentialType"));
        Label lblSalesRep = new Label(Msg.getElement((Properties)ctx, (String)"SalesRep_ID"));
        Label lblEntryConfidential = new Label(Msg.getElement((Properties)ctx, (String)"ConfidentialTypeEntry"));
        Label lblStartPlan = new Label(Msg.getElement((Properties)ctx, (String)"DateStartPlan"));
        Label lblCompletePlan = new Label(Msg.getElement((Properties)ctx, (String)"DateCompletePlan"));
        Label lblStartTime = new Label(Msg.getElement((Properties)ctx, (String)"StartTime"));
        Label lblEndTime = new Label(Msg.getElement((Properties)ctx, (String)"EndTime"));
        int columnID = MColumn.getColumn_ID((String)"R_Request", (String)"DueType");
        MLookup lookup = MLookupFactory.get((Properties)ctx, (int)0, (int)0, (int)columnID, (int)17);
        this.dueTypeField = new WTableDirEditor("DueType", true, false, true, (Lookup)lookup);
        this.dueTypeField.setValue(Env.getContext((Properties)ctx, (String)"P232|DueType"));
        if ((this.dueTypeField.getValue() == null || this.dueTypeField.getValue().equals("")) && this.dueTypeField.getComponent().getItemCount() > 1) {
            this.dueTypeField.setValue(this.dueTypeField.getComponent().getItemAtIndex(1).getValue());
        }
        columnID = MColumn.getColumn_ID((String)"R_Request", (String)"R_RequestType_ID");
        lookup = MLookupFactory.get((Properties)ctx, (int)0, (int)0, (int)columnID, (int)19);
        this.requestTypeField = new WTableDirEditor("R_RequestType_ID", true, false, true, (Lookup)lookup);
        this.requestTypeField.setValue(Env.getContext((Properties)ctx, (String)"P232|R_RequestType_ID"));
        if ((this.requestTypeField.getValue() == null || this.requestTypeField.getValue().equals("")) && this.requestTypeField.getComponent().getItemCount() > 1) {
            this.requestTypeField.setValue(this.requestTypeField.getComponent().getItemAtIndex(1).getValue());
        }
        columnID = MColumn.getColumn_ID((String)"R_Request", (String)"Priority");
        lookup = MLookupFactory.get((Properties)ctx, (int)0, (int)0, (int)columnID, (int)17);
        this.priorityField = new WTableDirEditor("Priority", true, false, true, (Lookup)lookup);
        this.priorityField.setValue(Env.getContext((Properties)ctx, (String)"P232|Priority"));
        if ((this.priorityField.getValue() == null || this.priorityField.getValue().equals("")) && this.priorityField.getComponent().getItemCount() > 1) {
            this.priorityField.setValue(this.priorityField.getComponent().getItemAtIndex(1).getValue());
        }
        columnID = MColumn.getColumn_ID((String)"R_Request", (String)"ConfidentialType");
        lookup = MLookupFactory.get((Properties)ctx, (int)0, (int)0, (int)columnID, (int)17);
        this.confidentialField = new WTableDirEditor("ConfidentialType", true, false, true, (Lookup)lookup);
        this.confidentialField.setValue(Env.getContext((Properties)ctx, (String)"P232|ConfidentialType"));
        if ((this.confidentialField.getValue() == null || this.confidentialField.getValue().equals("")) && this.confidentialField.getComponent().getItemCount() > 1) {
            this.confidentialField.setValue(this.confidentialField.getComponent().getItemAtIndex(1).getValue());
        }
        columnID = MColumn.getColumn_ID((String)"R_Request", (String)"SalesRep_ID");
        lookup = MLookupFactory.get((Properties)ctx, (int)0, (int)0, (int)columnID, (int)19);
        this.salesRepField = new WTableDirEditor("SalesRep_ID", true, false, true, (Lookup)lookup);
        this.salesRepField.setValue(Env.getContextAsInt((Properties)ctx, (String)"SalesRep_ID"));
        if ((this.salesRepField.getValue() == null || this.salesRepField.getValue().equals(0)) && this.salesRepField.getComponent().getItemCount() > 1) {
            this.salesRepField.setValue(this.salesRepField.getComponent().getItemAtIndex(1).getValue());
        }
        columnID = MColumn.getColumn_ID((String)"R_Request", (String)"ConfidentialTypeEntry");
        lookup = MLookupFactory.get((Properties)ctx, (int)0, (int)0, (int)columnID, (int)17);
        this.entryConfidentialField = new WTableDirEditor("ConfidentialTypeEntry", true, false, true, (Lookup)lookup);
        this.entryConfidentialField.setValue(Env.getContext((Properties)ctx, (String)"P232|ConfidentialTypeEntry"));
        if ((this.entryConfidentialField.getValue() == null || this.entryConfidentialField.getValue().equals("")) && this.entryConfidentialField.getComponent().getItemCount() > 1) {
            this.entryConfidentialField.setValue(this.entryConfidentialField.getComponent().getItemAtIndex(1).getValue());
        }
        this.txtSummary = new Textbox();
        this.txtSummary.setRows(3);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.txtSummary, "95%");
        this.dbxStartPlan = new Datebox();
        this.dbxCompletePlan = new Datebox();
        this.tbxStartTime = new Timebox();
        this.tbxEndTime = new Timebox();
        this.confirmPanel = new ConfirmPanel(true);
        this.confirmPanel.addActionListener(this);
        Grid grid = GridFactory.newGridLayout();
        Columns columns = new Columns();
        grid.appendChild((Component)columns);
        Column column = new Column();
        columns.appendChild((Component)column);
        column = new Column();
        columns.appendChild((Component)column);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)column, "250px");
        Rows rows = new Rows();
        grid.appendChild((Component)rows);
        Row row = new Row();
        rows.appendChild((Component)row);
        row.appendChild(lblDueType.rightAlign());
        row.appendChild((Component)this.dueTypeField.getComponent());
        row = new Row();
        rows.appendChild((Component)row);
        row.appendChild(lblRequestType.rightAlign());
        row.appendChild((Component)this.requestTypeField.getComponent());
        row = new Row();
        rows.appendChild((Component)row);
        row.appendChild(lblPriority.rightAlign());
        row.appendChild((Component)this.priorityField.getComponent());
        row = new Row();
        rows.appendChild((Component)row);
        row.appendChild(lblSummary.rightAlign());
        row.appendChild((Component)this.txtSummary);
        row = new Row();
        rows.appendChild((Component)row);
        row.appendChild(lblConfidential.rightAlign());
        row.appendChild((Component)this.confidentialField.getComponent());
        row = new Row();
        rows.appendChild((Component)row);
        row.appendChild(lblSalesRep.rightAlign());
        row.appendChild((Component)this.salesRepField.getComponent());
        row = new Row();
        rows.appendChild((Component)row);
        row.appendChild(lblEntryConfidential.rightAlign());
        row.appendChild((Component)this.entryConfidentialField.getComponent());
        row = new Row();
        rows.appendChild((Component)row);
        row.appendChild(lblStartPlan.rightAlign());
        row.appendChild((Component)this.dbxStartPlan);
        row = new Row();
        rows.appendChild((Component)row);
        row.appendChild(lblCompletePlan.rightAlign());
        row.appendChild((Component)this.dbxCompletePlan);
        row = new Row();
        rows.appendChild((Component)row);
        row.appendChild(lblStartTime.rightAlign());
        row.appendChild((Component)this.tbxStartTime);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.tbxStartTime, "50%");
        row = new Row();
        rows.appendChild((Component)row);
        row.appendChild(lblEndTime.rightAlign());
        row.appendChild((Component)this.tbxEndTime);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.tbxEndTime, "50%");
        Borderlayout borderlayout = new Borderlayout();
        this.appendChild((Component)borderlayout);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)borderlayout, "1");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)borderlayout, "1");
        Center centerPane = new Center();
        centerPane.setSclass("dialog-content");
        centerPane.setAutoscroll(true);
        borderlayout.appendChild((Component)centerPane);
        centerPane.appendChild((Component)grid);
        ZKUpdateUtil.setVflex((HtmlBasedComponent)grid, "min");
        ZKUpdateUtil.setHflex((HtmlBasedComponent)grid, "1");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)centerPane, "min");
        South southPane = new South();
        southPane.setSclass("dialog-footer");
        borderlayout.appendChild((Component)southPane);
        southPane.appendChild((Component)this.confirmPanel);
        this.dbxStartPlan.setValue(ce.getBeginDate());
        this.dbxCompletePlan.setValue(ce.getEndDate());
        this.tbxStartTime.setValue(ce.getBeginDate());
        this.tbxEndTime.setValue(ce.getEndDate());
    }

    public void onEvent(Event e) throws Exception {
        if (this.m_readOnly) {
            this.detach();
        } else if (e.getTarget() == this.confirmPanel.getButton("Ok")) {
            String fillMandatory = Msg.translate((Properties)Env.getCtx(), (String)"FillMandatory");
            if (this.dueTypeField.getValue() == null || this.dueTypeField.getValue().equals("")) {
                throw new WrongValueException((Component)this.dueTypeField.getComponent(), fillMandatory);
            }
            if (this.requestTypeField.getValue() == null || this.requestTypeField.getValue().equals(0)) {
                throw new WrongValueException((Component)this.requestTypeField.getComponent(), fillMandatory);
            }
            if (this.priorityField.getValue() == null || this.priorityField.getValue().equals("")) {
                throw new WrongValueException((Component)this.priorityField.getComponent(), fillMandatory);
            }
            if (this.txtSummary.getText() == null || this.txtSummary.getText().equals("")) {
                throw new WrongValueException((Component)this.txtSummary, fillMandatory);
            }
            if (this.confidentialField.getValue() == null || this.confidentialField.getValue().equals("")) {
                throw new WrongValueException((Component)this.confidentialField.getComponent(), fillMandatory);
            }
            if (this.salesRepField.getValue() == null || this.salesRepField.getValue().equals(0)) {
                throw new WrongValueException((Component)this.salesRepField.getComponent(), fillMandatory);
            }
            if (this.entryConfidentialField.getValue() == null || this.entryConfidentialField.getValue().equals("")) {
                throw new WrongValueException((Component)this.entryConfidentialField.getComponent(), fillMandatory);
            }
            if (this.dbxStartPlan.getValue().compareTo(this.dbxCompletePlan.getValue()) > 0) {
                throw new WrongValueException((Component)this.dbxCompletePlan, Msg.translate((Properties)Env.getCtx(), (String)"DateCompletePlan"));
            }
            if (this.checkTime()) {
                throw new WrongValueException((Component)this.tbxStartTime, Msg.translate((Properties)Env.getCtx(), (String)"CheckTime"));
            }
            MRequest request = new MRequest(Env.getCtx(), 0, null);
            request.setAD_Org_ID(Env.getAD_Org_ID((Properties)Env.getCtx()));
            request.setDueType((String)this.dueTypeField.getValue());
            request.setR_RequestType_ID(((Integer)this.requestTypeField.getValue()).intValue());
            request.setPriority((String)this.priorityField.getValue());
            request.setSummary(this.txtSummary.getText());
            request.setConfidentialType((String)this.confidentialField.getValue());
            request.setSalesRep_ID(((Integer)this.salesRepField.getValue()).intValue());
            request.setConfidentialTypeEntry((String)this.entryConfidentialField.getValue());
            request.setDateStartPlan(new Timestamp(this.calBegin.getTimeInMillis()));
            request.setDateCompletePlan(new Timestamp(this.calEnd.getTimeInMillis()));
            request.setStartTime(new Timestamp(this.calBegin.getTimeInMillis()));
            request.setEndTime(new Timestamp(this.calEnd.getTimeInMillis()));
            if (request.save()) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("R_Request_ID=" + request.getR_Request_ID());
                }
            } else {
                Dialog.error(0, "Request record not saved");
                return;
            }
            Events.postEvent((String)"onRefresh", (Component)this.parent, null);
            this.detach();
        } else if (e.getTarget() == this.confirmPanel.getButton("Cancel")) {
            this.detach();
        }
    }

    private boolean checkTime() {
        this.calBegin = Calendar.getInstance();
        this.calBegin.setTime(this.dbxStartPlan.getValue());
        Calendar cal1 = Calendar.getInstance();
        cal1.setTimeInMillis(this.tbxStartTime.getValue().getTime());
        this.calBegin.set(11, cal1.get(11));
        this.calBegin.set(12, cal1.get(12));
        this.calBegin.set(13, 0);
        this.calBegin.set(14, 0);
        this.calEnd = Calendar.getInstance();
        this.calEnd.setTime(this.dbxCompletePlan.getValue());
        Calendar cal2 = Calendar.getInstance();
        cal2.setTimeInMillis(this.tbxEndTime.getValue().getTime());
        this.calEnd.set(11, cal2.get(11));
        this.calEnd.set(12, cal2.get(12));
        this.calEnd.set(13, 0);
        this.calEnd.set(14, 0);
        return this.calBegin.compareTo(this.calEnd) >= 0;
    }
}

